"""
Figure 2c right panels, firing rates obtained from simulations.
"""

import os
import sys
import pickle as pkl
import numpy as np
from matplotlib import pyplot as plt
import helper
import seaborn as sns

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_fig2_rates(data_, filename):
    """

    :param data_: pickled data from simulation
    :param filename: where to save
    :return:
    """
    modularity = np.arange(0.78, 0.881, 0.02)
    populations = ['E{}'.format(x) for x in range(6)]

    # plotting params
    ticksize = 24
    helper.usetex_font()
    fig = plt.figure(figsize=(7, 9))
    color_palette = sns.cubehelix_palette(20, start=.5, rot=-.75)[::2]

    for subpop_idx, (subpop, ylim) in enumerate(zip(['active', 'non_active'], [(0, 30), (-0.1, 6)])):
        ax = plt.subplot2grid((2, 1), (subpop_idx, 0))
        linestyle = '-' if subpop == 'active' else '--'

        for idx, pop_name in enumerate(populations):
            pop_sim_data = data_[pop_name]  # 2D matrix
            rates = pop_sim_data[subpop]['mean_rates'][0][:, 0]

            ax.plot(modularity, rates[:len(modularity)], linestyle, linewidth=3., color=color_palette[idx])
            ax.set_ylim(ylim)
            ax.set_xticks(modularity)
            ax.set_xticklabels(np.around(modularity, decimals=3))
            ax.tick_params('both', labelsize=ticksize, direction='out')
            ax.spines['right'].set_visible(False)
            ax.spines['top'].set_visible(False)
            ax.grid(False)
            if subpop_idx == 0:
                ax.set_yticks([0., 10., 20., 30.])

    fig.tight_layout()
    fig.subplots_adjust(hspace=0.34)
    fig.savefig(os.path.join('plots/', filename))
    print("Finished plotting Figure 2c (right).")


if __name__ == "__main__":
    with open('data/fig_2_activity_rate.pkl', 'r') as f:
        data = pkl.load(f)

    plot_fig2_rates(data, 'fig2_c_sim.pdf')
