"""
Figure 2d.
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info >= (3, 0)
import numpy as np

from mft_helpers import mft_parameters as parameters
from mft_helpers import calc
from mft_helpers import mft_plotting

if __name__ == "__main__":
    # initialized to rates in layer 0, strongly influences at which m the system turns to the high FR fixed point
    initial_rates = np.array([8.5, 5.9])
    modularity = np.arange(0.75, 0.901, 0.01)
    # modularity = np.arange(0.8, 0.831, 0.01)

    pars = parameters.set_parameter_space()  # create parameter set
    pars = calc.derived_parameters(pars)

    results, modularity_values, limits = calc.nu_vs_layers(pars, modularity_values=modularity,
                                                           rates_initial_layer=initial_rates)

    mft_plotting.plot_nu_vs_layers_fig2(results, pars, initial_rates)


