"""
Figure 8 g
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info < (3, 0), "Please run this script using Python2.7"
import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from matplotlib import pyplot as plt
import helper
import seaborn as sns


color_palette_red = sns.cubehelix_palette(20, start=2.3, rot=-.75)[::2]

if __name__ == "__main__":
    modularity = np.arange(0.7, 1.01, 0.1)
    populations = ['E{}'.format(x) for x in range(6)]

    ticksize = 14
    helper.usetex_font()
    color_palette = sns.cubehelix_palette(20, start=.5, rot=-.75)[::2]
    fig, axes = plt.subplots(nrows=2, ncols=1, sharex=True, sharey=True, figsize=(6, 5))

    with open('data/fig_8g_data.pkl', 'rb') as f:
        data = pkl.load(f)

    for subpop_idx, (subpop, ylim) in enumerate(zip(['active', 'non_active'], [(0, 30), (-0.1, 6)])):
        ax = axes[subpop_idx]
        linestyle = '-' if subpop == 'active' else '--'

        for idx, pop_name in enumerate(populations):
            rates = data['E{}'.format(pop_name)]

            ax.plot(modularity, rates[:len(modularity)], linestyle, linewidth=3., color=color_palette[idx])
            # ax.set_ylim(ylim)
            xticks = np.linspace(min(modularity), max(modularity), 3)
            ax.set_xticks(xticks)
            ax.set_xticklabels(np.around(xticks, decimals=3))
            ax.tick_params('both', labelsize=ticksize, direction='out')
            ax.spines['right'].set_visible(False)
            ax.spines['top'].set_visible(False)
            ax.grid(False)

    axes[1].set_xlabel('m', fontsize=18)
    # fig.text(0.0, 0.5, r'$\nu$ (spks/sec)', va='center', rotation='vertical', fontsize=18)
    fig.add_subplot(111, frameon=False)
    plt.tick_params(labelcolor='none', which='both', top=False, bottom=False, left=False, right=False)
    # plt.grid()
    plt.ylabel(r'$\nu$ (spks/sec)', fontsize=18, labelpad=12)
    fig.tight_layout()
    fig.subplots_adjust(hspace=0.34)

    fig.savefig("plots/fig8_g.pdf")
