"""
Figure 8 S2 a
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info < (3, 0), "Please run this script using Python2.7"
import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from matplotlib import pyplot as plt
import helper
import seaborn as sns


color_palette_red = sns.cubehelix_palette(20, start=2.3, rot=-.75)[::2]

if __name__ == "__main__":
    modularity = np.arange(0.7, 1.01, 0.1)
    Lambdas = [0.05, 0.2, 0.5]

    ticksize = 14
    helper.usetex_font()
    fig, axes = plt.subplots(nrows=2, ncols=1, sharex=True, sharey=True, figsize=(6, 5))

    colors = color_palette_red[::3]

    with open('data/fig_8S2_a.pkl', 'rb') as f:
        data = pkl.load(f)

    for subpop_idx, (subpop, ylim) in enumerate(zip(['active', 'non_active'], [(-30, 500), (-30, 500)])):
        ax = axes[subpop_idx]
        linestyle = 'o-' if subpop == 'active' else 'x--'

        for idx, lbda in enumerate(Lambdas):
            rates = data[lbda]
            ax.plot(modularity, np.round(rates[:len(modularity)]), linestyle, ms=8., mew=2., lw=3., color=colors[idx],
                    label=r'$\lambda = $' + str(lbda) + '')
            ax.set_ylim(ylim)
            xticks = np.linspace(min(modularity), max(modularity), 3)
            ax.set_xticks(xticks)
            ax.set_xticklabels(np.around(xticks, decimals=3))
            ax.tick_params('both', labelsize=ticksize, direction='out')
            import matplotlib.ticker as ticker

            ax.yaxis.set_major_formatter(ticker.ScalarFormatter(useOffset=False))
            ax.spines['right'].set_visible(False)
            ax.spines['top'].set_visible(False)
            ax.grid(False)


    axes[0].legend(fontsize=12, loc='center right', handlelength=2.5)
    axes[1].set_xlabel('m', fontsize=18)

    # fig.text(0.0, 0.5, r'$\nu$ (spks/sec)', va='center', rotation='vertical', fontsize=18)
    fig.add_subplot(111, frameon=False)
    plt.tick_params(labelcolor='none', which='both', top=False, bottom=False, left=False, right=False)
    plt.ylabel(r'$\nu$ (spks/sec)', fontsize=18, labelpad=12)
    fig.tight_layout()
    fig.subplots_adjust(hspace=0.34)

    fig.savefig("plots/fig8_s2_a.pdf")
