function DynamicsITXProcessor
% Written by MBO JM
%Analyzes ALL *.itx files within a folder using Gaussian Edge Detector
%from Sass & Weninger ref.  

%Variables
close all
%for FRET
FirstRed=10; %Length of first Red Phase
Green=990; %Length of Green Phase

%for Edge Detector
scales=[1:2];
thresholds=0.65*ones(1,8);
timestep=0.1;
startTime=FirstRed/10;
startTime_1=10*startTime;
tranRad=1;

%User selects directory containing .itx files.  
[datafile,datapath]=uigetfile('*.itx','Choose the first *.itx file');
if datafile==0, return; end
cd(datapath);
FileList=dir('*.itx');  %Generating list of all *.itx files within folder.  Will analyze all.
NumberITX=size(FileList,1);
file=(FileList(1).name);
[donor, acceptor] = textread(file, '%n%n', 'headerlines', 3, 'whitespace', ' \t\nEND');
NumFrames=size(donor, 1);

%Setting up variables for analysis
m1=1;
time=(0:NumFrames-1);%TIME=time';
%pwFRET=zeros(100,1);
Dynamics=0;
DwellPlace=1;
TransPlace=1;
NoDynamics=0;
Saved=0;
AnotherPrevLastGood=m1;
prevlastgood=m1;        
lastgood=m1;			
m=m1;
pwPlace=1;

for CurrentITX=1:NumberITX
   file=(FileList(CurrentITX).name);
    [donor, acceptor] = textread(file, '%n%n', 'headerlines', 3, 'whitespace', ' \t\nEND');
    rawData = [donor, acceptor];
    close all
    set(0,'DefaultFigureWindowStyle','docked')
    plot(time,rawData(:,1),'g',time, rawData(:,2),'r','Linewidth',2);
    %whitebg('k')
   
   grid on;
%    temp=axis;
%    temp(1)=0;
%    temp(2)=axis_x;
%    axis(temp);
   title([' (' file ')']);
   zoom on;

  if 1 == 1
   
    what2do = input('enter s to select this molecule OR b to back up OR [ENTER] if no dynamics === ','s');
    %if ITX not selected advance.  Adjust backup function
      if isempty(what2do)== 1 
      what2do=' ';
      AnotherPrevLastGood=prevlastgood;
      prevlastgood=lastgood;
      lastgood = m;
      m=m+1;
      NoDynamics=NoDynamics+1;
      end
   %Quit if 'q' is pressed
      if what2do== 'q'
      finish   
      end
   %backup trace viewing
      if what2do== 'b'
      m=lastgood-1;
   	  lastgood=prevlastgood;   
   	  prevlastgood=AnotherPrevLastGood;   
      end
   %select trace for Edge Detection
      if what2do == 's' 
%         set(0,'DefaultFigureWindowStyle','docked')
%         % Plot viewer displays only emission trace
%         subplot(1,1,1)
%         plot(time,rawData(:,1),'g',time, rawData(:,2),'r','Linewidth',2);
%          title([' (' file ')']);
        
        what2do2='s';
        
        %asks for user selection of end point
        if what2do2=='s'
            endpointcheck=0;
            while endpointcheck==0
                disp('Click Cursor to select end point')
                Selected=ginput(1);
                %ginput gives X and Y value of point and frame is NOT round number
          
                endTime=round(Selected(1))*timestep;
                endTime_1=round(Selected(1));
                
                %Gathering location of selected region
                AverageSize=25;
                donor_1 = rawData(:,1)'; acceptor_1=rawData(:,2)'; time_1=time'; len=NumFrames;
                donor_selected = donor_1(endTime_1-AverageSize:endTime_1);
                acceptor_selected = acceptor_1(endTime_1-AverageSize:endTime_1);
                selected_points = (endTime_1-AverageSize:endTime_1);                                     

               
                set(0,'DefaultFigureWindowStyle','docked')
                %Plot viewer displays emission spectra with selected area
                 subplot(1,1,1)
                plot (time_1(1:len-5),donor_1(1:len-5),'g',time_1(1:len-5),acceptor_1(1:len-5),'r',selected_points,donor_selected,'y',selected_points,acceptor_selected,'y','LineWidth',4)
                title(['Molecule ' num2str(m)]);
                disp('The red color indicates the last frame to be analyzed for dynamics.')
                what2do3=input('enter s to accept trace OR r to retry point selection OR c to cancel selection of this trace === [s]','s');
            
                %cancels selection and moves onto next trace
                if what2do3=='c'
                    endpointcheck=1;
                    what2do2='c';
                    AnotherPrevLastGood=prevlastgood;
                    prevlastgood=lastgood;
                    lastgood=m;
                    NoDynamics=NoDynamics+1;
                end

                %user may retry to select endTime
                if what2do3=='r'
                    close all
                    endpointcheck=0;
                   plot(time,rawData(:,1),'g',time, rawData(:,2),'r','Linewidth',2);
                    title([' (' file ')']);
                end
                
              if what2do3=='s'
                     good=1;                   
                    endpointcheck=1;
                    
                    %Calculating FRET for Edge Detection
                    FRET = rawData(:,2) ./ (rawData(:,1) + rawData(:,2) + eps);
                    
          %Calculating point wise FRET for selected region only  
                            pwFPlace=1;
                       for f = startTime_1:endTime_1 %for each frame of a movie
         
                          %Calculate FRET for points with non-zero internisty
                            total = donor(f,1)+acceptor(f,1);
                          if total <= 0
                             pwF(pwFPlace,1) = 0.01; %negative points called 0.01
                          else
                             pwF(pwFPlace,1) = acceptor(f,1)/(donor(f,1)+acceptor(f,1));
                            
                          end
                            pwFPlace=pwFPlace+1;                    
                       end
                   %[ fret, dFret, minmax, stats ] = AnalyzeFretData( file, scales, thresholds, timestep, startTime, endTime, tranRad );
                    [dFret, minmax, stats] = AnalyzeEdgesPROC(FRET, scales, thresholds, timestep, startTime, endTime, tranRad);
                    
                    %Allow users to reject fit and cancel
                            what2do4=input('enter s to accept fit OR r to reject === [s]','s');
                            if what2do4=='s'
                            Dynamics=Dynamics+1;
                            
                            end  
                            if what2do4=='r'
                            what2do2='c';
                            good=0;
                            AnotherPrevLastGood=prevlastgood;
                            prevlastgood=lastgood;
                            lastgood=m;
                            
                            end  
                  if good==1;
                        %Generating Outputs
                    ToAdd=size(stats,1);
                     for z=1:ToAdd
                         %Calculating Dwell Times and Writing out Dwell Times vs state
                         %average FRET w/ Std Deviation
                         if z==1    
                        % First transition has unknown lifetime so not recorded
                        %Running accumulation of pointwise FRET
                         pwFRET(pwPlace:pwPlace+size(pwF,1)-1,1)=pwF;
                         pwPlace=pwPlace+size(pwF,1);  %tracking size of pwFRET
                         elseif z==ToAdd
                         %Last transition has unknown lifetime so not recorded  
                         else

                             DwellTimes(DwellPlace,1)=stats(z,3)-stats(z-1,3); %calculating dwell time from endpoints
                             DwellTimes(DwellPlace,2)=stats(z,1); %adding fret to column 2
                             DwellTimes(DwellPlace,3)=stats(z,2);  %adding std dev to column 3
                             DwellPlace=DwellPlace+1;
                         end    
                     end  
                     %Accumulating Pre and Post States for Transition Density Plots
                     for q=1:ToAdd

                         if q==ToAdd
                                %last fret state has no post so don't write
                         else

                             Transitions(TransPlace,1)=stats(q,1); %Pre-transition FRET in column 1
                             Transitions(TransPlace,2)=stats(q+1,1);%Post-transtion FRET in column 2
                             TransPlace=TransPlace+1;
                         end
                     end
                  Saved=Saved+1;
                  end
                AnotherPrevLastGood=prevlastgood;     
                prevlastgood=lastgood;
                lastgood = m;
                m=m+1;
               end
                
   
        end %End of selecting endpoint
        
     
       
       
      end %End of processing one ITX file
  
      end
       
    
  else 
      m=m+1;
  end
  
end 
PercentTransitions(:,1)=Dynamics; PercentTransitions(:,2)=NoDynamics; PercentTransitions(:,3)=(Dynamics/(NoDynamics+Dynamics))*100; 

%Saving Output Files
if Saved>=1
    
dlmwrite('pwFRET.txt',pwFRET,'Delimiter','\t');
dlmwrite('DwellTimes.txt',DwellTimes,'Delimiter','\t');
dlmwrite('Transitions.txt',Transitions,'Delimiter','\t');
dlmwrite('PercentTransitions.txt',PercentTransitions,'Delimiter','\t');
end
close all    %Need to clean up graphs
end
