function autoITX2

%Adding manual acceptor bleachpoint selection for non-gamma molecules
%210514.
close all;
set(0,'defaultfigurecolor',[1 1 1])

%Information about laser sequence

%Take in laser switch points to make useable for all data sequences
    prompstr={'Length of first red','Length of green ','Movie length'};
    initstr={'10','500','560'};
    titlestr='DO NOT PRESS CANCEL!';
    nlines=1;
    result=inputdlg(prompstr,titlestr,nlines,initstr);
    FirstRed=str2num(result{1});
    Green=str2num(result{2});
    NumFrames=str2num(result{3});
    
AverageSize=20; %Window length for post bleach baseline correction.
Buffer=2; %Frames to avoid or color around bleachpoint

%Settings for Edge Detector senstivity.  See AnalyzeEdgesITX.m for more
%details on these parameters
scales=1:2;
thresholds=0.65*ones(1,8); %This sets the sensitivity in unpredictable ways.
timestep=1;
tranRad=1;
%DwellPlace=1;

%User selects directory containing .itx files.  
[datafile,datapath]=uigetfile('*.itx','Choose the first *.itx file');
if datafile==0, return; end
cd(datapath);
FileList=dir('*.itx');  %Generating list of all *.itx files within folder.  Will analyze all.
NumberITX=size(FileList,1);
frame=(1:NumFrames); %sets up x-axis for plots

%These times set the window of data to be sent for edge detection
startTime1=FirstRed +1;
endTime1=FirstRed+Green +1; %NumFrames; %This sets to the end of the movie. For only green use: %FirstRed+Green;

startTime=1; %This is the start frame for Edge Finder
endTime=Green +1; %NumFrames-FirstRed; %This is end frames for Edge Finder

%Setting up counting for result handling
saved=0;
GammaCount=0;
CurrentITX=1; 
pwcount=0;  %Counter to track accumulation of pointwise FRET
pwCorrCount=0;
fail=0;
FailedITXList=struct('name',' ');

%Reading in all ITX into separate matrices for donor and acceptor
            for k=1:NumberITX
            datafile=FileList(k).name;
            fid=fopen(datafile,'r'); %#ok<NASGU>
            file=datafile;
            [Din, Ain] = textread(file, '%n%n', 'headerlines', 3, 'whitespace', ' \t\nEND');
            donor(:,k)=Din;
            acceptor(:,k)=Ain; %Raw intensity not corrected for leakage.
            fclose(fid);
            end

            
while CurrentITX<=NumberITX
%Find endges for Donor
%Taking donor from selected window
tempD=donor(startTime1:endTime1,CurrentITX);
dDONOR=tempD+abs(min(tempD));

%Sending data to external function AnalyzeEdgesITX.m
[dData, minmax, stats] = AnalyzeEdgesITX(dDONOR, scales, thresholds, timestep, startTime, endTime, tranRad); %#ok<*ASGLU>

%Incoming data used to find bleach.  Last state is always end of window so
%bleach is the second to last. Readjust timing back to full dataset.
DonorTrans=stats(:,3);
Donor_Bleach(CurrentITX)=DonorTrans(size(DonorTrans,1)-1)+FirstRed-1;

%As above for acceptor
tempA=acceptor(startTime1:endTime1,CurrentITX);
dACCEPTOR=tempA+abs(min(tempA));

[dData, minmax, stats] = AnalyzeEdgesITX(dACCEPTOR, scales, thresholds, timestep, startTime, endTime, tranRad);
 
AcceptorTrans=stats(:,3);
Acceptor_Bleach(CurrentITX)=AcceptorTrans(size(AcceptorTrans,1)-1)+FirstRed-1;
 
%Setting the baseline immediately after Donor Bleach.  AverageSize sets
%window length used for calculations. Subtracting this from the rawData and
%accumulating into new matrix corrData.

greenBG(CurrentITX)=mean(donor(Donor_Bleach(CurrentITX)+Buffer:endTime1, CurrentITX)); %Donor_Bleach(CurrentITX)+Buffer+AverageSize, CurrentITX));
redBG(CurrentITX)=mean(acceptor(Donor_Bleach(CurrentITX)+Buffer:endTime1, CurrentITX)); %Donor_Bleach(CurrentITX)+Buffer+AverageSize, CurrentITX));

%Sets up a new 2 martices for post-bleach, baseline-corrected donor and corrected acceptor
corrD(:,CurrentITX)=donor(:,CurrentITX) - greenBG(CurrentITX); 
corrA(:,CurrentITX)=acceptor(:,CurrentITX) - redBG(CurrentITX);

%Generate Plot of Data

%Set up coloring of Bleach Points. These are temporary and rewritten
donor_buffer = corrD(Donor_Bleach(CurrentITX)-Buffer:Donor_Bleach(CurrentITX)+Buffer,CurrentITX);
donor_buffer_points = (Donor_Bleach(CurrentITX)-Buffer:Donor_Bleach(CurrentITX)+Buffer);
acceptor_buffer = corrA(Acceptor_Bleach(CurrentITX)-Buffer:Acceptor_Bleach(CurrentITX)+Buffer, CurrentITX);
acceptor_buffer_points = (Acceptor_Bleach(CurrentITX)-Buffer:Acceptor_Bleach(CurrentITX)+Buffer);


%gcf;
plot(frame,corrD(:,CurrentITX),'g',frame, corrA(:,CurrentITX),'r',donor_buffer_points, donor_buffer, 'c',acceptor_buffer_points, acceptor_buffer, 'y','Linewidth',2);
title(['Molecule ' num2str(CurrentITX) '/' num2str(NumberITX)]);
set(0,'DefaultFigureWindowStyle','docked');
set(gca,'color','white')
set(gca, 'XColor', 'black')
set(gca, 'YColor', 'black')
%whitebg('k')
grid on;
zoom on;

if Donor_Bleach(CurrentITX) >= (FirstRed + Green)
   disp('This donor appears not to bleach'); 
    
end    

what2do = input('g for gamma, s for save, m for manual or [ENTER] to pass === ','s');
                  
          if isempty(what2do)== 1 
             what2do=' ';
          end
          if what2do==' '
            CurrentITX=CurrentITX+1;
          end
          if what2do== 'b'
             CurrentITX=CurrentITX-1; 
          end
           %Quit if 'q' is pressed
          if what2do== 'q'
             CurrentITX=NumberITX+1; 
          end
          if what2do == 'p' %If trace is worth saving for a figure this rewrites it with the word pretty
          
          disp('Now saving pretty trace  ');disp(CurrentITX);
          prettyTemp=FileList(CurrentITX).name;
           fname=[prettyTemp(3:length(prettyTemp)-4) 'PRETTY.itx']; %setting file extension 
         igorname=['PRETTY' num2str(CurrentITX)];
         [fid4,message] = fopen(fname,'w');
         
         %This sets up the file header specific to Igor
		 fprintf(fid4,'IGOR\nWAVES/D ');		%also calculate delta R Squared for 1 step
         fprintf(fid4,'donor');
         fprintf(fid4,igorname);
         fprintf(fid4,' ');
		 fprintf(fid4,'acceptor');		
         fprintf(fid4,igorname);
       	 fprintf(fid4,'\n');		
		 fprintf(fid4,'BEGIN\n');
         
        %Writing actual data point by point File structure is:
        %donor-space-acceptor-\n last is Igor specific
            for i = 1:NumFrames
            fprintf(fid4, num2str(corrD(i,CurrentITX)));
            fprintf(fid4, '	');
            fprintf(fid4, num2str(corrA(i,CurrentITX)));
            fprintf(fid4, '\n');
            end  
         
         fprintf(fid4,'\nEND\n');         
         fclose(fid4);
         
       
                   
          end
          if what2do=='s'
              saved=saved+1;
              PreDonor=mean(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
              PreDonorStd=std(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
              PreAcceptor=mean(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
              PreAcceptorStd=std(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
              
              rawFRET(saved,:)=(PreAcceptor)/((PreAcceptor)+PreDonor);
%               s2ngreen(saved,:)=PreDonor/PreDonorStd;
%               s2nred(saved,:)=PreAcceptor/PreAcceptorStd;
%               LifeTime(saved)=Acceptor_Bleach(CurrentITX)/10;
              PAcceptor(saved,:)=PreAcceptor;
              PDonor(saved,:)=PreDonor;

                    %Calculating pointwise from intial frame of FRET
                    %illumination
                    for k=startTime1:Acceptor_Bleach(CurrentITX)-Buffer
                        pwcount=pwcount+1;
                        pwFRET(pwcount,1)=corrA(k,CurrentITX)/(corrA(k,CurrentITX)+corrD(k,CurrentITX)); %#ok<*AGROW>
                    end
                     CurrentITX=CurrentITX+1; %Only advances after all saved.
          end    
if what2do == 'g'
%If selected then these would be automatic.
 GammaCount=GammaCount+1;
 saved=saved+1;
 %Calculate Gamma and PerMolecule FRET
                    PreDonor=mean(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                    PreDonorStd=std(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX)); %#ok<*NASGU>
                    PostDonor=mean(corrD((Acceptor_Bleach(CurrentITX)+Buffer):(Donor_Bleach(CurrentITX)-Buffer),CurrentITX));
                    PostAcceptor=mean(corrA((Acceptor_Bleach(CurrentITX)+Buffer):(Donor_Bleach(CurrentITX)-Buffer),CurrentITX));
                    if PostAcceptor<0
                        PostAcceptor=0;
                    end
                    PreAcceptor=mean(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                    PreAcceptorStd=std(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                    
                    Gamma(GammaCount,:)=(PostAcceptor-PreAcceptor)/(PreDonor-PostDonor);
                    rawFRET(saved,:)=(PreAcceptor)/((PreAcceptor)+PreDonor);
                    CorrE(GammaCount,:)=(PreAcceptor)/((PreAcceptor)+(PreDonor*Gamma(GammaCount,:)));
%                     s2ngreen(saved,:)=PreDonor/PreDonorStd;
%                     s2nred(saved,:)=PreAcceptor/PreAcceptorStd;
%                     LifeTime(saved)=Acceptor_Bleach(CurrentITX)/10;
                    PAcceptor(saved,:)=PreAcceptor;
                    PDonor(saved,:)=PreDonor;

                    %Calculating pointwise from intial frame of FRET
                    %illumination
                    for k=startTime1:Acceptor_Bleach(CurrentITX)-Buffer
                        pwcount=pwcount+1;
                        pwCorrCount=pwCorrCount+1;
                        pwCorrE(pwCorrCount,1)=corrA(k,CurrentITX)/(corrA(k,CurrentITX)+(Gamma(GammaCount,:)*corrD(k,CurrentITX)));
                        pwFRET(pwcount,1)=corrA(k,CurrentITX)/(corrA(k,CurrentITX)+corrD(k,CurrentITX));
                    end
                     CurrentITX=CurrentITX+1; %Only advances after all saved.
end

if what2do == 'm' %If fail, retry manual selection of bleachpoint.
    Adjuster=1;
    while Adjuster==1
              AdjBase = input('Enter a to pick acceptor bleach or d to use donor bleach === ','s');
                    if AdjBase== 'a'
                                  %user chooses acceptor blach point
                                  disp('Click cursor on acceptor Photobleaching event')
                              BleachPoint=ginput(1);
                                    if numel(BleachPoint)==0
                                        BleachPoint(1)=1+Buffer+AverageSize;
                                    end
                              BleachPoint=round(BleachPoint(1));
                                    if lt(BleachPoint,0)==1
                                        BleachPoint=1+Buffer+AverageSize;
                                    end    
                                    if isnan(BleachPoint)==1
                                           BleachPoint=1+Buffer+AverageSize;
                                    end
                                    if isempty(BleachPoint)==1
                                           BleachPoint=1+Buffer+AverageSize;
                                    end

                               Acceptor_Bleach(CurrentITX)=BleachPoint;
                               acceptor_buffer = corrA(Acceptor_Bleach(CurrentITX)-Buffer:Acceptor_Bleach(CurrentITX)+Buffer, CurrentITX);
                               acceptor_buffer_points = (Acceptor_Bleach(CurrentITX)-Buffer:Acceptor_Bleach(CurrentITX)+Buffer);


                                    %gcf;
                                    plot(frame,corrD(:,CurrentITX),'g',frame, corrA(:,CurrentITX),'r',donor_buffer_points, donor_buffer, 'c',acceptor_buffer_points, acceptor_buffer, 'y','Linewidth',2);
                                    title(['Molecule ' num2str(CurrentITX) '/' num2str(NumberITX)]);
                                    set(0,'DefaultFigureWindowStyle','docked');
                                    set(gca,'color','white')
                                    set(gca, 'XColor', 'black')
                                    set(gca, 'YColor', 'black')
                                    %whitebg('k')
                                    grid on;
                                    zoom on;
                                    

                          what2do2 = input('enter s to save or q to exit  == ','s');

                              if isempty(what2do2) == 1
                                  what2do2 = 'q';
                              end

                              if what2do2 =='s'
                                    saved=saved+1;
                              PreDonor=mean(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreDonorStd=std(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreAcceptor=mean(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreAcceptorStd=std(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));

                              rawFRET(saved,:)=(PreAcceptor)/((PreAcceptor)+PreDonor);
                %               s2ngreen(saved,:)=PreDonor/PreDonorStd;
                %               s2nred(saved,:)=PreAcceptor/PreAcceptorStd;
                %               LifeTime(saved)=Acceptor_Bleach(CurrentITX)/10;
                              PAcceptor(saved,:)=PreAcceptor;
                              PDonor(saved,:)=PreDonor;

                                    %Calculating pointwise from intial frame of FRET
                                    %illumination
                                    for k=startTime1:Acceptor_Bleach(CurrentITX)-Buffer
                                        pwcount=pwcount+1;
                                        pwFRET(pwcount,1)=corrA(k,CurrentITX)/(corrA(k,CurrentITX)+corrD(k,CurrentITX)); %#ok<*AGROW>
                                    end
                              CurrentITX=CurrentITX+1; %Only advances after all saved.
                              Adjuster=0; 

                              end
                    end              

                      if AdjBase== 'd'
                      %use donor bleachpoint
                       Acceptor_Bleach(CurrentITX)=Donor_Bleach(CurrentITX);
                             saved=saved+1;
                              PreDonor=mean(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreDonorStd=std(corrD((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreAcceptor=mean(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));
                              PreAcceptorStd=std(corrA((FirstRed+1):(Acceptor_Bleach(CurrentITX)-Buffer),CurrentITX));

                              rawFRET(saved,:)=(PreAcceptor)/((PreAcceptor)+PreDonor);
                %               s2ngreen(saved,:)=PreDonor/PreDonorStd;
                %               s2nred(saved,:)=PreAcceptor/PreAcceptorStd;
                %               LifeTime(saved)=Acceptor_Bleach(CurrentITX)/10;
                              PAcceptor(saved,:)=PreAcceptor;
                              PDonor(saved,:)=PreDonor;

                                    %Calculating pointwise from intial frame of FRET
                                    %illumination
                                    for k=startTime1:Acceptor_Bleach(CurrentITX)-Buffer
                                        pwcount=pwcount+1;
                                        pwFRET(pwcount,1)=corrA(k,CurrentITX)/(corrA(k,CurrentITX)+corrD(k,CurrentITX)); %#ok<*AGROW>
                                    end
                              CurrentITX=CurrentITX+1; %Only advances after all saved.
                              Adjuster=0;    
                      end
                      if AdjBase== 'b'
                           Adjuster=0;     
                      end
                      if AdjBase== 'q'
                          Adjuster=0;      
                      end
    end              
end
if what2do == 'f' %Catalog failures.
    fail=fail+1;
    FailedITXList(fail).name=FileList(CurrentITX).name;
    CurrentITX=CurrentITX+1;
end    
end 

%Generating Output. Not appended with filename.
 if saved>1
            save working.mat; %saves workspace
            
        %S2N=[s2ngreen,s2nred];
       % dlmwrite('LifeTime.txt',LifeTime,'Delimiter','\t');   %IN SECONDS
        dlmwrite('rawFRET.txt',rawFRET,'Delimiter','\t');
        %dlmwrite('S2N.txt',S2N,'Delimiter','\t');
        dlmwrite('pwFRET.txt',pwFRET,'Delimiter','\t');
        dlmwrite('Acceptor.txt',PAcceptor,'Delimiter','\t');
        dlmwrite('Donor.txt',PDonor,'Delimiter','\t');
 end   
        if GammaCount>1 % Only saving if Gamma Selection used
        dlmwrite('pwCorrE.txt',pwCorrE,'Delimiter','\t');
        dlmwrite('Gamma.txt',Gamma,'Delimiter','\t');
        dlmwrite('CorrE.txt',CorrE,'Delimiter','\t');
        end 

% Figure-not defined what we would want here.
if saved>1
    edges=[-0.2 -0.1:0.05:1.1 1.2];
            figure; 
            subplot(4,1,1)
            gcf;
            hist(rawFRET,edges);
            title('raw E');
            subplot(4,1,2)
            gcf;
            hist(pwFRET,edges);
            title('pwFRET')
            subplot(4,1,3)
            gcf;
            hist(Gamma);
            title('Gamma');
            subplot(4,1,4)
            gcf;
            hist(CorrE,edges);
            title('Corr E');
end
if fail>0
    save('fails.mat', 'FailedITXList');
end    
end     