%Extracts the channel offset between the donor and acceptor channels when
%using an image splitter (e.g. Cairn Optosplit) to generate replicate
%images on a single emCCD. Assumes 256x512 pixel channels with center
%split. Uses 10 frame movie of beads with emission in both channels. 

function BowenLab_Find_Bead_Offset

%Opening datafile via user prompt

[datafile,datapath]=uigetfile('*.tif','Choose a tif file');
if datafile==0 
    return; 
end
cd(datapath);
fid=fopen(datafile,'r');
file=datafile;
fileinfo = imfinfo(datafile); 
imagesizex=fileinfo.Width;  %take pixel resolution from the tif file info
imagesizey=fileinfo.Height;
NumberFrames = numel(fileinfo);
averagesize=10;

fseek(fid,0,-1);
z=0;
    for s=1:averagesize
        z =z + imread(file,s);
    end
    avg_image=z/averagesize;
    
low=min(min(avg_image));
high=ceil(max(max(avg_image(1:imagesizey,imagesizex/2+1:imagesizex))));
gcf;
imshow(avg_image, [low high]);

distanceAwayEdges = 25; %set how close peak can be from edge

offsetx=0;
offsety=0;
    result=size(avg_image);
    donor=avg_image(20+offsety:result(1)-20+offsety,20+offsetx:result(2)/2-20+offsetx);
    acceptor=avg_image(10:result(1)-10,result(2)/2+10:result(2)-10);
    cc = normxcorr2(donor,acceptor); 

    [max_cc, imax] = max(cc(:));
    [ypeak, xpeak] = ind2sub(size(cc),imax(1));

    yoffset=ypeak-size(donor,1)-10;
    xoffset=xpeak-size(donor,2)-10;
    Output(1)=xoffset;
   Output(2)=yoffset;

 disp('these are  offset in pixels (X, Y');
    disp(xoffset);
    disp(yoffset);
    
    OFFSEToutname=strrep(file, '.tif','OFF.txt'); 
    dlmwrite('OFFSET.txt',Output,'Delimiter','\t');

%Finding Peaks to get Affine Transform

        search_image=avg_image;
        low=ceil(max(min(search_image)));
        high=ceil(mean(max(search_image)));
        imshow(search_image, [low high]);
        m_number=0;
        threshold=250;
        
        disp('threshold');disp(threshold);
        
        for i=1+distanceAwayEdges:imagesizey-distanceAwayEdges %Y coord of region to look for peaks
            for j=1+distanceAwayEdges:imagesizex/2-distanceAwayEdges %x coord of region to look for peaks
                %point above threshold value and larger than neighbors
                if search_image(i,j)>threshold && search_image(i,j) == max(max(search_image(i-1:i+1,j-1:j+1)))
                    %count peaks found
                    m_number=m_number+1;
                    %store (x,y) of peak in list
                    tempx(m_number)=j;
                    tempy(m_number)=i;
                end
            end
        end
        
%Tag Overlapping Peaks using Variable overlap 0/1
        nn=8; %acceptable pixel separation between nearest neighbors
        overlap=zeros(1,m_number);
        for i=1:m_number
            for j=i+1:m_number
                if tempy(j)-tempy(i) > nn   
                    break;                  
                end
                %calculate hypotenuse between points in different columns.
                if (tempx(i)-tempx(j))^2+(tempy(i)-tempy(j))^2 < nn^2
                    overlap(i)=1;
                    overlap(j)=1;
                end
            end
        end
        
%Finding Associated Rightside Peak 
        j=0;
        for i=1:m_number          %loop on all molecues
            if overlap(i)==0    %if not overlapping
                j=j+1;          %j counts good molecules
                x(2*j-1)=tempx(i);         %odd members are original leftside spots
                y(2*j-1)=tempy(i);
                
                %apply offset to look for maxima in right side
                x(2*j)=tempx(i)+imagesizex/2+xoffset;
                y(2*j)=tempy(i)+yoffset;
                
                %select 3x3 region around point and find true maxima
                temp=search_image(y(2*j)-2:y(2*j)+2,x(2*j)-2:x(2*j)+2);
                [maxy, maxx]=find(temp==max(max(temp)));
                
                peakcheck=size(maxx);
                if peakcheck(1)~=1 %prevent catch if no peak on other side
                    %disp('peakcheck fail');
                    maxx=2;
                    maxy=2;
                end
                IndvOffstX(i)=maxx-2;
                IndvOffstY(i)=maxy-2;
                %even members are emperically found maxima on right side
                x(2*j)=x(2*j)+maxx-2;
                y(2*j)=y(2*j)+maxy-2;
                line(x(2*j-1),y(2*j-1),'linestyle','none','marker','o','color','w');
                line(x(2*j),y(2*j),'linestyle','none','marker','o','color','y');                
                donor_points(j,:)=[x(2*j-1) y(2*j-1)];
                acceptor_points(j,:)=[x(2*j) y(2*j)];
            end
            
        end
        
        tform = cp2tform(acceptor_points,donor_points,'affine');    
        f = tform.tdata.Tinv;
        disp(f);
        save;
        save f.mat f;
end 