%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Analyzes Traces Files (.traces) of smFRET. Requires user input of laser switch points.                
% Runs through all .traces files in a folder. User can halt.                                            
% Automatically Filters traces to find Acceptor only and unbleached  molecules                         
% For Selection of Traces Only. Requires postprocessing to get FRET
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function BowenLab_PruningTraceViewer
close all
repeater=0;
mov=1;
saved=0;

%MANUALLY SET PARAMETERS FOR PRUNING TRACES
averagewindow=10; %This sets number of points for calculating Intenisty and FRET averages
NOBODY=500; %threshold for automated rejection of molecules lacking donor

%Information about laser sequence

%Take in laser switch points to make useable for all data sequences
    prompstr={'Length of first red','Length of green'};
    initstr={'10','990'};
    titlestr='DO NOT PRESS CANCEL!';
    nlines=1;
    result=inputdlg(prompstr,titlestr,nlines,initstr);
    FirstRed=str2double(result{1});
    GreenLength=str2double(result{2});
    GreenOn=FirstRed+1;
    LastGreen=FirstRed+GreenLength;
    
while (repeater==0)
    
%Opening datafile via user prompt

[datafile,datapath]=uigetfile('*.traces','Choose a traces file');
if datafile==0, return; end
 %if datafile~=file,saved=0;end
cd(datapath);
fid=fopen(datafile,'r');
file=datafile;
pixelfile=strcat(file(1:numel(file)-7), '.maxima');

try load(pixelfile, '-mat') %#ok<LOAD>
catch    
    disp('no movies')
    mov=0;
end

if mov~=0
maximatemp=load(pixelfile, '-mat');
maxima=maximatemp.peaklocate;
 moviefile=strcat(file(1:numel(file)-9),'.tif');
end
   
    
disp('working on');
disp(file);
len=fread(fid,1,'int32');
Ntraces=fread(fid,1,'int16');
disp('there are '); disp(num2str(Ntraces/2)); disp(' molecules in this movie');

%raw takes in data is a single column. index is used to reorder data into
%matrix
raw=fread(fid,Ntraces*len,'int16'); %data is brought in as single column
index=(1:Ntraces*len);              %create variable to call data points from raw
time1 = zeros(1,len);
Data=zeros(Ntraces+1,len);          %set up structure for data matrix (molecule(left/right) x framenumber)
donor=zeros(Ntraces/2,len);
acceptor=zeros(Ntraces/2,len);
fretE=zeros(Ntraces/2,len);
time=(0:(len-1));

%convert raw data (single column) into matrix. 1st row is x-axis #s
%each row is a single molecule intensity trace alternating donor and acceptor
%each column is contains all intensity values for a single frame
%First row of Data is frame numbers for x-axis of graph

Data(index)=raw(index);
time1(1,:) = Data(1,:);

%Separating donor and acceptor traces into two separate matrices.
%Each row is a molecule

        for i=1:(Ntraces/2)
        donor(i,:)=Data(i*2,:);
        acceptor(i,:)=Data(i*2+1,:);
        end

axis_x = len*1;
m1=1; 
%m1 = input('number of starting trace = ');
leakage = 0.08;			%for cy3 leakage into cy5 factor 0.09, set to zero for calcein/cy5

%sets up go back during trace viewing to allow user to go back 2 traces
AnotherPrevLastGood=m1;
prevlastgood=m1;        
lastgood=m1;			
m=m1;
baddies=0; %For coutning how many molecules are rejected by pruning.
    while m < (Ntraces/2 + 1) %for each Movie
   
   %Creating 3 separate 1 column matrices for the frame# (time_1).  The
   %donor & accptr intensity (donor_1, acceptor_1)
   time_1 = time1'; 
   donor_1 = donor(m,:)'; 
   acceptor_1 = acceptor(m,:)'-leakage*donor_1;	
   

   for i = 1:len %for each frame of a movie   
%Calculate FRET for points with non-zero internisty
        total = donor_1(i,1)+acceptor_1(i,1);
      if total <= 0
         fret_1(i,1) = 0.01; %negative points called 0.01
      else
         fret_1(i,1) = acceptor_1(i,1)/(donor_1(i,1)+acceptor_1(i,1)); %#ok<*AGROW>
      end
      %iterate on each frame
   end

   if mean(acceptor_1(GreenOn:GreenOn+20)) + mean(donor_1(GreenOn:GreenOn+20))< NOBODY...
           ||mean(donor_1(LastGreen-5:LastGreen)) > 200....
           ||mean(acceptor_1(LastGreen-5:LastGreen)) > 200....
           ||mean(acceptor_1(2:FirstRed))<100
       baddies=baddies+1;
           m=m+1; %#ok<*NASGU>
           
      %Pruning traces where there is minimal intensity (NOBODY set above) during first 10 green
      %Also pruning where green appears not to bleach.
   else
            
   %initalize plot viewer w/ emission in top subplot @ calc FRET in second subplot  
   subplot (2,1,1) 
   whitebg('w');
   plot(time_1(1:len-5),donor_1(1:len-5),'b',time_1(1:len-5),acceptor_1(1:len-5),'r');
   %plot(time_1(1:len-5),donor_1(1:len-5),'b');	%to plot cy3 only
   grid on;
   temp=axis;
   temp(1)=0;
   temp(2)=axis_x;
   axis(temp);
   title(['Molecule ' num2str(m) ' / ' num2str(Ntraces/2) ' ' file]);
   zoom on;
   subplot (2,1,2)
   plot(time_1(1:len-5),fret_1(1:len-5),'m');
   grid on;
   axis([0 axis_x -0.1 1.1])
   zoom on;
   outfile=file(1:numel(file)-7);
   
   what2do = input('press s to save OR b to back up a trace OR other to pass === ','s');
   
   
   %if trace not saved advance to next trace.  Adjust backup function
      if isempty(what2do)== 1 
      what2do=' ';
      AnotherPrevLastGood=prevlastgood;
      prevlastgood=lastgood;
      lastgood = m;
      m=m+1;   
      end
      
      %play movie of spots
      if what2do=='m'
          willplay=0;
          if mov~=0
              while willplay==0
          prompstr={'Start Frame','Frames to Play','Pause'};
            initstr={'11','50','0.01'};
            titlestr='Movie Player';
            nlines=1;
            result=inputdlg(prompstr,titlestr,nlines,initstr); 
            frame1=str2double(result{1});
            frames2play=str2double(result{2});
            pausetime=str2double(result{3});
            if frame1+frames2play<len
                willplay=1;
            else
            end
              continue
              end
              
          showwidth=7;
          dlow=0.01*donor_1(11)+1;
          dhigh=max([2000 1.25*donor_1(11)+1]);
          alow=min([dlow 0.01*acceptor_1(11)+1]);
          ahigh=max([1.25*(acceptor_1(11)+1) dhigh]);
          fseek(fid,0,-1);
           
        for k=frame1:frame1+frames2play
            rawimage=imread(moviefile,k);
            disp(m);
            subplot(1,2,1)
            imshow(rawimage (maxima(m,2)-floor(showwidth/2):maxima(m,2)+floor(showwidth/2),...
            maxima(m,1)-floor(showwidth/2):maxima(m,1)+floor(showwidth/2)), [dlow dhigh]);
            title(donor_1(k));
            subplot(1,2,2)
            imshow(rawimage (maxima(m,4)-floor(showwidth/2):maxima(m,4)+floor(showwidth/2),...
            maxima(m,3)-floor(showwidth/2):maxima(m,3)+floor(showwidth/2)), [alow ahigh]);
            title(acceptor_1(k));
            drawnow;
            pause(pausetime);
   

        end

  
          else
              disp('no movie for these traces')
          end
           m=m-1;%redsiplay same graph
      end
   %Quit if 'q' is pressed
      if what2do== 'q'
      m=Ntraces;   
      end
   %backup trace viewing
      if what2do== 'b'
      m=lastgood;
   	  lastgood=prevlastgood;   
   	  prevlastgood=AnotherPrevLastGood;   
      end
   %write saved traces to file
      if what2do == 's' 
          saved = saved+1;
          DONOR_temp=donor_1(11:averagewindow+11,1);
          ACCEPTOR_temp=acceptor_1(11:averagewindow+11,1);
          FRET_temp=fret_1(11:averagewindow+11,1);
          avg_FRET(saved,1)=mean(FRET_temp);
          avg_D(saved,1)=mean(DONOR_temp);
          avg_A(saved,1)=mean(ACCEPTOR_temp);
          s2n_D(saved,1) = (mean(DONOR_temp))/std(DONOR_temp);
          s2n_A(saved,1) = (mean(ACCEPTOR_temp))/std(ACCEPTOR_temp);
        
          disp('Now saving trace number  ');disp(saved);
           fname=[outfile 'trace' num2str(m) '.itx']; %setting file extension 
         igorname=[outfile 'trace' num2str(m)];
         [fid2,message] = fopen(fname,'w'); %#ok<*ASGLU>
         
         %This sets up the file header specific to Igor
		 fprintf(fid2,'IGOR\nWAVES/D ');		%also calculate delta R Squared for 1 step
         fprintf(fid2,'donor');
         fprintf(fid2,igorname);
         fprintf(fid2,' ');
		 fprintf(fid2,'acceptor');		
         fprintf(fid2,igorname);
       	 fprintf(fid2,'\n');		
		 fprintf(fid2,'BEGIN\n');
         
        %Writing actual data point by point File structure is:
        %donor-space-acceptor-\n last is Igor specific
            for i = 1:len
            fprintf(fid2, num2str(donor_1(i,1)));
            fprintf(fid2, '	');
            fprintf(fid2, num2str(acceptor_1(i,1)));
            fprintf(fid2, '\n');
            end  
         
         fprintf(fid2,'\nEND\n');         
         fclose(fid2);
         
         %Tracking trace # for backup function
         AnotherPrevLastGood=prevlastgood;     
         prevlastgood=lastgood;
      	 lastgood = m;
         m=m+1;                    
      end
    
    end 
    end %end of plot viewing for a trace
    disp('done'); disp(num2str(baddies)); disp(' of the ');disp(num2str( Ntraces/2)); disp(' traces were pruned');
    
    prompstr={'Still want to look at traces? press 1 to quit'};
    initstr={'0'};
    titlestr='Fancy Trace Viewer';
    nlines=1;
    result=inputdlg(prompstr,titlestr,nlines,initstr);
    repeater=str2double(result);
    continue
 end %end of a movie

 save;
if saved>0
    
    %Generating Output files as text files saved in same folder
    
    dlmwrite('avg_FRET.txt',avg_FRET,'Delimiter','\t'); 
    dlmwrite('s2n_D.txt',s2n_D,'Delimiter','\t'); 
    dlmwrite('s2n_A.txt',s2n_A,'Delimiter','\t'); 
    dlmwrite('avg_D.txt',avg_D,'Delimiter','\t'); 
    dlmwrite('avg_A.txt',avg_A,'Delimiter','\t'); 
    
    figure;
    subplot(3,1,1)
    hist(avg_FRET,20);
    title('FRET');
    subplot(3,1,2)
    hist(s2n_D,20);
    title('S2N D');
    subplot(3,1,3)
    hist(s2n_A,20);
    title('S2N A');
end



end % end completely



