FUNCTION GetDistance,Point1,Point2
	return,sqrt((Point1[0]-Point2[0])*(Point1[0]-Point2[0])+(Point1[1]-Point2[1])*(Point1[1]-Point2[1]))
END
;////////////////////////////////////////////////////////////////////////

;////////////////////////////////////////////////////////////////////////

FUNCTION RotateArray,Array,midpoint,alpha,rotation_axis
COMMON COORS
angle=(2*!PI*alpha)/360
;print,"Rotation angle EQ: ",angle
	cos_a=cos(angle)
	sin_a=sin(angle)

	IF rotation_axis EQ 'X' THEN BEGIN
	 	FOR I=0,N_ELEMENTS(Array[0,*])-1 DO BEGIN
	 		y_new=(Array[1,i]-midpoint[1])
	 		z_new=(Array[2,i]-midpoint[2])

	 		y_end=y_new*cos_a-z_new*sin_a
	 		z_end=y_new*sin_a+z_new*cos_a

	 		y_end=y_end+midpoint[1]
	 		z_end=z_end+midpoint[2]

	 		Array[1,i]=y_end
	 		Array[2,i]=z_end
	 	ENDFOR
	ENDIF

	IF rotation_axis EQ 'Y' THEN BEGIN
	 	FOR I=0,N_ELEMENTS(Array[0,*])-1 DO BEGIN
	 		x_new=(Array[0,i]-midpoint[0])
	 		z_new=(Array[2,i]-midpoint[2])

	 		x_end=x_new*cos_a+z_new*sin_a
	 		z_end=z_new*cos_a-x_new*sin_a

	 		x_end=x_end+midpoint[0]
	 		z_end=z_end+midpoint[2]

	 		Array[0,i]=x_end
	 		Array[2,i]=z_end
		ENDFOR
	ENDIF

	IF rotation_axis EQ 'Z' THEN BEGIN
		FOR I=0,N_ELEMENTS(Array[0,*])-1 DO BEGIN
			x_new=(Array[0,i]-midpoint[0])
			y_new=(Array[1,i]-midpoint[1])

			x_end=x_new*cos_a-y_new*sin_a
			y_end=x_new*sin_a+y_new*cos_a

			x_end=x_end+midpoint[0]
			y_end=y_end+midpoint[1]


			Array[0,i]=x_end
			Array[1,i]=y_end

		ENDFOR
	ENDIF

return,Array
END
;////////////////////////////////////////////////////////////////////////

;////////////////////////////////////////////////////////////////////////
PRO ClickactionCoors,event
COMMON ALL
COMMON CTVS
COMMON COORS
COMMON WIDGET_IDS

;////////////////////////////////////////////////////////////
ArrayDims=SIZE(data)

x_pos=event.X
y_pos=window_size-event.Y

x_pos_frame=(x_pos-x_border)/resize
y_pos_frame=(y_pos-y_border)/resize

IF event.type EQ 2 AND event.press EQ 0 AND event.release EQ 0 THEN BEGIN
	IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
		pos=where(ShiftedAtlas[0,*] lt x_pos_frame+condensekernel AND ShiftedAtlas[0,*] gt x_pos_frame-condensekernel AND ShiftedAtlas[1,*] lt y_pos_frame+condensekernel AND ShiftedAtlas[1,*] gt y_pos_frame-condensekernel)
		IF pos[0] NE -1 THEN BEGIN
			widget_control,coors_xy_id,TOOLTIP=string(fix(ShiftedAtlas[3,pos[0]]))+' A'
		ENDIF
	ENDIF
	IF string(result[0]) NE 'Empty' THEN BEGIN
		pos=where(result[0,*] lt x_pos_frame+condensekernel AND Result[0,*] gt x_pos_frame-condensekernel AND Result[1,*] lt y_pos_frame+condensekernel AND Result[1,*] gt y_pos_frame-condensekernel)
		IF pos[0] NE -1 THEN BEGIN
			widget_control,coors_xy_id,TOOLTIP=string(fix(Result[2,pos[0]]))+' C'
		ENDIF
	ENDIF
ENDIF




IF event.type EQ 0 OR event.type EQ 1 THEN BEGIN

	IF event.press EQ 1 THEN BEGIN
 		pos=where(ShiftedAtlas[0,*] lt x_pos_frame+condensekernel AND ShiftedAtlas[0,*] gt x_pos_frame-condensekernel AND ShiftedAtlas[1,*] lt y_pos_frame+condensekernel AND ShiftedAtlas[1,*] gt y_pos_frame-condensekernel)
		IF pos[0] NE -1 THEN BEGIN
			adapt_coor=pos[0]
		ENDIF
	ENDIF

	IF event.release EQ 1  AND adapt_coor GT -1 THEN BEGIN
		ShiftedAtlas[0:1,adapt_coor]=[x_pos_frame,y_pos_frame]
		adapt_coor=-1
	ENDIF
	refreshcoors
ENDIF

;////////////////////////////////////////////////////////////

;/// Here comes the coordinate shift with the arrow keys
;print,event
IF event.type eq 6 AND event.key gt 0 AND event.release eq 1 then begin
	x_shift=0
	y_shift=0

	if event.key eq 5 then begin
		ShiftedAtlas[0,*]=ShiftedAtlas[0,*]-1
		;pos=where(ShiftedAtlas[0,*] lt 0,count)
		;if count ne 0 then ShiftedAtlas[0,pos]=ArrayDims[1]-1
	endif
	if event.key eq 6 then begin
		ShiftedAtlas[0,*]=ShiftedAtlas[0,*]+1
		;pos=where(ShiftedAtlas[0,*] gt ArrayDims[1]-1,count)
		;if count ne 0 then ShiftedAtlas[0,pos]=0
	endif
	if event.key eq 7 then begin
		ShiftedAtlas[1,*]=ShiftedAtlas[1,*]-1
		;pos=where(ShiftedAtlas[1,*] gt ArrayDims[2]-1,count)
		;if count ne 0 then ShiftedAtlas[1,pos]=0
	endif
	if event.key eq 8 then begin
		ShiftedAtlas[1,*]=ShiftedAtlas[1,*]+1
		;pos=where(ShiftedAtlas[1,*] lt 0,count)
		;if count ne 0 then ShiftedAtlas[1,pos]=ArrayDims[2]-1
	endif
	refreshcoors
ENDIF

END

;////////////////////////////////////////////////////////////////////////////////////////////////////////
;////////////////////////////////////////////////////////////////////////////////////////////////////////


PRO AdaptCoordinates_event,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON COORS
COMMON WIDGET_IDS
COMMON WINDOW_IDS
widget_control,event.id,get_uvalue=widget

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN DestroyWindow,"AdaptCoors" ELSE BEGIN

	IF (widget EQ 'Reset_Coors') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			ShiftedAtlas=Atlas
			widget_control,coors_slider_x,SET_VALUE=0
			widget_control,coors_slider_y,SET_VALUE=0
			widget_control,coors_slider_z,SET_VALUE=0
			widget_control,slider_scale_x,SET_VALUE=100
			widget_control,slider_scale_y,SET_VALUE=100
			last_x=0
			last_y=0
			last_z=0
			scaled_x=100
			scaled_y=100
			refreshcoors
		ENDIF
	ENDIF

	IF (widget EQ 'text') THEN BEGIN
		widget_control,event.id,get_value=temp
		ShiftedAtlas=RotateArray(ShiftedAtlas,mid_point,float(temp))
		refreshcoors
	ENDIF


	IF (widget EQ 'Load_Coors') THEN BEGIN
		filename=''
		filename=DIALOG_PICKFILE(/read,/MUST_EXIST,FILTER='*.coor',PATH=sapath)
		if filename ne '' then begin
			openR, unit,filename, /get_lun
			readF, unit, NumListe
			Atlas=fltarr(4,NumListe)
			FOR i = 0, Numliste-1 do begin
				readF, unit, a, b, c;, d
				Atlas[0,i]=float(a)
				Atlas[1,i]=float(b)
				Atlas[2,i]=float(0)
				Atlas[3,i]=float(c)
				;result[3,i]=string(fix(d))
			ENDFOR
			free_lun,unit
			ShiftedAtlas=Atlas
			ArrayDims=SIZE(data)
		limit=(abs(ArrayDims[1]-ArrayDims[2])*resize)/2
		IF ArrayDims[1] GT ArrayDims[2] THEN BEGIN
			window_size=ArrayDims[1]*resize
			x_border=0
			y_border=limit
		ENDIF ELSE BEGIN
			window_size=ArrayDims[2]*resize
			x_border=limit
			y_border=0
		ENDELSE
		mid_point=[x_border+ArrayDims[1]/2,y_border+ArrayDims[2]/2,0]
		refreshcoors
		endif
	ENDIF

	IF (widget EQ 'Save_Coors') THEN BEGIN
		IF string(ShiftedAtlas[0]) ne 'Empty' then begin
			temp=strsplit(fn,'.',/EXTRACT)
			temp=temp[0]+'.coor'
			filename=DIALOG_PICKFILE(/write,FILTER='*.coor',PATH=sapath,FILE=temp)
			if filename ne '' then begin
				form=fline([5],['A'])
				openw, unit,filename, /get_lun
				printf,unit, string(n_elements(ShiftedAtlas[0,*]))
				for i=0, n_elements(shiftedAtlas[0,*])-1 do begin
					printf,FORMAT=form,unit,ShiftedAtlas[*,i]
				endfor;
				free_lun,unit
				sapath=dirname(filename)
			endif
		ENDIF
	ENDIF

	IF (widget EQ 'Mirror_CorrsX') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			ArrayDims=SIZE(data)
			ShiftedAtlas[0,*]=ArrayDims[1]-1-ShiftedAtlas[0,*]
			refreshcoors
		ENDIF
	ENDIF

	IF (widget EQ 'Mirror_CorrsY') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			ArrayDims=SIZE(data)
			ShiftedAtlas[1,*]=ArrayDims[2]-1-ShiftedAtlas[1,*]
			refreshcoors
		ENDIF
	ENDIF

	IF (widget EQ 'scale_X') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			widget_control,event.id,GET_VALUE=temp
			scale=temp-scaled_x+100
			FOR I=0,N_ELEMENTS(ShiftedAtlas[0,*])-1 DO BEGIN
				xm=ShiftedAtlas[0,i]-mid_point[0]
				xnew=fix(xm*(scale/100.0))
				ShiftedAtlas[0,i]=xnew+mid_point[0]

			ENDFOR
			refreshcoors
			scaled_x=temp
		ENDIF ELSE widget_control,event.id,SET_VALUE=100
	ENDIF

	IF (widget EQ 'scale_Y') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			widget_control,event.id,GET_VALUE=temp
			scale=temp-scaled_y+100
			FOR I=0,N_ELEMENTS(ShiftedAtlas[1,*])-1 DO BEGIN
				ym=ShiftedAtlas[1,i]-mid_point[1]
				ynew=fix(ym*(scale/100.0))
				ShiftedAtlas[1,i]=ynew+mid_point[1]

			ENDFOR
			refreshcoors
			scaled_y=temp
		ENDIF ELSE widget_control,event.id,SET_VALUE=100
	ENDIF

	IF (widget EQ 'x_rotate') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			widget_control,event.id,GET_VALUE=alpha
			alpha_temp=fix(alpha-last_x)
			ShiftedAtlas=rotatearray(ShiftedAtlas,mid_point,alpha_temp,'X')
			last_x=alpha
			refreshcoors
		ENDIF ELSE widget_control,event.id,SET_VALUE=0
	ENDIF

	IF (widget EQ 'y_rotate') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			widget_control,event.id,GET_VALUE=alpha
			alpha_temp=fix(alpha-last_y)
			ShiftedAtlas=rotatearray(ShiftedAtlas,mid_point,alpha_temp,'Y')
			last_y=alpha
			refreshcoors
		ENDIF ELSE BEGIN
			widget_control,event.id,SET_VALUE=0
		ENDELSE
	ENDIF

	IF (widget EQ 'z_rotate') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			widget_control,event.id,GET_VALUE=alpha
			alpha_temp=fix(alpha-last_z)
			ShiftedAtlas=rotatearray(ShiftedAtlas,mid_point,alpha_temp,'Z')
			last_z=alpha
			refreshcoors
		ENDIF ELSE widget_control,event.id,SET_VALUE=0
	ENDIF

	IF (widget eq 'draw_coors_xy') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
			ClickActionCoors,event
		ENDIF
	ENDIF

	IF (widget EQ 'result_size') THEN BEGIN
		widget_control,event.id,GET_VALUE=temp
		result_size=temp
		refreshcoors
	ENDIF

	IF (widget EQ 'atlas_size') THEN BEGIN
		widget_control,event.id,GET_VALUE=temp
		atlas_size=temp
		refreshcoors
	ENDIF

	IF (widget eq 'transfer') THEN BEGIN
		IF string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
		ArrayDims=size(data)
		pos=WHERE(ShiftedAtlas[0,*] GE 1 AND ShiftedAtlas[0,*] LT ArrayDims[1]-1 AND ShiftedAtlas[1,*] GE 1 AND ShiftedAtlas[1,*] LT ArrayDims[2]-1)
		IF pos[0] NE -1 THEN ShiftedAtlas=ShiftedAtlas[*,pos]
			IF string(result[0]) NE 'Empty' THEN BEGIN
				FOR I=0,N_ELEMENTS(result[0,*])-1 DO BEGIN
					pos=WHERE(ShiftedAtlas[3,*] EQ result[2,I])
					IF pos NE -1 THEN ShiftedAtlas[0:1,pos]=result[0:1,I]
				ENDFOR
			ENDIF
			result=intarr(4,N_ELEMENTS(ShiftedAtlas[0,*]))
			result[0,*]=fix(ShiftedAtlas[0,*])
			result[1,*]=fix(ShiftedAtlas[1,*])
			result[2,*]=fix(ShiftedAtlas[3,*])
			refreshscreen
			refreshcorrel
			refreshtraces,-1,-1,-1,0
			refreshtraces,-1,-1,-1,1
		ENDIF
	ENDIF
ENDELSE

END


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO refreshcoors
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON COORS
COMMON Window_IDS

device,decomposed=1
ArrayDims=SIZE(data)
limit=(abs(ArrayDims[1]-ArrayDims[2])*resize)/2
IF ArrayDims[1] GT ArrayDims[2] THEN BEGIN
	window_size=ArrayDims[1]*resize
	x_border=0
	y_border=limit
ENDIF ELSE BEGIN
	window_size=ArrayDims[2]*resize
	x_border=limit
	y_border=0
ENDELSE
midpoint=[window_size/2,window_size/2,0]

;swidget_control,coors_xy_id,draw_xsize=window_size,draw_ysize=window_size
;widget_control,coors_xz_id,draw_xsize=window_size,draw_ysize=window_size
;widget_control,coors_yz_id,draw_xsize=window_size,draw_ysize=window_size
;widget_control,coors_xy_id,get_value=winnum_xy
;widget_control,coors_xz_id,get_value=winnum_xz
;widget_control,coors_yz_id,get_value=winnum_yz


temp_black=bytarr(window_size,window_size,3)
temp_black[*]=0

temp_xy=temp_black
temp_yz=temp_black
temp_xz=temp_black


step=atlas_size

IF string(ShiftedAtlas[0]) ne 'Empty' THEN BEGIN

	FOR i=0,n_elements(ShiftedAtlas[2,*])-1 DO BEGIN
		x=fix(ShiftedAtlas[0,i])*resize+x_border
		y=fix(ShiftedAtlas[1,i])*resize+y_border
		z=(fix(ShiftedAtlas[2,i])*resize)+window_size/2
		IF x GE 0 AND x LT ArrayDims[1]*resize AND y GE 0 AND y LT ArrayDims[2]*resize THEN BEGIN
			x_start=x-step
			if x_start lt 0 then x_start=0
			x_end=x+step
			if x_end ge window_size then x_end=window_size-1
			y_start=y-step
			if y_start lt 0 then y_start=0
			y_end=y+step
			if y_end ge window_size then y_end=window_size-1
			z_start=z-step
			z_end=z+step

			temp=[255,255,255]
			pos=WHERE(colors[0,*] EQ ShiftedAtlas[3,I])
			IF pos[0] NE -1 THEN BEGIN
				temp[0]=colors[1,pos]
				temp[1]=colors[2,pos]
				temp[2]=colors[3,pos]
			ENDIF
			temp_xy[x_start:x_end,y_start:y_end,0]=temp[0]
			temp_xy[x_start:x_end,y_start:y_end,1]=temp[1]
			temp_xy[x_start:x_end,y_start:y_end,2]=temp[2]

			temp_yz[y_start:y_end,z_start:z_end,0]=temp[0]
			temp_yz[y_start:y_end,z_start:z_end,1]=temp[1]
			temp_yz[y_start:y_end,z_start:z_end,2]=temp[2]

			temp_xz[x_start:x_end,z_start:z_end,0]=temp[0]
			temp_xz[x_start:x_end,z_start:z_end,1]=temp[1]
			temp_xz[x_start:x_end,z_start:z_end,2]=temp[2]

		ENDIF
	ENDFOR



	border_z=window_size/2+midpoint[2]
	temp_xy[midpoint[0]-step:midpoint[0]+step,midpoint[1]-step:midpoint[1]+step,*]=255
	temp_yz[midpoint[1]-step/2:midpoint[1]+step,border_z-step:border_z+step,*]=255
	temp_xz[midpoint[0]-step/2:midpoint[0]+step,border_z-step:border_z+step,*]=255


	wset,winnum_xy
	tv,temp_xy,TRUE=3
	wset,winnum_xz
	tv,temp_xz,TRUE=3
	wset,winnum_yz
	tv,temp_yz,TRUE=3
ENDIF

;IF string(result[0]) NE 'Empty' THEN BEGIN
;	wset,winnum_xy
;	FOR I=0, N_ELEMENTS(result[0,*])-1 DO BEGIN
;		x=fix(result[0,i])*resize+x_border
;		y=fix(result[1,i])*resize+y_border

;		IF x GE 0 AND x LT ArrayDims[1]*resize AND y GE 0 AND y LT ArrayDims[2]*resize THEN BEGIN
;			x_start=x-result_size
;			if x_start lt 0 then x_start=0
;			x_end=x+result_size
;			if x_end gt (ArrayDims[1]-1)*resize then x_end=(ArrayDims[1]-1)*resize
;			y_start=y-result_size
;			if y_start lt 0 then y_start=0
;			y_end=y+result_size
;			if y_end gt (ArrayDims[2]-1)*resize then y_end=(ArrayDims[2]-1)*resize

;			temp=[125,125,125]
;			pos=WHERE(colors[0,*] EQ result[2,I])
;			IF pos[0] NE -1 THEN BEGIN
;				temp[0]=colors[1,pos]
;				temp[1]=colors[2,pos]
;				temp[2]=colors[3,pos]
;			ENDIF
;
;			IF string(ShiftedAtlas[0]) ne 'Empty' THEN BEGIN
;			pos= WHERE (ShiftedAtlas[0,*]-result_size LT result[0,I] AND ShiftedAtlas[0,*]+result_size GT result[0,I] AND ShiftedAtlas[1,*]-result_size LT result[1,I] AND ShiftedAtlas[1,*]+result_size GT result[1,I] AND ShiftedAtlas[3,*] EQ result[2,i])
;				IF pos[0] NE -1 THEN temp=[255,255,255]
;			ENDIF
;			temp_xy[x_start:x_end,y_start:y_end,0]=temp[0]
;			temp_xy[x_start:x_end,y_start:y_end,1]=temp[1]
;			temp_xy[x_start:x_end,y_start:y_end,2]=temp[2]
;		ENDIF
;	ENDFOR
;	tv,temp_xy,TRUE=3
;ENDIF

IF show_name gt 0 AND string(ShiftedAtlas[0]) NE 'Empty' THEN BEGIN
	FOR i=0,n_elements(ShiftedAtlas[2,*])-1 DO BEGIN
		x=fix(ShiftedAtlas[0,i])*resize+x_border
		y=(ArrayDims[2]*resize)-fix(ShiftedAtlas[1,i])*resize+y_border
		name=string(fix(ShiftedAtlas[3,i]))
		xyouts,x,y,name,/DEVICE,font=1,charsize=1.5,color=255,ALIGNMENT=0.7
	ENDFOR
ENDIF


END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO AdaptCoors,base
COMMON ALL
COMMON CORREL
COMMON WIDGET_IDS
COMMON COORS
COMMON Window_IDS

device,get_screen_size=resolution

cd,current=working_dir
colors=bytarr(4,54)
subdir='\bitmaps\'
file=working_dir+subdir+'ColorCodeAtlas.txt'
openr,UNIT,file,/GET_LUN
readF, unit, colors
free_lun,Unit

;//////////////   Correlation Widget       ////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
coors_base=widget_base(column=1,mbar=mbar,title="AdaptCoordinates",GROUP_LEADER=base,/TLB_KILL_REQUEST_EVENTS)
coors_buttons=widget_base(coors_base,row=1)
subdir='\accessories\bitmaps\'
file=working_dir+subdir+'open.bmp'
coors_load=widget_button(coors_buttons,value=file,uvalue='Load_Coors',/bitmap)
file=working_dir+subdir+'save.bmp'
coors_save=widget_button(coors_buttons,value=file,uvalue='Save_Coors',/bitmap)

coors_reset=widget_button(coors_buttons,uvalue='Reset_Coors',value='Reset')

coors_mirrorX=widget_button(coors_buttons,uvalue='Mirror_CorrsX',value='MirrorX')

coors_mirrorY=widget_button(coors_buttons,uvalue='Mirror_CorrsY',value='MirrorY')

coors_transfer=widget_button(coors_buttons,uvalue='transfer',value='Transfer')

slider_base=widget_base(coors_base,row=1)

slider_xy_base=widget_base(slider_base,column=1)
z_rotate_coors=widget_slider(slider_xy_base,MAXIMUM=180,MINIMUM=-180,Title='Rotate along Z',uvalue='z_rotate',value=0)
draw_coors_xy=widget_draw(slider_xy_base,uvalue='draw_coors_xy',RETAIN=1,/KEYBOARD_EVENTS,/BUTTON_EVENTS,/MOTION_EVENTS)
scale_x_slider=widget_slider(slider_xy_base,MAXIMUM=400,MINIMUM=0,Title='Scale X%',uvalue='scale_X',value=100)
scale_y_slider=widget_slider(slider_xy_base,MAXIMUM=400,MINIMUM=0,Title='Scale Y%',uvalue='scale_Y',value=100)

slider_xz_base=widget_base(slider_base,column=1)
y_rotate_coors=widget_slider(slider_xz_base,MAXIMUM=45,MINIMUM=-45,Title='Rotate along Y',uvalue='y_rotate',value=0)
draw_coors_xz=widget_draw(slider_xz_base,uvalue='draw_coors_xz',RETAIN=1)

slider_yz_base=widget_base(slider_base,column=1)
x_rotate_coors=widget_slider(slider_yz_base,MAXIMUM=45,MINIMUM=-45,Title='Rotate along X',uvalue='x_rotate',value=0)
draw_coors_yz=widget_draw(slider_yz_base,uvalue='draw_coors_yz',RETAIN=1)

result_size=widget_slider(coors_base,uvalue='result_size',MAXIMUM=10,MINIMUM=1,Title='Coordinate Size',value=1)
atlas_size=widget_slider(coors_base,uvalue='atlas_size',MAXIMUM=10,MINIMUM=1,Title='Atlas Size',value=1)

slider_scale_x=scale_x_slider
slider_scale_y=scale_y_slider
coors_xy_id=draw_coors_xy
coors_yz_id=draw_coors_yz
coors_xz_id=draw_coors_xz
coors_slider_x=x_rotate_coors
coors_slider_y=y_rotate_coors
coors_slider_z=z_rotate_coors

AdaptCoors_ID=coors_base

widget_control,coors_base,/realize,XOFFSET=resolution[0]-300,YOFFSET=200
xmanager,'AdaptCoordinates',coors_base,/no_block

END