;////////////////////////////////////////////////////////////////////////////////////////////////////////
;////////////////////////////////////////////////////////////////////////////////////////////////////////

FUNCTION CorrelSegment, ThreeDStack, kernelsize
COMMON widget_ids
ArrayDims=SIZE(ThreeDStack)
IF ArrayDims[0] EQ 3 THEN BEGIN
	correl_image=fltarr(ArrayDims[1],ArrayDims[2])
	correl_image[*,*]=0.0
	FOR i=0, ArrayDims[1]-1 DO BEGIN
		FOR j=0, ArrayDims[2]-1 DO BEGIN
			neighbours=getneighbours(i,j,ArrayDims,kernelsize,ThreeDStack)
			DimsNeighbours=size(neighbours)
			sum=-1.0 ;// Because soon there will be an additional autocorrelation which always yields 1
			a=reform(ThreeDStack[i,j,*])
			FOR k=0,DimsNeighbours[1]-1 DO BEGIN
				b=neighbours[k,*]
				b=reform(b)
				sum=sum+abs(correlate(a,b))
			ENDFOR
			correlation=sum/float(n_elements(neighbours)/2-1)
			;if correlation lt 0.3 then correlation=0
			correl_image[i,j]=correlation
		ENDFOR
		progress=i/(ArrayDims[1]/100)
		IF progress MOD 10 EQ 0 THEN BEGIN
			progress=string(progress)+'%'
			widget_control,correl_progress_id,set_value=progress
		ENDIF

	ENDFOR
	RETURN,correl_image
ENDIF ELSE RETURN,-1

END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO Correlations_event,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON WINDOW_IDS
widget_control,event.id,get_uvalue=widget

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN DestroyWindow,"Correlations" ELSE BEGIN

	IF (widget EQ 'reset') THEN BEGIN
		IF string(correl_image[0]) NE 'Empty' THEN BEGIN
			correl_image=bytscl(correl_image_raw)
			widget_control,slider_brigthness,set_value=0
			widget_control,slider_contrast,set_value=0
			brigthness_mem=0
			contrast_mem=0
			refreshcorrel,event
		ENDIF
	ENDIF
	IF (widget EQ 'contrast') THEN BEGIN
		IF string(correl_image[0]) NE 'Empty' THEN BEGIN
			IF event.value NE 0 THEN BEGIN
				correl_image=bytscl(correl_image_raw)
				correl_image=correl_image+brigthness_mem
				temp= WHERE(correl_image GT 255)
				IF temp[0] NE -1 THEN correl_image[temp]=255
				temp= WHERE(correl_image LT 0)
		    	IF temp[0] NE -1 THEN correl_image[temp]=0
				IF event.value LT 0 THEN correl_image=correl_image/(1+(-1.0*event.value)/10.0) 	ELSE correl_image=correl_image*(1+event.value/10.0)
				temp= WHERE(correl_image GT 255)
				IF temp[0] NE -1 THEN correl_image[temp]=255
				temp= WHERE(correl_image LT 0)
		    	IF temp[0] NE -1 THEN correl_image[temp]=0
		    	contrast_mem=event.value
		 		refreshcorrel,event
		 	ENDIF
		ENDIF
	ENDIF

	IF (widget EQ 'brigthness') THEN BEGIN
		IF string(correl_image[0]) NE 'Empty' THEN BEGIN
			correl_image=bytscl(correl_image_raw)
			IF contrast_mem LT 0 THEN correl_image=correl_image/(-1.0)*(1+contrast_mem/10.0) ELSE correl_image=correl_image*(1+contrast_mem/10.0)
			temp= WHERE(correl_image GT 255)
			IF temp[0] NE -1 THEN correl_image[temp]=255
			temp= WHERE(correl_image LT 0)
			IF temp[0] NE -1 THEN correl_image[temp]=0
			correl_image=correl_image+event.value
			temp= WHERE(correl_image GT 255)
			IF temp[0] NE -1 THEN correl_image[temp]=255
			temp= WHERE(correl_image LT 0)
			IF temp[0] NE -1 THEN correl_image[temp]=0
			brigthness_mem=event.value
			refreshcorrel,event
		ENDIF
	ENDIF

	IF (widget EQ 'correlate_Correl') THEN BEGIN
		IF string(data[0]) NE 'Empty' THEN BEGIN

			correl_image_raw=CorrelSegment(data,1)
			correl_image=bytscl(correl_image_raw)
			brigthness_mem=0
			contrast_mem=0
			refreshcorrel,event
			IF GetCoors_ID NE 0 THEN refreshscreen

		ENDIF

	ENDIF

	IF (widget EQ 'load_Correl') THEN BEGIN
		filename=DIALOG_PICKFILE(/read,/MUST_EXIST,FILTER='*_correl.tif',PATH=sapath,FILE=temp)
		IF filename NE '' THEN BEGIN
			correl_image_raw=read_tiff(filename)
			correl_image=correl_image_raw
			refreshcorrel,event
			widget_control,slider_brigthness,set_value=0
			widget_control,slider_contrast,set_value=0

		ENDIF
	ENDIF

	IF (widget EQ 'save_Correl') THEN BEGIN
		IF string(correl_image[0]) NE 'Empty' THEN BEGIN
			loadct,0,/SILENT
			ArrayDims=SIZE(correl_image)
			temp=fn+'_correl.tif'
			filename=DIALOG_PICKFILE(/write,FILTER='*_correl.tif',PATH=sapath,FILE=temp)
			tempframe=bytscl(correl_image)
			IF filename NE '' THEN BEGIN
				tvlct,r,g,b,/GET
				write_tiff,filename,tempframe,red=r,green=g,blue=b
				sapath=dirname(filename)
				start_name=strpos(filename,'\',/REVERSE_SEARCH)
				end_name=strpos(filename,'.',/REVERSE_SEARCH)
				filename=strmid(filename,start_name+1,end_name-start_name)
			ENDIF
		ENDIF
	ENDIF


	IF (widget eq 'draw_correl') THEN BEGIN
		refreshflag=0
		IF string(correl_image[0]) NE 'Empty' THEN BEGIN
			ArrayDims=SIZE(correl_image)
			IF ArrayDims[0] EQ 3 THEN BEGIN
				ArrayDims[1]=ArrayDims[2]
				ArrayDims[2]=ArrayDims[3]
				ArrayDims[3]=3
			ENDIF
			x_pos=event.X/resize
			y_pos=ArrayDims[2]-(event.Y/resize)
			result=Coordinates[*,*,actualcoordinates]
			num_entries=where(result[0,*] NE '-1000')
			IF event.release EQ 4 AND num_entries[0] NE -1 THEN BEGIN
				pos=where(fix(result[0,*]) LT x_pos+condensekernel AND fix(result[0,*]) GT x_pos-condensekernel AND fix(result[1,*]) LT y_pos+condensekernel AND fix(result[1,*]) GT y_pos-condensekernel)
				IF pos[0] NE -1 THEN BEGIN
					IF N_ELEMENTS(num_entries) EQ 1 THEN BEGIN
						result[*]='-1000'
					ENDIF ELSE result[*,pos]='-1000'
				ENDIF
			refreshflag=1
			ENDIF
			IF event.release EQ 1 THEN BEGIN
				IF num_entries[0] NE -1 THEN BEGIN
					glom=MAX(fix(result[2,*]))+1
					pos=where(fix(result[0,*]) LT x_pos+condensekernel AND fix(result[0,*]) GT x_pos-condensekernel AND fix(result[1,*]) LT y_pos+condensekernel AND fix(result[1,*]) GT y_pos-condensekernel)
					IF pos[0] EQ -1 THEN BEGIN
						odor='Corr'
						pos=min(where(result[0,*] EQ '-1000'))
						IF pos[0] NE -1 THEN result[*,pos]=[string(x_pos),string(y_pos),string(glom),string(odor)]
					ENDIF
				ENDIF ELSE BEGIN
					glom=300
					odor='Corr'
					result[*,0]=[string(x_pos),string(y_pos),string(glom),string(odor)]
				ENDELSE
				refreshflag=1
			ENDIF
			Coordinates[*,*,actualcoordinates]=result
		ENDIF
		if refreshflag eq 1 then begin
			refreshcorrel,event
			refreshscreen
			refreshtable
		ENDIF
	ENDIF
ENDELSE
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;///////////////////////////


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO refreshcorrel,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON Window_IDS
IF string(correl_image[0]) ne 'Empty' THEN BEGIN
	ArrayDims=SIZE(correl_image)
	IF ArrayDims[0] EQ 2 THEN BEGIN
		widget_control,correl_id,draw_xsize=ArrayDims[1]*resize,draw_ysize=ArrayDims[2]*resize
		widget_control,correl_id,get_value=winnum2
		wset,winnum2
		correl_temp=rebin(correl_image,ArrayDims[1]*resize,ArrayDims[2]*resize)
		IF string(result[0]) ne 'Empty' then begin
			step=resize/2
			FOR i=0,n_elements(result[2,*])-1 DO BEGIN
				x=fix(result[0,i])*resize
				y=fix(result[1,i])*resize
				IF x GE 0 AND x LT ArrayDims[1]*resize AND y GE 0 AND y LT ArrayDims[2]*resize THEN BEGIN
					x_start=x-step
					if x_start lt 0 then x_start=0
					x_end=x+step
					if x_end gt (ArrayDims[1]-1)*resize then x_end=(ArrayDims[1]-1)*resize
					y_start=y-step
					if y_start lt 0 then y_start=0
					y_end=y+step
					if y_end gt (ArrayDims[2]-1)*resize then y_end=(ArrayDims[2]-1)*resize
					correl_temp[x_start:x_end,y_start:y_end]=0
				ENDIF
			ENDFOR
		ENDIF


		loadct,0,/SILENT
		tv,correl_temp
	ENDIF
	IF ArrayDims[0] EQ 3 THEN BEGIN
		widget_control,correl_id,draw_xsize=ArrayDims[2]*resize,draw_ysize=ArrayDims[3]*resize
		widget_control,correl_id,get_value=winnum2
		wset,winnum2
		correl_temp=intarr(ArrayDims[2]*resize,ArrayDims[3]*resize,ArrayDims[1])
		temp=intarr(ArrayDims[2],ArrayDims[3])
		temp[*,*]=correl_image[0,*,*]
		correl_temp[*,*,0]=rebin(temp,ArrayDims[2]*resize,ArrayDims[3]*resize)
		temp[*]=correl_image[1,*,*]
		correl_temp[*,*,1]=rebin(temp,ArrayDims[2]*resize,ArrayDims[3]*resize)
		temp[*]=correl_image[2,*,*]
		correl_temp[*,*,2]=rebin(temp,ArrayDims[2]*resize,ArrayDims[3]*resize)
		IF string(result[0]) ne 'Empty' then begin
			step=resize/2
			FOR i=0,n_elements(result[2,*])-1 DO BEGIN
				x=fix(result[0,i])*resize
				y=fix(result[1,i])*resize
				IF x GE 0 AND x LT ArrayDims[2]*resize AND y GE 0 AND y LT ArrayDims[3]*resize THEN BEGIN
					x_start=x-step
					if x_start lt 0 then x_start=0
					x_end=x+step
					if x_end gt (ArrayDims[2]-1)*resize then x_end=(ArrayDims[2]-1)*resize
					y_start=y-step
					if y_start lt 0 then y_start=0
					y_end=y+step
					if y_end gt (ArrayDims[3]-1)*resize then y_end=(ArrayDims[3]-1)*resize
					correl_temp[x_start:x_end,y_start:y_end,*]=0
				ENDIF
			ENDFOR
		ENDIF


		loadct,0,/SILENT
		tv,correl_temp,true=3
	ENDIF
	IF ArrayDims[0] EQ 3 THEN BEGIN
		ArrayDims[1]=ArrayDims[2]
		ArrayDims[2]=ArrayDims[3]
		ArrayDims[3]=3
	ENDIF

	if show_name gt 0 AND string(result[0,0]) ne 'Empty' then begin
		for i=0,n_elements(result[2,*])-1 do begin
			x=fix(result[0,i])*resize
			y=(ArrayDims[2]*resize)-fix(result[1,i])*resize
			name=string(result[2,i])
			xyouts,x,y,name,/DEVICE,font=1,charsize=1.5,color=0,ALIGNMENT=0.7
		endfor
	endif
ENDIF

END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO CORRELATIONS,base
COMMON ALL
COMMON CORREL
COMMON WIDGET_IDS
COMMON Window_IDS
device,get_screen_size=resolution

;//////////////   Correlation Widget       ////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
correl_base=widget_base(column=1,mbar=mbar,title="Correlations",GROUP_LEADER=base,/TLB_KILL_REQUEST_EVENTS)
correl_buttons=widget_base(correl_base,row=1)
correl_load=widget_button(correl_buttons,value='Correlate',uvalue='correlate_Correl')
subdir='\bitmaps\'
file=working_dir+subdir+'open.bmp'
correl_load=widget_button(correl_buttons,value=file,uvalue='load_Correl',/bitmap)
file=working_dir+subdir+'save.bmp'
correl_save=widget_button(correl_buttons,value=file,uvalue='save_Correl',/bitmap)
correl_reset=widget_button(correl_buttons,uvalue='reset',value='Reset')
draw_correl=widget_draw(correl_base,uvalue='draw_correl',RETAIN=1,/button_events,/MOTION_EVENTS)
contrast_correl=widget_slider(correl_base,MAXIMUM=100,MINIMUM=-100,uvalue='contrast',value=0)
brigthness_correl=widget_slider(correl_base,MAXIMUM=255,MINIMUM=-255,uvalue='brigthness',value=0)
label_base=widget_base(correl_base,row=1)
correl_label1=widget_label(label_base,uvalue='Progress',value='Progress: ')
prog='0%'
correl_label2=widget_label(label_base,uvalue='ProgVal',value=prog)
correl_id=draw_correl
correlate_id=correl_base
slider_contrast=contrast_correl
slider_brigthness=brigthness_correl
correl_progress_id=correl_label2


widget_control,correl_base,/realize,XOFFSET=0,YOFFSET=resolution[1]-200
xmanager,'Correlations',correl_base,/no_block

END