
COMMON ALL,resize,rebinfactor,show_name,result,coordinates,no_measurements,lopath,sapath,fn,data,lastframes,parameters,measurements,filenamelist,working_dir,resolution,$
        Exptslist,actualcoordinates,rawdata,FancyStack, $
        newDefaults ;;1107 structure with default values for medianwidht, smoothwidth, stimulus...
COMMON CTVS,border,ncols,nrows,xval,yval,ctvimages,rawimages,ctvimages_raw,tilllog,threshold,condensekernel,chosenframes,framethreshold,waterlist,maxflag,messungslist,odorlist,showsequence,sorted,spath,no_one,no_two,ctv_method,maskimage, $
         ctv_firstframe, ctv_lastframe,ctv_coor,raw_images_noshift,ctv_lowscale,ctv_highscale,colortab,experiments_visible,filetree
COMMON TOGGLES,data_medianed,smoothed,medianed,data_masked,raw_ims,$
      loadwithshifts,loadwithcoors,correctSL, Medianflag,calcRatios,FilterNames,$
      Filter,LoadMeth,bleachcorrect,load_raw
COMMON CORREL,correl_image_raw,correl_image,contrast_mem,brigthness_mem,maskfather_id
COMMON CORRECT_MOV,raw_shift_staple,raw_mov_staple,image_staple,shift_reference,mov_reference,shiftlist,movlist, $
       frames_or_measurements, $ ;;1107 0: mov. correct. between frames 1: mov. correct. within measurement 2: Both: (loading movement from file ??)
       x_pos,y_pos,error,enlarge,count,TreeWidget,widget_error,widget_fn,active,rawborder, $
         applied_shifts,applied_movs,shifts_applied_list,movs_applied_list,tupel,last_shifts,this_frame,changed
COMMON SHOW_TRACES,colortable,linetype, min_y_val,max_y_val,ControlLine,glomeruli,glom_colors,panelsize,legend_entry_positions,legend_entry_names,blacklist,showlist,traces_measurements_id,measurements_entry_positions
COMMON SHOW_MOVIE,presentframe,movie_measurement,show_dots,movie_no
COMMON MaskVars,tempmask,region,sliderval,maskdraw_id,start_draw,start_delete,fillarea
COMMON EditParams,text0,text00,text1,text2,text3,text4,text5,text6,text7,text8,text9, text10,text11, text12,params_tree,params_tree_ID,selection,checkbox_base0
COMMON COORS,Atlas, ShiftedAtlas,TempAtlas,pressed,start_point,mid_point,x_border,y_border,window_size,last_x,last_y,last_z,adapt_coor,result_size,atlas_size,scaled_x,scaled_y,colors
COMMON WIDGET_IDS, tlb_parameters_id, table_id,draw_id,draw_id_movcorr,fn_id,diff_id,diff_one_id,diff_two_id,correl_id,slider_contrast,slider_brigthness,traces_scroll_id,correl_progress_id,tree_base_id,traces_legend_id, $
         measu_id,frame_id,measu_label_id,coors_xy_id,coors_yz_id,coors_xz_id,coors_slider_x,coors_slider_y,coors_slider_z,slider_scale_x,slider_scale_y,scalelow_id,scalehigh_id,traces_wid,traces_mean_wid, $
         MIN_Y_VAL_TEXT,MAX_Y_VAL_TEXT
COMMON GetLogFiles,folder,logfilenames,logfiles,struct,wtbase,counterlist,$
       namelist,xlist,ylist,zlist,VisionFilenameList,timelist,diffvals,Experimentlist,$
       hide_waves,isDenominator,isNumerator
COMMON Window_IDS,GetCoors_ID,Mask_ID,Traces_ID,Correlate_ID,MovementCorrect_ID,AdaptCoors_ID,GetCoordinates_ID
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

;;Event handler
PRO EditParameters_event,event
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON GetLogFiles
COMMON Window_IDS
COMMON EditParams
widget='Empty'

;1107 get UVALUE of current event
widget_control,event.id,get_uvalue=widget
IF KEYWORD_SET(widget) THEN BEGIN

	IF n_tags(widget) NE 0 THEN BEGIN
	  widget_control, /hourglass
	       IF widget.Name eq "browse" THEN BEGIN
	         IF (LoadMeth NE 1) THEN BEGIN
	          GetAllLogfilenames
	         ENDIF
	         IF (LoadMeth EQ 1) THEN BEGIN
	          GetAllLSMFiles
	          ;;1107 no xml files (future?)GetAllXmlFilenames
	         ENDIF
	       ENDIF ELSE BEGIN

	         IF event.id gt wtbase AND (widget.Numerator NE "Folder" AND widget.Numerator NE "None") THEN BEGIN
	          IF event.clicks EQ 2 THEN BEGIN ; Doppelklick
	              IF LoadMeth NE 1 THEN BEGIN
	                 LoadVisionStack,widget,1
	              ENDIF
	              IF LoadMeth EQ 1 THEN BEGIN
	                 LoadVisionStack,widget,1
	              ENDIF
	          ENDIF
	         ENDIF
	       ENDELSE
	ENDIF ELSE BEGIN

	       IF (widget EQ 'LS') THEN BEGIN

	         a=widget_info(wtbase,/TREE_SELECT)
           ;;1107
           widget_control, /hourglass

	         IF a[0] NE -1 THEN BEGIN
	          ;;1107 why to change order of measurements ?? a=reverse(a)
	          length=N_ELEMENTS(a)

;;1107 Tested: Now runs with one measurement selected, length eq 1 does not make sense !?
;	          IF length EQ 1 THEN BEGIN
;	              widget_control,a[0],get_uvalue=widget_temp
;	              IF a[0] gt wtbase AND (widget_temp.Numerator NE "Folder" AND widget_temp.Numerator NE "None") THEN BEGIN
;	                 widgetlist=widget_temp
;	              ENDIF ELSE BEGIN
;	                 IF a[0] gt wtbase AND (widget_temp.Numerator EQ "Folder") AND CalcRatios EQ 1 THEN BEGIN
;
;	                 ENDIF
;	              ENDELSE
;
;	          ENDIF ELSE BEGIN
	              FOR I=0,length-1 DO BEGIN
	                 widget_control,a[i],get_uvalue=widget_temp
	                 IF a[i] gt wtbase AND (widget_temp.Numerator NE "Folder" AND widget_temp.Numerator NE "None") THEN BEGIN
	                   IF i EQ 0 THEN widgetlist=widget_temp ELSE widgetlist=[widgetlist,widget_temp]
	                 ENDIF
	              ENDFOR
	              IF LoadMeth NE 1 THEN BEGIN
	                 LoadVisionStack,widgetlist,n_elements(widgetlist)
	              ENDIF
	              IF LoadMeth EQ 1 THEN BEGIN
	                 LoadVisionStack,widgetlist,n_elements(widgetlist)
	              ENDIF
;	          ENDELSE
	         ENDIF
	       ENDIF

	       IF (widget EQ 'DS') THEN BEGIN
	         a=widget_info(params_tree_ID,/TREE_SELECT)
	         IF a[0] NE -1 THEN BEGIN
	          IF n_elements(a) LT n_elements(parameters) THEN BEGIN
	              deleteselection
	          ENDIF ELSE BEGIN
	              IF n_elements(a) EQ n_elements(parameters) THEN BEGIN
	                 EmptyVars
	                 IF GetCoors_ID NE 0 THEN RefreshTable
	              ENDIF
	          ENDELSE

	          IF MovementCorrect_ID NE 0 THEN refresh
	          IF Correlate_ID NE 0 THEN refreshcorrel
	          IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
	          IF GetCoordinates_ID NE 0 THEN refreshscreen
	          RefreshParameters
	         ENDIF
	         shift_reference=n_elements(parameters)-1
	       ENDIF


	       IF (widget EQ 'DA') THEN BEGIN
	         EmptyVars
	         selection=-1
	         RefreshParameters
	         IF MovementCorrect_ID NE 0 THEN refresh
	         IF GetCoors_ID NE 0 THEN refreshscreen
	         IF Correlate_ID NE 0 THEN refreshcorrel
	         IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
	         IF GetCoordinates_ID NE 0 THEN BEGIN
	          refreshscreen
	          RefreshTable
	         ENDIF


	       ENDIF

;;1107 not used
;;	       IF (widget EQ 'LoadLogFileList') THEN BEGIN
;;	         f=dialog_pickfile(/read,FILTER='*.sav')
;;	         IF f NE '' THEN BEGIN
;;	          restore,f
;;	          folder=FolderTree.folder
;;	          logfilenames=FolderTree.logfilenames
;;	          counterlist=FolderTree.counterlist
;;	          namelist=FolderTree.namelist
;;	          xlist=FolderTree.xlist
;;	          ylist=FolderTree.ylist
;;	          zlist=FolderTree.zlist
;;	          VisionFilenamelist=FolderTree.VisionFilenamelist
;;	          ExperimentList=FolderTree.ExperimentList
;;	          timelist=FolderTree.timelist
;;	          isDenominator=FolderTree.isDenominator
;;	          isNumerator=FolderTree.isNumerator
;;	          CreateFileTree
;;	         ENDIF
;;	       ENDIF
;;
;;
;;	       IF (widget EQ 'SaveLogFileList') THEN BEGIN
;;	         IF string(logfilenames[0]) NE 'Empty' THEN BEGIN
;;	          FolderTree={folder:folder,logfilenames:logfilenames,counterlist:counterlist,namelist:namelist,xlist:xlist,ylist:ylist,zlist:zlist,VisionFilenamelist:VisionFilenamelist,ExperimentList:Experimentlist,timelist:timelist,$
;;	              isNumerator:isNumerator,isDenominator:isDenominator}
;;	          tree_fn=DIALOG_PICKFILE(/WRITE,FILTER='*.sav')
;;	          if rstrpos(tree_fn,'.sav') EQ -1 THEN tree_fn=tree_fn+'.sav'
;;	          save,FILENAME=tree_fn,FolderTree
;;	         ENDIF
;;	       ENDIF

 IF widget EQ 'EXIT' then widget_control, event.top, /destroy

            ;;1107 not used	       IF (widget EQ 'SaveParams') THEN BEGIN
            ;;	         Saveparameters
            ;;	       ENDIF

	       IF (widget EQ 'MovementCorrectButton') THEN BEGIN
	         IF MovementCorrect_ID EQ 0 THEN CreateWindow,"Movement_correct" ELSE DestroyWindow,"Movement_correct"
	       ENDIF

;;1107
;;	       IF (widget EQ 'CorrelationsButton') THEN BEGIN
;;	         IF Correlate_ID EQ 0 THEN CreateWindow,"Correlations" ELSE DestroyWindow,"Correlations"
;;	       ENDIF
;;1107
;;	       IF (widget EQ 'MaskButton') THEN BEGIN
;;	         IF Mask_ID EQ 0 THEN CreateWindow,"Mask" ELSE DestroyWindow,"Mask"
;;	       ENDIF

	       IF (widget EQ 'TracesButton') THEN BEGIN
	         IF Traces_ID EQ 0 THEN CreateWindow,"Traces" ELSE DestroyWindow,"Traces"

	       ENDIF

	       IF (widget EQ 'InterpolateButton') THEN BEGIN
	         IF AdaptCoors_ID EQ 0 THEN CreateWindow,"AdaptCoors" ELSE DestroyWindow,"AdaptCoors"
	       ENDIF

	       IF (widget EQ 'GetCoorsButton') THEN BEGIN

	         IF GetCoordinates_ID EQ 0 THEN CreateWindow,"GetCoordinates" ELSE DestroyWindow,"GetCoordinates"
	       ENDIF

	       IF (widget EQ 'CorrectSL') THEN BEGIN
	         CorrectSL=-1*CorrectSL
	       ENDIF

	       IF (widget EQ 'MEDIANFLAG') THEN BEGIN
	         Medianflag=-1*Medianflag
	       ENDIF

	         IF( widget EQ "ShowAll") THEN BEGIN
	          IF event.Select EQ 1 THEN BEGIN
	              CalcRatios=-1
	              hide_waves=-1
	              CreateFileTree
	          ENDIF
	         ENDIF


	         IF (widget EQ "CalcRatios") THEN BEGIN
	          IF event.Select EQ 1 THEN BEGIN
	              CalcRatios=1
	              hide_waves=-1
	              CreateFileTree
	          ENDIF
	         ENDIF

;;1107 not used (no button)
	         IF (widget EQ 'Hide_wavelengths') THEN BEGIN
	          IF event.Select EQ 1 THEN BEGIN
	              hide_waves=1
	              CalcRatios=-1
	              CreateFileTree
	          ENDIF
	         ENDIF

	       IF (widget EQ 'LoadTif') THEN BEGIN
	         LoadMeth=1
	         widget_control,checkbox_base0,SENSITIVE=0

	       ENDIF

			IF (widget EQ 'GCamp') THEN BEGIN
	         LoadMeth=2
	         widget_control,checkbox_base0,SENSITIVE=0
	       ENDIF

			IF (widget EQ 'Chameleon') THEN BEGIN
	         LoadMeth=3
	         widget_control,checkbox_base0,SENSITIVE=1
	       ENDIF

	       IF (widget EQ 'LoadTill') THEN BEGIN
	         LoadMeth=4
	         widget_control,checkbox_base0,SENSITIVE=1
	       ENDIF


	       IF (widget EQ 'LoadWithShifts') THEN BEGIN
	         LoadWithShifts=-1*LoadWithShifts
	       ENDIF

	       IF (widget EQ 'LoadWithCoors') THEN BEGIN
	         LoadWithCoors=-1*LoadWithCoors
	       ENDIF


		IF (widget EQ 'CorrectBleach') THEN BEGIN

			bleachcorrect=-1*bleachcorrect

		ENDIF

		IF (widget EQ "loadraw") THEN BEGIN
			load_raw=-1*load_raw
		ENDIF


;;1107 not used
;	       IF (widget EQ 'Filternames') THEN BEGIN
;	         Filternames=-1*Filternames
;	       ENDIF
;;1107 not used
;	       IF (widget EQ 'Filter') THEN BEGIN
;	         widget_control,event.id,get_value=temp
;	         Filter=temp
;	         IF calcRatios EQ 1 THEN CreateRatioFileTree ELSE CreateNormalFileTree
;	       ENDIF

	    IF strpos(widget,"l_") EQ 0 THEN BEGIN
	       a=widget_info(params_tree_ID,/TREE_SELECT)
	       IF a[0] NE -1 THEN BEGIN
	         FOR i=0,N_ELEMENTS(A)-1 DO BEGIN
	          widget_control,a[i],get_uvalue=temp_widget
	          pos=fix(strtrim(strmid(temp_widget,2)))
	          IF i EQ 0 THEN selection=pos ELSE selection=[selection,pos]
	         ENDFOR
	         RefreshParameters
	       ENDIF
	    ENDIF

	    IF widget EQ "ExpName" THEN BEGIN
	       widget_control,event.id,get_value=temp
	       parameters[selection].experiment=temp
	    ENDIF

            ;;1107 not used	    IF widget EQ "OdorName" THEN BEGIN
            ;;	       widget_control,event.id,get_value=temp
            ;;	       parameters[selection].odor=temp
            ;;	    ENDIF
            ;;
            ;;	    IF widget EQ "OdorConc" THEN BEGIN
            ;;	       widget_control,event.id,get_value=temp
            ;;	       parameters[selection].odor_nr=temp
            ;;	    ENDIF
  ;;1107 wg to change, use cw_field...
   IF widget EQ "MEDIANWIDTH" THEN BEGIN
      widget_Control, event.id, get_value= txtval
      on_ioerror, castFault1
      ;widget_Control, event.id, set_value= string(val)
      return
      castFault1:;;reset  value + beep
      widget_control, event.id, set_value = string(newdefaults.medianwidth)
      beep
      return
   end

   IF widget EQ "SMOOTHWIDTH" THEN BEGIN
      widget_Control, event.id, get_value= txtval
      on_ioerror, castFault2
      val = fix(txtval)
      ;;widget_Control, event.id, set_value= string(val)
      return
      castFault2:;;reset  value + beep
      widget_control, event.id, set_value = string(newdefaults.smoothwidth)
      beep
      return
   end

      IF widget EQ "StimulusOn" THEN BEGIN
	       widget_control,event.id,get_value=temp
	        newDefaults.stimulus_on=fix(temp)
	        if size(parameters, /type) eq 8  then parameters.stimulus_on= newDefaults.stimulus_on
	        ;;todo send_event delete all ?
	    ENDIF

	    IF widget EQ "StimulusOff" THEN BEGIN
	       widget_control,event.id,get_value=temp
	       newDefaults.stimulus_off=fix(temp)
	       if  size(parameters, /type) eq 8 then parameters.stimulus_end= newDefaults.stimulus_on
	    ENDIF

	    IF widget EQ "Frequency" THEN BEGIN
	       widget_control,event.id,get_value=temp
	       newDefaults.frequency=fix(temp)
	         if size(parameters, /type) gt 1 then parameters.frequency= newDefaults.frequency
	    ENDIF

	    IF widget EQ "MeaTime" THEN BEGIN
	       widget_control,event.id,get_value=temp
	       parameters[selection].os9time=fix(temp)
	    ENDIF

	ENDELSE
ENDIF
END


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////

FUNCTION GetCurve,x_pos,y_pos,image,kernelsize
imagesize=size(image)
xstart=x_pos-kernelsize
IF xstart LT 0 THEN xstart=0
xend=x_pos+kernelsize
IF xend GE imagesize[1] THEN xend=imagesize[1]-1

ystart=y_pos-kernelsize
IF ystart LT 0 THEN ystart=0
yend=y_pos+kernelsize
IF yend GE imagesize[2] THEN yend=imagesize[2]-1

positions=image[xstart:xend,ystart:yend]
return,reform(positions,n_elements(positions))
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////


PRO RefreshParameters
COMMON ALL
COMMON EditParams
IF selection[0] EQ -1 THEN BEGIN
    widget_control,text0,SET_VALUE=string("NONE")
    widget_control,text9,SET_VALUE=string("NONE")
    widget_control,text1,SET_VALUE=string(0)
    widget_control,text2,SET_VALUE=string(0)
    widget_control,text3,SET_VALUE=string(0)
    widget_control,text4,SET_VALUE=string(newDefaults.frequency)
      ;;1107 not used          widget_control,text5,SET_VALUE=string("NONE")
      ;;          widget_control,text6,SET_VALUE=string(0)
    widget_control,text7,SET_VALUE=string(newDefaults.stimulus_on)
    widget_control,text8,SET_VALUE=string(newDefaults.stimulus_off)
    ;;widget_control,text00,SET_VALUE=string("NONE")
    widget_control,text10,SET_VALUE=string(0)
ENDIF ELSE BEGIN
    temp=parameters[selection[0]]
    widget_control,text0,SET_VALUE=temp.experiment
    widget_control,text9,SET_VALUE=temp.ex_name
    widget_control,text1,SET_VALUE=string(temp.format_x)
    widget_control,text2,SET_VALUE=string(temp.format_y)
    widget_control,text3,SET_VALUE=string(temp.frames)
    widget_control,text4,SET_VALUE=string(temp.frequency)
      ;;1107 not used    widget_control,text5,SET_VALUE=string(temp.odor)
      ;;    widget_control,text6,SET_VALUE=string(temp.odor_nr)
    widget_control,text7,SET_VALUE=string(temp.stimulus_on)
    widget_control,text8,SET_VALUE=string(temp.stimulus_end)
    ;;widget_control,text00,SET_VALUE=string(temp.messungszahl)
    widget_control,text10,SET_VALUE=string(temp.os9time)
ENDELSE
END


PRO GetAllXmlFilenames
COMMON GetLogFiles
folder=DIALOG_PICKFILE(/DIRECTORY)
IF folder NE '' THEN BEGIN
    logfilenames=FILE_SEARCH(folder,"*.xml")
    namelist=''
    xlist=0
    ylist=0
    zlist=0
    VisionFilenamelist=''
    Experimentlist=''
    isNumerator=0
    isDenominator=0
    timelist=0
    FOR I=0,N_ELEMENTS(logfilenames)-1 DO BEGIN
       a=file_lines(logfilenames[I])
       temp=FILE_basename(logfilenames[I])
       temp=strmid(temp,8)
	     temp=strsplit(temp,'.',/EXTRACT)
	     temp=temp[0]
       experimentlist=[experimentlist,temp]
       VisionFileNameList=[VisionFileNameList,logfilenames[i]]
       timelist=[timelist,i]
       isNumerator=[isNumerator,0]
       isDenominator=[isDenominator,0]
       OPENR,UNIT,logfilenames[I],/GET_LUN
       Line=''
       x=0
       y=0
       counter=0
       name='Empty'
       FOR j=0,a-1 DO BEGIN
         readf,unit,line
		IF (strpos(line,'filename=') NE -1) THEN BEGIN
			counter=counter+1
			IF name EQ 'Empty' THEN BEGIN
				temp=strsplit(line,'"',/EXTRACT)
				name=temp[3]
				pos=strpos(name,'_',/REVERSE_SEARCH)
				name=strmid(name,0,pos+1)
			ENDIF

         ENDIF

         IF (strpos(line,'pixelsPerLine') NE -1) THEN BEGIN
        	pos=strpos(line,'value=')
        	x=fix(strmid(line,pos+7,4))

    	ENDIF
    	IF  (strpos(line,'linesPerFrame') NE -1) THEN BEGIN
        	pos=strpos(line,'value=')
        	y=fix(strmid(line,pos+7,4))
    	ENDIF


       ENDFOR
       xlist=[xlist,x]
       ylist=[ylist,y]
       zlist=[zlist,counter]
       namelist=[namelist,name]
       FREE_LUN,unit
    ENDFOR
    counterlist=[0,N_ELEMENTS(logfilenames)]
    namelist=namelist[1:*]
    xlist=xlist[1:*]
    ylist=ylist[1:*]
    zlist=zlist[1:*]
    VisionFilenamelist=VisionFilenamelist[1:*]
    ExperimentList=ExperimentList[1:*]
    timelist=timelist[1:*]
    isNumerator=isNumerator[1:*]
    isDenominator=isDenominator[1:*]

    CreateFileTree

ENDIF
END

;;1107 quick workaround to read Zeiss LSM files
PRO GetAllLSMFiles;
COMMON GetLogFiles
folder=DIALOG_PICKFILE(/DIRECTORY)
IF folder NE '' THEN BEGIN
    logfilenames='' ;;no log files no xml
    lsmfilenames=FILE_SEARCH(folder,"*.lsm", count=n_files)
    counterlist=[0, n_files] ;;1 = one Logfile
    namelist=''
    xlist=0
    ylist=0
    zlist=0
    VisionFilenamelist=''
    Experimentlist=''
    isNumerator=0
    isDenominator=0
    timelist=0
    If lsmfilenames[0] NE "" THEN begin
    ;;loop over LSM files
    FOR I=0,N_ELEMENTS(lsmfilenames)-1 DO BEGIN
       ;;ERASE a=file_lines(lsmfilenames[I])
       temp=FILE_basename(lsmfilenames[I])
       ;;erasetemp=strmid(temp,8) ;?
	     temp=strsplit(temp,'.',/EXTRACT)
	     temp=temp[0]
       namelist=[namelist,temp]
       experimentlist=[experimentlist,temp]
       VisionFileNameList=[VisionFileNameList,lsmfilenames[i]]
       timelist=[timelist,i]
       isNumerator=[isNumerator,0]
       isDenominator=[isDenominator,0]
       flag = query_tiff(lsmfilenames[I], TiffInfo, image_index=0) ;;image 0: grey scale)
       noIm = tiffInfo.NUM_IMAGES/2 ;;pairs of grey scale + TrueColor Images, we only need greyscale !
       if flag eq 0 then begin
         r = dialog_message("Not a valid Tiff file: " +  lsmfilenames[I], /error)
         return
       endif
       x=0
       y=0
       counter=0

;; erase                   ;;loop over tiff images inside current lsm file
;;                      for iFile=0, tiffInfo.NUM_IMAGES-1 do begin
;             ;        counter++
        ; tiffInfo.document_name ;;always empty ?
        x = (TiffInfo.dimensions)[0];pixelsPerLine
        y = (TiffInfo.dimensions)[1];linesPerFrame
        xlist=[xlist,x]
        ylist=[ylist,y]
        zlist=[zlist,noIm]
;;;    ENDFOR ;;images within one lsm file
    endfor ;;lsm files
    ;;throw el.0
    namelist=namelist[1:*]
    xlist=xlist[1:*]
    ylist=ylist[1:*]
    zlist=zlist[1:*]
    VisionFilenamelist=VisionFilenamelist[1:*]
    ExperimentList=ExperimentList[1:*]
    timelist=timelist[1:*]
    isNumerator=isNumerator[1:*]
    isDenominator=isDenominator[1:*]

    CreateFileTree
    ENDIF
  ENDIF
END

PRO GetAllLogfilenames
COMMON GetLogFiles
COMMON toggles
    folder=DIALOG_PICKFILE(/DIRECTORY, PATH="\\Filer1\evo-lab\Optical Imaging\Sonja SoBi3799\Manduca sexta\OR36 knockout")
    IF folder NE '' THEN BEGIN
       logfilenames=FILE_SEARCH(folder,"*.vws.log")
       namelist=''
       xlist=''
       ylist=''
       zlist=''
       VisionFilenamelist=''
       isNumerator=0
       isDenominator=0
       Experimentlist=''
       counterlist=0
       timelist=long(0)
       fatherlist=''
       l=0
       is34=0
       is38=0
       temp_timelist=0
   If logfilenames[0] NE "" THEN begin

    FOR I=0,N_ELEMENTS(logfilenames)-1 DO BEGIN

			IF LoadMeth EQ 2 THEN BEGIN
			   	LoadFuraLogFile,logfilenames[i],temp_timelist,l,fatherlist
			ENDIF

			IF LoadMeth EQ 3 THEN BEGIN
			  	LoadChameleonLogFile,logfilenames[i],temp_timelist,l,fatherlist
			ENDIF


			IF LoadMeth EQ 4 THEN BEGIN
				LoadFuraLogFile,logfilenames[i],temp_timelist,l,fatherlist
			ENDIF

;;1107 if there is a z-stack in the image and log file, its time will be included into temp_timelist
;;
 			timelist=[timelist,0]
         	temp_timelist=temp_timelist[1:*];throw elemnt 0
         	temp_timelist=temp_timelist-temp_timelist[0]
         	timelist=[timelist,temp_timelist]
         	temp_timelist=0
       ENDFOR

       counterlist=counterlist[1:*]
       counterlist=[counterlist,n_elements(namelist)-1]
       namelist=namelist[1:*]
       xlist=xlist[1:*]
       ylist=ylist[1:*]
       zlist=zlist[1:*]
       VisionFilenamelist=VisionFilenamelist[1:*]  ;;filenames
       ExperimentList=ExperimentList[1:*]
       timelist=timelist[1:*]
       isNumerator=isNumerator[1:*]
       isDenominator=isDenominator[1:*]

       CreateFileTree
		ENDIF
    ENDIF
END

PRO LoadChameleonLogFile,fn,temp_timelist,l,fatherlist
COMMON GetLogFiles
COMMON toggles

OPENR,UNIT,fn,/GET_LUN
;Create a variable of type string.
 LINE = ''
 ;Read and print each line until the end of the file is encountered.
 counterlist=[counterlist,l]
 temp_timelist=0
 WHILE(~ EOF(unit)) DO BEGIN
 	READF,unit,LINE
    IF strpos(LINE,"[") NE -1 AND strpos(LINE,"[nm]") EQ -1 AND strpos(LINE,"[ms]") EQ -1 THEN BEGIN

    ; Extract the name
    startname=strpos(LINE,"[")+1
    endname=strpos(LINE,"]")
    name=strmid(LINE,startname,endname-startname)
    IF strpos(name,"DeltaF") EQ -1 AND strpos(name,"Snapshot") EQ -1 THEN BEGIN
    l=l+1
    namelist=[namelist,name]
    ; Get the size
    READF,unit,LINE
    sizeline=strsplit(LINE," ",/EXTRACT)
    zdim=0
    xdim=sizeline[1]
    endx=strpos(xdim,"x")
    xdim=strmid(xdim,0,endx)
    ydim=sizeline[2]
    IF n_elements(sizeline) GT 3 THEN zdim=sizeline[7]
    	xlist=[xlist,xdim]
        ylist=[ylist,ydim]
        zlist=[zlist,zdim]
        READF,unit,LINE

        ; Get filename
        READF,unit,LINE

        filename=strsplit(LINE,":",/EXTRACT)

		dims=size(filename)
		IF dims[1] EQ 2 THEN filename=strtrim(filename[1]) ELSE filename=strtrim(filename[2])


        filename=strmid(filename,strpos(filename,"\",/REVERSE_SEARCH)+1)
        temp=strpos(fn,".vws.log")
        filename=strmid(fn,0,temp)+".pst\"+filename
        temp2=strpos(fn,"\",/REVERSE_SEARCH)+1
        temp=strmid(fn,temp2,temp-temp2)

        ExperimentList=[ExperimentList,temp]
        VisionFilenamelist=[VisionFilenamelist,filename]

        ;Get time from experiment onset
        READF,unit,LINE
        utc_time=strsplit(LINE,":",/EXTRACT)
        utc_time=strtrim(utc_time[1])
        READF,unit,LINE
        utc_add=strsplit(LINE,":",/EXTRACT)
        utc_add=strtrim(utc_add[1])


		;Very very ugly and complicated way of making Chameleon work
		IF LoadMeth EQ 3 THEN BEGIN
			fatherlist=[fatherlist,'Raw']
			IF strpos(name,'(channel 0)') NE -1 THEN BEGIN
	        	isDenominator=[isDenominator,0]
	            isNumerator=[isNumerator,1]
            ENDIF ELSE BEGIN
	            isDenominator=[isDenominator,1]
	            isNumerator=[isNumerator,0]
            ENDELSE
		ENDIF
      	temp_timelist=[temp_timelist,utc_time+(utc_add/1000)]
    	ENDIF
	ENDIF
ENDWHILE
FREE_LUN,unit

END


PRO LoadFuraLogFile,fn,temp_timelist,l,fatherlist
COMMON GetLogFiles
COMMON toggles

OPENR,UNIT,fn,/GET_LUN
;Create a variable of type string.
 LINE = ''
 ;Read and print each line until the end of the file is encountered.
 counterlist=[counterlist,l]
 temp_timelist=0
 WHILE(~ EOF(unit)) DO BEGIN
 	READF,unit,LINE
    IF strpos(LINE,"[") NE -1 AND strpos(LINE,"[nm]") EQ -1 AND strpos(LINE,"[ms]") EQ -1 THEN BEGIN

    ; Extract the name
    startname=strpos(LINE,"[")+1
    endname=strpos(LINE,"]")
    name=strmid(LINE,startname,endname-startname)
    IF strpos(name,"DeltaF") EQ -1 AND strpos(name,"Snapshot") EQ -1 THEN BEGIN
    l=l+1
    namelist=[namelist,name]
    ; Get the size
    READF,unit,LINE
    sizeline=strsplit(LINE," ",/EXTRACT)
    zdim=0
    xdim=sizeline[1]
    endx=strpos(xdim,"x")
    xdim=strmid(xdim,0,endx)
    ydim=sizeline[2]
    IF n_elements(sizeline) GT 3 THEN zdim=sizeline[7]
    	xlist=[xlist,xdim]
        ylist=[ylist,ydim]
        zlist=[zlist,zdim]
        READF,unit,LINE

        ; Get filename
        READF,unit,LINE

        filename=strsplit(LINE,":",/EXTRACT)

		dims=size(filename)
		IF dims[1] EQ 2 THEN filename=strtrim(filename[1]) ELSE filename=strtrim(filename[2])


        filename=strmid(filename,strpos(filename,"\",/REVERSE_SEARCH)+1)
        temp=strpos(fn,".vws.log")
        filename=strmid(fn,0,temp)+".pst\"+filename
        temp2=strpos(fn,"\",/REVERSE_SEARCH)+1
        temp=strmid(fn,temp2,temp-temp2)

        ExperimentList=[ExperimentList,temp]
        VisionFilenamelist=[VisionFilenamelist,filename]

        ;Get time from experiment onset
        READF,unit,LINE
        utc_time=strsplit(LINE," ",/EXTRACT)
        utc_time=long(strtrim(utc_time[2]))
        READF,unit,LINE
        utc_add=strsplit(LINE," ",/EXTRACT)
        utc_add=long(strtrim(utc_add[2]))

		;// Continue only when Fura2 Data
        IF LoadMeth EQ 2 OR LoadMEth EQ 4 THEN BEGIN
	    	READF,unit,LINE
	        READF,unit,LINE
	        numerator=strsplit(LINE," ",/EXTRACT)
	        IF numerator[0] EQ 'Numerator:' THEN BEGIN
	        	fatherlist=[fatherlist,numerator[1]]
	            isDenominator=[isDenominator,0]
	            isNumerator=[isNumerator,0]
	        ENDIF ELSE BEGIN
	            fatherlist=[fatherlist,'Raw']
	            READF,unit,LINE
	            time=strsplit(LINE," ",/EXTRACT)
	            READF,unit,LINE
	            READF,unit,LINE
	            temp=strsplit(LINE,": ",/EXTRACT)
	            IF fix(temp[3]) EQ 340 THEN BEGIN
	         	   isDenominator=[isDenominator,0]
	               isNumerator=[isNumerator,1]

	            ENDIF ELSE BEGIN
	               isDenominator=[isDenominator,1]
	               isNumerator=[isNumerator,0]

	           ENDELSE
           ENDELSE
		ENDIF; LoadMeth EQ 4

      	temp_timelist=[temp_timelist,utc_time+(utc_add/1000)]
    	ENDIF
	ENDIF
ENDWHILE
FREE_LUN,unit

END

FUNCTION MakeParameters,widget
COMMON ALL
; declare main structure for all experimental parameters
pos=strpos(widget.name,'-')
odor=''
conc=''
IF pos EQ -1 THEN BEGIN
    temp=strsplit(widget.name,'_',/EXTRACT)
    odor=temp[1]
    if n_elements(temp) gt 2 then conc=fix(temp[2]) else conc=0 ;;1107 workaround LSM files !?
ENDIF ELSE BEGIN
    pos=strpos(widget.name,'_')
    odor='Kontrolle'
    conc=-1
    IF pos EQ -1 THEN BEGIN
       temp=strsplit(widget.name,'-',/EXTRACT)
       odor=temp[1]
       IF N_ELEMENTS(temp) GT 1 THEN conc=-1*fix(temp[1]) ELSE conc=-3
    ENDIF
    IF pos EQ 2 THEN BEGIN
		temp=strsplit(widget.name,'_',/EXTRACT)
    	odor=temp[1]
    	conc=fix(temp[2])
	ENDIF
ENDELSE


    p1       = {    $
               messungszahl: 0,    $  ;Zahl der Messung
               format_x:    widget.x,   $   ; framesize in pixels after binning
               format_y:    widget.y,   $
               binning :    1,     $  ; size of binning (square)
               x_offset:    0,     $  ; offset of imaging area in ccd pixels
               y_offset:    0,     $
               frames:      widget.z,   $   ; number of frames per odors
               frame_time:  0.0,     $    ; exposure time in ms
               frequency:   newDefaults.frequency,     $
               trials:      1,     $  ; number of averaged trials
               trial_ticks: 5,     $  ; time for one trial
               odor:        odor,  $    ; names of odors
               odor_info:   0, $   ; other info about each odor memory slot
               odor_nr:     conc,  $    ; numbers of odors, or concentration
               stimulus_del:  0L,   $   ; time to stimulus on in ms
               stimulus_time: 2000,       $ ; duration of stimulus in ms
               stimulus_on:   newDefaults.stimulus_on, $    ; first frame with stimulus on
               stimulus_end:  newDefaults.stimulus_off, $    ; last frame with stimulus on
               stimulus_ISI:  0,     $    ; repeated stimuli
               odors:         1,            $  ; new: number of odors
               experiment:   widget.Experiment,    $
               kontrollmessung: 0,        $ ; zahl der Kontrollmessung
               ex_name:       widget.Numerator, $ ; for the measurement tags in TILL
               os9time:       widget.time,       $
               treatment:   'LoadExp',  $
               pharma_time:       [0,0,0],       $ ; pharmacological application
               treat_conc: 0.0,       $   ;is at the same time a flag for treatment
               remark   :   'x'     ,    $
               viewLabel   : 'XXX'   , $
               shiftX   :   0     ,  $
               shiftY   :   0     ,    $
               pixelSizeX  : 2.4       , $  ;in micrometers
               pixelSizeY  : 2.4       , $  ;in micrometers
               posZ         : 0.0       , $  ;in micrometers
               lambda   :1000     ,    $  ;in nanometers
               slvFlip     :  0       ,     $  ;was the slave image already flipped?
               stim2ON     :   0   ,   $  ;second stimulus (e.g. sugarwater), in frames
               stim2OFF       : 0     ,   $  ;frames
               stim2_del   : 0     ,    $  ;second stimulus onset: in milliseconds
               stim2_time  :    0   ,   $  ;second stimulus duration, in milliseconde
               Leaf_name :widget.name  ,    $
               Denominator:widget.Denominator, $
               Numerator:widget.Numerator  $
    }
    return,p1
END


FUNCTION Filter_tiffs,raw
ArrayDims=size(raw)
temp=raw
FOR i=0,ArrayDims[3]-1 DO temp[*,*,i]=median(raw[*,*,i],3)
return,temp

END

;;1107 image file loading +
;; prepare/process images (background, bleach, scatter)
PRO LoadVisionStack,widgetlist,number
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON WINDOW_IDS
COMMON SHOW_MOVIE
COMMON SHOW_TRACES
COMMON GetLogFiles
COMMON EditParams

    ; Some IDL-Widget_error causes in multiple selcetions the last selection to appear as first, so I put it back to the end of the list
    ;;1107 We don't see this error: IF N_ELEMENTS(widgetlist) GT 1 THEN widgetlist=[widgetlist[1:*],widgetlist[0]]

    ; Check whether all movies have the same dimensions (at least x and y)
    x=0
    y=0
    z=0
    FOR I=0,N_ELEMENTS(widgetlist)-1 DO BEGIN
       x=[x,widgetlist[i].x]
       y=[y,widgetlist[i].y]
       z=[z,widgetlist[i].z]
    ENDFOR
    x=x[1:*]
    y=y[1:*]
    z=z[1:*]

    ; Here I have to write the convalidation code sometime to exclude the measurements with unequal x and y dims resulting in a controlled_widgetlist
    controlled_widgetlist=widgetlist

    px=x[0]
    py=y[0]
    pz=total(z)
;	  IF LoadMeth EQ 1 THEN pz = z[0] ;;1107 quick LSM

    first=0
    last=N_ELEMENTS(controlled_widgetlist)-1
    already=0
    sum=0
    IF string(data[0]) EQ 'Empty' THEN BEGIN
       data=fltarr(px,py,pz)
       rawdata=data
       rawimages=fltarr(px,py,n_elements(controlled_widgetlist))
       raw_images_noshift=rawimages
    ENDIF ELSE BEGIN
       ArrayDims=SIZE(data)
       RawDims=SIZE(rawimages)
       IF RawDims[0] EQ 2 THEN RawDims[3]=1
       sum=ArrayDims[3]
       temp=data
       tempr=rawdata
       data=fltarr(ArrayDims[1],ArrayDims[2],ArrayDims[3]+pz)
       rawdata=data
       data[*,*,0:ArrayDims[3]-1]=temp
       rawdata[*,*,0:ArrayDims[3]-1]=tempr
       temp=rawimages
       rawimages=fltarr(RawDims[1],RawDims[2],RawDims[3]+n_elements(controlled_widgetlist))
       rawimages[*,*,0:RawDims[3]-1]=temp
       temp=raw_images_noshift
       raw_images_noshift=fltarr(RawDims[1],RawDims[2],RawDims[3]+n_elements(controlled_widgetlist))
       raw_images_noshift[*,*,0:RawDims[3]-1]=temp
       first=ArrayDims
       already=n_elements(parameters)
    ENDELSE

    previous_shifts=''
    shiftfile='Empty'
    FOR I=0, last DO BEGIN
       widget=controlled_widgetlist[i]

       filename=widget.Numerator+'.params'
       a=FILE_INFO(filename)
       IF a.exists EQ 1 THEN BEGIN
         restore,filename
         p1=p_temp
       ENDIF ELSE p1=MakeParameters(widget)

       Raw1     = intarr(p1.format_x,   p1.format_y, p1.frames)
       Raw_flt   =fltarr(p1.format_x,   p1.format_y, p1.frames)
       deltaF    =Intarr(p1.format_x,   p1.format_y, p1.frames)
       dark1    = intarr(p1.format_x,   p1.format_y)
		IF LoadMeth NE 1 THEN BEGIN
        	IF CalcRatios NE 1 THEN BEGIN
          		OPENR, unit, widget.Numerator, /GET_LUN
          		readu, unit, raw1
          		; Take out the weird NaNs on the border of Silkes Chameleon data
       			IF LoadMeth EQ 3 THEN BEGIN
          			fr=4
					temp=raw1[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]
					val=mean(temp)
					raw1[*]=val
					raw1[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]=temp
				ENDIF
          		raw_flt=float(raw1)
          		FREE_LUN,unit
          		dark1=bytscl(total(raw_flt,3))
         	ENDIF ELSE BEGIN
	         	tempnum=raw1
		       	OPENR, unit, widget.Numerator, /GET_LUN
		        readu, unit, tempnum
		        FREE_LUN,unit
		        tempdenom=raw1
		        OPENR, unit, widget.Denominator, /GET_LUN
		        readu, unit, tempdenom
		        FREE_LUN,unit
		        raw1=tempnum

				; Take out the weird NaNs on the border of Silkes Chameleon data
	          	IF LoadMeth EQ 3 THEN BEGIN
	          		fr=4
					temp=tempnum[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]
					val=mean(temp)
					tempnum[*]=val
					tempnum[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]=temp

					temp=tempdenom[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]
					val=mean(temp)
					tempdenom[*]=val
					tempdenom[fr:p1.format_x-(1+fr),fr:p1.format_y-(1+fr),*]=temp
			 	ENDIF
	          	background_den=total(tempdenom[*,*,0:p1.stimulus_on-1],3)/p1.stimulus_on-1
	          	background_num=total(tempnum[*,*,0:p1.stimulus_on-1],3)/p1.stimulus_on-1
	          	deltaF_num=1000*tempnum/background_num
	          	deltaF_denom=1000*tempdenom/background_den
	          	raw_flt=1000*float(tempnum)/float(tempdenom)
	          	background=background_den/background_num
	          	FOR k=0, p1.frames-1 DO raw_flt[*,*,k]=raw_flt[*,*,k]*background
	          	dark1=bytscl(total(tempdenom,3))
	         ENDELSE
       	ENDIF
       	IF LoadMeth EQ 1 THEN BEGIN

;;1107 quickly adapted for LSM files
        	tifflist=FILE_SEARCH(file_dirname(widget.numerator),widget.name+"*", count=lsmcount)
        	if lsmcount ne 1 then message,'More than one LSM file ' + widget.name
         	;;IF N_ELEMENTS(tifflist) EQ widget.z THEN BEGIN

          		FOR z=0,widget.z-1 DO BEGIN
              		raw_flt[*,*,z]=float(read_tiff(tifflist[0], image_index=z*2)) ;;1107 z*2: LSM files, only the grey images
          		ENDFOR
;;1107quick test only    multiply 8 bit rawdata by  factor8bits_12bits
;;              factor8bits_12bits=8 ;1107 test only
;;              raw_flt *=  factor8bits_12bits
          		dark1=bytscl(total(raw_flt,3))
         	ENDIF
       	temp_shifts_applied_list=intarr(2,p1.frames)
       	temp_movs_applied_list=intarr(2,p1.frames)
       	shiftval=0


       IF LoadWithShifts EQ 1 THEN BEGIN
         IF p1.Experiment NE previous_shifts THEN BEGIN
          path=FILE_DIRNAME(p1.ex_name)
          path=strmid(path,0,strpos(path,'\',/REVERSE_SEARCH))
          path=strmid(path,0,strpos(path,'\',/REVERSE_SEARCH))+'\Shifts'
          movlistname=p1.Experiment+'.moveList'
          shiftfilename=FILE_SEARCH(path,movlistname)
          IF shiftfilename NE '' THEN BEGIN
              numlines=FILE_LINES(shiftfilename)
              shiftfile=STRARR(numlines)
              OPENR,unit,shiftfilename,/GET_LUN
              READF,unit,shiftfile
              FREE_LUN,unit
              previous_shifts=p1.Experiment
          ENDIF
         ENDIF
         IF shiftfile[0] NE 'Empty' THEN BEGIN
          FOR J=0,N_ELEMENTS(shiftfile)-1 DO BEGIN
              a=STRSPLIT(shiftfile[j],/EXTRACT)
              breakit=0
              IF a[0] EQ file_basename(p1.ex_name) THEN BEGIN
                 movs_X=fix(a[3:*])
                 b=STRSPLIT(shiftfile[j+1],/EXTRACT)
                 movs_Y=fix(b[3:*])
                 FOR K=0,p1.Frames-1 DO raw_flt[*,*,K]=SHIFT(raw_flt[*,*,K],movs_X[K],movs_y[K])
                 pos_shift=n_elements(movs_x)/2
                 dark1=shift(dark1,movs_X[pos_shift],movs_Y[pos_shift])

                 temp_shifts_applied_list[0,*]=movs_X[pos_shift]
                 temp_shifts_applied_list[1,*]=movs_Y[pos_shift]

                 temp_movs_applied_list[0,*]=(movs_X-movs_X[pos_shift])
                 temp_movs_applied_list[1,*]=(movs_Y-movs_Y[pos_shift])
                 shiftval=1
                 breakit=1
              ENDIF
              IF breakit EQ 1 THEN BREAK
          ENDFOR
         ENDIF
       ENDIF
	ratio=raw_flt


;////////////////////////////////////////////////////////////////////////////
;////////// HELLO KENTA!!!! THIS IS BACKGROUND DEFINITION ///////////////////
;////////////////////////////////////////////////////////////////////////////

;;background correction
	IF load_raw NE 1 THEN BEGIN
	          ;;1107 not used for LSM files
            ;;		IF LoadMeth EQ 1 THEN BEGIN  ;;i.e. tiff files (lsm files)
            ;;		      ;;use frame 0 until (stimulus_on-1)
            ;;       		background=total(raw_flt[*,*,0:p1.stimulus_on-1],3)/(p1.stimulus_on)
            ;;       		FOR j=0,p1.frames-1 DO ratio[*,*,j]=(raw_flt[*,*,j]*100/background)-100
            ;;       	ENDIF ELSE BEGIN
      	    ;;use 5 frames before stimulus_on (pst files)
       		background=total(raw_flt[*,*,p1.stimulus_on-5:p1.stimulus_on-1],3)/5
       		;1107 original hard coded: 100
          factor=100  ;mean(background)
       		FOR j=0,p1.frames-1 DO ratio[*,*,j]=(raw_flt[*,*,j]*factor/background)-factor
          ;;        	ENDELSE


	ENDIF

;////////////////////////////////////////////////////////////////////////////
;////////////////////////////////////////////////////////////////////////////

;median filter
IF medianflag EQ 1 THEN begin

; median width
    widget_control, text11, get_value = medianwidth
    medianwidth = fix(medianwidth[0])
    ;;loop over all
      FOR j=0,p1.frames-1 DO begin
        ratio[*,*,j]= median(ratio[*,*,j], medianwidth)
      ENDFOR

 ENDIF

;Scattered light correction
   IF correctSL EQ 1 THEN begin

;;1107 Strength of ScatteredLightCorr ??
    smoothFactor=5
; size of ScatteredLigthCorr in pixel
    widget_control, text12, get_value = smoothValue
    smoothValue = fix(smoothValue[0])
          ;;loop over all
      FOR j=0,p1.frames-1 DO begin
        ratio[*,*,j]=ratio[*,*,j]+SmoothFactor*smooth((ratio[*,*,j] - $
                    smooth(ratio[*,*,j], smoothValue, /EDGE_TRUNCATE)),smoothValue, /edge_truncate)
      ENDFOR
    ENDIF


;Bleach correction
		IF BleachCorrect EQ 1 THEN BEGIN

		print,"BLEACH!!"
			;settings for log-fit bleach correction


			;bleach correction!
			;necessary data structures
			;excluded frames at the beginning are defined in fitlogdecay
			correctArray    = fltarr(p1.frames)
			AllcorrectArray = fltarr(p1.odors+1,p1.frames)
			AllOdourArray   = fltarr(p1.odors+1,p1.frames)
			for lk= 0, p1.frames-1 do correctarray(lk) = median(ratio[*,*,lk])
			weights = replicate(1.0, p1.frames)
			weights[p1.stimulus_on:p1.stimulus_end+(p1.frames/10)]=0
			;weights[0:p1.stimulus_on]=2
			;weights[0:4]=0
			fitlogdecay,correctarray,detract,weights
			FOR lk=0,p1.frames-1 DO ratio[*,*,lk]=ratio[*,*,lk]-detract[lk]
			print,detract
		ENDIF


       data[*,*,sum:sum+p1.frames-1]=ratio
       rawdata[*,*,sum:sum+p1.frames-1]=raw_flt
       if(LoadMeth GT 1 AND CalcRatios EQ 1) THEN rawdata[*,*,sum:sum+p1.frames-1]=raw1
       sum=sum+p1.frames
       rawimages[*,*,already]=dark1
       raw_images_noshift[*,*,already]=dark1

       variance=total(raw1-mean(raw1))
       variance=variance*variance

       coorfilename=''
       IF LoadWithCoors EQ 1 THEN BEGIN
         path=FILE_DIRNAME(p1.ex_name)
         path=strmid(path,0,strpos(path,'\',/REVERSE_SEARCH))
         path=strmid(path,0,strpos(path,'\',/REVERSE_SEARCH))+'\Coors'
         coorlistname=p1.Experiment+'.coor'
         coorfilename=FILE_SEARCH(path,coorlistname)
       ENDIF

       IF widget.denominator EQ "None" THEN rawfilename=widget.numerator ELSE rawfilename=widget.denominator

       IF I EQ 0 AND already EQ 0 THEN BEGIN
         exptslist=p1.Experiment
         p1.messungszahl=0
         IF LoadWithCoors EQ 1 THEN LoadPeaks,coorfilename,p1.messungszahl
         parameters=p1
         lastframes=[0,p1.frames]
         diffvals=[variance,variance]
         filenamelist=rawfilename
         shifts_applied_list=temp_shifts_applied_list
         movs_applied_list=temp_movs_applied_list
         applied_movs=shiftval
       ENDIF ELSE BEGIN
         temp=WHERE(Exptslist EQ p1.Experiment)
         IF temp EQ -1 THEN BEGIN
          exptslist=[exptslist,p1.experiment]
          p1.messungszahl=N_ELEMENTS(exptslist)-1
       		IF LoadWithCoors EQ 1 THEN LoadPeaks,coorfilename,p1.messungszahl
       		ENDIF ELSE p1.messungszahl=temp[0]
       	 par=parameters
         parameters=[par,p1]
         lastframes=[lastframes,max(lastframes)+p1.frames]
         diffvals=diffvals[0:n_elements(diffvals)-2]
         diffvals=[diffvals,variance,total(diffvals)]
         filenamelist=[filenamelist,rawfilename]
         tempx=reform(shifts_applied_list[0,*])
         tempy=reform(shifts_applied_list[1,*])
         tempx=[tempx,reform(temp_shifts_applied_list[0,*])]
         tempy=[tempy,reform(temp_shifts_applied_list[1,*])]
         shifts_applied_list=INTARR(2,N_ELEMENTS(tempy))
         shifts_applied_list[0,*]=tempx
         shifts_applied_list[1,*]=tempy

         tempx=reform(movs_applied_list[0,*])
         tempy=reform(movs_applied_list[1,*])
         tempx=[tempx,reform(temp_movs_applied_list[0,*])]
         tempy=[tempy,reform(temp_movs_applied_list[1,*])]
         movs_applied_list=INTARR(2,N_ELEMENTS(tempy))
         movs_applied_list[0,*]=tempx
         movs_applied_list[1,*]=tempy
         applied_movs=[applied_movs,shiftval]
       ENDELSE
       already=already+1

    ENDFOR

    shift_reference=n_elements(parameters)/2 ;;; shift_reference = Referenzbild fr Movement correction (mittleres Bild)
    applied_shifts=0

    fn=p1.Experiment
	temp=data
	ArrayDims=size(data)
	IF LoadMeth EQ 1 AND load_raw NE 1 THEN temp=median(total(temp,3)/ArrayDims[3],5)

	min_y_val=min(temp)
	max_y_val=max(temp)

    IF MovementCorrect_ID NE 0 THEN BEGIN
       createTree,diffvals
       refresh
    ENDIF

    IF Correlate_ID NE 0 THEN BEGIN
       refreshcorrel,event
    ENDIF

    IF Traces_ID NE 0 THEN BEGIN
		widget_control,min_y_val_text,set_value=string(min_y_val)
		widget_control,max_y_val_text,set_value=string(max_y_val)

    ENDIF



    IF GetCoordinates_ID EQ 0 THEN BEGIN
       CreateWindow,"GetCoordinates"
       GenerateCTVimages
       refreshscreen
       refresh_measurement

    ENDIF ELSE BEGIN
       GenerateCTVimages
       refreshscreen
       refresh_measurement
    ENDELSE

    CreateParamsTree

END






PRO DELETESELECTION
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON GetLogFiles
COMMON Window_IDS
COMMON EditParams

IF N_ELEMENTS(selection) GT 1 THEN selection=reverse(selection[sort(selection)])
FOR I=0,N_ELEMENTS(selection)-1 DO BEGIN
       pos= selection[i]
       IF pos[0] NE -1 THEN BEGIN
         IF N_ELEMENTS(parameters) EQ 1 THEN BEGIN
          EmptyVars
         ENDIF ELSE BEGIN

              to_delete=pos
              lastentry=N_ELEMENTS(parameters)-1
              del_start=lastframes[to_delete]
              del_end=lastframes[to_delete+1]-1

              temp=parameters
              IF to_delete GT 1 THEN parameters=temp[0:to_delete-1] ELSE IF to_delete EQ 1 THEN parameters=temp[0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN parameters=temp[1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN parameters=[parameters,temp[to_delete+1]] ELSE parameters=[parameters,temp[to_delete+1:*]]
                 ENDELSE
              ENDIF



              IF lastentry EQ 0 THEN lastframes='Empty' ELSE BEGIN
                 IF to_delete EQ 0 THEN Lastframes=lastframes[1:*]-(del_end-del_start)
                 IF to_delete EQ lastentry THEN Lastframes=lastframes[0:lastentry-1]
                 IF to_delete NE 0 AND to_delete NE lastentry THEN lastframes=[lastframes[0:to_delete-1],lastframes[to_delete+1:*]-((del_end+1)-del_start)]
              ENDELSE


              temp=diffvals
              IF to_delete GT 1 THEN diffvals=temp[0:to_delete-1] ELSE IF to_delete EQ 1 THEN diffvals=temp[0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN diffvals=temp[1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN diffvals=[diffvals,temp[to_delete+1]] ELSE diffvals=[diffvals,temp[to_delete+1:*]]
                 ENDELSE
              ENDIF

              temp=filenamelist
              IF to_delete GT 1 THEN filenamelist=temp[0:to_delete-1] ELSE IF to_delete EQ 1 THEN filenamelist=temp[0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN filenamelist=temp[1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN filenamelist=[filenamelist,temp[to_delete+1]] ELSE filenamelist=[filenamelist,temp[to_delete+1:*]]
                 ENDELSE
              ENDIF

              temp=odorlist
              IF to_delete GT 1 THEN odorlist=temp[0:to_delete-1] ELSE IF to_delete EQ 1 THEN odorlist=temp[0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN odorlist=temp[1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN odorlist=[odorlist,temp[to_delete+1]] ELSE odorlist=[odorlist,temp[to_delete+1:*]]
                 ENDELSE
              ENDIF


              IF lastentry EQ 0 THEN waterlist=-1 ELSE BEGIN
                 delpos=WHERE(waterlist EQ to_delete)
                 IF delpos[0] NE -1 THEN BEGIN
                   IF delpos[0] EQ 0 THEN waterlist=waterlist[1:*]
                   IF delpos[0] EQ lastentry THEN waterlist=waterlist[0:lastentry-1]
                   IF delpos[0] NE 0 AND delpos[0] NE lastentry THEN waterlist=[waterlist[0:delpos-1],waterlist[delpos+1:*]]
                 ENDIF
              ENDELSE





              water_pos=WHERE(waterlist EQ to_delete)
              IF water_pos[0] NE -1 THEN BEGIN
                 waternumber=N_ELEMENTS(water_pos)-1
                 FOR l=0,waternumber DO BEGIN
                   lastwater=N_ELEMENTS(waterlist)-1
                   waterdel=water_pos[waternumber-l]
                   temp=waterlist
                   IF waterdel GT 1 THEN waterlist=temp[0:waterdel-1] ELSE IF waterdel EQ 1 THEN waterdel=temp[0]
                   IF waterdel NE lastwater THEN BEGIN
                    IF waterdel EQ 0 THEN waterlist=temp[1:*] ELSE BEGIN
                        IF waterdel EQ lastwater-1 THEN waterlist=[waterlist,temp[waterdel+1]] ELSE waterlist=[waterlist,temp[waterdel+1:*]]
                    ENDELSE
                   ENDIF
                 ENDFOR
              ENDIF

              temp=rawimages
              rawimages=rawimages[*,*,1:*]
              rawimages[*]=0
              IF to_delete GT 1 THEN rawimages[*,*,0:to_delete-1]=temp[*,*,0:to_delete-1] ELSE IF to_delete EQ 1 THEN rawimages[*,*,0]=temp[*,*,0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN rawimages=temp[*,*,1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN rawimages[*,*,to_delete]=temp[*,*,to_delete+1] ELSE rawimages[*,*,to_delete:*]=temp[*,*,to_delete+1:*]
                 ENDELSE
              ENDIF

              temp=raw_images_noshift
              raw_images_noshift=raw_images_noshift[*,*,1:*]
              raw_images_noshift[*]=0
              IF to_delete GT 1 THEN raw_images_noshift[*,*,0:to_delete-1]=temp[*,*,0:to_delete-1] ELSE IF to_delete EQ 1 THEN raw_images_noshift[*,*,0]=temp[*,*,0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN raw_images_noshift=temp[*,*,1:*] ELSE BEGIN

                   IF to_delete EQ lastentry-1 THEN raw_images_noshift[*,*,to_delete]=temp[*,*,to_delete+1] ELSE raw_images_noshift[*,*,to_delete:*]=temp[*,*,to_delete+1:*]
                 ENDELSE
              ENDIF

              temp=ctvimages
              ctvimages=ctvimages[*,*,1:*]
              ctvimages[*]=0
              IF to_delete GT 1 THEN ctvimages[*,*,0:to_delete-1]=temp[*,*,0:to_delete-1] ELSE IF to_delete EQ 1 THEN ctvimages[*,*,0]=temp[*,*,0]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN ctvimages=temp[*,*,1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN ctvimages[*,*,to_delete]=temp[*,*,to_delete+1] ELSE ctvimages[*,*,to_delete:*]=temp[*,*,to_delete+1:*]
                 ENDELSE
              ENDIF

              temp=data
              data=temp[*,*,(del_end-del_start)+1:*]
              data[*]=0
              IF to_delete GT 1 THEN data[*,*,0:del_start-1]=temp[*,*,0:del_start-1] ELSE IF to_delete EQ 1 THEN data[*,*,0:del_start-1]=temp[*,*,0:del_start-1]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN data=temp[*,*,del_end+1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN data[*,*,del_start:*]=temp[*,*,del_end+1:*] ELSE data[*,*,del_start:*]=temp[*,*,del_end+1:*]
                 ENDELSE
              ENDIF

              temp=movs_applied_list
              movs_applied_list=temp[*,(del_end-del_start)+1:*]
              movs_applied_list[*]=0
              IF to_delete GT 1 THEN movs_applied_list[*,0:del_start-1]=temp[*,0:del_start-1] ELSE IF to_delete EQ 1 THEN movs_applied_list[*,0:del_start-1]=temp[*,0:del_start-1]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN movs_applied_list=temp[*,del_end+1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN movs_applied_list[*,del_start:*]=temp[*,del_end+1:*] ELSE movs_applied_list[*,del_start:*]=temp[*,del_end+1:*]
                 ENDELSE
              ENDIF

              temp=shifts_applied_list
              shifts_applied_list=temp[*,(del_end-del_start)+1:*]
              shifts_applied_list[*]=0
              IF to_delete GT 1 THEN shifts_applied_list[*,0:del_start-1]=temp[*,0:del_start-1] ELSE IF to_delete EQ 1 THEN shifts_applied_list[*,0:del_start-1]=temp[*,0:del_start-1]
              IF to_delete NE lastentry THEN BEGIN
                 IF to_delete EQ 0 THEN shifts_applied_list=temp[*,del_end+1:*] ELSE BEGIN
                   IF to_delete EQ lastentry-1 THEN shifts_applied_list[*,del_start:*]=temp[*,del_end+1:*] ELSE shifts_applied_list[*,del_start:*]=temp[*,del_end+1:*]
                 ENDELSE
              ENDIF


         ENDELSE

       ENDIF
ENDFOR


CreateParamsTree
IF MovementCorrect_ID NE 0 THEN refresh
IF Correlate_ID NE 0 THEN refreshcorrel
IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
IF GetCoordinates_ID NE 0 THEN Refreshscreen
widget_control,params_tree_id,set_tree_select=0
selection=-1

END

PRO LoadPeaks,filename,coorset
COMMON ALL
COMMON CTVS

if filename ne '' then begin
    openR, unit,filename, /get_lun
    readF, unit, NumListe
    result=strarr(4,100)
    result[0:2,*]='-1000'

    FOR i = 0, Numliste-1 do begin
       readF, unit, a, b, c;, d
       result[0,i]=strtrim(fix(a),2)
       result[1,i]=strtrim(fix(b),2)
       result[2,i]=strtrim(fix(c),2)
       ;result[3,i]=string(fix(d))
    ENDFOR
    free_lun,unit
    Coordinates[*,*,coorset]=result
endif
END



PRO CreateWindow,name
    COMMON Window_IDS
    COMMON WIDGET_IDS
    COMMON CTVS
    COMMON GETLOGFILES
    IF name EQ "AdaptCoors" THEN BEGIN
       AdaptCoors,tlb_parameters_id
       refreshcoors
    ENDIF
    IF name EQ "Correlations" THEN BEGIN
       Correlations,tlb_parameters_id
       refreshcorrel,event
    ENDIF
    IF name EQ "Traces" THEN BEGIN
       Traces,tlb_parameters_id
       refreshtraces,-1,-1,-1,1
    ENDIF
    IF name EQ "Movement_correct" THEN BEGIN
       Movement_correct,tlb_parameters_id
       IF string(diffvals[0]) NE 'Empty' THEN BEGIN
         createTree,diffvals
         REFRESH
       ENDIF
    ENDIF
    IF name EQ "Mask" THEN BEGIN
       Mask,tlb_parameters_id
       refreshmask
    ENDIF

    IF name EQ "GetCoordinates" THEN BEGIN
       GetCoors,tlb_parameters_id
       IF    string(ctvimages[0]) EQ 'Empty' THEN GenerateCTVimages
       refreshscreen

    ENDIF

END

PRO DestroyWindow,name
    COMMON Window_IDS
    COMMON CORRECT_MOV
    COMMON EditParams
    IF name EQ "AdaptCoors" THEN BEGIN
       WIDGET_CONTROL,AdaptCoors_ID,/DESTROY
       AdaptCoors_ID=0
    ENDIF
    IF name EQ "Correlations" THEN BEGIN
       WIDGET_CONTROL,Correlate_ID,/DESTROY
       Correlate_ID=0
    ENDIF
    IF name EQ "Traces" THEN BEGIN
       WIDGET_CONTROL,Traces_ID,/DESTROY
       Traces_ID=0
    ENDIF
    IF name EQ "Movement_correct" THEN BEGIN
       WIDGET_CONTROL,MovementCorrect_ID,/DESTROY
       TreeWidget='Empty'
       MovementCorrect_ID=0
    END
    IF name EQ "Mask" THEN BEGIN
       WIDGET_CONTROL,Mask_ID,/DESTROY
       Mask_ID=0
    ENDIF
    IF name EQ "GetCoordinates" THEN BEGIN
       WIDGET_CONTROL,GetCoordinates_ID,/DESTROY
       GetCoordinates_ID=0
    ENDIF


END


PRO EmptyVars
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON COORS
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON SHOW_TRACES
Common GetLogFiles
COMMON EditParams

no_one=0
no_two=0
ctvimages_raw='Empty'
rawimages='Empty'
ctvimages='Empty'
filenamelist='Empty'
lastframes='Empty'
tillog='Empty'
chosenframes='Empty'
result='Empty'
Coordinates[*]='-1000'
showsequence='Empty'
odorlist='Empty'
data='Empty'
lastframes='Empty'
parameters='Empty'
movie_measurement='Empty'
pixmap='Empty'
diff_frame='Empty'
pixmap_x='Empty'
pixmap_y='Empty'
pixmap_name='Empty'
odor_x='Empty'
odor_y='Empty'
odor_list='Empty'
measurement_x='Empty'
measurement_list='Empty'
folder="Empty"
Exptslist="Empty"
actualCoordinates=0
waterlist=-1

; From Movement correct
image_staple='Empty'

raw_shift_staple='Empty'
raw_mov_staple='Empty'
shiftlist='Empty'
movlist='Empty'
shifts_applied_list='Empty'
movs_applied_list='Empty'
IF string(TreeWidget[0]) NE 'Empty' THEN BEGIN
    widget_control,TreeWidget[0],/DESTROY
    TreeWidget='Empty'
ENDIF
tupel='Empty'
diffvals='Empty'
active=0

; From Maskimage
maskimage='Empty'


; From Correlations
correl_image='Empty'
correl_measurements='Empty'


; From AdaptCoors

Atlas='Empty'
ShiftedAtlas='Empty'
start_point='Empty'


; FROM EditParameters
IF string(params_Tree[0]) NE 'Empty' THEN BEGIN
    widget_control,params_Tree[0],/DESTROY
    params_tree='Empty'
ENDIF

; FROM TRACES
blacklist='Empty'
showlist='Empty'


END

PRO StartupSettings
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON COORS
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON SHOW_TRACES
Common GetLogFiles
COMMON Window_IDS
COMMON EditParams

;;1107:: new or changed txt fields, setting startup values here
newDefaults = { medianwidth:2, $
                smoothwidth:11,$
                frequency:4, $
                stimulus_on:8, $
                stimulus_off:15 $
              }

GetCoors_ID=0
Mask_ID=0
Traces_ID=0
Correlate_ID=0
MovementCorrect_ID=0
AdaptCoors_ID=0
GetCoordinates_ID=0

load_raw=-1
!order=1
cd,current=working_dir
resize=1
rebinfactor=1
border=0.1
ncols=1
nrows=1
ctv_method=22
colortab=39
loadct,colortab
threshold=254
condensekernel=3
framethreshold=10
waterlist=-1
no_measurements=1
maxflag=-1
lopath=''
sapath="C:\"
fn=''
error=0
smoothed=1   ;;1107 was(!) used in getcoors / GenerateCTVImages
medianed=1   ;;1107 was used in getcoors / GenerateCTVImages
raw_ims=-1
data_masked=0
data_medianed=0
sorted=0
show_name=-1
coordinates=strarr(4,100,40)
coordinates[*]='-1000'
ctv_firstframe=6
ctv_lastframe=15
ctv_lowscale=0
ctv_highscale=0
no_one=0
no_two=0
ctv_coor=-1
presentframe=0
show_dots=0
hide_waves=-1
logfilenames='Empty'
Exptslist="Empty"
actualCoordinates=0
loadwithshifts=-1 ;;1107 no button anymore, off
loadwithcoors=-1  ;;1107 no button anymore, off
bleachcorrect=-1
correctSL=-1
Medianflag=-1
calcRatios=-1
FilterNames=-1
LoadMeth=2
Filter=''

; From MovementCorrect
shift_reference=0
mov_reference=0
x_pos=0
y_pos=0
error=0.0
filename=''
loadpath=''
spath=''
count=0
frames_or_measurements=-1
active=0
rawborder=0
changed=0
last_shifts={flag:0,x:0,y:0}
this_frame=last_shifts


; From Correlations
correl_image='Empty'
correl_measurements='Empty'
contrast_mem=0
brigthness_mem=0


; From Traces
min_y_val=0
max_y_val=100
ControlLine=0
device,get_screen_size=resolution
panelsize=resolution[1]/4
blacklist='Empty'
showlist='Empty'


; From AdaptCoors
pressed=0
last_x=0
last_y=0
last_z=0
adapt_coor=-1
result_size=1
atlas_size=1
window_size=0
scaled_x=100
scaled_y=100

; From EditParameters
params_tree='Empty'
selection=-1
isDenominator=0
isNumerator=0
VisionFilenamelist='Empty'

END


PRO CreateFileTree
COMMON Toggles
COMMON GetLogFiles
    IF VisionFilenamelist[0] NE 'Empty' THEN BEGIN
       IF LoadMeth EQ 1 OR LoadMeth EQ 2 OR CalcRatios EQ -1 THEN CreateNormalFileTree ELSE CreateChamFileTree
    ENDIF
END


PRO CreateChamFileTree
COMMON CTVS
COMMON GetLogFiles
COMMON Toggles
IF string(filetree[0]) NE "Empty" THEN widget_control,filetree[0],/DESTROY
noNum=total(isNumerator)
noDenom=total(isDenominator)
filetree=intarr(noNum+N_ELEMENTS(logfilenames)+1)
filetree[0]=WIDGET_TREE(wtbase,value=folder,/FOLDER,/EXPANDED,uvalue={Name:"Root",LogFileName:"Root",Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0})
K=1
FOR I=0, N_ELEMENTS(logFilenames)-1 DO BEGIN

    filetree[K]=widget_tree(filetree[0],value=String(i)+" "+logfilenames[i],/FOLDER,uvalue={Name:logfilenames[i],LogFileName:logfilenames[i],Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0},/EXPANDED)
    folder_base_pos=k
    k=k+1
    interval_start=counterlist[i]
    interval_end=counterlist[i+1]-1
    listNumerator=where(isNumerator[interval_start:interval_end] EQ 1)
    listNumerator=listNumerator+interval_start
    tookFirst=0
    FOR J=0,n_elements(listNumerator)-1 DO BEGIN
       	posNum=listNumerator[j]
       	time=timelist[posNum]
       	posDenom=posNum+1
       	IF xlist[posDenom] EQ xlist[posNum] AND  ylist[posDenom] EQ ylist[posNum] AND zlist[posDenom] EQ zlist[posNum] THEN BEGIN
  			temp=namelist[posNum]+"/"+namelist[posDenom]
            name=temp
            IF FilterNames NE 1 OR strpos(name,Filter) NE -1 THEN BEGIN
            	filetree[k]=widget_tree(filetree[folder_base_pos],value=string(j)+name,uvalue={Name:name,LogFilename:logfilenames[i],Denominator:VisionFilenameList[posDenom],Numerator:VisionFilenameList[posNum], $
                Experiment:Experimentlist[posNum],x:fix(xlist[posNum]),y:fix(ylist[posNum]),z:fix(zlist[posNum]),time:long(timelist[posNum])})
                k=k+1
           	ENDIF
     	ENDIF
    ENDFOR
ENDFOR


END

PRO CreateRatioFileTree
COMMON CTVS
COMMON GetLogFiles
COMMON Toggles
IF string(filetree[0]) NE "Empty" THEN widget_control,filetree[0],/DESTROY
noNum=total(isNumerator)
noDenom=total(isDenominator)
filetree=intarr(noNum+N_ELEMENTS(logfilenames)+1)
filetree[0]=WIDGET_TREE(wtbase,value=folder,/FOLDER,/EXPANDED,uvalue={Name:"Root",LogFileName:"Root",Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0})
K=1
FOR I=0, N_ELEMENTS(logFilenames)-1 DO BEGIN

    filetree[K]=widget_tree(filetree[0],value=String(i)+" "+logfilenames[i],/FOLDER,uvalue={Name:logfilenames[i],LogFileName:logfilenames[i],Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0},/EXPANDED)
    folder_base_pos=k
    k=k+1
    interval_start=counterlist[i]
    interval_end=counterlist[i+1]-1
    listNumerator=where(isNumerator[interval_start:interval_end] EQ 1)
    listNumerator=listNumerator+interval_start
    tookFirst=0
    FOR J=0,n_elements(listNumerator)-1 DO BEGIN
       posNum=listNumerator[j]
       time=timelist[posNum]
       posDenom=where(isDenominator[interval_start:interval_end] EQ 1)
       postime=WHERE(timelist[interval_start:interval_end] EQ time)
       posBoth=CompareArrays(posDenom,postime)
       IF posBoth.a[0] EQ -1 THEN BEGIN
         postime=WHERE(timelist[interval_start:interval_end] EQ time+1)
         posBoth=CompareArrays(posDenom,postime)
       ENDIF
       IF posBoth.a[0] EQ -1 THEN BEGIN
         postime=WHERE(timelist[interval_start:interval_end] EQ time-1)
         posBoth=CompareArrays(posDenom,postime)
       ENDIF
       IF posBoth.a[0] NE -1 THEN BEGIN
         posDenom=posDenom[posBoth.a]
         posDenom=posDenom+interval_start
         IF N_ELEMENTS(posDenom) GT 1 THEN BEGIN
          print,"Alert !!!!!"+string(n_elements(posDenom))+" Elements found!!!"
          posDenom=posDenom[tookFirst]
          tookFirst=1
         ENDIF ELSE posDenom=posDenom[0]
         IF posDenom[0] NE -1 THEN BEGIN
          IF xlist[posDenom] EQ xlist[posNum] AND  ylist[posDenom] EQ ylist[posNum] AND zlist[posDenom] EQ zlist[posNum] THEN BEGIN
              temp=namelist[posNum]+"/"+namelist[posDenom]
              pos=strpos(temp,'_',/REVERSE_SEARCH)
              IF N_ELEMENTS(postime) EQ 3 THEN BEGIN
                 x=[posNum,posDenom]
                 postime=postime+interval_start
                 x=CompareArrays(x,postime)
                 IF x.b[0] NE -1 THEN BEGIN
                   postime[x.b]=0
                   posratio=WHERE(postime NE 0)
                   IF posratio[0] NE -1 THEN temp=namelist[postime[posRatio[0]]]
                 ENDIF
              ENDIF
              name=temp

              IF FilterNames NE 1 OR strpos(name,Filter) NE -1 THEN BEGIN
                 filetree[k]=widget_tree(filetree[folder_base_pos],value=string(j)+name,uvalue={Name:name,LogFilename:logfilenames[i],Denominator:VisionFilenameList[posDenom],Numerator:VisionFilenameList[posNum], $
                 Experiment:Experimentlist[posNum],x:fix(xlist[posNum]),y:fix(ylist[posNum]),z:fix(zlist[posNum]),time:long(timelist[posNum])})
                 k=k+1
              ENDIF
          ENDIF
         ENDIF
       ENDIF
    ENDFOR
ENDFOR


END

PRO CreateNormalFileTree
COMMON CTVS
COMMON GetLogFiles
COMMON TOGGLES

IF string(filetree[0]) NE "Empty" THEN widget_control,filetree[0],/DESTROY
filetree=intarr(n_elements(namelist)+n_elements(logfilenames)+1)
filetree[0]=WIDGET_TREE(wtbase,value=folder,/FOLDER,/EXPANDED,uvalue={Name:"Root",LogFileName:"Root",Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0})
counter=1
FOR I=0,N_ELEMENTS(counterlist)-2 DO BEGIN
    filetree[counter]=widget_tree(filetree[0],value=String(i)+" "+logfilenames[i],/FOLDER,uvalue={Name:logfilenames[i],LogFileName:logfilenames[i],Denominator:"None",Numerator:"Folder",Experiment:"None",x:0,y:0,z:0},/EXPANDED)
    basecounter=counter
    counter=counter+1
    k=0
    FOR J=counterlist[I],counterlist[I+1]-1 DO BEGIN
       isDenom=isDenominator[j]
       isNum= isNumerator[j]
       isDeltaF=strpos(namelist[j],'Delta')
       IF (hide_waves EQ -1) OR (isNum EQ 0 AND isDenom EQ 0 AND isDeltaF EQ -1) THEN BEGIN
         IF FilterNames NE 1 OR strpos(namelist[j],Filter) NE -1 THEN BEGIN
          filetree[counter]=widget_tree(filetree[basecounter],value=string(k)+" "+namelist[j],$
              uvalue={Name:namelist[j],LogFileName:logfilenames[i],Denominator:'None',Numerator:VisionFilenamelist[j],Experiment:ExperimentList[j],x:fix(xlist[j]),y:fix(ylist[j]),z:fix(zlist[j]),time:long(timelist[j])})
          counter=counter+1
         ENDIF
       ENDIF
       k=k+1
    ENDFOR
ENDFOR

END




PRO CreateParamsTree
COMMON ALL
COMMON EditParams
COMMON Window_IDS

IF n_elements(lastframes) GE 2 THEN BEGIN
    IF string(params_tree[0]) NE 'Empty' THEN widget_control,params_tree[0],/DESTROY
    temp=parameters[*].experiment
    ex_num=0
    ex_name="None"
    FOR I=0, N_ELEMENTS(temp)-1 DO BEGIN
       IF temp[i] NE ex_name THEN BEGIN
         ex_num=ex_num+1
         ex_name=temp[i]
       ENDIF
    ENDFOR

    no_leafs=N_ELEMENTS(parameters)+ex_num+1
    params_tree=intarr(no_leafs)
    ex_name="None"
    tree_base=0
    j=0
    params_tree[0]=widget_tree(params_tree_id,value="In memory ..",uvalue="ParamTreeFolder",/FOLDER,/EXPANDED)
    FOR I=1,no_leafs-1 DO BEGIN
       IF parameters[j].experiment NE ex_name THEN BEGIN
         params_tree[i]=widget_tree(params_tree[0],value=parameters[j].experiment,uvalue="ParamTreeFolder",/FOLDER,/EXPANDED)
         tree_base=params_tree[i]
         ex_name=parameters[j].experiment
       ENDIF ELSE    BEGIN
         leaf_no="l_"+string(j)
         params_tree[i]=widget_tree(tree_base,value=parameters[j].leaf_name,uvalue=leaf_no)
         j=j+1
       ENDELSE
    ENDFOR
ENDIF

END

PRO Saveparameters
COMMON ALL
num=N_ELEMENTS(parameters)
IF string(lastframes[0]) NE 'Empty' THEN BEGIN
    FOR I=0,num-1 DO BEGIN
       p_temp=parameters[i]
       filename=p_temp.ex_name+'.params'
       save,FILENAME=filename,p_temp
    ENDFOR
ENDIF
END

PRO EditParameters
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
Common GetLogFiles
COMMON EditParams

TreeWidget='Empty'
FileTree='Empty'
params_tree='Empty'

StartupSettings
EmptyVars
device,get_screen_size=resolution


tlb_parameters_id=widget_base(row=1,title="Edit Parameters",mbar=mbar)
file_menu=WIDGET_BUTTON(mbar,VALUE='File',/MENU)
browseb=WIDGET_BUTTON(file_menu,value='Browse to folder...',uvalue={Name:'browse',Filename:'none'})
;;1107 not used loadlist=WIDGET_BUTTON(file_menu,value='Load logfilelist...',uvalue='LoadLogFileList')
;;savelist=WIDGET_BUTTON(file_menu,value='Save logfilelist...',uvalue='SaveLogFileList')
;;saveb=WIDGET_BUTTON(file_menu,value='Save ...',uvalue='save')
exitb=WIDGET_BUTTON(file_menu,value='Exit', uvalue='EXIT')
;;1107Parameters_Menu=WIDGET_BUTTON(mbar,VALUE='Parameters...',/MENU)
;;1107SaveParameters_Button=WIDGET_BUTTON(Parameters_menu,value='Save parameters..',uvalue='SaveParams')
Window_Menu=WIDGET_BUTTON(mbar,VALUE='Windows...',/MENU)
;;1107 not used Correlations_Button=WIDGET_BUTTON(Window_menu,value='Correlation',uvalue='CorrelationsButton',/CHECKED_MENU)
;;1107 not used Mask_Button=WIDGET_BUTTON(Window_menu,value='Mask',uvalue='MaskButton',/CHECKED_MENU)
MovementCorrect_Button=WIDGET_BUTTON(Window_menu,value='Movement',uvalue='MovementCorrectButton',/CHECKED_MENU)
Parameters_Button=WIDGET_BUTTON(Window_menu,value="GetCoors",uvalue="GetCoorsButton",/CHECKED_MENU)
Traces_Button=WIDGET_BUTTON(Window_menu,value='Traces',uvalue='TracesButton',/CHECKED_MENU)
drawbase=widget_base(tlb_parameters_id,row=1)

newbuttonbase=widget_base(drawbase,col=1)
transfer_button_1=WIDGET_BUTTON(newbuttonbase, VALUE="Load Selection",uvalue="LS");,xsize=100,ysize=50)
;transfer_button_2=WIDGET_BUTTON(newbuttonbase, VALUE="Delete Selection",uvalue="DS",xsize=100,ysize=50)
transfer_button_3=WIDGET_BUTTON(newbuttonbase, VALUE="Delete All",uvalue="DA");,xsize=100,ysize=50)

checkbox_baseTifforTill=widget_base(newbuttonbase,col=1,/EXCLUSIVE,title="Tiffs",Frame=1)
checkbox_Tiffs=widget_Button(checkbox_baseTifforTill,value='2Photon Tifs',uvalue='LoadTif')
checkbox_GCAMP=widget_Button(checkbox_baseTifforTill,value='GCamp',uvalue='GCamp')
checkbox_Cham=widget_Button(checkbox_baseTifforTill,value='Chameleon',uvalue='Chameleon')
checkbox_till= widget_Button(checkbox_baseTifforTill,value="Fura2",uvalue="LoadTill")

checkbox_base0=widget_base(newbuttonbase,col=1,/EXCLUSIVE,title="Till Photonics",Frame=1)
checkbox_all=widget_Button(checkbox_base0,value="Show all",uvalue="ShowAll")
      ;;1107 not used checkbox_hide_waves=widget_Button(checkbox_base0,value="Hide 380/340",uvalue="Hide_wavelengths")
checkbox_calculate_ratios=widget_BUTTON(checkbox_base0,value="Calculate Ratios",uvalue="CalcRatios")
checkbox_base=widget_base(newbuttonbase,col=1,/NONEXCLUSIVE)
      ;;1107 not used checkbox_load_with_shifts=widget_BUTTON(checkbox_base,value="Load with shifts",uvalue="LoadWithShifts")
      ;;checkbox_load_with_coors=widget_BUTTON(checkbox_base,value="Load with coors",uvalue="LoadWithCoors")
checkbox_correct_median=widget_BUTTON(checkbox_base,value="Median",uvalue="MEDIANFLAG")
checkbox_correct_scattered=widget_BUTTON(checkbox_base,value="Correct Scattered Light",uvalue="CorrectSL")
checkbox_correct_bleach=widget_button(checkbox_base,value="Use bleach correction",uvalue="CorrectBleach")
checkbox_load_raw=widget_button(checkbox_base,value="Raw data (background correction off)",uvalue="loadraw")
     ;;1107 not used checkbox_filter_names=widget_BUTTON(checkbox_base,value="Filter names",uvalue="Filternames")
     ;;1107 not used filter_text=widget_text(newbuttonbase,value='',uvalue='Filter',/EDITABLE)

txtPara_base = widget_base(newbuttonbase,col=1, /grid)
txtXsize = 4
base11=widget_base(txtPara_base,/ROW )
lab11=widget_label(base11,value="Median Width  ")
text11=widget_text(base11,value=string(newdefaults.medianwidth),/EDITABLE, uvalue="MEDIANWIDTH", xsize = txtXsize, /tab_mode)
base12=widget_base(txtPara_base,/ROW )
lab12=widget_label(base12,value="Smooth Width  ")
text12=widget_text(base12,value=string(newdefaults.smoothwidth),/EDITABLE, uvalue="SMOOTHWIDTH", xsize = txtXsize, /tab_mode)
base4=widget_base(txtPara_base,/ROW)
lab4=widget_label(base4,value="Frequency  ")
text4=widget_text(base4,value=string(newdefaults.frequency),/EDITABLE,uvalue="Frequency", xsize = txtXsize, /tab_mode)
base7=widget_base(txtPara_base,/ROW)
lab7=widget_label(base7,value="Stimulus On  ")
text7=widget_text(base7,value=string(newdefaults.stimulus_on),/EDITABLE,uvalue="StimulusOn", xsize = txtXsize, /tab_mode)
base8=widget_base(txtPara_base,/ROW)
lab8=widget_label(base8,value="Stimulus Off  ")
text8=widget_text(base8,value=string(newdefaults.stimulus_off),/EDITABLE,uvalue="StimulusOff", xsize = txtXsize, /tab_mode)


widget_control,checkbox_Gcamp,/SET_BUTTON
widget_control,checkbox_all,/SET_BUTTON
      ;;1107widget_control,checkbox_load_with_shifts,/SET_BUTTON
      ;;1107widget_control,checkbox_load_with_coors,/SET_BUTTON

wtbase=WIDGET_TREE(drawbase,XSIZE=resolution[0]/4,ysize=resolution[1]*0.7,/MULTIPLE,uname='wtbase')


params_tree_ID=WIDGET_TREE(tlb_parameters_id, xsize= resolution[0]/4,ysize=resolution[1]*0.7,/MULTIPLE,uname="measu_tree")
;parameters_tab=WIDGET_TAB(tlb_parameters_id,location=0,xsize=600,ysize=600,uvalue="tab_widget")
wT1 = WIDGET_BASE(tlb_parameters_id, TITLE='Parameters', /COL,uvalue="tab1")
base0=widget_base(wT1,/ROW)
lab0=widget_label(base0,value="Experiment Name:")
text0=widget_text(base0,value="NONE",/EDITABLE,uvalue="ExpName")
  ;;lab00=widget_label(base0,value="CoordinateSet")
  ;;text00=widget_text(base0,value='0')
base9=widget_base(wT1,/ROW)
lab9=widget_label(base9,value="Filename:")
text9=widget_text(base9,value="NONE",xsize=50)


base1=widget_base(wT1,/ROW)
lab1=widget_label(base1,value="X_Size:")
text1=widget_text(base1,value='0')
base2=widget_base(wT1,/ROW)
lab2=widget_label(base2,value="Y_Size:")
text2=widget_text(base2,value='0')
base3=widget_base(wT1,/ROW)
lab3=widget_label(base3,value="Frames:")
text3=widget_text(base3,value='0')
;;1107 not used base5=widget_base(wT1,/ROW)
;;lab5=widget_label(base5,value="Odor:")
;;text5=widget_text(base5,value="NONE",/EDITABLE,uvalue="OdorName")
;;base6=widget_base(wT1,/ROW)
;;lab6=widget_label(base6,value="Concentration:")
;;text6=widget_text(base6,value="NONE",/EDITABLE,uvalue="OdorConc")
base10=widget_base(wT1,/ROW)
lab10=widget_label(base10,value="Time:")
text10=widget_text(base10,value="NONE",/EDITABLE,uvalue="MeaTime")
base11=widget_base(wT1,/ROW)
;;1107 SP_Button=WIDGET_BUTTON(base11,value='Save parameters..',uvalue='SaveParams');,xsize=100,ysize=25)


widget_control,checkbox_base0,SENSITIVE=0

widget_control,tlb_parameters_id,/realize
xmanager,'EditParameters',tlb_parameters_id,/no_block


END

