
;Fit a function of the form F(x) = a * exp(b*x) + c to sample pairs contained in arrays X and Y. The partial derivatives are easily computed symbolically:
;df/da = exp(b*x)
;df/db = a * x * exp(b*x)
;df/dc = 1.0
;First, define a procedure to return F(x) and the partial derivatives, given X. Note that A is an array containing the values a, b, and c.





PRO gfunct, X, A, F, pder
  bx = EXP(A[1] * X)
  F = A[0] * bx + A[2]
  IF N_PARAMS() GE 4 THEN $	;If the procedure is called with four parameters, calculate the partial derivatives.
    pder= [[bx], [A[0] * X * bx], [replicate(1.0, N_ELEMENTS(X))]]
END








pro FitLogDecay, lineIn, fittedOut, weights ;, noConverge


;excludeStart and excludeEnd are optional
;if present, time before excludeStart is weighted more

;given an input one-dimensional array,
;a fitted output is given

;Compute the fit to the function we have just defined. First, define the independent and dependent variables:

;common data ; necessary in order to write parameters into p structure
;common CFD
;common CFDconst


Y = reform(lineIn)
X = FLOAT(INDGEN(N_elements(y)))


offset = double(mean(y))
A = [1.0D,-0.1D,offset]	;Provide an initial guess of the function's parameters.

;July 2003: estimate initial parameters with a linear fit
estimate = LINFIT(X, Y, yfit=yfit)
A(0)=yfit(0)-yfit(n_elements(y)-1)
A(2)=yfit(n_elements(y)-1)
;one time correction, remove if needed
a(1) = a(1)/100
print, 'FitLogDecay.pro: Function estimates: ', A



itMax = 1000
yfit = CURVEFIT(X, Y, weights, A, SIGMA, FUNCTION_NAME='gfunct', ITmax=itMax, ITER=iter)


;Compute the parameters.
IF ((iter gt itmax) OR (iter eq 1)) THEN noConverge=1 ELSE noConverge=0
PRINT, 'FitLogDecay.pro: Function parameters (check FitLogDecay.pro for function): ', A	;Print the parameters returned in A.
IF noConverge THEN print, 'FitLogDecay.pro: Failed to converge, setting parameters to 0; check FitLogDecay.pro'

;copy the parameters into the p structure, so it is available for later retrieval
;p1.BleachPar = A


;IDL prints:
;Function parameters:       9.91120    -0.100883      2.07773
;Thus, the function that best fits the data is:
;F(x) = 9.91120 * exp(-0.100883x) +  2.07773


fittedout = a(0) * exp(a(1)*X) + a(2)


IF noConverge THEN fittedOut(*) = offset


end