FUNCTION Get3DKernel,ThreeDStack,kernel,position
ArrayDims=SIZE(ThreeDStack)
frame=position/(ArrayDims[1]*ArrayDims[2])
framepos= position MOD (ArrayDims[1]*ArrayDims[2])
x_pos=framepos MOD ArrayDims[1]
y_pos=framepos/ArrayDims[1]
IF x_pos-Kernel LT 0 THEN x_start=0 ELSE x_start=x_pos-Kernel
IF x_pos+Kernel GT ArrayDims[1]-1 THEN x_end=ArrayDims[1]-1 ELSE x_end=x_pos+kernel

IF y_pos-Kernel LT 0 THEN y_start=0 ELSE y_start=y_pos-Kernel
IF y_pos+Kernel GT ArrayDims[2]-1 THEN y_end=ArrayDims[2]-1 ELSE y_end=y_pos+kernel

IF frame-Kernel LT 0 THEN z_start=0 ELSE z_start=frame-Kernel
IF frame+Kernel GT ArrayDims[3]-1 THEN z_end=ArrayDims[3]-1 ELSE z_end=frame+Kernel

result=ThreeDStack[x_start:x_end,y_start:y_end,z_start:z_end]

return,result
END