;Module REFRESHTABLE.
;Module APPLYFILTER.
;Module SHIFTIMAGESTAPLE.
;Module GENERATECTVIMAGES.
;Module CLICKACTION_3DRAW.
;Module TRACECURSOR.
;Module LOADSIG1.
;Module SAVECOORS_3DRAW.
;Module SAVEIMAGES.
;Module LOAD_MOVIE.
;Module GETWATERLIST.
;Module REFRESHSCREEN: main display routine
;Module REFRESH_MEASUREMENT.
;Module CONDENSE.
;Module WATERPEAKS.
;Module GETPEAKS.
;Module GETFILES_EVENT.
;Module GETCOORS_EVENT.
;Module GETCOORS.


PRO RefreshTable
COMMON ALL
COMMON Widget_IDs
tempres=Coordinates[*,*,actualcoordinates]
pos=where(tempres[0,*] NE '-1000')
IF pos[0] NE -1 THEN BEGIN
	tempres=tempres[*,pos]

	coor_num=n_elements(tempres[0,*])
	widget_control,table_id,Table_YSIZE=coor_num
	widget_control,table_id,SET_VALUE=tempres
ENDIF ELSE widget_control,table_id,Table_YSIZE=0
END


FUNCTION ApplyFilter, images, filtername
ArrayDims=size(images)
IF ArrayDims[0] EQ 2 THEN ArrayDims[3]=1
IF filtername EQ 'Convol' THEN BEGIN
	FOR i=0,ArrayDims[3]-1 do begin
		kern3=[[1,1,1],[1,2,1],[1,1,1]]
		kern5=[[1,1,1,1,1,1,1],[1,1,1,2,1,1,1],[1,1,2,2,2,1,1],[1,2,2,2,2,2,1],[1,1,2,2,2,1,1],[1,1,1,2,1,1,1],[1,1,1,1,1,1,1]]
		images[*,*,i]=convol(images[*,*,i],kern3,/EDGE_TRUNCATE)/total(kern5)
	ENDFOR
ENDIF
IF filtername EQ 'Median' THEN BEGIN
	FOR i=0,ArrayDims[3]-1 do begin
		images[*,*,i]=MEDIAN(images[*,*,i],5)
	ENDFOR
ENDIF
return,images
END

FUNCTION ShiftImageStaple,images, list_with_shifts
FOR i=0, n_elements(list_with_shifts[0,*])-1 do begin	images[*,*,i]=shift(images[*,*,i],-list_with_shifts[0,i],-list_with_shifts[1,i])
ENDFOR
return,images
END



;//////////////////////////////////////////////////////////////;//////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////;//////////////////////////////////////////////////////////////
;///////////////////////////////////////////////////////////////////////////
;/////////
PRO GenerateCTVImages ;;creates and preprocessed CTVImages
COMMON ALL
COMMON TOGGLES
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
IF string(data[0]) NE 'Empty' THEN BEGIN
	DataDims=SIZE(data)
	ctvimages_raw=fltarr(DataDims[1],DataDims[2],N_ELEMENTS(parameters))
	IF DataDims[0] EQ 2 THEN BEGIN
		temp=data
		stim_on=parameters.STIMULUS_ON
		stim_off=parameters.STIMULUS_END
		FOR y=0,DataDims[2]-1 DO BEGIN
			FOR x=0,DataDims[1]-1 DO BEGIN
				ctvimages_raw[x,y]=CTV_TreatSignals(temp[x,y,*],stim_on,stim_off,ctv_method)
			ENDFOR
		ENDFOR
	ENDIF ELSE BEGIN
		FOR I=0, N_ELEMENTS(lastframes)-2 DO BEGIN
			temp=data[*,*,lastframes[i]:lastframes[i+1]-1]
			stim_on=parameters[i].STIMULUS_ON
			stim_off=parameters[i].STIMULUS_END
			FOR y=0,DataDims[2]-1 DO BEGIN  ;;1107 todo avoid loop(performance)
		 ;;1107 fill ctvimage
				FOR x=0,DataDims[1]-1 DO BEGIN
					ctvimages_raw[x,y,i]=CTV_TreatSignals(temp[x,y,*],stim_on,stim_off,ctv_method)
				ENDFOR
			ENDFOR
			kern3=[[1,1,1],[1,2,1],[1,1,1]]
			;ctvimages_raw[*,*,i]=median(ctvimages_raw[*,*,i],3)
			;ctvimages_raw[*,*,i]=convol(ctvimages_raw[*,*,i],kern3,/EDGE_TRUNCATE)/total(kern3)
		ENDFOR
	ENDELSE
	ctvimages=ctvimages_raw
	tilllog=parameters
	measurements=tilllog[0].odor
	noname=''
	pos=where(measurements ne noname)
	no_measurements=MAX(pos)+1
	ArrayDims=SIZE(CTVIMAGES)
	IF ArrayDims[0] EQ 2 THEN ArrayDims[3]=1
	IF ArrayDims[3]/no_measurements le 5 then begin
		reference=ArrayDims[3]/(2*no_measurements)
	endif else begin
		reference=5
	endelse

	IF medianed eq 1 THEN ctvimages=ApplyFilter(ctvimages,'Median')
	IF smoothed eq 1 THEN ctvimages=ApplyFilter(ctvimages,'Convol')
	getwaterlist
	odorlist=strarr(ArrayDims[3])
	messungslist=strarr(ArrayDims[3])
	experiments_visible=strarr(ArrayDims[3])
	showsequence=indgen(ArrayDims[3])

	FOR I=0,ArrayDims[3]-1 DO BEGIN
		name=''
		messung=i

		name=strcompress(parameters[i].odor[0]+STRING(FIX(parameters[i].odor_nr[0])))
		experiments_visible[i]=parameters[i].experiment
		odorlist[i]=name
		messungslist[i]=string(messung)
	ENDFOR
	IF LoadMeth EQ 1 AND Load_Raw NE 1 THEN BEGIN
		IF ArrayDims[3] GT 1 THEN BEGIN
			ctv_lowscale=min(median(total(ctvimages,3)/ArrayDims[3],5))
			ctv_highscale=max(median(total(ctvimages,3)/ArrayDims[3],5))
		ENDIF ELSE BEGIN
			ctv_lowscale=min(ctvimages)
			ctv_highscale=max(ctvimages)
		ENDELSE
	ENDIF ELSE BEGIN
		ctv_lowscale=min(ctvimages)
		ctv_highscale=max(ctvimages)
	ENDELSE
	widget_control,scalehigh_id,set_value=string(ctv_highscale)
	widget_control,scalelow_id,set_value=string(ctv_lowscale)
ENDIF
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO clickaction_3DRAW,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON Window_IDS
; Are the images already loaded? If yes, set variables, like which frame the mouse points at and which position
IF string(ctvimages[0]) ne 'Empty' then begin
	refreshflag=0
	refreshmeasu=0
	refreshmovcorr=0
	refreshcorr=0
	x_pos=event.X
	y_pos=yval-event.Y
	ArrayDims=SIZE(ctvimages)
	IF ArrayDims[0] EQ 2 THEN ArrayDims[3]=1
	x_frame=x_pos/(ArrayDims[1]*resize)
	y_frame=y_pos/(ArrayDims[2]*resize)

	x_pos_frame=((x_pos MOD (resize*ArrayDims[1]))/resize)
	y_pos_frame=(y_pos MOD (resize*ArrayDims[2]))/resize

	framenum=y_frame*ncols+x_frame



	; Does the frame exist (does ctvimages have that many frames?)? Is the mouse above an image?
	IF framenum LT ArrayDims[3] AND framenum GE 0 AND x_pos_frame GT 0 AND x_pos_frame LT ArrayDims[1] AND y_pos_frame GT 0 AND y_pos_frame LT ArrayDims[2] THEN BEGIN
		framenum=showsequence[framenum]

		result=Coordinates[*,*,parameters[framenum].messungszahl]
		pos=where(result[0,*] NE '-1000')
		IF pos[0] NE -1 THEN num_coors=n_elements(pos) ELSE num_coors=0

		; A typical draw_event structure has several variables, some of these are:
		;	- event.type (Mouse movement =2, button press =0, button release=1)
		;	- event.X and event.Y (position of event)
		;	- event.press and event.release (1=left mouse button, 2= middle mouse button, 4=rigth mouse button)
		; 	- event.modifiers and event.key (1= shift, 8= alt for modifiers; event.key =5,6,7,8 for arrows on keyboard)
		; 	- event.ch (The character pressed on keyboard (a number))
		;


		;//////////////////////////////////////////////////////////////////////////
		;
		;					MOUSE
		;
		;////////////////////////////////////////////////////////////////////////////
		; Enters here whenever the mouse generated the event::

		IF event.type EQ 0 OR event.type EQ 1 OR event.type EQ 2 THEN BEGIN

			;Mouse button press generated event
			IF event.type EQ 0 THEN BEGIN
				IF event.press EQ 1 THEN BEGIN
					IF  num_coors NE 0 THEN BEGIN
						pos=where(fix(result[0,*]) lt x_pos_frame+condensekernel AND fix(result[0,*]) gt x_pos_frame-condensekernel AND fix(result[1,*]) lt y_pos_frame+condensekernel AND fix(result[1,*]) gt y_pos_frame-condensekernel)
						IF pos[0] NE -1 THEN ctv_coor=pos[0]
					ENDIF
				ENDIF
			ENDIF; event.type EQ 0

			;Mouse button release generated event
			IF event.type EQ 1 THEN BEGIN

				; Left mouse button was released here
				IF event.release EQ 1 THEN BEGIN
					; Left button was pressed. What shall be done? If presseed without modifiers the possibilities are:
					; 1. Select a new coordinate
					; 2. Move a coordinate to its new position
					; 3. Nothing
					IF event.modifiers EQ 0 THEN BEGIN
						pos=-1
						glom=300
						loginfo=tilllog[framenum]
						odor=strcompress(loginfo.odor[0]+string(fix(loginfo.odor_nr[0])))
						; The coordinate list is not empty. Look for the glomerulus with the highest number. If less then 300 its set to 300, else to the next higher value
						IF  num_coors NE 0 THEN BEGIN
							glom=MAX(fix(result[2,*]))+1
							IF glom LT 300 THEN glom=300
							; Look whether there a coordinates closeby to the mouse release point?
							pos=where(fix(result[0,*]) lt x_pos_frame+condensekernel AND fix(result[0,*]) gt x_pos_frame-condensekernel AND fix(result[1,*]) lt y_pos_frame+condensekernel AND fix(result[1,*]) gt y_pos_frame-condensekernel)
						ENDIF
						; If there are no coordiantes nearby set ....
						IF pos[0] EQ -1 THEN BEGIN
							;AND there was no coordinate chosen ("ctv_coor=-1") a new coordiante at the release site with the value "odor"
							IF ctv_coor EQ -1 THEN BEGIN
								IF  num_coors NE 0 THEN BEGIN
									x_pos=reform(result[0,*])
									row=min(WHERE(x_pos EQ '-1000'))
									IF row GE 0 THEN BEGIN
										result[0,row]=strtrim(string(x_pos_frame),2)
										result[1,row]=strtrim(string(y_pos_frame),2)
										result[2,row]=strtrim(string(glom),2)
										result[3,row]=strtrim(string(odor),2)
									ENDIF
								ENDIF ELSE BEGIN
									result[*,0]=[strtrim(string(x_pos_frame),2),strtrim(string(y_pos_frame),2),strtrim(string(glom),2),strtrim(string(odor),2)]
								ENDELSE
								refreshflag=1
								refreshmeasu=1
								refreshcorr=1
								refreshmovcorr=1
							; But if there was a coordinate chosen, its x and y positions just get overwritten with the new values of the mouse release
							ENDIF ELSE BEGIN
								IF  num_coors NE 0 THEN BEGIN
									result[0:1,ctv_coor]=[strtrim(string(x_pos_frame),2),strtrim(string(y_pos_frame),2)]
									ctv_coor=-1
									refreshflag=1
									refreshmeasu=1
									refreshcorr=1
									refreshmovcorr=1
								ENDIF
							ENDELSE
							Coordinates[*,*,parameters[framenum].messungszahl]=result
						ENDIF

					;/////////// Left Mouse button released with shift (1) or Alt (8)
					ENDIF ELSE BEGIN
						IF event.modifiers EQ 1 THEN BEGIN
							IF framenum lt ArrayDims[3] AND framenum GE 0 THEN BEGIN
								no_one=framenum
								widget_control,diff_one_id,set_value=string(no_one)
							ENDIF
						ENDIF
						IF event.modifiers EQ 8 THEN BEGIN
							IF framenum LT ArrayDims[3] AND framenum GE 0 THEN BEGIN
							 	IF frames_or_measurements EQ 0 THEN count=framenum ELSE BEGIN
									LoadShifts
									count=framenum
									last_shifts=this_frame
									this_frame.x=0
									this_frame.y=0
									this_frame.flag=0
								ENDELSE
								refreshmovcorr=1
							ENDIF
						ENDIF
					ENDELSE
					refreshflag=1
					refreshmeasu=1
					refreshcorr=1
					refreshmovcorr=1
				ENDIF; event.release EQ 1


				; Middle mouse button was released here
				IF event.release EQ 2 THEN BEGIN
					; Middle button pressed to show movies , with shift to mark or unmark frames for the test watershed
					IF event.modifiers EQ 1 THEN BEGIN
						pos=where(waterlist eq framenum)
						pos=pos[0]
						temp1=-1
						if pos eq -1 AND n_elements(waterlist) eq 1 AND waterlist[0] eq -1 then temp1=0
						if pos eq -1 AND (n_elements(waterlist) ne 1 OR waterlist[0] ne -1) then temp1 =3
						if pos ne -1 AND n_elements(waterlist) ne 1 then temp1=1
						if pos ne -1 AND n_elements(waterlist) eq 1 AND waterlist[0] eq -1 then temp1=2
						CASE temp1 of
							0: waterlist=framenum
							1: begin
								temp=-1
								if pos gt 0 AND pos lt n_elements(waterlist)-1 then temp=0
								if pos eq 0 then temp =1
								if pos eq n_elements(waterlist)-1 then temp=2
								CASE temp of
									0: waterlist=[waterlist[0:pos-1],waterlist[pos+1:n_elements(waterlist)-1]]
									1: waterlist=waterlist[1:n_elements(waterlist)-1]
									2: waterlist=waterlist[0:n_elements(waterlist)-2]
								endcase
								end
							2: waterlist=framenum
							3: waterlist=[waterlist,framenum]
							else: waterlist=-1
						ENDCASE
						refreshflag=1
					ENDIF ELSE BEGIN
						Load_Movie,framenum
					ENDELSE
				ENDIF;event.release EQ 2


				; Right mouse button was released here
				IF event.release EQ 4 THEN BEGIN
					; Was the shift modifier pressed? If not and if this release happened above a coordinate this coordiante will be deleted
					IF event.modifiers NE 1 THEN BEGIN
						; Are there coordiantes to be deleted (it makes no sense to delete non existant coordinates)
						IF  num_coors NE 0 THEN BEGIN
							; Check whether there are any coordiantes in the distance of "condensekernel" to the mouse release.
							pos=where(fix(result[0,*]) LT x_pos_frame+condensekernel AND fix(result[0,*]) GT x_pos_frame-condensekernel AND fix(result[1,*]) LT y_pos_frame+condensekernel AND fix(result[1,*]) GT y_pos_frame-condensekernel)
							; If there is at least one  coordinate nearby do:
							IF pos[0] NE -1 THEN BEGIN
								; If there was only one coordinate overall reset the variable "result", else delete the colseby variables whose positions are marked in "pos".
								IF num_coors EQ 1 THEN BEGIN
									Coordinates[*,*,parameters[framenum].messungszahl]='-1000'
								ENDIF ELSE BEGIN
									result[*,pos]='-1000'
									Coordinates[*,*,parameters[framenum].messungszahl]=result
								ENDELSE

								refreshflag=1
								refreshmeasu=1
								refreshcorr=1
								refreshmovcorr=1
							ENDIF
						ENDIF
					ENDIF ELSE BEGIN
						; The Button was released with shift pressed -> Second image for differential image was chosen
						IF framenum LT ArrayDims[3] AND framenum GE 0 THEN BEGIN
							no_two=framenum
							widget_control,diff_two_id,set_value=string(no_two)
							refreshflag=1
							refreshmeasu=1
							refreshcorr=1
							refreshmovcorr=1
						ENDIF
					ENDELSE
				ENDIF;event.release Eq 4

			ENDIF; event.type EQ 1
			;Mouse move generated event
			IF event.type EQ 2 THEN BEGIN
				intensity=0
				intensity=ctvimages[x_pos_frame,y_pos_frame,framenum]
				tempstring="x:"+strcompress(string(x_pos_frame))+"   y:"+strcompress(string(y_pos_frame))+"   Val:"+strcompress(string(intensity))
				widget_control,draw_id,TOOLTIP=string(tempstring)
				tracecursor,x_pos_frame,y_pos_frame,framenum
			ENDIF ;event.type EQ 2

		ENDIF; Event Type MOUSE

		;/// Here comes the coordinate shift with the arrow keys
		IF event.type EQ 6 AND event.key GT 0 AND event.release EQ 1 AND  string(result[0]) NE '-1000' then begin
			result=Coordinates[*,*,actualcoordinates]
			coors_pos=WHERE(result[0,*] NE -1000)


			IF event.key EQ 5 THEN result[0,coors_pos]=strtrim(string(fix(result[0,coors_pos])-1),2)

			IF event.key EQ 6 THEN result[0,coors_pos]=strtrim(string(fix(result[0,coors_pos])+1),2)

			IF event.key EQ 7 THEN result[1,coors_pos]=strtrim(string(fix(result[1,coors_pos])-1),2)

			IF event.key EQ 8 THEN result[1,coors_pos]=strtrim(string(fix(result[1,coors_pos])+1),2)

			refreshflag=1
			refreshmeasu=1
			refreshcorr=1
			Coordinates[*,*,actualcoordinates]=result
		ENDIF; Keyboard released

		IF refreshflag gt 0 then BEGIN
			refreshscreen
			refreshtable
			refresh_measurement
			IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
			;refreshcoors
		ENDIF
		IF refreshmovcorr GT 0 AND MovementCorrect_ID NE 0 THEN BEGIN
			refresh
		ENDIF
		IF refreshcorr GT 0 AND Correlate_ID NE 0 THEN refreshcorrel,event

	ENDIF; event happened in one of the CTVimages present
ENDIF; CTVimages are present
END;







;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO tracecursor,x_pos,y_pos,measurement
COMMON ALL
COMMON CTVS
COMMON WINDOW_IDS
COMMON WIDGET_IDS
COMMON SHOW_TRACES
Device, Decomposed=0
loadct,39,/SILENT
IF x_pos NE -1 AND y_pos NE -1 THEN BEGIN
	IF measurement GE 0 AND measurement LT N_ELEMENTS(lastframes)-1 THEN BEGIN
		xs=resolution[0]/4+20
		ys=resolution[1]/4
		widget_control,traces_wid,draw_xsize=xs,draw_ysize=ys
		widget_control,traces_wid,get_value=winnum
		wset,winnum
		light=lonarr(xs,ys)
		light[*]=255
		tv,light
		!p.charsize=2
		temp=data[*,*,lastframes[measurement]:lastframes[measurement+1]-1]
		ArrayDims=SIZE(temp)
		IF string(maskimage[0]) NE 'Empty' THEN BEGIN
			FOR I=0,ArrayDims[3]-1 DO temp[*,*,i]=temp[*,*,i]*maskimage
		ENDIF
		curve=fltarr(ArrayDims[3])
 		FOR k=0, ArrayDims[3]-1 DO BEGIN
			a=temp[*,*,k]
			tempcurve=getcurve(x_pos,y_pos,a,condensekernel)
			curve[k]=MEAN(tempcurve)
		ENDFOR

		stimon=parameters[measurement].stimulus_on
		stimoff=parameters[measurement].stimulus_end
		x=[stimon,stimoff,stimoff,stimon]
		y=[max_y_val,max_y_val,min_y_val,min_y_val]
		plot,curve,YRANGE=[min_y_val,max_y_val],THICK=1.5,background=255,color=0,/NODATA
		POLYFILL,x,y,color=FSC_COLOR("Grey", !D.Table_Size-4)
		oplot,curve,THICK=1.5,color=0
		IF ControlLine NE 0 THEN BEGIN
			ctrlLine=fltarr(ArrayDims[3])
			ctrlLine[*]=ControlLine
			oplot,ctrlLine,linestyle=1,THICK=1,color=0
		ENDIF

	ENDIF
ENDIF

END

;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////



PRO LoadSig1
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON TOGGLES
COMMON SHOW_MOVIE
COMMON COORS


f=DIALOG_PICKFILE(/read,/MUST_EXIST,FILTER='*.sav',PATH=lopath)

IF f[0] NE '' THEN BEGIN
	ctvimages_raw='Empty'
	rawimages='Empty'
	ctvimages='Empty'
	tillog='Empty'
	chosenframes='Empty'
	waterlist=-1
	result='Empty'

	data='Empty'
	lastframes=0
	image_staple='Empty'

	frames_or_measurements=-1
	image_staple='Empty'
	maskimage='Empty'
	movie_measurement='Empty'
	correl_image='Empty'
	medianed=0
	smoothed=0

	restore,f
	filenamelist=f_names
	cutoff=strpos(f,"\",/REVERSE_SEARCH)
	fn=strmid(f,cutoff+1)
	lopath=strmid(f,0,cutoff+1)
	a=strlen(fn)
	fn=strmid(fn,0,a-4)
	widget_control,fn_id,set_value=fn

	staple_ptrs=PTRARR(n_elements(f_names),/ALLOCATE_HEAP)
	raw_ptrs=PTRARR(n_elements(f_names),/ALLOCATE_HEAP)
	dimensions=intarr(2,n_elements(f_names))
	framenum=0
	lastentry=0
	diffvals=fltarr(n_ELEMENTS(f_names)+1)
	FOR I=0,n_elements(f_names)-1 DO BEGIN
		filename=lopath+filenamelist[i]
		restore,filename
		temp1=temp[*,*,*,1]
		ArrayDims=SIZE(temp1)
		temp1=congrid(temp1,float(ArrayDims[1])*rebinfactor,float(ArrayDims[2])*rebinfactor,ArrayDims[3])
		ArrayDims=SIZE(temp1)
		lastframes=[lastframes,lastframes[i]+ArrayDims[3]]
		framenum=framenum+ArrayDims[3]
		IF I EQ 0 THEN parameters=pars ELSE parameters=[parameters,pars]
   		dimensions[0,i]=ArrayDims[1]
   		dimensions[1,i]=ArrayDims[2]
		staple_ptrs[i]=ptr_new(temp1)
		temp0=temp[*,*,*,0]
		dims=SIZE(temp0)
		temp0=congrid(temp0,float(dims[1])*rebinfactor,float(dims[2])*rebinfactor,dims[3])
		dims=SIZE(temp0)
		ref=dims[3]/2
		sum=0.0
		totpix=(Dims[1]*Dims[2])
		FOR J=0,ArrayDims[3]-1 DO BEGIN
			im1=MEAN(float(temp0[*,*,J]))
			im2=MEAN(float(temp0[*,*,ref]))
			val=totpix*((im1+im2)/2)
			sum=[sum,total(abs(float(temp0[*,*,J])-float(temp0[*,*,ref])))/val]
		ENDFOR
		sum=sum[1:n_elements(sum)-1]
		diffvals[i]=total(sum)/n_elements(sum)
		raw_ptrs[i]=ptr_new(total(temp0,3))
	ENDFOR
	data=fltarr(max(dimensions[0,*]),max(dimensions[1,*]),framenum)
	raw=fltarr(max(dimensions[0,*]),max(dimensions[1,*]),n_elements(f_names))
	rawimages=fltarr(max(dimensions[0,*]),max(dimensions[1,*]),n_elements(f_names))
	raw_images_noshift=rawimages
	data[*,*,*]=0
	raw[*]=0

	frame_onset=0
	FOR i=0,n_elements(f_names)-1 DO BEGIN
		;/// FOR data
		a=*staple_ptrs[i]
		temp=float(*raw_ptrs[i])
		;temp=bytscl(3*median(temp,3))
		temp=bytscl(2*temp-smooth(temp,3))
		raw_images_noshift[*,*,i]=temp

		ArrayDims=size(A)
		data[0:dimensions[0,i]-1,0:dimensions[1,i]-1,frame_onset:frame_onset+ArrayDims[3]-1]=a
		frame_onset=frame_onset+ArrayDims[3]
		ptr_free,staple_ptrs[i]

		;//// For temp
		a=*raw_ptrs[i]
		ArrayDims=SIZE(A)

		a=a[1:ArrayDims[1]-2,1:ArrayDims[2]-2]
		ArrayDims=SIZE(A)

		raw[1:dimensions[0,i]-2,1:dimensions[1,i]-2,i]=a

		ptr_free,raw_ptrs[i]
	ENDFOR;
	rawimages=raw_images_noshift
	sum=0.0
	ref=N_ELEMENTS(f_names)/2
	dims=SIZE(raw)
	totpix=dims[1]*dims[2]
	sum=0.0
	FOR I=0,N_ELEMENTS(f_names)-1 DO BEGIN
		im1=MEAN(float(raw[*,*,I]))
		im2=MEAN(float(raw[*,*,ref]))
		val=totpix*((im1+im2)/2)
		sum=[sum,total(abs(float(raw[*,*,I])-float(raw[*,*,ref])))/val]
	ENDFOR
	sum=sum[1:n_elements(sum)-1]
	diffvals[N_ELEMENTS(f_names)]=total(sum)/N_ELEMENTS(sum)
	ArrayDims=SIZE(data)
	ptr_free,staple_ptrs
	ptr_free,raw_ptrs
	heap_gc,/ptr,/verbose
		;FOR I=0, ArrayDims[3]-1 DO BEGIN
	;	data[*,*,i]=MEDIAN(data[*,*,i],3)
	;ENDFOR

	shift_reference=ref
	shifts_applied_list=intarr(2,ArrayDims[3])
	shifts_applied_list[*,*]=0
	movs_applied_list=shifts_applied_list
	applied_shifts=0
	applied_movs=intarr(N_ELEMENTS(f_names))
	createTree,diffvals

	count=0
	last_shifts.x=0
	last_shifts.y=0
	last_shifts.flag=0

	this_frame.y=0
	this_frame.y=0
	this_frame.flag=0

	result_size=1
	atlas_size=1

	no_one=0
	no_two=2

	refresh
	refreshcorrel,event
	GenerateCTVimages
	refreshscreen
	refresh_measurement
	refreshcoors

	;data=congrid(data,ArrayDims[1]*0.5,ArrayDims[2]*0.5,ArrayDims[3])
	;data=-1*data
ENDIF
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO savecoors_3DRAW
COMMON ALL
COMMON CTVS
tempres=Coordinates[*,*,actualcoordinates]
pos=where(tempres[0,*] NE '-1000')
IF pos[0] NE -1 THEN BEGIN
	tempres=tempres[*,pos]
	coor_num=n_elements(tempres[0,*])
	posname=WHERE(parameters[*].Messungszahl eq actualcoordinates)
	IF posname[0] NE -1 THEN tempname=parameters[pos[0]].Experiment ELSE tempname=fn
	tempname=strsplit(tempname,'.',/EXTRACT)
	tempname=tempname[0]+'.coor'
	filename=DIALOG_PICKFILE(/write,FILTER='*.coor',PATH=sapath,FILE=tempname)
	IF filename NE '' THEN BEGIN
		form=fline([5],['A'])
		openw, unit,filename, /get_lun
		printf,unit, strmid(string(coor_num),2)
		FOR i=0, coor_num-1 DO BEGIN
			printf,FORMAT=form,unit,tempres[*,i]
		ENDFOR;
		free_lun,unit
		sapath=dirname(filename)
	ENDIF
ENDIF

END
;/////////////////////////////////////////////////////////////////////////////////////////////////////

;/////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO saveimages
	COMMON ALL
	COMMON CTVS
	if string(ctvimages[0]) ne 'Empty' then begin
		ArrayDims=SIZE(FancyStack)
		pathname=dialog_pickfile(/Directory,/write)
		if pathname ne '' then begin
			FOR I=0, ArrayDims[3]-1 do begin
				name=''
				messung=string(i)
				name=strcompress(tilllog[i].odor[0]+STRING(FIX(tilllog[i].odor_nr[0])))
				animalname=strsplit(fn,'.',/EXTRACT)
				animalname=animalname[0]
				filename=pathname+strcompress(name+'_'+string(i)+'_'+animalname+'.png',/REMOVE_ALL)
				;filename=strcompress(filename,/REMOVE_ALL)
				r=rebin(FancyStack[*,*,i,0],ArrayDims[1],ArrayDims[2])
				g=rebin(FancyStack[*,*,i,1],ArrayDims[1],ArrayDims[2])
				b=rebin(FancyStack[*,*,i,2],ArrayDims[1],ArrayDims[2])
				;write_tiff,filename,tempframe,PLANARCONFIG=2,red=r,green=g,blue=b
				temp=fltarr(4,ArrayDims[1],ArrayDims[2])
				temp[0,*,*]=rotate(transpose(rebin(FancyStack[*,*,i,0],ArrayDims[1],ArrayDims[2])),3)
				temp[1,*,*]=rotate(transpose(rebin(FancyStack[*,*,i,1],ArrayDims[1],ArrayDims[2])),3)
				temp[2,*,*]=rotate(transpose(rebin(FancyStack[*,*,i,2],ArrayDims[1],ArrayDims[2])),3)
				temp[3,*,*]=255
				write_png,filename,temp
			ENDFOR;
		endif
	endif

end


;////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO LOAD_MOVIE,Movienum
COMMON ALL
COMMON SHOW_MOVIE
COMMON TOGGLES
COMMON WIDGET_IDS

IF MOVIENUM GE 0 AND MOVIENUM LT N_ELEMENTS(Lastframes)-1 THEN BEGIN
	movie_no=Movienum
 	movie_measurement=data[*,*,lastframes[movienum]:lastframes[movienum+1]-1]
 	ArrayDims=SIZE(movie_measurement)
 	IF medianed EQ 1 THEN movie_measurement=ApplyFilter(movie_measurement,'Median')

	IF smoothed EQ 1 THEN movie_measurement=ApplyFilter(movie_measurement,'Convol')

 	widget_control,frame_id, SET_SLIDER_MAX=ArrayDims[3]-1
 	widget_control,frame_id, SET_VALUE=0
 	widget_control,measu_label_id,SET_VALUE=string(Movienum)
 	refresh_measurement
 	presentframe=0
ENDIF
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO GetWaterlist
COMMON CTVS
COMMON ALL
IF string(ctvimages[0]) ne 'Empty' then begin
	ArrayDims=SIZE(ctvimages)
	maxlist=0
	x_low=fix(border*float(ArrayDims[1]-1))
	x_high=(1.0-border)*float(ArrayDims[1]-1)
	y_low=fix(border*float(ArrayDims[2]-1))
	y_high=(1.0-border)*float(ArrayDims[2]-1)

	IF ArrayDims[0] EQ 2 THEN BEGIN
		maxlist=[maxlist,MAX(ctvimages[x_low:x_high,y_low:y_high])]
	ENDIF ELSE BEGIN
		FOR I=0,ArrayDims[3]-1 do begin
			maxlist=[maxlist,MAX(ctvimages[x_low:x_high,y_low:y_high,I])]
		ENDFOR
	ENDELSE
	maxlist=maxlist[1:n_elements(maxlist)-1]
	maxval=max(maxlist)
	tval=maxval*framethreshold/100
	waterlist=where(maxlist ge tval[0])
ENDIF

END
;/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 main display routine
;,added contouy
PRO refreshscreen
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON TOGGLES
COMMON CORRECT_MOV
COMMON WIDGET_IDS
loadct,colortab,/SILENT


tvlct,r,g,b,/GET
IF colortab EQ 39 THEN BEGIN
	r[255]=r[254]   ;;meaning ?
	g[255]=g[254]
	b[255]=b[254]
	tvlct,r,g,b
ENDIF
device,decomposed=1
;;1107 winnum=0
device,get_screen_size=resolution
widget_control,draw_id,get_value=winnum
wset,winnum
IF string(ctvimages[0]) ne 'Empty' then begin
	tempres=coordinates[*,*,0]

	ArrayDims=SIZE(ctvimages)
	;;1107waterlist bug ?? -> replace waterlist by indices of images=measurements i.e. 0,1,2,3,4...
	case ArrayDims[0] of
	2:  begin
	  waterlist=[0]
	end
	3: begin
	   waterlist=lindgen(ArrayDims[3])
	end
	endcase

	IF ArrayDims[0] EQ 2 THEN ArrayDims[3]=1
	;*********** Calculate the bordersize in pixels and add it to temp_stack
	x_low=fix(border*float(ArrayDims[1]-1))
	x_high=(1.0-border)*float(ArrayDims[1]-1)
	y_low=fix(border*float(ArrayDims[2]-1))
	y_high=(1.0-border)*float(ArrayDims[2]-1)
	helpstack=ctvimages
	helpstack[*,*,*]=0
	framestack=helpstack  ;;1107 two copies ! (memory), sense ?
	x2_low=1
	x2_high=ArrayDims[1]-1-1
	y2_low=1
	y2_high=ArrayDims[2]-1-1
	helpstack[x_low:x_high,y_low:y_high,*]=1
	framestack[x2_low:x2_high,y2_low:y2_high,*]=1
	framepos=where(framestack[*,*,0] eq 0)
	helpstack2=ctvimages*helpstack
	temp_stack=ctvimages
	IF string(maskimage[0]) NE 'Empty' THEN BEGIN
		FOR i=0,ArrayDims[3]-1 DO BEGIN
			temp_stack[*,*,i]=temp_stack[*,*,i]*maskimage
		ENDFOR
		mini=MIN(temp_stack)
		pos=where(maskimage eq 0)
		IF pos[0] NE -1 THEN BEGIN
			FOR I=0,ArrayDims[3]-1 DO BEGIN
				a=temp_stack[*,*,i]
				a[pos]=mini
				temp_stack[*,*,i]=a
			ENDFOR
		ENDIF
		temp_stack=bytscl(temp_stack)
	ENDIF

	;
	IF ArrayDims[3] EQ 1 THEN BEGIN
		no_one=0
		no_two=0
	ENDIF
	IF no_one GE ArrayDims[3] THEN no_one=ArrayDims[3]-1
	IF no_two GE ArrayDims[3] THEN no_two=ArrayDims[3]-1
	temp_diff_frame=bytscl(128+0.5*temp_stack[*,*,no_one]-0.5*temp_stack[*,*,no_two])
	if maxflag eq 1 then begin
		IF string(maskimage[0]) EQ 'Empty' THEN BEGIN
			FOR I=0,arrayDims[3]-1 DO BEGIN
				temp_stack[*,*,i]=bytscl(ctvimages[*,*,i])
			ENDFOR
		ENDIF
	endif else begin
		minlist=0
		maxlist=0
		IF string(maskimage[0]) NE 'Empty' THEN helpstack2=temp_stack
		if 0 then begin
		FOR i=0, ArrayDims[3]-1 DO BEGIN
			maxlist=[maxlist,MAX(helpstack2[*,*,i])]
			minlist=[minlist,MIN(helpstack2[*,*,i])];CTVimages[*,*,i])]
		ENDFOR
		maxlist=maxlist[1:n_elements(maxlist)-1]
		minlist=minlist[1:n_elements(minlist)-1]
		;temp_stack=ctvimages
		endif
		FOR i=0, ArrayDims[3]-1 DO BEGIN
			IF string(maskimage[0]) EQ 'Empty' THEN temp_stack[*,*,i]=bytscl(temp_stack[*,*,i],MAX=ctv_highscale,MIN=ctv_lowscale) ELSE BEGIN
				pos=where(maskimage EQ 1)
				IF pos[0] NE -1 THEN BEGIN
					a=temp_stack[*,*,i]
					mini=MIN(a[pos],max=maxi)
					if mini lt ctv_lowscale THEN mini=ctv_lowscale
					if maxi gt ctv_highscale THEN maxi=ctv_highscale
					a=bytscl(a,max=maxi,min=mini)
					pos=where(maskimage EQ 0)
					IF pos[0] NE -1 THEN a[pos]=0
					temp_stack[*,*,i]=a
				ENDIF
			ENDELSE
		ENDFOR
	endelse



	;********

	;***** Give the chosen frames in temp_stack (found in waterlist) a black frame ***********************
	IF waterlist[0] ne -1 then begin
		FOR i=0,n_elements(waterlist)-1 do begin
			if waterlist[i] ge 0 AND waterlist[i] lt ArrayDims[3] then begin
				tempframe=temp_stack[*,*,waterlist[i]]
				if framepos[0] ne -1 then tempframe[framepos]=255
				temp_stack[*,*,waterlist[i]]=tempframe
			endif
		ENDFOR

		tempframe=temp_stack[*,*,0];//////////////////////////////////////////reference]
		if framepos[0] ne -1 then tempframe[framepos]=128
		temp_stack[*,*,0]=tempframe;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;reference]=tempframe
		IF frames_or_measurements EQ 0 THEN BEGIN
			IF shift_reference LT ArrayDims[3]-1 THEN BEGIN
				tempframe=temp_stack[*,*,shift_reference]
				if framepos[0] ne -1 then tempframe[framepos]=128
				temp_stack[*,*,shift_reference]=tempframe
			ENDIF
		ENDIF


	ENDIF
	copy_stack=temp_stack

	;temp_diff_frame=temp_stack[*,*,no_one]-temp_stack[*,*,no_two]

;;1107 here the rawimages are set to temp_stack ( ..->display)
	IF raw_ims EQ 1 AND waterlist[0] NE -1 THEN BEGIN
		temp_stack[*,*,waterlist]=bytscl(rawimages[*,*,waterlist])
	ENDIF


	;********* Draw found coordinates into temp_stack AND the table on the bottom **********************************
;;1107 insert "trace" rectangle into temp_stack and copy_stacj
	FOR j=0, MAX(parameters[*].messungszahl) DO BEGIN
		tempres=coordinates[*,*,j]  ;;1107 coordinates of "trace" rectangle
		pos=where(tempres[0,*] NE '-1000')
		IF pos[0] NE -1 THEN BEGIN
			tempres=tempres[*,pos]
			pos=WHERE(parameters[*].messungszahl EQ j)
			IF pos[0] NE -1 THEN BEGIN
			coor_num=n_elements(tempres[0,*])

				FOR i=0, coor_num-1 do begin
					IF fix(tempres[0,i]) gt 0 AND fix(tempres[0,i]) lt ArrayDims[1] AND fix(tempres[1,i]) gt 0 AND fix(tempres[1,i]) lt ArrayDims[2] then BEGIN
						x_start=fix(tempres[0,i])-condensekernel
						x_end=fix(tempres[0,i])+condensekernel
						y_start=fix(tempres[1,i])-condensekernel
						y_end=fix(tempres[1,i])+condensekernel
						IF x_start LT 0 THEN x_start=0
						IF x_end GT ArrayDims[1]-1 THEN x_end=ArrayDims[1]-1
						IF y_start LT 0 THEN y_start=0
						IF y_end GT ArrayDims[2]-1 THEN y_end=ArrayDims[2]-1
						temp_stack[x_start:x_end,y_start:y_end,pos]=0
						copy_stack[x_start:x_end,y_start:y_end,pos]=0
						IF j EQ actualcoordinates THEN temp_diff_frame[x_start:x_end,y_start:y_end]=0
					ENDIF

				endfor;
			ENDIF
		ENDIF
	ENDFOR


	if waterlist[0] NE -1 THEN overlayframes=copy_stack[*,*,waterlist]

	;******** Draw temp_stack on a black background array of screensize and then on the screen

	ncols=resolution[0]/(ArrayDims[1]*resize)
	nrows=(ArrayDims[3]/ncols)+1
	xval=ncols*ArrayDims[1]*resize
	yval=nrows*ArrayDims[2]*resize
	widget_control,draw_id,draw_xsize=(xval),draw_ysize=(yval)
	temp_black=bytarr(xval,yval,3)
	temp_black[*,*,*]=0

	temp=rebin(temp_stack,resize*ArrayDims[1],resize*ArrayDims[2],ArrayDims[3],/SAMPLE)
	IF waterlist[0] NE -1 THEN BEGIN
		overlaydims=SIZE(overlayframes)
		overlayframes=rebin(overlayframes,resize*ArrayDims[1],resize*ArrayDims[2],overlaydims[3],/SAMPLE)
	ENDIF
	temp_stack=fltarr(resize*ArrayDims[1],resize*ArrayDims[2],ArrayDims[3],3)

	temp_stack[*,*,*,0]=r[temp] ;;temp: false color diff. images
	temp_stack[*,*,*,1]=g[temp]
	temp_stack[*,*,*,2]=b[temp]
	overlay=1
	IF raw_ims EQ 1 AND waterlist[0] NE -1 THEN BEGIN
		temp_stack[*,*,waterlist,0]=temp[*,*,waterlist]
		temp_stack[*,*,waterlist,1]=temp[*,*,waterlist]
		temp_stack[*,*,waterlist,2]=temp[*,*,waterlist]
		IF Overlay EQ 1 THEN BEGIN
			FOR i=0,n_elements(waterlist)-1 DO BEGIN
				otemp=overlayframes[*,*,i]
				pos=where(otemp GT Threshold)
				temp=temp_stack[*,*,waterlist[i],0]
				IF pos[0] NE -1 THEN temp[pos]=otemp[pos]
				temp_red=temp
				temp_green=temp
				temp_blue=temp
				IF pos[0] NE -1 THEN BEGIN
					temp_red[pos]=r[temp[pos]]
					temp_green[pos]=g[temp[pos]]
					temp_blue[pos]=b[temp[pos]]
				ENDIF
				temp_stack[*,*,waterlist[i],0]=temp_red
				temp_stack[*,*,waterlist[i],1]=temp_green
				temp_stack[*,*,waterlist[i],2]=temp_blue
			ENDFOR
		ENDIF

	ENDIF



	FOR j=0,ArrayDims[3]-1 DO BEGIN
		i=showsequence[j]
		x_start=(J MOD ncols)*resize*ArrayDims[1]
		x_end=x_start+resize*ArrayDims[1]
		y_start=(J/ncols)*resize*ArrayDims[2]
		y_end=y_start+resize*ArrayDims[2]
		;;temp_blak current screen
		temp_black[x_start:x_end-1,y_start:y_end-1,*]=temp_stack[*,*,i,*]
	ENDFOR;
	;;1107 this draws the current image
	FancyStack=temp_stack ;;1107 Fancystack used to save images
	TV,temp_black,true=3 ;;1107 all false colors + raw images + rectangles



;;1107 add contour plots !
;	FOR j=0,ArrayDims[3]-1 DO BEGIN
;		i=showsequence[j]
;		x_start=(J MOD ncols)*resize*ArrayDims[1]
;		x_end=x_start+resize*ArrayDims[1]
;		y_start=(J/ncols)*resize*ArrayDims[2]
;		y_end=y_start+resize*ArrayDims[2]
;		;;temp_blak current screen
;		cont_position = fltarr(4)
;		cont_position[0:1] = (CONVERT_COORD(x_start, (size(temp_black))[2]-y_end, /device, /to_normal))[0:1]
;	  cont_position[2:3] = (CONVERT_COORD(x_end, (size(temp_black))[2]-y_start, /device, /to_normal))[0:1]
;    ;;calculate two levels
;    ;factormedium= 0.25	  ;;40%
;    factorhigh= 0.5
;;	  levels = [ factormedium*max(ctvImages),  factorhigh*max(ctvImages) ] ;; max over all ctvimages
;	 ; levels = [ factormedium*max(ctvImages[*,*,i]),  factorhigh*max(ctvImages[*,*,i]) ] ;;max of current ctvimage
;	  levels = factorhigh*max(ctvImages[*,*,i])  ;;max of current ctvimage
;	        ;;origanl data: levels = [0.4*max(data[*,*,i])]
;		contour, reverse( ctvImages[*,*,i], 2), level= levels, $
;		;;origanl data: contour, reverse( data[*,*,i], 2), level= levels, $
;		    position = cont_position, $
;		    xstyle=4+1, ystyle=4+1, $
;		    /noerase, c_thick=[1,2], $
;		    c_color=[0,0]
;	ENDFOR;

FOR j=0,ArrayDims[3]-1 DO BEGIN
        i=showsequence[j]
        x_start=(J MOD ncols)*resize*ArrayDims[1]
        x_end=x_start+resize*ArrayDims[1]
        y_start=(J/ncols)*resize*ArrayDims[2]
        y_end=y_start+resize*ArrayDims[2]
       cont_position = fltarr(4)
        cont_position[0:1] = (CONVERT_COORD(x_start, (size(temp_black))[2]-y_end, /device, /to_normal))[0:1]
      cont_position[2:3] = (CONVERT_COORD(x_end, (size(temp_black))[2]-y_start, /device, /to_normal))[0:1]
    ;;calculate two levels
    factormedium= 0.25
    factorhigh= 0.5
;      levels = [ factormedium*max(ctvImages),  factorhigh*max(ctvImages) ] ;; max over all ctvimages
       levels = [ factormedium*max(ctvImages[*,*,i]),  factorhigh*max(ctvImages[*,*,i]) ] ;;max of current ctvimage
       contour, reverse( ctvImages[*,*,i], 2), level= levels, $
            position = cont_position, $
            xstyle=4+1, ystyle=4+1, $
            /noerase, c_thick=[1,2], $
            c_color=[0,0]
    ENDFOR;
	;////////////////////////////////////////////////////////////////////////////////////////////////////////////
	; NOW comes the legend
	;//////////////////////////////////////////////////////////////////////////////////////////////////
	IF show_name GT 0 THEN BEGIN
		FOR j=0,ArrayDims[3]-1 DO BEGIN
			i=showsequence[j]
			tempres=coordinates[*,*,parameters[i].messungszahl]
			pos=where(tempres[0,*] NE '-1000')
			IF pos[0] NE -1 THEN BEGIN
				tempres=tempres[*,pos]
				coor_num=n_elements(tempres[0,*])
				x_start=(J MOD ncols)*resize*ArrayDims[1]
				y_start=(J/ncols)*resize*ArrayDims[2]

					FOR i=0,coor_num-1 DO BEGIN
						x=fix(tempres[0,i])*resize+x_start
						y=yval-(fix(tempres[1,i])*resize+y_start)
						name=string(tempres[2,i])
						xyouts,x,y,name,/DEVICE,font=1,charsize=1.2,color=255,ALIGNMENT=0.7
					ENDFOR
			ENDIF
		ENDFOR;
	ENDIF
  ;;legend, annotations
	FOR j=0,ArrayDims[3]-1 DO BEGIN
		i=showsequence[j]
		x=(J MOD ncols)*(ArrayDims[1]*resize) +(8*resize)
		y=yval-(ArrayDims[2]*resize)*((J/ncols)+1)+4*resize
		xyouts,x,y,odorlist[i],/DEVICE,font=1,charsize=1.2,color=254
		xold=x
		yold=y
		x=x+((ArrayDims[1]*resize)*0.7)
		xyouts,x,y,messungslist[i],/DEVICE,font=1,charsize=1.2,color=254
		y=yval-(ArrayDims[2]*resize)*((J/ncols)+1)+(ArrayDims[2]*resize-8*resize)
		xyouts,xold,y,experiments_visible[i],/DEVICE,font=1,charsize=1.2,color=254
		xyouts,x,y,parameters[i].messungszahl,/DEVICE,font=1,charsize=1.2,color=254
	ENDFOR
	;************************************************************************************
		;;1107 differential tab
	widget_control,diff_id,draw_xsize=ArrayDims[1]*resize,draw_ysize=ArrayDims[2]*resize
	widget_control,diff_id,get_value=winnum1
	wset,winnum1
	temp_diff_frame=rebin(temp_diff_frame,ArrayDims[1]*resize,ArrayDims[2]*resize,/SAMPLE)
	device,decomposed=0
	tvscl,temp_diff_frame ;;1107 differential tab
	IF show_name GT 0 THEN BEGIN
		tempres=coordinates[*,*,actualcoordinates]
		pos=where(tempres[0,*] NE '-1000')
		IF pos[0] NE -1 THEN BEGIN
			FOR i=0,n_elements(tempres[2,*])-1 DO BEGIN
				x=fix(tempres[0,i])*resize
				y=(ArrayDims[2]*resize)-fix(tempres[1,i])*resize
				name=tempres[2,i]
				xyouts,x,y,name,/DEVICE,font=1,charsize=1.2,color=255,ALIGNMENT=0.7

			endfor
		ENDIF
	endif

ENDIF ELSE BEGIN
	temp_black=bytarr(resolution[0],resolution[1],3)
	temp_black[*]=0
	tv,temp_black
	widget_control,diff_id,get_value=winnum1
	wset,winnum1
	device,decomposed=0
	temp_diff_frame=bytarr(300,200)
	temp_diff_frame[*]=0
	tvscl,temp_diff_frame

ENDELSE
;print,show_name
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO refresh_measurement
COMMON ALL
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON CTVS
loadct,0,/SILENT

IF string(movie_measurement[0]) ne 'Empty' THEN BEGIN
	result=coordinates[*,*,parameters[movie_no].messungszahl]
	device,decomposed=0
	loadct,colortab,/SILENT
	ArrayDims=SIZE(movie_measurement)
	widget_control,measu_id,draw_xsize=ArrayDims[1]*resize,draw_ysize=ArrayDims[2]*resize
	widget_control,measu_id,get_value=winnum2
	wset,winnum2
	measu_temp=rebin(movie_measurement[*,*,presentframe],ArrayDims[1]*resize,ArrayDims[2]*resize)

	IF  string(result[0]) ne '-1000' AND show_dots EQ 1 then begin
		step=resize/2
		FOR i=0,n_elements(result[2,*])-1 DO BEGIN
			x=fix(result[0,i])*resize
			y=fix(result[1,i])*resize
			IF x GE 0 AND x LT ArrayDims[1]*resize AND y GE 0 AND y LT ArrayDims[2]*resize THEN BEGIN
				x_start=x-step
				if x_start lt 0 then x_start=0
				x_end=x+step
				if x_end gt (ArrayDims[1]-1)*resize then x_end=(ArrayDims[1]-1)*resize
				y_start=y-step
				if y_start lt 0 then y_start=0
				y_end=y+step
				if y_end gt (ArrayDims[2]-1)*resize then y_end=(ArrayDims[2]-1)*resize
				measu_temp[x_start:x_end,y_start:y_end]=0
			ENDIF
		ENDFOR
	ENDIF

	IF string(maskimage[0]) NE 'Empty' THEN BEGIN
		FOR i=0,ArrayDims[3]-1 DO BEGIN
			movie_measurement[*,*,i]=movie_measurement[*,*,i]*maskimage
		ENDFOR
		mini=MIN(movie_measurement)
		pos=where(maskimage eq 0)
		IF pos[0] NE -1 THEN BEGIN
			FOR I=0,ArrayDims[3]-1 DO BEGIN
				a=movie_measurement[*,*,i]
				a[pos]=mini
				movie_measurement[*,*,i]=a
			ENDFOR
		ENDIF
		movie_measurement=bytscl(movie_measurement)
	ENDIF ELSE BEGIN
		x_low=fix(border*float(ArrayDims[1]-1))
		x_high=(1.0-border)*float(ArrayDims[1]-1)
		y_low=fix(border*float(ArrayDims[2]-1))
		y_high=(1.0-border)*float(ArrayDims[2]-1)
		helpstack=movie_measurement
		helpstack[*]=0
		helpstack[x_low:x_high,y_low:y_high,*]=1
		temp=helpstack*movie_measurement
		mini=MIN(temp,MAX=maxi)
		movie_measurement=bytscl(movie_measurement,MIN=mini,MAX=maxi)
	ENDELSE


	tv,measu_temp
	if show_name gt 0 AND  string(result[0]) ne '-1000' then begin
		for i=0,n_elements(result[2,*])-1 do begin
			x=fix(result[0,i])*resize
			y=(ArrayDims[2]*resize)-fix(result[1,i])*resize
			name=string(result[2,i])
			xyouts,x,y,name,/DEVICE,font=1,charsize=1.2,color=0,ALIGNMENT=0.7
		endfor
	endif
ENDIF
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

FUNCTION condense,array,kernelsize, flag
; This functions takes the result of test_watersehd as input (e.g. a 4 column string_array containing X_pos,Y_pos,odor_name and odor concentration)
; It looks for nearby peaks (not further than kernelsize apart) and fuses them into one. The result is an array with the same number of columns but less rows. If flag is not set condense
; also adds the concentration value to the odorname
if flag eq 1 then kernelsize=4
x_arr=fix(array[0,*])
y_arr=fix(array[1,*])

odor_arr=array[2,*]
if flag eq 0 then begin
	conc_arr=fix(array[3,*])
	intensity_arr=fix(array[4,*])
endif

x_res=[0]
y_res=[0]
odor_res=["None"]
conc_res=[0]
counter=1
num=0

; take the first entry of the x and y lists and look for similar entries in the same lists. Rows with the same x and y
; values are marked for later deletion
while counter gt 0 do begin
	temp_x=x_arr[0]
	temp_y=y_arr[0]
	x_positions=where(x_arr ge temp_x-kernelsize AND x_arr le temp_x+kernelsize)
	delrows=[0]
	for i=0, n_elements(x_positions)-1 do begin
		if y_arr[x_positions[i]] ge temp_y-kernelsize AND y_arr[x_positions[i]] le temp_y+kernelsize then delrows=[delrows,x_positions[i]]
	endfor;

	delrows=delrows[1:n_elements(delrows)-1]
	x=0
	y=0
	odor=" "
;****************************************************************
; Get the mean position of the nearby peaks, disabled now

	for i=0, n_elements(delrows)-1 do begin
		x=x+x_arr[delrows[i]]
		y=y+y_arr[delrows[i]]
		if flag eq 0 then begin
			temp_odor=odor_arr[delrows[i]]+string(conc_arr[delrows[i]])
		endif else begin
			temp_odor=odor_arr[delrows[i]]
		endelse
		if strpos(odor,temp_odor) eq -1 then odor=odor+temp_odor
	endfor;
	x=x/n_elements(delrows)
	y=y/n_elements(delrows)

;**************************
; Here we overwrite the x and y (choosing the maximum intensity-position instead of the mean peak positions)
; Standard way
	if flag eq 0 then begin
		pos=where(intensity_arr[delrows] eq MAX( intensity_arr[delrows]))
		x=x_arr[delrows[pos[0]]]
		y=y_arr[delrows[pos[0]]]
	endif;

;****************************


	x_res=[x_res,x]
	y_res=[y_res,y]
	odor_res=[odor_res,strcompress(odor)]
	multi_arr=replicate(1L,n_elements(x_arr))
	multi_arr[delrows]=0L
	keeprows=where(multi_arr eq 1)
	if keeprows[0] eq -1 then begin
		counter =0
	endif else begin
		x_arr=x_arr[keeprows]
		y_arr=y_arr[keeprows]
		odor_arr=odor_arr[keeprows]
	endelse
;print,num
num=num+1
endwhile;
x_res=x_res[1:n_elements(x_res)-1]
y_res=y_res[1:n_elements(y_res)-1]
odor_res=odor_res[1:n_elements(odor_res)-1]

result=strarr(4,n_elements(x_res))
result[0,*]=string(x_res)
result[1,*]=string(y_res)
result[2,*]=indgen(n_elements(x_res))
result[3,*]=odor_res
print,'Done Condense'
return, result
end;


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////

FUNCTION waterpeaks,CTVimage,framenum
COMMON ALL
COMMON CTVS

COMMON CORRECT_MOV
COMMON WIDGET_IDS
loginfo=tilllog[framenum]
image=bytscl(CTVimage)
ArrayDims=SIZE(image)
tot_num=ArrayDims[1]*ArrayDims[2]
int_pix=tot_num/100.0*threshold
temp_hist=histogram(image,binsize=1)
integral=0
i=n_elements(temp_hist)-1
while integral lt int_pix do begin
	integral=integral+temp_hist[i]
	i=i-1
endwhile;
waterlimit=i
filtered_frame=fltarr(ArrayDims[1],ArrayDims[2])
filtered_frame=image
;; Waterline is at MAX
waterlevel=MAX(filtered_frame)
oldframe=filtered_frame
oldframe[*,*]=0
labelled_frame=intarr(ArrayDims[1],ArrayDims[2])
peaklist=0
new_land=0
peakheight=0
end_peaklist=0
while waterlevel gt waterlimit do begin
	land=where(filtered_frame gt waterlevel,count)
	if n_elements(land) gt 0 then begin
		for k=0, n_elements(land)-1 do begin
			temp=land[k]
			x_pos=temp MOD ArrayDims[1]
			y_pos=temp / ArrayDims[1]
			if NOT (x_pos eq 0 OR y_pos eq 0 OR x_pos eq ArrayDims[1]-1 OR y_pos eq Arraydims[2]-1) then new_land=[new_land,temp]
		endfor;
	endif;
	if n_elements(new_land) gt 1 then begin
		land=new_land[1:n_elements(new_land)-1]
		count=n_elements(land)
	endif else count=0

	if count gt 0 then begin
		labelled_frame[*,*]=0
		labelled_frame[land]=255
		labelled_frame=LABEL_REGION(labelled_frame)
		isles=labelled_frame[uniq(labelled_frame,SORT(labelled_frame))]
		if isles[0] eq 0 then isles=isles[1:n_elements(isles)-1]
		for j=0,n_elements(isles)-1 do begin
			patch=where(labelled_frame eq isles[j])
			oldframe_values_at_pos=oldframe[patch]
			blobs=oldframe_values_at_pos[uniq(oldframe_values_at_pos,SORT(oldframe_values_at_pos))]
			num_blobs=n_elements(blobs)
			if num_blobs eq 1 AND blobs[0] eq 0 then begin
				;; New peak
				newpeak=MEDIAN(patch)
				peaklist=[peaklist,newpeak]
				peakheight=[peakheight,waterlevel]
			endif;
		endfor;
	endif;
	waterlevel=waterlevel-1
	oldframe=labelled_frame
	if not n_elements(peaklist) eq 1 then begin
		tempframe=intarr(ArrayDims[1],ArrayDims[2])
		temp_frame=image
		temp_frame[peaklist[1:n_elements(peaklist-1)]]=0
	endif;

endwhile;
x_list=0
y_list=0
int_list=0
IF N_ELEMENTS(peaklist) GT 1 THEN peaklist=peaklist[1:n_elements(peaklist)-1]
x_low=(arrayDims[1]/100.0)*5
x_high=(arrayDims[1]/100.0)*95
y_low=(arrayDims[2]/100.0)*5
y_high=(arrayDims[2]/100.0)*95
for i=0,n_elements(peaklist)-1 do begin
	temp=fix(peaklist[i])
	x_pos=temp MOD(ArrayDims[1])
	y_pos=temp/ArrayDims[1]
	if(x_pos gt x_low AND x_pos lt x_high AND y_pos gt y_low AND y_pos lt y_high) then begin
		end_peaklist=[end_peaklist,temp]
		x_list=[x_list,x_pos]
		y_list=[y_list,y_pos]
		int_list=[int_list,peakheight[i]]
	endif;
endfor;
x_list=x_list[1:n_elements(x_list)-1]
y_list=y_list[1:n_elements(y_list)-1]
int_list=int_list[1:n_elements(int_list)-1]
result=strarr(5,n_elements(x_list))
result[0,*]=string(x_list)
result[1,*]=string(y_list)
result[2,*]=loginfo.odor[0]
result[3,*]=string(loginfo.odor_nr[0])
result[4,*]=string(int_list)

RETURN, result
END;FUNCTION

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 not used ?
PRO getpeaks
COMMON ALL
COMMON CTVS
ArrayDims=SIZE(ctvimages)
x_arr=0
y_arr=0
odor_arr=''
x_low=fix(border*float(ArrayDims[1]-1))
x_high=(1.0-border)*float(ArrayDims[1]-1)
y_low=fix(border*float(ArrayDims[2]-1))
y_high=(1.0-border)*float(ArrayDims[2]-1)
helpstack=ctvimages
helpstack[*,*,*]=0
helpstack[x_low:x_high,y_low:y_high,*]=1
temp_stack=ctvimages*helpstack
maxval=MAX(temp_stack,MIN=minval)
temp_stack=bytscl(ctvimages,MAX=maxval,MIN=minval)

FOR i=0,n_elements(waterlist)-1 DO BEGIN
	 result=waterpeaks(temp_stack[*,*,waterlist[i]],waterlist[i])
	 result=condense(result,condensekernel,0)
	 x_temp_arr=reform(result[0,*],n_elements(result[0,*]))
	 y_temp_arr=reform(result[1,*],n_elements(result[1,*]))
	 x_arr=[x_arr,x_temp_arr]
	 y_arr=[y_arr,y_temp_arr]
	 odor_temp_arr=reform(string(result[3,*]))
	 odor_arr=[odor_arr,odor_temp_arr]
ENDFOR;
x_arr=x_arr[1:n_elements(x_arr)-1]
y_arr=y_arr[1:n_elements(y_arr)-1]
odor_arr=odor_arr[1:n_elements(odor_arr)-1]
temp_arr=strarr(3,n_elements(x_arr))
temp_arr[0,*]=x_arr
temp_arr[1,*]=y_arr
temp_arr[2,*]=odor_arr
result=condense(temp_arr,condensekernel,1)


END


PRO GetFiles_EVENT,event
COMMON GetLogFiles
widget_control,event.id,GET_UVALUE=widget
print,widget

END



PRO GetCoors_event,event
;main event handler
COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
COMMON GetLogFiles
COMMON Window_IDS

	widget_control,event.id,get_uvalue=widget

	IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN DestroyWindow,"GetCoordinates" ELSE BEGIN


		if (widget eq 'resize_3DRAW') then begin
			widget_control,event.id,get_value=temp
			if temp[0] gt 9 OR temp[0] le 0.5 then begin
				widget_control,event.id,set_value='2'
			endif else resize=temp[0]
			refreshscreen
			IF Correlate_ID NE 0 THEN refreshcorrel,event
		endif

		if (widget eq 'rebin_3DRAW') then begin
			widget_control,event.id,get_value=temp
			if temp[0] gt 9 OR temp[0] le 0.1 then begin
				widget_control,event.id,set_value='1'
			endif else rebinfactor=temp[0]
		endif

		IF (widget eq 'lastframe_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_lastframe=temp

		ENDIF
		IF (widget EQ 'firstframe_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_firstframe=temp

		ENDIF

		IF (widget EQ 'invert_3DRAW') THEN BEGIN
			data=-1*data
			ctvimages_raw=-1*ctvimages_raw
			ctvimages=-1*ctvimages
			refreshscreen
			IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
		ENDIF


		if (widget eq 'table_3DRAW') then begin ;AND string(result[0]) ne '-1000' then begin
			if event.X eq 2 then begin
				widget_control,event.id,USE_TABLE_SELECT=[event.X,event.Y,event.X,event.Y],GET_VALUE=value

				Coordinates[2,event.Y,actualcoordinates]=strtrim(string(value),2)
				refreshscreen
				refreshtable
				IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,-1
				IF Correlate_ID NE 0 THEN refreshcorrel,event
			endif
		endif

		IF (widget EQ 'ChangeCoordinateSet') THEN BEGIN
			widget_control,event.id,get_value=temp
			IF temp[0] GT MAX(parameters[*].messungszahl) OR temp[0] LT 0 THEN BEGIN
				widget_control,event.id,set_value='0'
				actualcoordinates=0
			endif else actualcoordinates=fix(temp)
			refreshtable
			IF Correlate_ID NE 0 THEN refreshcorrel,event

		ENDIF

		if (widget eq 'border_3DRAW') then begin
			widget_control,event.id,get_value=temp
			if temp[0] gt 0.5 OR temp[0] lt 0 then begin
				widget_control,event.id,set_value='0.0000'
			endif else border=temp[0]
			refreshscreen
		endif
		if (widget eq 'framethreshold_3DRAW') then begin
			widget_control,event.id,get_value=temp
			if temp[0] gt 100 OR temp[0] lt 0 then begin
				widget_control,event.id,set_value='90'
			endif else framethreshold=temp[0]
			getwaterlist
			refreshscreen
		endif;

;;1107 new threshold
		if (widget eq 'text1_3DRAW') then begin
			widget_control,event.id,get_value=temp
			threshold=fix(temp[0])
			IF threshold GT 254 THEN BEGIN
				threshold=254
				widget_control,event.id,set_value='254'
			ENDIF

			IF threshold LT 0 THEN BEGIN
				threshold=0
				widget_control,event.id,set_value='0'
			ENDIF
			refreshscreen
		endif

		if (widget eq 'text2_3DRAW') then begin
			widget_control,event.id,get_value=temp
			condensekernel=temp[0]
			refreshscreen
		endif
		if (widget eq 'start_3DRAW') then begin
			if waterlist[0] ne -1 then	getpeaks
			refreshscreen
			IF Correlate_ID NE 0 THEN refreshcorrel,event
		endif
		if (widget eq 'maxframe_3DRAW') then begin
			maxflag=-1*maxflag
			refreshscreen
		endif

		if (widget eq 'rawdata_3DRAW') then begin
			raw_ims=-1*raw_ims
			refreshscreen
		endif

		if (widget eq 'sort_3DRAW') then begin
			if string(ctvimages[0]) ne 'Empty' then begin
				if string(showsequence[0]) ne 'Empty' AND string(odorlist[0]) ne 'Empty'then begin
					ArrayDims=SIZE(ctvimages)
					sorted=-sorted
					if sorted eq -1 then showsequence=indgen(ArrayDims[3]) else showsequence=sort(odorlist)
					refreshscreen
				endif
			endif
		endif
		if (widget eq 'load_3DRAW') then begin

			loadsig1
		endif
		if (widget eq 'save_3DRAW') then begin
			savecoors_3DRAW
		endif
		if (widget eq 'table_3DRAW') then begin

		endif
		if (widget eq 'draw_3DRAW') then begin
			clickaction_3DRAW,event
		endif
		if (widget eq 'loadPeaks_3DRAW') then begin
			filename=''
			filename=DIALOG_PICKFILE(/read,/MUST_EXIST,FILTER='*.coor',PATH=sapath)
			LoadPeaks,filename,actualcoordinates
			refreshscreen
			refreshtable
			IF Correlate_ID NE 0 THEN refreshcorrel,event
			IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,1
		endif
		if (widget eq 'showNames_3DRAW') then begin
			show_name=-1*show_name
			refreshscreen
			IF Correlate_ID NE 0 THEN refreshcorrel,event
			IF AdaptCoors_ID NE 0 THEN refreshCoors
		endif

		IF (widget EQ 'scalerangelow_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_lowscale=temp
			refreshscreen
		ENDIF

		IF (widget EQ 'scalerangehigh_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_highscale=temp
			refreshscreen
		ENDIF

		IF widget eq 'Smooth_3DRAW' AND string(ctvimages[0]) ne 'Empty' THEN BEGIN
			IF smoothed EQ 1 THEN BEGIN
				ctvimages=ctvimages_raw
				;IF string(shiftlist[0]) NE 'Empty' THEN ctvimages=ShiftImageStaple(ctvimages,shiftlist)
				IF medianed EQ 1 THEN BEGIN
					ctvimages=ApplyFilter(ctvimages,'Median')
				ENDIF
				smoothed=0
			ENDIF ELSE BEGIN
				ctvimages=ApplyFilter(ctvimages,'Convol')
				smoothed=1
			ENDELSE
			ctv_lowscale=min(ctvimages)
			ctv_highscale=max(ctvimages)
			widget_control,scalehigh_id,set_value=string(ctv_highscale)
			widget_control,scalelow_id,set_value=string(ctv_lowscale)
			refreshscreen
		ENDIF

		IF widget EQ 'Median_3DRAW' AND string(ctvimages[0]) NE 'Empty'THEN BEGIN
			IF medianed EQ 1 THEN BEGIN
				ctvimages=ctvimages_raw
				;IF string(shiftlist[0]) NE 'Empty' THEN ctvimages=ShiftImageStaple(ctvimages,shiftlist)
				IF smoothed EQ 1 THEN BEGIN
					ctvimages=ApplyFilter(ctvimages,'Convol')
				ENDIF
				medianed=0
			ENDIF ELSE BEGIN
				ctvimages=ApplyFilter(ctvimages,'Median')
				medianed=1
			ENDELSE
			ctv_lowscale=min(ctvimages)
			ctv_highscale=max(ctvimages)
			widget_control,scalehigh_id,set_value=string(ctv_highscale)
			widget_control,scalelow_id,set_value=string(ctv_lowscale)
			refreshscreen
		ENDIF


		if (widget eq 'saveImages_3DRAW') then begin
			saveimages
		endif

		IF (widget EQ 'ctv_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_method=fix(temp[0])
			refreshscreen
		ENDIF




		IF (widget eq 'lastframe_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_lastframe=temp

		ENDIF
		IF (widget EQ 'firstframe_3DRAW') THEN BEGIN
			widget_control,event.id,get_value=temp
			ctv_firstframe=temp

		ENDIF

		if (widget eq 'GenCTV_3DRAW') then begin
			GenerateCTVimages

			refreshscreen
		endif

		IF widget EQ 'GenRaw_3DRAW' THEN BEGIN
			FOR I=0,N_ELEMENTS(parameters)-1 DO BEGIN
				rawimages[*,*,i]=bytscl(total(rawdata[*,*,lastframes[i]:lastframes[i+1]-1],3))
			ENDFOR
			refreshscreen
		ENDIF

		;////////////////////////// Here comes the movie stuff !!!!!!

		IF (widget EQ 'Frame') THEN BEGIN
			IF string(movie_measurement[0]) NE 'Empty' THEN BEGIN
				presentframe=event.value
				refresh_measurement
			ENDIF
		ENDIF

		IF widget EQ 'colortable_3DRAW' THEN BEGIN
			widget_control,event.id,get_value=temp
			IF fix(temp) LT 0 OR fix(temp) GT 39 THEN BEGIN
				widget_control,event.id,set_value='39'
				colortab=39
			ENDIF ELSE colortab=fix(temp)
			refreshscreen
		ENDIF

		IF (widget EQ 'show_measu') THEN BEGIN
			IF SHOW_DOTS EQ 0 THEN SHOW_DOTS=1 ELSE SHOW_DOTS=0
			refresh_measurement
		ENDIF

		IF (widget EQ 'play_measu') THEN BEGIN
			IF string(movie_measurement[0]) NE 'Empty' THEN BEGIN
				arrayDims=SIZE(movie_measurement)
				temp=presentframe

				FOR i=0,ArrayDims[3]-1 DO BEGIN
					presentframe=i
					widget_control,frame_id,SET_VALUE=present_frame
					refresh_measurement
					FOR J=0L,200000 DO a=0
				ENDFOR
				presentframe=temp
				widget_control,frame_id,SET_VALUE=present_frame
			ENDIF

		ENDIF

		IF (widget EQ 'deletePeaks_3DRAW') THEN BEGIN
			Coordinates[*,*,actualCoordinates]='-1000'
			IF Traces_ID NE 0 THEN refreshtraces,-1,-1,-1,0
			IF AdaptCoors_ID NE 0 THEN refreshcoors
			refreshscreen
			refreshtable
			IF Correlate_ID NE 0 THEN refreshcorrel
		ENDIF


		IF (widget eq 'draw_measu') THEN BEGIN
			refreshflag=0
			IF string(movie_measurement[0]) NE 'Empty' THEN BEGIN
				ArrayDims=SIZE(movie_measurement)
				x_pos=event.X/resize
				y_pos=ArrayDims[2]-(event.Y/resize)
				IF event.release EQ 4 AND string(result[0]) ne '-1000' THEN BEGIN
					pos=where(result[0,*] LT x_pos+condensekernel AND result[0,*] GT x_pos-condensekernel AND result[1,*] LT y_pos+condensekernel AND result[1,*] GT y_pos-condensekernel)
					IF pos[0] NE -1 THEN BEGIN
						IF n_elements(result[0,*]) EQ 1 THEN BEGIN
							result[*]=-1000
						ENDIF ELSE BEGIN
							temp=result
							temp[*,*]=1
							temp[*,pos]=0
							pos=where(temp[0,*] EQ 1)
							result=result[*,pos]
						ENDELSE
					ENDIF
				refreshflag=1
				ENDIF
				IF event.release EQ 1 THEN BEGIN
					IF string(result[0]) NE '-1000' THEN BEGIN
						glom=MAX(fix(result[2,*]))+1
						pos=where(result[0,*] LT x_pos+condensekernel AND result[0,*] GT x_pos-condensekernel AND result[1,*] LT y_pos+condensekernel AND result[1,*] GT y_pos-condensekernel)
						IF pos[0] EQ -1 THEN BEGIN
							odor='Movie-'+string(movie_no)
							x_positions=reform(result[0,*])
							y_positions=reform(result[1,*])
							glomPositions=reform(result[2,*])

							odorPositions=reform(result[3,*])
							x_positions=[x_positions,x_pos]
							y_positions=[y_positions,y_pos]

							glomPositions=[glomPositions,glom]
							odorPositions=[odorPositions,odor]
							result=strarr(4,n_elements(x_positions))
							result[0,*]=string(x_positions)
							result[1,*]=string(y_positions)
							result[2,*]=string(glompositions)
							result[3,*]=string(odorPositions)
						ENDIF
					ENDIF ELSE BEGIN
						glom=0
						odor='Movie-'+string(movie_no)
						result=[string(x_pos),string(y_pos),string(glom),string(odor)]
					ENDELSE
					refreshflag=1
				ENDIF
			ENDIF
			if refreshflag eq 1 then begin
				IF Correlate_ID NE 0 THEN refreshcorrel,event
				refreshscreen
				refresh_measurement
				IF AdaptCoors_ID NE 0 THEN refreshcoors
			ENDIF
		END

ENDELSE
;//////////////////////////////////////////////////////////////
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////


PRO GetCoors,parambase

COMMON ALL
COMMON CTVS
COMMON TOGGLES
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON SHOW_MOVIE
Common GetLogFiles
COMMON EditParams
COMMON window_ids

; Tree Widget has to be set in the beginning for Emptyvars to work


;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////   CTV Widget (Main widget) ////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////


base=widget_base(col=1,title="GetCoors",GROUP_LEADER=parambase,/TLB_KILL_REQUEST_EVENTS)


iconbase=widget_base(base,row=1,/frame)
subdir='\bitmaps\'
file=working_dir+subdir+'open.bmp'
load_3DRAW=widget_button(iconbase,value=file,uvalue='load_3DRAW',/bitmap,TOOLTIP='Load dataset')

;button_MedianData=widget_button(iconbase,value='Median_Data',uvalue='MedianData_3DRAW')
;button_SmoothData=widget_button(iconbase,value='USMaks_Data',uvalue='USMaskData_3DRAW')
resizelabel_3DRAW=widget_label(iconbase,value='resize')
resizetext_3DRAW=widget_text(iconbase,value=string(resize),uvalue='resize_3DRAW',/editable,xsize=5)
rebinlabel_3DRAW=widget_label(iconbase,value='rebin')
rebintext_3DRAW=widget_text(iconbase,value=string(rebinfactor),uvalue='rebin_3DRAW',/editable,xsize=5)
file=working_dir+subdir+'invert.bmp'
button_Invert=widget_button(iconbase,value=file,uvalue='invert_3DRAW',/BITMAP,TOOLTIP='invert')
borderlabel_3DRAW=widget_label(iconbase,value='Bordersize')
bordertext_3DRAW=widget_text(iconbase,value=string(border),uvalue='border_3DRAW',/editable,xsize=5)
framethresholdlabel_3DRAW=widget_label(iconbase,value='% Max')
framethresholdtext_3DRAW=widget_text(iconbase,value=string(framethreshold),uvalue='framethreshold_3DRAW',/editable,xsize=5)
;setuplabel_3DRAW=widget_label(iconbase,value='Setup (new =0)')
;setuptext_3DRAW=widget_text(iconbase,value=string(setup),uvalue='setup_3DRAW',/editable,xsize=7)
filelabel_3DRAW=widget_label(iconbase,uvalue='name_3DRAW',value='',xsize=100)

button2_3DRAW=widget_button(iconbase,value='Max',uvalue='maxframe_3DRAW',TOOLTIP='Scale individual measurements')
button3_3DRAW=widget_button(iconbase,value='Raw',uvalue='rawdata_3DRAW',TOOLTIP='Show raw images')
label1_3DRAW=widget_label(iconbase,value='Threshold')
text1_3DRAW=widget_text(iconbase,/editable,uvalue='text1_3DRAW',value=string(threshold),xsize=5)

button4_3DRAW=widget_button(iconbase,value='Sort',uvalue='sort_3DRAW',TOOLTIP='Sort measurements alphabetically')

file=working_dir+subdir+'medianctv.bmp'
button_Median=widget_button(iconbase,value=file,uvalue='Median_3DRAW',/BITMAP,TOOLTIP='Median filter CTVs')
file=working_dir+subdir+'smoothctv.bmp'
button_Smooth=widget_button(iconbase,value=file,uvalue='Smooth_3DRAW',/BITMAP,TOOLTIP='Smooth CTVs')

file=working_dir+subdir+'saveimages.bmp'
button_SaveImages=widget_button(iconbase,value=file,uvalue='saveImages_3DRAW',/BITMAP,TOOLTIP='Save CTV images')

CTVlabel_3DRAW=widget_label(iconbase,value='CTV')
CTVtext_3DRAW=widget_text(iconbase,value=string(ctv_method),uvalue='ctv_3DRAW',/editable,xsize=5)
ctv_firstframe_label=widget_label(iconbase,value='firstframe')
ctv_firstframe_3DRAW=widget_text(iconbase,value=string(ctv_firstframe),uvalue='firstframe_3DRAW',/editable,xsize=5)
ctv_lastframe_label=widget_label(iconbase,value='lastframe')
ctv_lastframe_3DRAW=widget_text(iconbase,value=string(ctv_lastframe),uvalue='lastframe_3DRAW',/editable,xsize=5)
ctv_Scalerange_low_label=widget_label(iconbase,value='Scale from')
ctv_scalerange_low_3DRAW=widget_text(iconbase,value=string(ctv_lowscale),uvalue='scalerangelow_3DRAW',/editable,xsize=5)
ctv_scalerange_high_label=widget_label(iconbase,value='to')
ctv_scalerange_high_3DRAW=widget_text(iconbase,value=string(ctv_highscale),uvalue='scalerangehigh_3DRAW',/editable,xsize=5)

colortable_label=widget_label(iconbase,value='ColorTable:')
colortable_3DRAW=widget_text(iconbase,value=string(colortab),uvalue='colortable_3DRAW',/editable,xsize=5)

file=working_dir+subdir+'makectvs.bmp'
ctv_generate=widget_button(iconbase,value=file,uvalue='GenCTV_3DRAW',/BITMAP,TOOLTIP='Generate CTVs')
file=working_dir+subdir+'makeraw.bmp'
raw_generate=widget_button(iconbase,value=file,uvalue='GenRaw_3DRAW',/BITMAP,TOOLTIP='Regenerate mean raw images')


temp=resolution[0]/7

draw_3DRAW=widget_draw(base,XSIZE=resolution[0]-10,YSIZE=resolution[1]*0.5,scr_xsize=resolution[0]-10,scr_ysize=resolution[1]*0.5,$
	uvalue='draw_3DRAW',/button_events,/MOTION_EVENTS,/KEYBOARD_EVENTS,RETAIN=1,/SCROLL,TOOLTIP="Mouse is here!")



drawbase=widget_base(base,row=1,xsize=resolution[0]-10)
rightbase_3DRAW=widget_base(drawbase,col=1,xsize=resolution[0]-10-resolution[0]/7)
lower_right_base_3DRAW=widget_base(rightbase_3DRAW,row=1)
widths=[50,50,50,150]
table_base=widget_base(lower_right_base_3DRAW,col=1)
table_button_base=widget_base(table_base,row=1)
coordinate_label=widget_label(table_button_base,value='Coorsys:')
coordinate_text=widget_text(table_button_base,value='0',/EDITABLE,uvalue='ChangeCoordinateSet',XSIZE=4)
file=working_dir+subdir+'loadpeaks.bmp'
button_LoadPeaks=widget_button(table_button_base,value=file,uvalue='loadPeaks_3DRAW',/BITMAP,TOOLTIP='Load Coordinates')
file=working_dir+subdir+'savecoors.bmp'
save_3DRAW=widget_button(table_button_base,value=file,uvalue='save_3DRAW',/bitmap,TOOLTIP='Save coordinates')
file=working_dir+subdir+'shownames.bmp'
button_Show_Names=widget_button(table_button_base,value=file,uvalue='showNames_3DRAW',/BITMAP,TOOLTIP='Show/Hide glomerulus names')
label2_3DRAW=widget_label(table_button_base,value='CoorSize')
text2_3DRAW=widget_text(table_button_base,/editable,uvalue='text2_3DRAW',value=string(condensekernel),xsize=4)
file=working_dir+subdir+'deleteCoors.bmp'
button_DeletePeaks=widget_button(table_button_base,value=file,uvalue='deletePeaks_3DRAW',/BITMAP,TOOLTIP='Delete all coordinates')
table_3DRAW=widget_table(table_base,y_scroll_size=15,uvalue='table_3DRAW',column_labels=['X_Pos','Y_Pos','Peak_No','Odors'],xsize=4,column_widths=widths,/EDITABLE)

tab_base=WIDGET_TAB(lower_right_base_3DRAW,location=0,xsize=resolution[0]*0.4,YSIZE=resolution[1]*0.37,uvalue="tab_widget")
WT0 = widget_BASE(tab_base,TITLE='Trace',/COL,uvalue="Trace")
traces_wid=widget_draw(WT0,uvalue='draw_traces',RETAIN=1)

wT1 = WIDGET_BASE(tab_base, TITLE='Differential', /COL,uvalue="Differential")
draw_differential3DRAW=widget_draw(wT1,uvalue='draw_DiffImg3D',RETAIN=1)
label_Frame_one_3DRAW=widget_label(wT1,value='Frame_one:')
value_Frame_one_3DRAW=widget_label(wT1,value=string(no_one),XSIZE=100)
label_Frame_two_3DRAW=widget_label(wT1,value='Frame_two:')
value_Frame_two_3DRAW=widget_label(wT1,value=string(no_two),XSIZE=100)
wT2 = WIDGET_BASE(tab_base, TITLE='Movie', /COL,uvalue="Movie")
measu_base=widget_base(wT2,column=1)
measu_buttons=widget_base(measu_base,row=1)
measu_play=widget_button(measu_buttons,value='Play',uvalue='play_measu')
show_coors=widget_button(measu_buttons,value='Dots',uvalue='show_measu')
measu_label=widget_label(measu_buttons,value='0')

draw_measu=widget_draw(measu_base,uvalue='draw_measu',RETAIN=1,/button_events,/MOTION_EVENTS)
frame_measu=widget_slider(measu_base,MAXIMUM=1,MINIMUM=0,uvalue='Frame',value=0)



;//////////////////////////////////////////////////////////////////////////////////////////////////////////////

traces_wid=traces_wid

draw_id=draw_3DRAW
diff_id=draw_differential3DRAW

maskfather_id=base
base_id=base
diff_one_id=value_Frame_one_3DRAW
diff_two_id=value_Frame_two_3DRAW
table_id=table_3DRAW

fn_id=filelabel_3DRAW

measu_id=draw_measu
frame_id=frame_measu
measu_label_id=measu_label

scalelow_id=ctv_scalerange_low_3DRAW

scalehigh_id=ctv_scalerange_high_3DRAW

GetCoordinates_ID=base

widget_control,base,/realize
xmanager,'GetCoors',base,/NO_BLOCK

END


