FUNCTION GetNeighbours,x_val,y_val,ArrayDims,kernelsize,ThreeDStack
IF ArrayDims[0] NE 3 OR kernelsize LT 0 OR kernelsize GT ArrayDims[1]/2 OR kernelsize GT ArrayDims[2]/2 THEN RETURN,-1 ELSE BEGIN
	x_start=x_val-kernelsize
	IF x_start LT 0 THEN x_start=0
	x_end=x_val+kernelsize
	IF x_end GT ArrayDims[1]-1 THEN x_end=ArrayDims[1]-1
	y_start=y_val-kernelsize
	IF y_start LT 0 THEN y_start=0
	y_end=y_val+kernelsize
	IF y_end GT ArrayDims[2]-1 THEN y_end=ArrayDims[2]-1
	num_x=x_end+1-x_start
	num_y=y_end+1-y_start
	neighbours=fltarr(num_x*num_y,ArrayDims[3])
	FOR i=x_start, x_end DO BEGIN
		FOR j=y_start,y_end DO BEGIN
			neighbours[(i-x_start)*num_y+(j-y_start),*]=ThreeDStack[i,j,*]
		ENDFOR
	ENDFOR
	RETURN,neighbours
ENDELSE
END