;;  GETBITMAP.  define bitmaps
;;  CREATETREE.
;;  SAVEMOVEMENTCORRECTION.: save current movement in text file (after "Apply")
;;  LOADSHIFTS.             : Load Shifts from Txt-file
;;  APPLYSHIFTS.
;;  CLICKACTION_MOVCORR.   ;e.g. apply cursor keys for movement
;;  LOADAPPLYSHIFTS.
;;  REFRESH.               ; display the 4 images
;;  SHOWMOVIE_MOVCORR.     : Retrieve image data for movement correction * "Preprocessing"
;;  LOADMOVEMENTCORR.
;;  RESET_MOVS.
;;  RESET_SHIFTS.
;;  LOADMEASUREMENT.
;;  MOVEMENTCORRECTION.     : Autom. movement correction
;;  MOVEMENT_CORRECT_EVENT. : event handler
;;  MOVEMENT_CORRECT.       : main



FUNCTION GetBitmap,param
COMMON ALL
IF param EQ 1 THEN BEGIN

;;todo1107 replace hard coded Bitmaps by files
subdir='\bitmaps\'
filename=working_dir+subdir+'check.bmp'
bitmap1=read_bmp(filename)
bitmap=intarr(16,16,3)
bitmap[*,*,0]=reverse(rotate(bitmap1,2))
bitmap[*,*,1]=reverse(rotate(bitmap1,2))
bitmap[*,*,2]=reverse(rotate(bitmap1,2))

ENDIF ELSE BEGIN
	subdir='\bitmaps\'
	filename=working_dir+subdir+'Danger.bmp'
	bitmap1=read_bmp(filename)
	pos=where(bitmap1 EQ 249)
	bitmap2=bitmap1
	bitmap2[pos]=0
	bitmap3=bitmap2
	bitmap=intarr(16,16,3)
	bitmap[*,*,0]=bitmap1
	bitmap[*,*,1]=bitmap2
	bitmap[*,*,2]=bitmap3
ENDELSE
RETURN, bitmap
END


;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
PRO createTree,difflist
COMMON ALL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON WINDOW_IDS
IF MovementCorrect_ID NE 0 THEN BEGIN
	IF string(TreeWidget[0]) NE 'Empty' THEN widget_control,TreeWidget[0],/DESTROY
ENDIF
no_leafs=N_ELEMENTS(filenamelist)
TreeWidget=intarr(no_leafs+3)
TreeWidget[0]=widget_tree(tree_base_id,/FOLDER,value='NONE',uvalue='tree_MOVCORR',scr_xsize=300)
bitmap=GetBitmap(2)
IF difflist[n_ELEMENTS(difflist)-1] GT 0.01 THEN TreeWidget[1]=widget_tree(TreeWidget[0],/FOLDER,value=fn,/EXPANDED,uvalue='tree_MOVCORR',bitmap=bitmap) ELSE TreeWidget[1]=widget_tree(TreeWidget[0],/FOLDER,value=fn,/EXPANDED,uvalue='tree_MOVCORR')
FOR I=2, no_leafs+1 DO BEGIN
	leaf_name=strtrim(string(i-2)+"   "+filenamelist[i-2])
	IF difflist[i-2] EQ max(difflist[0:N_ELEMENTS(difflist)-2]) THEN TreeWidget[i]=widget_tree(TreeWidget[1],value=leaf_name,uvalue='tree_MOVCORR',bitmap=bitmap) ELSE TreeWidget[i]=widget_tree(TreeWidget[1],value=leaf_name,uvalue='tree_MOVCORR')
ENDFOR
IF difflist[n_ELEMENTS(difflist)-1] GT 0.01 THEN TreeWidget[no_leafs+2]=widget_tree(TreeWidget[0],value=fn,uvalue='tree_MOVCORR',bitmap=bitmap) ELSE TreeWidget[no_leafs+2]=widget_tree(TreeWidget[0],value=fn,uvalue='tree_MOVCORR')
shiftlist=intarr(2,N_ELEMENTS(filenamelist))
shiftlist[*,*]=0
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////

;////////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 save current movement in text file (after "Apply" button pressed! )
PRO SaveMovementCorrection
COMMON ALL
COMMON CORRECT_MOV
IF string(movs_applied_list[0]) NE 'Empty' THEN BEGIN
	temp_list=movs_applied_list+shifts_applied_list

	temp=fn+'.moveList'
	MoveFile=DIALOG_PICKFILE(/write,/MUST_EXIST,FILTER='*.moveList',PATH=sapath,FILE=temp)
	IF MoveFile NE '' THEN BEGIN
		openw, unit, MoveFile, /get_lun
		FOR J=0, N_ELEMENTS(lastframes)-2 DO BEGIN
			movementList=intarr(3,lastframes[j+1]-lastframes[j])
			movementList[0:1,*]=temp_list[*,lastframes[j]:lastframes[j+1]-1]
			FOR K=0,1 DO BEGIN
				FOR I=0,2 DO BEGIN
					arr1 = strtrim([file_basename(parameters[j].ex_name),string(i),string(k),string(reform(movementList[i,*]))],2)
					nnn  = n_elements(arr1)
					form=fline([nnn],['A'])
					printf, unit, format=form, arr1
				ENDFOR
			ENDFOR
		ENDFOR
	free_lun, unit
	ENDIF
ENDIF
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 Load Shifts from Txt-file
PRO LoadApplyShifts
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON TOGGLES
filename=''
filename=DIALOG_PICKFILE(/read,/MUST_EXIST,FILTER='*.MoveList',PATH=sapath)
if filename ne '' then begin
;;1107 fix to avoid crash
n_files_movelist = file_lines(filename)/6
if  n_files_movelist lt N_ELEMENTS(filenamelist) then begin
  r = dialog_message("Error: Number of files in the MoveList less than number of loaded files",  /error)
  return
endif
  widget_control, /hourglass
	ArrayDims=SIZE(Data)
	frames_or_measurements=0
	IF strpos(filename,'.moveList') NE -1 THEN BEGIN
		shifts_applied_list=intarr(2,ArrayDims[3])
		shifts_applied_list[*]=0
		movs_applied_list=shifts_applied_list
		openR, unit,filename, /get_lun
		FOR j=0,N_ELEMENTS(filenamelist)-1 DO BEGIN
			line=''
			FOR i=0,5 DO BEGIN
				readf, unit, line  ;read one line
				separated=strsplit(line,/EXTRACT)
				int_separated=fix(separated[1:*])
				IF int_separated[1] EQ 0 AND int_separated[0] NE 2 THEN BEGIN
					movs=int_separated[2:*]
					pos_shift=n_elements(movs)/2
					shifts_applied_list[int_separated[0],lastframes[j]:lastframes[j+1]-1]=movs[pos_shift]
					movs_applied_list[int_separated[0],lastframes[j]:lastframes[j+1]-1]=(movs-movs[pos_shift])
				ENDIF
			ENDFOR
		ENDFOR
		free_lun,unit
	ENDIF
	shiftlist=intarr(2,N_ELEMENTS(filenamelist))
	frames_or_measurements=2
	applied_shifts=1
	applied_movs[*]=1
	ApplyShifts
	GenerateCTVImages
	IF medianed eq 1 THEN ctvimages=ApplyFilter(ctvimages,'Median')
	IF smoothed eq 1 THEN ctvimages=ApplyFilter(ctvimages,'Convol')

	IF frames_or_measurements EQ 0 THEN LoadShifts
	IF frames_or_measurements EQ 1 THEN LoadMeasurement
endif
END


;////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO ApplyShifts
COMMON ALL
COMMON CORRECT_MOV
COMMON WIDGET_IDS

IF frames_or_measurements NE -1 THEN BEGIN
  templist=shifts_applied_list ;;1107 for init. only
	templist[*,*]=0

;;1107 fix to apply the current movement: send "next frame" event
 ;;send event for Shift -> (Shift cursor)
 IF frames_or_measurements EQ 1 or frames_or_measurements EQ 0 then begin ;;better ?
  parent_id = widget_info( draw_id_MOVCORR, /parent)
  while parent_id ne 0 do begin
    tbl_id = parent_id
    parent_id = widget_info(parent_id, /parent)
  endwhile
  widget_control, draw_id_MOVCORR, send_event = $
      {WIDGET_DRAW,id:draw_id_MOVCORR, top:tbl_id, handler:tbl_id, $
       type:6l, x:1, y:1l,press:0b,release:1b,clicks:0l, modifiers:1l, ch:0b, key:6l}
  dummy = widget_event(tbl_id, /nowait)
end

	IF frames_or_measurements EQ 0  THEN BEGIN  ;;between measurements
		FOR I=0,N_ELEMENTS(lastframes)-2 DO BEGIN
			templist[0,lastframes[i]:lastframes[i+1]-1]=shiftlist[0,i]
			templist[1,lastframes[i]:lastframes[i+1]-1]=shiftlist[1,i]
		ENDFOR
		bitmap=getbitmap(1)
		widget_control,TreeWidget[1],SET_TREE_BITMAP=bitmap
		widget_control,TreeWidget[N_ELEMENTS(TreeWidget)-1],SET_TREE_BITMAP=bitmap
		applied_shifts=1
		shifts_applied_list=shifts_applied_list+templist
		shiftlist[*]=0
	ENDIF

	IF frames_or_measurements EQ 1  THEN BEGIN
		templist[*,lastframes[active]:lastframes[active+1]-1]=movlist
		bitmap=getbitmap(1)
		widget_control,TreeWidget[active+2],SET_TREE_BITMAP=bitmap
		applied_movs[active]=1

		movs_applied_list=movs_applied_list+templist
		movlist[*]=0  ;;
	ENDIF

	IF frames_or_measurements EQ 2 THEN BEGIN
		templist=shifts_applied_list+movs_applied_list
		bitmap=getbitmap(1)
		FOR I=1,N_ELEMENTS(TreeWidget)-1 DO BEGIN
			widget_control,TreeWidget[i],SET_TREE_BITMAP=bitmap
		ENDFOR
		frames_or_measurements=0
	ENDIF

	FOR I=0, N_ELEMENTS(templist[0,*])-1 DO BEGIN
		data[*,*,i]=shift(data[*,*,i],templist[0,i],templist[1,i])
		;rawdata[*,*,i]=shift(rawdata[*,*,i],templist[0,i],templist[1,i])
	ENDFOR

ENDIF

END
;////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO CLICKACTION_MOVCORR,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS

changed=0
ArrayDims=SIZE(image_staple)
IF ArrayDims[0] eq 3 then begin
	if event.release GT 0 then begin
		IF frames_or_measurements EQ 0 THEN templist=shiftlist ELSE templist=movlist
		x_shift=0
		y_shift=0

		IF event.type EQ 6 then begin; //////Pfeiltasten gettigt

			IF event.modifiers EQ 0 THEN BEGIN ; //// Pfeiltasten ohne shift gettigt
				x_shift=0
				y_shift=0

				if event.key eq 5 then x_shift=-1

				if event.key eq 6 then x_shift=1

				if event.key eq 7 then y_shift=-1

				if event.key eq 8 then y_shift=1;;

				this_frame.x=this_frame.x+x_shift
				this_frame.y=this_frame.y+y_shift

				image_staple[*,*,count]=shift(image_staple[*,*,count],x_shift,y_shift)

				IF string(ctvimages[0]) ne 'Empty' AND frames_or_measurements EQ 0 then BEGIN
					ctvimages[*,*,count]=shift(ctvimages[*,*,count],x_shift,y_shift)
					rawimages[*,*,count]=shift(rawimages[*,*,count],x_shift,y_shift)
				ENDIF
				changed=1

			ENDIF; event.modifiers EQ 0
			IF event.modifiers EQ 1 THEN BEGIN; //// Pfeiltasten mit shift gettigt
				templist[0,count]=templist[0,count]+this_frame.x
				templist[1,count]=templist[1,count]+this_frame.y

				last_shifts=this_frame

				this_frame.x=0
				this_frame.y=0
				this_frame.flag=0

				if event.key eq 5 OR event.key eq 8 then begin
					count=count-1
					if count lt 0 then count= ArrayDims[3]-1
				endif;
				if event.key eq 6 OR event.key eq 7 then begin
					count=count+1
					if count gt ArrayDims[3]-1 then count=0
				endif;
			ENDIF; event.modifiers EQ 1
		ENDIF; event.type EQ 6


		IF event.type EQ 5 THEN BEGIN; // Normale tastatur gedrckt
			IF event.ch EQ 13 THEN BEGIN
				this_frame.x=this_frame.x+last_shifts.x
				this_frame.y=this_frame.y+last_shifts.y
			ENDIF
			image_staple[*,*,count]=shift(image_staple[*,*,count],last_shifts.x,last_shifts.y)
			if string(ctvimages[0]) ne 'Empty' AND frames_or_measurements EQ 0 then begin
				ctvimages[*,*,count]=shift(ctvimages[*,*,count],last_shifts.x,last_shifts.y)
				rawimages[*,*,count]=shift(rawimages[*,*,count],last_shifts.x,last_shifts.y)
			ENDIF
		ENDIF; event.type EQ 5


		IF event.type EQ 1 THEN BEGIN ; ///////////////////Maustaste gedrckt
			IF event.release EQ 1 THEN BEGIN ;/////// Linke Maustaste gedrckt
				IF string(tupel[0]) EQ 'Empty' THEN BEGIN
					ArrayDims=SIZE(image_staple)
					y_pos=event.y/resize
					IF event.x GE 0 AND event.x LT 2*((ArrayDims[1]-1)*resize) AND y_pos GE 0 AND y_pos LT ArrayDims[2] THEN tupel=[event.x/resize,ArrayDims[2]-1-y_pos]
				ENDIF ELSE BEGIN
					IF event.x GE 0 AND event.x LT 2*((ArrayDims[1]-1)*resize) AND y_pos GE 0 AND y_pos LT ArrayDims[2] THEN BEGIN
						x_pos=event.x/resize
						y_pos=ArrayDims[2]-1-event.y/resize


						IF x_pos / ArrayDims[1] NE tupel[0]/ArrayDims[1] THEN BEGIN
							shifts=[x_pos-tupel[0],y_pos-tupel[1]]
							IF abs(shifts[0]-ArrayDims[1]) LT shifts[0] THEN shifts[0]=shifts[0]-ArrayDims[1]
							IF abs(shifts[1]-ArrayDims[2]) LT shifts[1] THEN shifts[1]=shifts[1]-ArrayDims[2]
							image_staple[*,*,count]=shift(image_staple[*,*,count],shifts[0],shifts[1])
							if string(ctvimages[0]) ne 'Empty' AND frames_or_measurements EQ 0 then begin
								ctvimages[*,*,count]=shift(ctvimages[*,*,count],shifts[0],shifts[1])
								rawimages[*,*,count]=shift(rawimages[*,*,count],shifts[0],shifts[1])
							ENDIF
							this_frame.x=this_frame.x+shifts[0]
							this_frame.y=this_frame.y+shifts[1]
							changed=1
						ENDIF
						tupel='Empty'
					ENDIF
				ENDELSE
			ENDIF; event.release EQ 1

			;IF event.release EQ 4 THEN BEGIN;/////rechte Maustaste gedrckt
			;	last_shifts.flag=0
			;	last_shifts.x=0
			;	last_shifts.y=0
			;ENDIF; event.release EQ 4
		ENDIF; event.type EQ 1

		this_frame.x=this_frame.x MOD ArrayDims[1]
		this_frame.y=this_frame.y MOD ArrayDims[2]

		IF frames_or_measurements EQ 0 THEN shiftlist=templist ELSE movlist=templist
		refresh
		IF frames_or_measurements EQ 0 AND changed EQ 1 THEN refreshscreen
	ENDIF; Event.release GT 0

ENDIF; ArrayDims[0] EQ 3

END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107: Retrieve image data for (all) movement correction
;;      "Preprocessing2
FUNCTION LoadMovementCorr,filename,active
COMMON ALL
COMMON Toggles
COMMON GetLogFiles

ArrayDims=SIZE(Data)
frames=lastframes[active+1]-lastframes[active]
raw1=intarr(ArrayDims[1],ArrayDims[2],frames)

;;1107 original: this code, i.e. read again data file not used ! (see below rawdata)
                  ;;1107 erase ?  IF 0 THEN BEGIN
                  ;;	IF LoadMeth EQ 1 THEN BEGIN
                  ;;		tifflist=FILE_SEARCH(file_dirname(logfilenames[active]),namelist[active]+"*")
                  ;;		tifflist=tifflist[sort(tifflist)]
                  ;;	 	IF N_ELEMENTS(tifflist) EQ frames THEN BEGIN
                  ;;	    	FOR z=0,frames-1 DO BEGIN
                  ;;	        	raw1[*,*,z]=float(read_tiff(tifflist[z]))
                  ;;	        ENDFOR
                  ;;	    ENDIF
                  ;;	ENDIF ELSE BEGIN
                  ;;		OPENR, unit, filename, /GET_LUN
                  ;;		readu, unit, raw1
                  ;;		Free_LUN,unit
                  ;;	ENDELSE
                  ;;ENDIF
raw1=rawdata[*,*,lastframes[active]:lastframes[active+1]-1]
print,active

;;1107 new:
;; use abs(total(...))
for i=0, (size(raw1))[3]-1 do begin raw1[*,*,i] = raw1[*,*,i] - $
     ( total(  (raw1[*,*,i]-raw1[*,*,parameters.stimulus_on-1]) ) / ( (size(raw1))[1]*(size(raw1))[2] ) )
endfor


;;1107 (pre) processing of rawdata before movement correction (from original)
;;make thresholds (hist gt 2) variable/parameter
hist=histogram(raw1)
mini=min(raw1)
maxval=max(where(hist GT 2))+mini  ;;1107 why "2" !?
minval=min(where(hist GT 2))+mini
;;1107thesholding
raw1 = temporary(raw1) < maxval
        ;1107 original pos=where(raw1 GT maxval)
        ;if pos[0] ne -1 THEN raw1[pos]=maxval
raw1 = temporary(raw1)>minval
        ;1107 original pos=where(raw1 LT minval)
        ;if pos[0] ne -1 THEN raw1[pos]=minval
;;bytscl....
temp=bytscl(raw1)
ArrayDims=SIZE(temp)
if rebinfactor ne 1 then $ ;;1107 rebinfactor from Parameters ?
    temp=congrid(temp,float(ArrayDims[1])*rebinfactor,float(ArrayDims[2])*rebinfactor,ArrayDims[3])
return, temp
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 this routine only displays 4 images
PRO REFRESH
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
loadct,0,/SILENT
device,decomposed=1
counter=count
winnum=0

IF frames_or_measurements EQ 1 THEN reference=mov_reference ELSE reference=shift_reference

ArrayDims=SIZE(Image_staple)
IF ArrayDims[0] eq 3 THEN BEGIN
	widget_control,draw_id_MOVCORR,get_value=winnum
	device,get_screen_size=resolution

	widget_control,draw_id_MOVCORR,draw_xsize=(4*ArrayDims[1]*resize),draw_ysize=(ArrayDims[2]*resize)
	wset,winnum

	temp_staple=image_staple
;	IF string(result[0]) NE 'Empty' THEN BEGIN
;		FOR I=0,N_ELEMENTS(result[0,*])-1 DO BEGIN
;			temp_staple[result[0,i],result[1,i],*]=0
;		ENDFOR
;	ENDIF

;1107;;resize only if it make sense !
if resize ne 1 then begin
  ;;ref. image
	tempref=rebin(temp_staple[*,*,reference],resize*ArrayDims[1],resize*ArrayDims[2],SAMPLE=1)
	;;curr. image
	tempcount=rebin(temp_staple[*,*,counter],resize*ArrayDims[1],resize*ArrayDims[2],SAMPLE=1)
endif else begin
  tempref = temp_staple[*,*,reference]
  tempcount = temp_staple[*,*,counter]
endelse

        ;;1107 original code: (tupel ??)
            ;;	IF string(tupel[0]) NE 'Empty' THEN BEGIN
            ;;		IF tupel[0] GT ArrayDims[1]-1 THEN BEGIN
            ;;			temp=temp_staple[*,*,counter]
            ;;			temp[tupel[0]-ArrayDims[1],tupel[1]]=255
            ;;			temp_ref_red=rebin(temp,resize*ArrayDims[1],resize*ArrayDims[2],/SAMPLE)
            ;;
            ;;			temp_count_red=tempcount
            ;;		ENDIF ELSE BEGIN
            ;;			temp=temp_staple[*,*,reference]
            ;;			temp[tupel[0],tupel[1]]=255
            ;;			temp_count_red=rebin(temp,resize*ArrayDims[1],resize*ArrayDims[2],/SAMPLE)
            ;;
            ;;			temp_ref_red=tempref
            ;;		ENDELSE
            ;;	ENDIF ELSE BEGIN
            ;;		temp_ref_red=tempref
            ;;		temp_count_red=tempcount
            ;;	ENDELSE

;;1107Calculate difference Current - reference
	temp=128+0.5*bytscl(tempcount)-0.5*bytscl(tempref)

;;background ? (for window only);;complete image
	background=fltarr(4*resize*ArrayDims[1],resize*ArrayDims[2],3)

  ;1st image
	background[0:resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,0]=tempcount;;1107 orig: temp_count_red
	background[0:resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,1]=tempcount
	background[0:resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,2]=tempcount
  ;2nd image (reference)
	background[resize*ArrayDims[1]:2*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,0]=tempref ;;1107 orig: temp_ref_red
	background[resize*ArrayDims[1]:2*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,1]=tempref
	background[resize*ArrayDims[1]:2*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,2]=tempref
  ;3rd iamge (difference)
	background[2*resize*ArrayDims[1]:3*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,0]=temp
	background[2*resize*ArrayDims[1]:3*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,1]=temp
	background[2*resize*ArrayDims[1]:3*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,2]=temp
  ;4th image: reference(blue channel) and current(red channel) image
	background[3*resize*ArrayDims[1]:4*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,0]=rebin(temp_staple[*,*,counter],resize*ArrayDims[1],resize*ArrayDims[2],/SAMPLE)
	background[3*resize*ArrayDims[1]:4*resize*ArrayDims[1]-1,0:resize*ArrayDims[2]-1,2]=rebin(temp_staple[*,*,reference],resize*ArrayDims[1],resize*ArrayDims[2],/SAMPLE)

	TV,background,true=3
	x_start=ArrayDims[1]*0.2
	x_end=ArrayDims[1]*0.8
	y_start=ArrayDims[2]*0.2
	y_end=ArrayDims[2]*0.8
	totpix=(x_end-x_start)*(y_end-y_start)
	error=abs(float(temp_staple[x_start:x_end,y_start:y_end,count])-float(temp_staple[x_start:x_end,y_start:y_end,reference]))/totpix
	error=long(total(error))
	widget_control,widget_error,set_value=string(fix(error))
	xyouts,10,10,count,/DEVICE,font=1,charsize=resize-1,color=254
	xyouts,resize*ArrayDims[1]+10,10,reference,/DEVICE,font=1,charsize=resize-1,color=254

ENDIF ELSE BEGIN
	IF STRING(data[0]) NE 'Empty' THEN BEGIN
		ArrayDims=SIZE(data)
		background=fltarr(4*resize*ArrayDims[1],resize*ArrayDims[2])
		background[*,*]=0
		widget_control,draw_id_MOVCORR,get_value=winnum
		wset,winnum
		TV,background
	ENDIF
ENDELSE

END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

PRO SHOWMOVIE_MOVCORR
COMMON CORRECT_MOV
IF frames_or_measurements EQ 1 THEN reference=mov_reference ELSE reference=shift_reference
ArrayDims=SIZE(image_Staple)
if ArrayDims[0] eq 3 then begin
	temp=reference
	for i=0,ArrayDims[3]-1 do begin
		IF frames_or_measurements EQ 1 THEN mov_reference=i ELSE shift_reference=i
		refresh
		for j=0L,50000 do k=0
	endfor;
	IF frames_or_measurements EQ 1 THEN mov_reference=temp ELSE shift_reference=temp
endif
END

;////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO reset_movs
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS

if raw_mov_staple[0] eq 'Empty' then return

ArrayDims=SIZE(raw_mov_staple)
x_start=rawborder
x_end=ArrayDims[1]-1-rawborder
y_start=rawborder
y_end=ArrayDims[2]-1-rawborder
image_staple=bytscl(raw_mov_staple[x_start:x_end,y_start:y_end,*])

movlist[*,*]=0

IF applied_movs[active] EQ 1 THEN BEGIN
	FOR I=lastframes[active],lastframes[active+1]-1 DO BEGIN
		data[*,*,i]=shift(data[*,*,i],(-1)*movs_applied_list[0,i],(-1)*movs_applied_list[1,i])
	ENDFOR
	movs_applied_list[*,lastframes[active]:lastframes[active+1]-1]=0
	widget_control,TreeWidget[active+2],SET_TREE_BITMAP=0
	applied_movs[active]=0
ENDIF

END
;////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO reset_shifts
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
ArrayDims=SIZE(raw_shift_staple)
x_start=rawborder
x_end=ArrayDims[1]-1-rawborder
y_start=rawborder
y_end=ArrayDims[2]-1-rawborder
image_staple=bytscl(raw_shift_staple[x_start:x_end,y_start:y_end,*])
shiftlist[*,*]=0
rawimages=raw_images_noshift
ctvimages=ctvimages_raw
ArrayDims=SIZE(data)
IF applied_shifts EQ 1 THEN BEGIN
	FOR I=0,ArrayDims[3]-1 DO BEGIN
		data[*,*,i]=shift(data[*,*,i],(-1)*shifts_applied_list[0,i],(-1)*shifts_applied_list[1,i])
	ENDFOR
	applied_shifts=0
	widget_control,TreeWidget[N_ELEMENTS(TreeWidget)-1],SET_TREE_BITMAP=0
	shifts_applied_list[*]=0
ENDIF
refreshscreen
END
;////////////////////////////////////////////////////////////////////////////////////////////////////////////#
;;1107 Get raw frames for correction of a measurement
PRO LoadMeasurement
COMMON ALL
COMMON CORRECT_MOV
filename=parameters[active].ex_name
raw_mov_staple=LoadMovementCorr(filename,active)
ArrayDims=SIZE(raw_mov_staple)
x_start=rawborder
x_end=ArrayDims[1]-1-rawborder
y_start=rawborder
y_end=ArrayDims[2]-1-rawborder
image_staple=bytscl(raw_mov_staple[x_start:x_end,y_start:y_end,*])
ArrayDims=SIZE(image_staple)
movlist=movs_applied_list[*,lastframes[active]:lastframes[active+1]-1]
if max(movlist) gt 0 then begin
      FOR I=0,ArrayDims[3]-1 DO BEGIN
      	image_staple[*,*,i]=shift(image_staple[*,*,i],movlist[0,i],movlist[1,i])
      ENDFOR
endif
mov_reference=ArrayDims[3]/2 ;;1107 parameter ?
count=0
frames_or_measurements=1
cutoff=strpos(filename,"\",/REVERSE_SEARCH)
filename=strmid(filename,cutoff+1)
widget_control,widget_fn,set_value=filename
count=0

END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;;1107 Get raw frames and prepare them for correction between frames + other initializiations (shiftlist )
PRO LoadShifts
COMMON ALL
COMMON Toggles
COMMON CORRECT_MOV
;IF LoadMeth EQ 1 THEN extract=LoadMovementCorr(lopath+filenamelist[0],active) ELSE extract=LoadMovementCorr(lopath+filenamelist[0],active)
ArrayDims=SIZE(data)
raw_shift_staple=fltarr(ArrayDims[1],ArrayDims[2],n_elements(lastframes)-1)
shiftlist=intarr(2,N_ELEMENTS(filenamelist))
FOR I=0,N_ELEMENTS(filenamelist)-1 DO BEGIN
  ;;1107 get orginal data
	extract=LoadMovementCorr(lopath+filenamelist[i],i)
	ArrayDims=SIZE(extract)
	;;1107 apply measurements correction already done
	movlist=movs_applied_list[*,lastframes[i]:lastframes[i+1]-1]
	FOR J=0,ArrayDims[3]-1 DO BEGIN
		extract[*,*,J]=shift(extract[*,*,J],movlist[0,J],movlist[1,J])
	ENDFOR
	;;1107
	raw_shift_staple[0:ArrayDims[1]-1,0:ArrayDims[2]-1,i]=total(extract,3)/ArrayDims[3]
	temp=shifts_applied_list[*,lastframes[i]:lastframes[i+1]-1]
	shiftlist[*,i]=temp[*,ArrayDims[3]/2]
ENDFOR
x_start=rawborder
x_end=ArrayDims[1]-1-rawborder
y_start=rawborder
y_end=ArrayDims[2]-1-rawborder
image_staple=bytscl(raw_shift_staple[x_start:x_end,y_start:y_end,*])
frames_or_measurements=0  ;;
shift_reference=N_ELEMENTS(filenamelist)/2 ;;index of reference frame
if max(abs(shiftlist)) ne 0 then begin ;;1107 shiftList ne 0 when shifts_applied_list ne 0, s.a.
  FOR I=0,N_ELEMENTS(shiftlist[0,*])-1 DO BEGIN
  	image_staple[*,*,I]=shift(image_staple[*,*,I],shiftlist[0,I],shiftlist[1,I])
  ENDFOR
endif
widget_control,widget_fn,set_value=fn
count=0
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;1107 Auto movement correction
PRO MovementCorrection
brute_size=10
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
ArrayDims=SIZE(image_staple)
if ArrayDims[0] eq "Empty" then return ;;1107 nothing loading
IF frames_or_measurements EQ 0 THEN reference=shift_reference ELSE reference=mov_reference
reference_slice=image_staple[*,*,reference]
reference_slice=reference_slice+1 ; To avoid division by zero
x_shift_list=0
y_shift_list=0
for i=0,ArrayDims[3]-1 do begin
	new_slice=image_staple[*,*,i]+1;To make up for the +1 above

	errors=fltarr(brute_size*2+1,brute_size*2+1)
	for shift_x=-brute_size,brute_size do begin
		for shift_y=-brute_size,brute_size do begin
			;; Now the images are cropped so that a wrap-around doesn`t have any impact on the error-sum
			if shift_x le 0 then begin
				if shift_y le 0 then begin
					old=reference_slice[0:ArrayDims[1]-1+shift_x,0:ArrayDims[2]-1+shift_y]
					new=new_slice[abs(shift_x):ArrayDims[1]-1,abs(shift_y):ArrayDims[2]-1]
				endif else begin
					old=reference_slice[0:ArrayDims[1]-1+shift_x,shift_y:ArrayDims[2]-1]
					new=new_slice[abs(shift_x):ArrayDims[1]-1,0:ArrayDims[2]-1-shift_y]
				endelse
			endif else begin
				if shift_y le 0 then begin
					old=reference_slice[shift_x:ArrayDims[1]-1,0:ArrayDims[2]-1+shift_y]
					new=new_slice[0:ArrayDims[1]-1-shift_x,abs(shift_y):ArrayDims[2]-1]
				endif else begin
					old=reference_slice[shift_x:ArrayDims[1]-1,shift_y:ArrayDims[2]-1]
					new=new_slice[0:ArrayDims[1]-1-shift_x,0:ArrayDims[2]-1-shift_y]
				endelse
			endelse;; End of cropping

			;;1107 Compare the shifted image-parts and calculate the error
			small_dims=size(new)
			x_start=small_dims[1]*0.2
			x_end=small_dims[1]*0.8
			y_start=small_dims[2]*0.2
			y_end=small_dims[2]*0.8
			totpix=(x_end-x_start)*(y_end-y_start)
			error=total(abs(float(new[x_start:x_end,y_start:y_end])-float(old[x_start:x_end,y_start:y_end]))/totpix)

			if error lt 0 then begin
				print,'Break'
			endif
			errors[shift_x+brute_size,shift_y+brute_size]=error
		endfor;
	endfor;

;;1107
	pos=where(errors eq MIN(errors))
	if n_elements(pos) gt 1 then print,"More than one Minimum
	x_pos=pos[0] MOD (2*brute_size+1)
	y_pos=pos[0]/(2*brute_size+1)
	template_array=intarr(2*brute_size+1)
	for j=-brute_size,brute_size do template_array[j+brute_size]=j
	x_shift=template_array[x_pos]
	y_shift=template_array[y_pos]
	x_shift_list=[x_shift_list,x_shift]
	y_shift_list=[y_shift_list,y_shift]
endfor;
x_shift_list=x_shift_list[1:n_elements(x_shift_list)-1]
y_shift_list=y_shift_list[1:n_elements(y_shift_list)-1]

IF frames_or_measurements EQ 0 THEN BEGIN
	shiftlist[0,*]=x_shift_list
	shiftlist[1,*]=y_shift_list
	copyshifts=shiftlist
ENDIF ELSE BEGIN
	movlist[0,*]=x_shift_list
	movlist[1,*]=y_shift_list
	copyshifts=movlist
ENDELSE

FOR i=0, ArrayDims[3]-1 DO BEGIN
	image_staple[*,*,i]=shift(image_staple[*,*,i],copyshifts[0,i],copyshifts[1,i])
	IF string(ctvimages[0]) ne 'Empty' AND frames_or_measurements EQ 0 THEN BEGIN
		ctvimages[*,*,i]=shift(ctvimages[*,*,i],copyshifts[0,i],copyshifts[1,i])
		rawimages[*,*,count]=shift(rawimages[*,*,count],copyshifts[0,i],copyshifts[1,i])
	ENDIF
ENDFOR
print,'Finished Movement Correction'

END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;///////// Event Handler
;///////////////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////
PRO movement_correct_event,event
COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON WINDOW_IDS

widget_control,event.id,get_uvalue=widget

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN DestroyWindow,"Movement_correct" ELSE BEGIN

	if (widget eq 'save_all_MOVCORR') then begin
	 		SaveMovementCorrection
	endif

	if (widget eq 'draw_MOVCORR') then begin
	 		clickaction_MOVCORR,event
	endif

	if (widget eq 'MovCorr_MOVCORR') then begin
	  widget_control, /hourglass
		MovementCorrection
		refresh
		refreshscreen
	endif
	if (widget eq 'Movie_MOVCORR') then begin
		ShowMovie_MOVCORR
	endif
	if (widget eq 'reset_MOVCORR') then begin
		last_shifts.flag=0
		last_shifts.x=0
		last_shifts.y=0

		IF frames_or_measurements EQ 0 THEN reset_shifts ELSE reset_movs
		count=0
		last_shifts.x=0
		last_shifts.y=0
		last_shifts.flag=0

		this_frame.x=0
		this_frame.y=0
		this_frame.flag=0

		refresh
	endif
	IF (widget EQ 'apply_MOVCORR') THEN BEGIN
		ApplyShifts
	ENDIF

	if (widget eq 'LA_Shifts_MOVCORR') then begin
		LoadApplyShifts
		refresh
		refreshscreen
	endif

	IF (widget eq 'tree_MOVCORR') THEN BEGIN
		IF tag_names(event,/STRUCTURE_NAME) EQ 'WIDGET_TREE_SEL' THEN BEGIN
			IF event.clicks EQ 2 THEN BEGIN
			  widget_control, /hourglass
				IF event.id GE TreeWidget[2] AND event.id LE TreeWidget[N_ELEMENTS(TreeWidget)-2] THEN BEGIN
					active=event.id-TreeWidget[2]
					LoadMeasurement
					refresh
				ENDIF
				IF event.id EQ TreeWidget[N_ELEMENTS(TreeWidget)-1] THEN BEGIN
					LoadShifts
					refresh
				ENDIF
			ENDIF
		ENDIF
	ENDIF

	if (widget eq 'pixelborder') then begin
		changed=0
		widget_control,event.id,get_value=temp
		if temp[0] gt 15 OR temp[0] lt 0 then begin
			widget_control,event.id,set_value=string(rawborder)
		endif else begin
			rawborder=temp[0]
			IF string(image_staple[0]) NE 'Empty' THEN changed=1
		endelse
		IF changed EQ 1 THEN BEGIN

			IF frames_or_measurements EQ 0 THEN BEGIN
				ArrayDims=SIZE(raw_shift_staple)
				x_start=rawborder
				x_end=ArrayDims[1]-1-rawborder
				y_start=rawborder
				y_end=ArrayDims[2]-1-rawborder
				image_staple=bytscl(raw_shift_staple[x_start:x_end,y_start:y_end,*])
			ENDIF
			IF frames_or_measurements EQ 1 THEN BEGIN
				ArrayDims=SIZE(raw_mov_staple)
				x_start=rawborder
				x_end=ArrayDims[1]-1-rawborder
				y_start=rawborder
				y_end=ArrayDims[2]-1-rawborder
				image_staple=bytscl(raw_mov_staple[x_start:x_end,y_start:y_end,*])
			ENDIF
		 	refresh
		ENDIF
	endif
ENDELSE

END


;//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO movement_correct,base

COMMON ALL
COMMON CTVS
COMMON CORREL
COMMON CORRECT_MOV
COMMON WIDGET_IDS
COMMON Window_IDS

device,get_screen_size=resolution


;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////   ShiftCorrection widget   ////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
iconbase_MOVCORR=widget_base(column=1,mbar=mbar,title="CorrectMovement",GROUP_LEADER=base,/TLB_KILL_REQUEST_EVENTS)
mov_base_left=widget_base(iconbase_MOVCORR,row=1)
mov_base_right=widget_base(iconbase_MOVCORR,row=1)
subdir='\bitmaps\'
file=working_dir+subdir+'saveshifts.bmp'
iconopt2_MOVCORR=widget_button(mov_base_left,value=file,uvalue='save_all_MOVCORR',/bitmap,tooltip="Save shifts for here")
buttonCorr_MOVCORR=widget_button(mov_base_left,value='AUTOcorrection',uvalue='MovCorr_MOVCORR')
buttonFilm_MOVCORR=widget_button(mov_base_left,value='Movie',uvalue='Movie_MOVCORR')
quaderror_MOVCORR=widget_label(mov_base_left,uvalue='error_MOVCORR',value=string(error),xsize=100)
buttonReset_MOVCORR=widget_button(mov_base_left,value='Reset',uvalue='reset_MOVCORR')
;buttonReset_ALL_MOVCORR=widget_button(mov_base_left,value='ResetAll',uvalue='reset_All_MOVCORR')
button_LAShifts_MOVCORR=widget_button(mov_base_left,value='LoadShifts',uvalue='LA_Shifts_MOVCORR')
buttonApply_MOVCORR=widget_button(mov_base_left,value='Apply',uvalue='apply_MOVCORR',xsize=150)
borderpixellabel=widget_label(mov_base_left,value='Exclude border pixel:')
borderpixeltext=widget_text(mov_base_left,value=string(0),uvalue='pixelborder',/editable,xsize=10)
filelabel_MOVCORR=widget_label(mov_base_left,uvalue='name_MOVCORR',value='',xsize=150)
draw_MOVCORR=widget_draw(mov_base_right,XSIZE=400,YSIZE=200,uvalue='draw_MOVCORR',/keyboard_events,/button_events,RETAIN=1)


widget_error=quaderror_MOVCORR
widget_fn=filelabel_MOVCORR


Tree_base_id=mov_base_right


draw_id_movcorr=draw_MOVCORR
MovementCorrect_ID=iconbase_movcorr

widget_control,iconbase_movcorr,/realize,XOFFSET=resolution[0]-880,YOFFSET=resolution[1]-400
xmanager,'Movement_Correct',iconbase_MOVCORR,/no_block


END