FUNCTION OTN, odor
CASE odor of
	'AIR': number=0
	'MOL': number=0
	'HX1': number=1
	'HX2': number=2
	'HXA': number=3
	'HXN': number=4
	'HP1': number=5
	'HP2': number=6
	'HPA': number=7
	'HPN': number=8
	'OC1': number=9
	'OC2': number=10
	'OCA': number=11
	'OCN': number=12
	'NO1': number=13
	'NO2': number=14
	'NOA': number=15
	'NON': number=16
	'Kontrolle': number=-1
	else : number=-2

ENDCASE

return,number
END

PRO SaveGloDataMix,filename,dyename,stainmethod

COMMON ALL
COMMON CTVS
COMMON WINDOW_IDS
COMMON WIDGET_IDS
COMMON SHOW_TRACES

no_measu=N_ELEMENTS(showlist)
IF string(showlist[0]) NE 'Empty' THEN BEGIN
	FOR show=0,no_measu-1 DO BEGIN
		i=showlist[show]

		;now go through odours

		p1=parameters[i]

		temp=data[*,*,lastframes[i]:lastframes[i+1]-1]

		ArrayDims=SIZE(temp)

		; The according coordinateset is put into tempres
		tempres=coordinates[*,*,p1.Messungszahl]

		; As tempres is a 100 row Array, empty slots are filled with -1000. These are erased now
		pos=where(tempres[0,*] NE '-1000')

		; If there are coordinates marked (not all slots are -1000)
		IF pos[0] NE -1 THEN BEGIN

			; Erase the -1000 slots
			tempres=tempres[*,pos]

			; Get the number glomeruli
			GlomeruliNum=n_elements(tempres[0,*])


			numinfos = 15
			ArrayNumInfos	= intArr (numinfos, GlomeruliNum)
			;each position with the following meaning:
			;0		GloTag	 ;integer name of glomerulus, or fictive name >300, or incrementative >1000
			;1		OdorNr	 ;integer code of odor
			;2		Conc		 ;concentration of odour stimulus, always TENFOLD logarithmic, i.e. -23 is 10 to the -2.3
			;3		Stim_on	 ;stimulus onset, frame (first frame WITH odor)
			;4		Stim_off	 ;stimulus offset, frame (last frame WITH odor)
			;5		NoFrames	 ;number of frames in one measurement
			;6		FrameTime	 ;inverse of frequency, in ms. Set to 0 for uneven frequencies
			;7		RealTime	 ;time in minutes
			;8		Treatment   ; 1 for treatment, eg 1: ptx, 0: wash or pre-ptx, includes concentration of treat
			;9		shiftX
			;10		shiftY
			;11		kontrollmessung ; zahl der kontrollmessung
			;12		messungszahl ; zahl der messung
			;13		stimulus_ISI: interval between stimuli
			;14     odorN, i.e. no Measu for old setup, or slice for 3D measus new setup, 4th dimension in sig1 and sig1corr

			txtinfos = 10
			ArrayTxtInfos	= strArr (txtinfos, GlomeruliNum)
			;each position with the following meaning:
			;0		GloInfo	 ;comment text for the glomerulus
			;1		OdorTag	 ;name of odor stimulus, e.g. 'HX1'
			;2		ExpTag	 ;experimental file, or measurement (TILL) expDatei
			;3		comment	 ;any comment
			;4		Treatment   ;text of treatment
			;5		Pharma_time ; application time of treatment
			;6		os9time   ; time of measurement
			;7		viewLabel   ; label view
			;8		ex_name     ;unique name of measurement
			;9		flag[stg_reporttag]     ;unique name of animal




			;containes the time-courses
			ArrayGloTraces	= fltArr (p1.frames, GlomeruliNum)

			ArrayGloTraces(*)   = 0 ;reset array to 0

			;numerical information that is equal for all glomeruli
			ArrayNumInfos[1, *] = p1.Leaf_name;number code of odour
			ArrayNumInfos[2, *] = p1.odor_nr;number code of odour concentration
			ArrayNumInfos[3, *] = p1.stimulus_on;stimulus on
			ArrayNumInfos[4, *] = p1.stimulus_end;stimulus off
			ArrayNumInfos[5, *] = p1.frames;no of frames
			ArrayNumInfos[6, *] = p1.frequency;inverse of frequency in ms, Cycletime
			ArrayNumInfos[7, *] = p1.os9time ;measurement time, check calculation
			ArrayNumInfos[8, *] = p1.treat_conc;number code of concentration of treatment
			ArrayNumInfos[9, *] = p1.shiftX
			ArrayNumInfos[10,*] = p1.shiftY
			ArrayNumInfos[11,*] = p1.kontrollmessung ; zahl der kontrollmessung
			ArrayNumInfos[12,*] = p1.messungszahl ; zahl der messung
			ArrayNumInfos[13,*] = p1.stimulus_ISI ; interstimulus Interval


			;text information that is equal for all glomeruli
			ArrayTxtInfos[1,*] = p1.odor;text code of odour
			ArrayTxtInfos[2,*] = p1.experiment;experiment
			ArrayTxtInfos[3,*] = p1.Leaf_name;any comment
			ArrayTxtInfos[4,*] = p1.treatment;any comment
			ArrayTxtInfos[5,*] = 'PillePalle';stringzero(2,p1.pharma_time(0))+ ':' +stringzero(2,p1.pharma_time(1))+':'+stringzero(2,p1.pharma_time(2)) ; appplacation time of treatment
			ArrayTxtInfos[6,*] = '00:00:00'
			ArrayTxtInfos[7,*] = p1.viewLabel;any comment
			ArrayTxtInfos[8,*] = file_basename(p1.ex_name);any comment
			ArrayTxtInfos[9,*] = file_dirname(p1.ex_name)

			;now goes to all glomeruli, insert their data into TraceArray

			FOR glo=0, GlomeruliNum-1 do begin
				IF fix(tempres[0,glo]) gt 0 AND fix(tempres[0,glo]) lt ArrayDims[1] AND fix(tempres[1,glo]) gt 0 AND fix(tempres[1,glo]) lt ArrayDims[2] then BEGIN
					x=fix(tempres[0,glo])
					x_start=x-condensekernel
					x_end=x+condensekernel
					y=fix(tempres[1,glo])
					y_start=y-condensekernel
					y_end=y+condensekernel
					IF x_start LT 0 THEN x_start=0
					IF x_end GT ArrayDims[1]-1 THEN x_end=ArrayDims[1]-1
					IF y_start LT 0 THEN y_start=0
					IF y_end GT ArrayDims[2]-1 THEN y_end=ArrayDims[2]-1
					ArrayGloTraces(*,glo)=total(total(temp[x_start:x_end,y_start:y_end,*],2),1)/((2*condensekernel+1)*(2*condensekernel+1))
				    	;write information which is peculiar to this glomerulus
				    ArrayNumInfos[0,glo] = fix(tempres[2,glo])
				    ArrayTxtInfos[0,glo] = 'Coor'+strtrim(string(x),2)+':'+strtrim(string(y),2) ;gives the coordinates
				    ArrayNumInfos[14,glo] = i ; layer/odor
				ENDIF
			ENDFOR; glo

			openw, unit, filename, /get_lun ,/append
			IF (p1.frames gt 3000) THEN BEGIN
				ArrayGloTraces = congrid(ArrayGloTraces,3000,GlomeruliNum,/interp)
				shrinkFrames = p1.frames
				p1.frames = 3000
				print, 'WARNING in exportGlomeruli!!! Frames artificially reduced to 3000'
			ENDIF
			FOR J = 0, GlomeruliNum-1 DO BEGIN
				 printf,unit, ArrayNumInfos(*,j),ArrayTxtInfos(*,j), ArrayGloTraces(*,j), $
				 	FORMAT='((I,'+strtrim(string(numinfos-1),2)+'("' + string(9b) + '",I)),('+strtrim(string(txtinfos),2)+'("' + string(9b) + '",A)),('+ strtrim(string(p1.frames),2) + '("' + string(9b) + '",F8.3)))'
			ENDFOR

			free_lun, unit

		ENDIF
	ENDFOR
ENDIF

END


