

;/////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
PRO Traces_event,event
COMMON SHOW_TRACES
COMMON WINDOW_IDS
COMMON ALL
COMMON CTVS

widget_control,event.id,get_uvalue=widget

IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN DestroyWindow,"Traces" ELSE BEGIN


	if (widget eq 'save_Traces') then begin
		SaveTraces
	endif

	if (widget eq 'change_min_y_val') THEN BEGIN
		widget_control,event.id,get_value=temp
		IF float(temp) GT max_y_val THEN BEGIN
			min_y_val=max_y_val-1
			widget_control,event.id,set_value=max_y_val-1
		ENDIF ELSE BEGIN
			min_y_val=temp
		ENDELSE
	ENDIF

	IF (widget EQ 'GenTraces') THEN BEGIN
		;refreshtraces,-1,-1,-1,1
		refreshtraces,-1,-1,-1,0
	ENDIF

	IF (widget EQ 'ZoomIn') THEN BEGIN
		panelsize=fix(panelsize*1.2)
		;refreshtraces,-1,-1,-1,1
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF

	IF (widget EQ 'ZoomOut') THEN BEGIN
		panelsize=fix(panelsize/1.2)
		;refreshtraces,-1,-1,-1,1
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF

	IF (widget eq 'change_max_y_val') THEN BEGIN
		widget_control,event.id,get_value=temp
		IF float(temp) LT min_y_val THEN BEGIN
			max_y_val=min_y_val+1
			widget_control,event.id,set_value=min_y_val+1
		ENDIF ELSE BEGIN
			max_y_val=temp
		ENDELSE
	ENDIF

	IF (widget eq 'ControlLine') THEN BEGIN
		widget_control,event.id,get_value=temp
		ControlLine=temp
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF

	IF (widget eq 'draw_legend') THEN BEGIN
		IF event.press EQ 1 THEN BEGIN
			x=event.x
			y=event.y
			;print,x,y
			xpos=where(legend_entry_positions[0,*] GT x-30 AND legend_entry_positions[0,*] LT x+30)
			ypost=where(legend_entry_positions[1,*] GT y-30 AND legend_entry_positions[1,*] LT y+30)
			temp=CompareArrays(xpos,ypost)
			IF temp.a[0] NE -1 AND xpos[0] NE -1 AND ypost[0] NE -1 THEN BEGIN
				pos=xpos[temp.a]
				black=legend_entry_names[pos]
				IF string(blacklist[0]) NE 'Empty' THEN BEGIN
					pos=WHERE(blacklist EQ black[0])
					IF pos[0] NE -1 THEN BEGIN
						IF N_ELEMENTS(blacklist) EQ 1 THEN blacklist='Empty' ELSE BEGIN
							if pos[0] EQ 0 THEN BEGIN
								blacklist=blacklist[1:*]
							ENDIF ELSE BEGIN
								IF pos[0] EQ N_ELEMENTS(blacklist)-1 THEN BEGIN
									blacklist=blacklist[0:n_elements(blacklist)-2]
								ENDIF ELSE BEGIN
									IF pos[0] NE 0 AND pos[0] NE N_ELEMENTS(blacklist)-1 THEN BEGIN
										temp=blacklist[0:pos[0]-1]
										blacklist=[temp,blacklist[pos[0]+1:*]]
									ENDIF
								ENDELSE
							ENDELSE
						ENDELSE
					ENDIF ELSE blacklist=[blacklist,black]
				ENDIF ELSE blacklist=black
				;print,blacklist
				refreshtraces,-1,-1,-1,0
				refreshmeanwid
			ENDIF
		ENDIF
	ENDIF
	IF (widget EQ 'draw_measurements') THEN BEGIN
		IF event.press EQ 1 THEN BEGIN
			y=event.y
			x=event.x
			xpos=where(measurements_entry_positions[0,*] GT x-30 AND measurements_entry_positions[0,*] LT x+30)
			ypost=where(measurements_entry_positions[1,*] GT y-30 AND measurements_entry_positions[1,*] LT y+30)
			temp=CompareArrays(xpos,ypost)
			IF temp.a[0] NE -1 AND xpos[0] NE -1 AND ypost[0] NE -1 THEN BEGIN
				pos=xpos[temp.a]
				measurement=pos[0]
				IF string(showlist[0]) NE 'Empty' THEN BEGIN
					pos=WHERE(showlist EQ measurement[0])
					IF pos[0] NE -1 THEN BEGIN
						IF N_ELEMENTS(showlist) EQ 1 THEN showlist='Empty' ELSE BEGIN
							if pos[0] EQ 0 THEN BEGIN
								showlist=showlist[1:*]
							ENDIF ELSE BEGIN
								IF pos[0] EQ N_ELEMENTS(showlist)-1 THEN BEGIN
									showlist=showlist[0:n_elements(showlist)-2]
								ENDIF ELSE BEGIN
									IF pos[0] NE 0 AND pos[0] NE N_ELEMENTS(showlist)-1 THEN BEGIN
										temp=showlist[0:pos[0]-1]
										showlist=[temp,showlist[pos[0]+1:*]]
									ENDIF
								ENDELSE
							ENDELSE
						ENDELSE
					ENDIF ELSE showlist=[showlist,measurement]
				ENDIF ELSE showlist=measurement
				refreshtraces,-1,-1,-1,0
				refreshmeanwid
			ENDIF
		ENDIF
	ENDIF


	IF (widget EQ 'NoGloms') THEN BEGIN
		tempres=reform(coordinates[2,*,0])
		FOR I=1,MAX(parameters[*].messungszahl) DO BEGIN
			tempres=[tempres,reform(coordinates[2,*,I])]
		ENDFOR
		pos=WHERE(tempres NE '-1000')
		IF pos[0] NE -1 THEN tempres=tempres[pos]
		pos=WHERE(tempres NE '')
		IF pos[0] NE -1 THEN tempres=tempres[pos]
		blacklist=tempres[UNIQ(tempres, SORT(tempres))]

		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF
	IF (widget EQ 'AllGloms') THEN BEGIN
		blacklist='Empty'
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF
	IF (widget EQ 'NoMeas') THEN BEGIN
		showlist='Empty'
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF
	IF (widget EQ 'AllMeas') THEN BEGIN
		temp=indgen(N_ELEMENTS(parameters))
		showlist=showsequence[temp]
		refreshtraces,-1,-1,-1,0
		refreshmeanwid
	ENDIF

ENDELSE
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
FUNCTION GetColVal,ColorName
rgb=intarr(3)
CASE ColorName OF
	'White':	rgb=[255,255,255]
	'Ivory':	rgb=[255,255,160]
	'Black':	rgb=[0,0,0]
	'Red':		rgb=[255,0,0]
	'lRed':		rgb=[255,42,0]
	'Orange':	rgb=[255,76,0]
	'lOrange':	rgb=[255,161,0]
	'Yellow':	rgb=[255,233,0]
	'lYellow':	rgb=[255,255,0]
	'mGreen':	rgb=[76,255,0]
	'lmGreen':	rgb=[161,255,0]
	'dGreen':	rgb=[0,255,0]
	'ldGreen':	rgb=[0,255,76]
	'Cyan':		rgb=[0,216,255]
	'lCyan':	rgb=[0,255,255]
	'mBlue':	rgb=[0,42,255]
	'lmBlue':	rgb=[0,127,255]
	'dBlue':	rgb=[60,0,214]
	'ldBlue':	rgb=[43,0,236]
	'Violett':	rgb=[69,0,77]
	'lViolett':	rgb=[87,0,150]
	'Grey':		rgb=[90,90,90]
	'lGrey':	rgb=[180,180,180]
	'vGrey':	rgb=[210,210,210]
	'lvGrey':	rgb=[225,225,225]
	ELSE:		rgb=[0,0,0]
ENDCASE

val=long(rgb[2])*256L*256L+long(rgb[1])*255L+long(rgb[0])
return,val
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
FUNCTION GlomerulusToColor,glom
ColorName=''
secColorName=''
linetype=0
CASE glom OF
	301: BEGIN
		 	ColorName='dBlue'
		 	secColorName='ldBlue'
		 	linetype=0
		 END
	302: BEGIN
			ColorName='mGreen'
			secColorName='lmGreen'
			linetype=0
		END
	303: BEGIN
			ColorName='Red'
			secColorName='lRed'
			linetype=0
		END
	304: BEGIN
			ColorName='Orange'
			secColorName='lOrange'
			linetype=0
		END
	305: BEGIN

			ColorName='Cyan'
			secColorName='lCyan'
			linetype=0
		END
	306: BEGIN
			ColorName='Grey'
			secColorName='lGrey'
			linetype=0
		END
	307:BEGIN
			ColorName='mBlue'
			secColorName='lmBlue'
			linetype=0
		END
	308: BEGIN
			ColorName='Yellow'
			secColorName='lYellow'
			linetype=0
		END
	309:	BEGIN
			ColorName='dGreen'
			secColorName='ldGreen'
			linetype=0
		END
	310:	BEGIN
			ColorName='Violett'
			secColorName='lViolett'
			linetype=0
		END
	311: BEGIN
			ColorName='Black'
			secColorName='Ivory'
			linetype=0
		END
	312:	BEGIN
			ColorName='mBlue'
			secColorName='lmBlue'
			linetype=1
		END
	313:	BEGIN
			ColorName='mGreen'
			secColorName='lmGreen'
			linetype=1
		END
	314:	BEGIN
			ColorName='Red'
			secColorName='lRed'
			linetype=1
		END
	315:	BEGIN
			ColorName='Orange'
			secColorName='lOrange'
			linetype=1
		END
	316:	BEGIN
			ColorName='Cyan'
			secColorName='lCyan'
			linetype=1
		END
	317:	BEGIN
			ColorName='Grey'
			secColorName='lGrey'
			linetype=1
		END
	318:	BEGIN
			ColorName='dBlue'
			secColorName='ldBlue'
			linetype=1
		END
	319:	BEGIN
			ColorName='Yellow'
			secColorName='lYellow'
			linetype=1
		END
	320:	BEGIN
			ColorName='dGreen'
			secColorName='ldGreen'
			linetype=1
		END
	321:	BEGIN
			ColorName='Violett'
			secColorName='lViolett'
			linetype=1
		END
	1000:Begin
			ColorName='vGrey'
			secColorNmae='lvGrey'
			linetype=1
		END
	ELSE: BEGIN
			ColorName='Black'
			secColorName='White'
			linetye=2
		END
ENDCASE
a={primColor:GetColVal(ColorName),secColor:GetColVal(secColorName),linetype:linetype}
return,a
END

;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
PRO refreshmeanwid
COMMON ALL
COMMON CTVS
COMMON WINDOW_IDS
COMMON WIDGET_IDS
COMMON SHOW_TRACES
Device, Decomposed=1
IF MAX(fix(coordinates[0,*,*])) NE -1000 AND string(showlist[0]) NE 'Empty'THEN BEGIN
	tempres=reform(coordinates[2,*,0])
	FOR I=1,MAX(parameters[*].messungszahl) DO BEGIN
		tempres=[tempres,reform(coordinates[2,*,I])]
	ENDFOR
	pos=WHERE(tempres NE '-1000')
	IF pos[0] NE -1 THEN tempres=tempres[pos]
	pos=WHERE(tempres NE '')
	IF pos[0] NE -1 THEN tempres=tempres[pos]
	CoorsList=tempres[UNIQ(tempres, SORT(tempres))]
	coor_num=n_elements(CoorsList)
	widget_control,traces_mean_wid,draw_xsize=resolution[0]/3+20,draw_ysize=panelsize
	widget_control,traces_mean_wid,get_value=winnum
	wset,winnum
	light=intarr(resolution[0]/3+20,panelsize)
	light[*]=255
	tv,light

	mea_num=n_elements(parameters)
	numframes=lastframes[showlist[0]+1]-lastframes[showlist[0]]
	curve=fltarr(numframes)
	curve[*]=0.0

	PLOT,curve,YRANGE=[min_y_val,max_y_val],THICK=1.5,/NODATA,color=0,background=FSC_COLOR("White", !D.Table_Size-3)
	oplot,curve,linestyle=1,THICK=1.5,COLOR=0
	stimon=parameters[showlist[0]].stimulus_on
	stimoff=parameters[showlist[0]].stimulus_end
	x=[stimon,stimoff,stimoff,stimon]
	y=[max_y_val,max_y_val,min_y_val,min_y_val]
	POLYFILL,x,y,color=FSC_COLOR("Grey", !D.Table_Size-4)
	l=0
	FOR I=0, coor_num-1 DO BEGIN
		glom_name=strtrim(CoorsList[I],2)
		pos=WHERE(blacklist EQ glom_name)
		; Hier wird geprft ob der Glomerulus gezeigt werden soll
		IF pos[0] EQ -1 THEN BEGIN
			FOR J=0,mea_num -1 DO BEGIN
				l=showsequence[j]
				pos=WHERE(showlist EQ l)
				; Hier wird geprft ob die Messung gezeigt werden soll
				IF pos[0] NE -1 THEN BEGIN
					tempres=coordinates[*,*,parameters[l].messungszahl]
					pos=WHERE(strtrim(tempres[2,*],2) EQ glom_name)
					pos=pos[0]
					; Hier wird geprft, ob der Glomerulus in dieser Messung gefunden wurde
					IF pos NE -1 THEN BEGIN
						temp=data[*,*,lastframes[l]:lastframes[l+1]-1]
						Dims=SIZE(temp)
						doit=1
						IF numframes EQ 0 THEN  numframes=dims[3] ELSE BEGIN
							IF numframes NE dims[3] THEN doit=0
						ENDELSE
						; Er wurde gefunden und zwar auch in Sinnvoller Position und diese Messung hat dieselbe Anzahl an Frames wie die erste
						IF fix(tempres[0,pos]) gt 0 AND fix(tempres[0,pos]) lt Dims[1] AND fix(tempres[1,pos]) gt 0 AND fix(tempres[1,pos]) lt Dims[2] AND doit EQ 1 THEN BEGIN
							x_start=fix(tempres[0,pos])-condensekernel
							x_end=fix(tempres[0,pos])+condensekernel
							y_start=fix(tempres[1,pos])-condensekernel
							y_end=fix(tempres[1,pos])+condensekernel
							IF x_start LT 0 THEN x_start=0
							IF x_end GT Dims[1]-1 THEN x_end=Dims[1]-1
							IF y_start LT 0 THEN y_start=0
							IF y_end GT Dims[2]-1 THEN y_end=Dims[2]-1
							temp=total(total(temp[x_start:x_end,y_start:y_end,*],2),1)/((2*condensekernel+1)*(2*condensekernel+1))
							curve=[curve,temp]
						ENDIF
					ENDIF
				ENDIF
			ENDFOR
			IF N_ELEMENTS(CURVE) NE numframes THEN BEGIN
				curve=curve[numframes:*]
				number_of_meas=N_ELEMENTS(curve)/numframes
				a=glomerulustocolor(fix(glom_name))
				temp=reform(curve,numframes,number_of_meas)
				IF number_of_meas GT 1 THEN BEGIN
					mean_curve=fltarr(numframes)
					error_curve=fltarr(numframes)
					FOR k=0,numframes-1 DO BEGIN
						mean_curve[k]=mean(temp[k,*])
						error_curve[k]=stddev(temp[k,*])/sqrt(numframes)
					ENDFOR
					upper=mean_curve+error_curve
					lower=mean_curve-error_curve

					x=indgen(numframes)
					x=[x,reverse(x)]
					y=[lower,reverse(upper)]


					POLYFILL,x,y,color=a.seccolor
				ENDIF ELSE mean_curve=curve
				oplot,mean_curve,THICK=1.5,color=a.primcolor,linestyle=a.linetype
				IF ControlLine NE 0 THEN BEGIN
					ctrlLine=fltarr(numframes)
					ctrlLine[*]=ControlLine
					oplot,fltarr(2)+ctrlLine,linestyle=0,THICK=2,COLOR=0,!y.crange
				ENDIF
				curve=fltarr(numframes)
			ENDIF

		ENDIF
	ENDFOR
	oplot,curve,linestyle=1,THICK=1.5,COLOR=0
ENDIF

END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////
;/////////
PRO refreshtraces,x_pos,y_pos,measurement,onlylegend
COMMON ALL
COMMON CTVS
COMMON WINDOW_IDS
COMMON WIDGET_IDS
COMMON SHOW_TRACES
device,decomposed=1
	IF MAX(fix(coordinates[0,*,*])) NE -1000 THEN BEGIN
		ArrayDims=SIZE(Data)
		!p.charsize=3
			IF measurement EQ -1 THEN BEGIN
				tempres=reform(coordinates[2,*,0])
				FOR I=1,MAX(parameters[*].messungszahl) DO BEGIN
					tempres=[tempres,reform(coordinates[2,*,I])]
				ENDFOR
				pos=WHERE(tempres NE '-1000')
				IF pos[0] NE -1 THEN tempres=tempres[pos]
				pos=WHERE(tempres NE '')
				IF pos[0] NE -1 THEN tempres=tempres[pos]
				tempres=tempres[UNIQ(tempres, SORT(tempres))]
				coor_num=n_elements(tempres)
				legend_entry_positions=intarr(2,coor_num)
				legend_entry_names=strarr(coor_num)
				number_rows_legend=coor_num/8+1
				widget_control,traces_legend_id,draw_xsize=resolution[0]/3,draw_ysize=number_rows_legend*35
				widget_control,traces_legend_id,get_value=winnum
				wset,winnum
				column=0
				row=0
				light=intarr(resolution[0]/3,number_rows_legend*35)
				light[*]=255
				tv,light

				FOR I=0, coor_num-1 DO BEGIN
					IF column gt 7 THEN column=0
					row=i /8
					xpos=column*50+10
					ypos=row*30+10
					glom=strtrim(tempres[i],2)
					a=glomerulustocolor(fix(glom))
					;PLOTS,[xpos-3,xpos+17],[ypos+7,ypos+7],COLOR=a.primcolor,/DEVICE,THICK=2,linestyle=a.linetype
					xyouts,xpos+10,ypos,glom,/DEVICE,CHARSIZE=1.5,CHARTHICK=1,ALIGNMENT=0.0,COLOR=a.primcolor
					legend_entry_positions[*,i]=[xpos+35,ypos]
					legend_entry_names[i]=glom
					column=column+1
				ENDFOR


				; Now Comes the Measurements legend
				mea_num=n_elements(parameters)
				number_rows_legend=(mea_num/4)+1
				widget_control,traces_measurements_id,draw_xsize=resolution[0]/3,draw_ysize=number_rows_legend*35
				widget_control,traces_measurements_id,get_value=winnum
				wset,winnum
				column=0
				row=0
				light=intarr(resolution[0]/3,number_rows_legend*35)
				light[*]=255
				tv,light
				measurements_entry_positions=intarr(2,mea_num)
				FOR I=0, mea_num-1 DO BEGIN
					IF column gt 3 THEN column=0
					row=i /4
					xpos=column*70
					ypos=row*35+10
					pos=i MOD 6
					;PLOTS,[xpos-3,xpos+15],[ypos+7,ypos+7],COLOR=col,/DEVICE,THICK=3,linestyle=glom_colors[1,pos]
					xyouts,xpos,ypos,strtrim(strmid(string(i),2)+"_"+odorlist[i]),/DEVICE,CHARSIZE=1,CHARTHICK=1.2,ALIGNMENT=0.0,COLOR=0
					measurements_entry_positions[*,i]=[xpos+35,ypos]
					column=column+1
				ENDFOR
			ENDIF
			IF measurement EQ -1 AND OnlyLegend EQ 0 THEN BEGIN
				no_measu=float(N_ELEMENTS(showlist))
				widget_control,traces_scroll_id,draw_xsize=resolution[0]/3+20,draw_ysize=(no_measu)*panelsize
				widget_control,traces_scroll_id,get_value=winnum
				wset,winnum
				ArrayDims=SIZE(data)

				!P.multi=[0,0,fix(no_measu)]
				IF string(showlist[0]) NE 'Empty' THEN BEGIN
					FOR show=0,no_measu-1 DO BEGIN
						i=showsequence[showlist[show]]
						tempres=coordinates[*,*,parameters[i].messungszahl]
						pos=where(tempres[0,*] NE '-1000')
						IF pos[0] NE -1 THEN BEGIN
							tempres=tempres[*,pos]
							coor_num=n_elements(tempres[0,*])
							temp=data[*,*,lastframes[i]:lastframes[i+1]-1]
							Dims=SIZE(temp)
							IF string(maskimage[0]) NE 'Empty' THEN BEGIN
								FOR J=0,Dims[3]-1 DO temp[*,*,J]=temp[*,*,J]*maskimage
							ENDIF
							curve=fltarr(dims[3])
							header=odorlist[i]+'   '+string(i)
							PLOT,curve,YRANGE=[min_y_val,max_y_val],THICK=1.5,/NODATA,TITLE=header,color=0,background=FSC_COLOR("White", !D.Table_Size-3)
							stimon=parameters[i].stimulus_on
							stimoff=parameters[i].stimulus_end
							x=[stimon,stimoff,stimoff,stimon]
							y=[max_y_val,max_y_val,min_y_val,min_y_val]
							POLYFILL,x,y,color=FSC_COLOR("Grey", !D.Table_Size-4)

							FOR j=0, coor_num -1 do begin
								glom_name=strtrim(tempres[2,j],2)
								pos=WHERE(blacklist EQ glom_name)
								IF pos[0] EQ -1 THEN BEGIN
									IF fix(tempres[0,j]) gt 0 AND fix(tempres[0,j]) lt ArrayDims[1] AND fix(tempres[1,j]) gt 0 AND fix(tempres[1,j]) lt ArrayDims[2] then BEGIN
										x_start=fix(tempres[0,j])-condensekernel
										x_end=fix(tempres[0,j])+condensekernel
										y_start=fix(tempres[1,j])-condensekernel
										y_end=fix(tempres[1,j])+condensekernel
										IF x_start LT 0 THEN x_start=0
										IF x_end GT Dims[1]-1 THEN x_end=Dims[1]-1
										IF y_start LT 0 THEN y_start=0
										IF y_end GT Dims[2]-1 THEN y_end=Dims[2]-1
										curve=total(total(temp[x_start:x_end,y_start:y_end,*],2),1)/((2*condensekernel+1)*(2*condensekernel+1))
										a=glomerulustocolor(fix(glom_name))
										oplot,curve,THICK=1.5,color=a.primcolor,linestyle=a.linetype
									ENDIF
								ENDIF
							endfor;
							zero=fltarr(ArrayDims[3])
							zero[*]=0
							oplot,zero,linestyle=1,THICK=1.5,COLOR=0
							IF ControlLine NE 0 THEN BEGIN
								ctrlLine=fltarr(ArrayDims[3])
								ctrlLine[*]=ControlLine
								oplot,fltarr(2)+ctrlLine,linestyle=0,THICK=2,COLOR=0,!y.crange
							ENDIF
						ENDIF
					ENDFOR
				ENDIF ELSE BEGIN
					light=intarr(resolution[0]/3+20,(no_measu)*panelsize)
					light[*]=255
					tv,light
				ENDELSE
				!P.multi=0
			ENDIF
		ENDIF
!p.charsize=0
END
;//////////////////////////////////////////////////////////////////////////////////////////////////////////



PRO SaveTraces
	common ALL
	filename=DIALOG_PICKFILE(/write,FILTER=['*.gloDataMix','*.MySQL'],PATH=sapath,FILE=fn,DEFAULT_EXTENSION='*.gloDataMix')
	IF strpos(filename,'MySQL') NE -1 THEN BEGIN
		SaveMySQL,filename,'FuraDextran','PN'
	ENDIF
	IF strpos(filename,'gloDataMix') NE -1 THEN BEGIN
		SaveGloDataMix,filename,'FuraDextran','PN'
		sapath=file_dirname(filename)
	ENDIF


END

PRO Traces,base
COMMON ALL
COMMON CTVS
COMMON WIDGET_IDS
COMMON SHOW_TRACES
COMMON Window_IDS
Device, Decomposed=1

;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
;//////////////   Measurements widget      ////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////////////////////////////////////
subdir='\bitmaps\'
Traces_base=widget_base(column=1,title="Traces",mbar=mbar,GROUP_LEADER=base,/TLB_KILL_REQUEST_EVENTS)
traces_buttons=widget_base(Traces_base,row=1)
subdir='\bitmaps\'
file=working_dir+subdir+'save.bmp'
traces_save=widget_button(traces_buttons,value=file,uvalue='save_Traces',/bitmap)
min_y_val_label=widget_label(traces_buttons,value='Minimum')
min_y_val_text=widget_text(traces_buttons,value=string(min_y_val),uvalue='change_min_y_val',/editable,xsize=7)
max_y_val_label=widget_label(traces_buttons,value='Maximum')
max_y_val_text=widget_text(traces_buttons,value=string(max_y_val),uvalue='change_max_y_val',/editable,xsize=7)

Control_line_label=widget_label(traces_buttons,value='Control line')
Control_line_text=widget_text(traces_buttons,value=string(ControlLine),uvalue='ControlLine',/editable,xsize=7)
traces_generate=widget_button(traces_buttons,value='Make traces',uvalue='GenTraces')
traces_bigger=widget_button(traces_buttons,value='ZoomIn',uvalue='ZoomIn')
traces_smaller=widget_button(traces_buttons,value='ZoomOut',uvalue='ZoomOut')
traces_showG=widget_button(traces_buttons,value='AllGloms',uvalue='AllGloms')
traces_hideG=widget_button(traces_buttons,value='NoGloms',uvalue='NoGloms')
traces_showM=widget_button(traces_buttons,value='AllMeas',uvalue='AllMeas')
traces_hideM=widget_button(traces_buttons,value='NoMeas',uvalue='NoMeas')
traces_draw_base=widget_base(traces_base,row=1)
traces_draw_base1=widget_base(traces_draw_base,col=1)

;traces_sec_base=widget_base(traces_base,row=1)
Framebase1=widget_base(traces_draw_base1,row=1,FRAME=1)
traces_legend_wi=widget_draw(Framebase1,uvalue='draw_legend',RETAIN=1,/button_events)
Framebase2=widget_base(traces_draw_base1,row=1,FRAME=1)
traces_measurements=widget_draw(Framebase2,uvalue='draw_measurements',RETAIN=1,/button_events)
Together_Draw=widget_draw(traces_draw_base1,uvalue='together_draw',RETAIN=1,/button_events,xsize=resolution[0]/3)
traces_scroll=widget_draw(traces_draw_base,xsize=resolution[0]/3,ysize=(resolution[1]-200),x_scroll_size=resolution[0]/3,y_scroll_size=(resolution[1]-100),uvalue='traces_scroll',RETAIN=1,/SCROLL)



traces_mean_wid=Together_Draw
traces_scroll_id=traces_scroll
traces_legend_id=traces_legend_wi
traces_measurements_id=traces_measurements
elements=45
colortable=lonarr(elements)
linetype=lonarr(elements)
j=0
value=255

Traces_ID=traces_base

widget_control,traces_base,/realize,XOFFSET=0,YOFFSET=0
xmanager,'Traces',traces_base,/no_block
END