function fline, repetitionArr, formatArr
;gives fortran-style output line with tabulators
;call: formatline = fline([3,5,3,4],['I','A','F8.3','A'] for 3 integers, 5 chars, 3 floats, 4 chars



numRep = n_elements(repetitionArr) ; HOW MANY different entries
outputline = '('+formatArr(0) ;e.g. '(I'



;add remaining entries for first set

IF repetitionArr(0) gt 1 then begin
	outputLine = outputLine + ',' + strtrim(string(repetitionArr(0)-1),2)+'("' + string(9b) + '",' + formatArr(0) + ')'
endIF



;add other sets

IF numRep gt 1 then begin
	for i=1,numRep-1 do begin
		outputLine = outputLine + ',' + strtrim(string(repetitionArr(i)),2)+'("' + string(9b) + '",' + formatArr(i) + ')'
	endFor
endIF



;add closing bracket

outputline = outputline + ')'
return, outputline



end