
run('../init');

clb = [.8,.8,.8];
cl1 = [0,0,0]; cl2 = [0.5,0.5,0.5]; cl3 = [1,0.5,0];
             
cl11 = cl1;
cl22 = cl2;
cl12 = cl3;

fs = 17.5;

r2s = [];

reg = 'VISp';

%% -
for dsi = 1:2
    
    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        nm = 10*3;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        nm = 10;
    end

    cnt_more = 0;
    
    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type)
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end

    N_sessions = length(session_ids);
    N_rep = 2;
    
    %%
    
    ppl_diff = [];
    zz11_m = []; zz22_m = []; zz12_m = []; zz312_m = [];
    cc11_m = []; cc22_m = []; cc12_m = [];
    zz1_all = []; zz2_all = []; zz3_all = []; 
    zz21_all = []; zz22_all = [];
    cnt = 0;
    
    yreg_all = []; r2_all = [];
    
    xcol_cnt = 1;
    
    for sessi = 1:N_sessions
        session_id = session_ids{sessi};
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        ppw_z = (ppw - nanmean(ppw(:)))/nanstd(ppw(:));
        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
                
        reg_un = unique(unit_regs); 
        
        if strcmp(reg, 'all')
            unids = 1:size(act,1);
        else
            unids = find(ismember(unit_regs, reg));
        end
        
        if length(unids) > 40 && (size(act,2) == N_rep*nm) && (sum(isnan(ppw(:)))<prod(size(ppw)))
            cnt = cnt+1;

            z_act = permute(act(unids,:,:),[2,3,1]);                
            z_act_r = reshape(z_act, size(z_act,1), []);

            cc_all = corrcoef(z_act_r', 'Rows', 'complete');
            cc_all(eye(length(cc_all))==1)=nan;

            avg_beh1 = nanmean(ppw,2);
            avg_beh2 = nanmean(spd,2);
            
            diff_beh1 = nan*zeros(N_rep*nm);
            diff_beh2 = nan*zeros(N_rep*nm);
            sum_beh1 = nan*zeros(N_rep*nm);
            for i = 1:N_rep*nm
                for j = 1:N_rep*nm
                    diff_beh1(i,j) = (avg_beh1(i) - avg_beh1(j))/nanmean(avg_beh1(:));
                    diff_beh2(i,j) = (avg_beh2(i) - avg_beh2(j));
                    sum_beh1(i,j) = avg_beh1(i);
                end
            end

            mids1 = 1:nm; 
            mids2 = nm+1:2*nm;

            zz2 = cc_all;
            zz1 = abs(diff_beh1);
            zz3 = abs(diff_beh2);

            zz1_all = [zz1_all; reshape(zz1, 1,[])];
            zz2_all = [zz2_all; reshape(zz2, 1,[])];
            zz21_all = [zz21_all; reshape(zz2(mids1,mids1),1,[])];
            zz22_all = [zz22_all; reshape(zz2(mids2,mids2),1,[])];
            zz3_all = [zz3_all; reshape(zz3, 1,[])];

            zz11_m = [zz11_m, nanmean(nanmean(zz1(mids1,mids1)))];
            cc11_m = [cc11_m, nanmean(nanmean(zz2(mids1,mids1)))];

            zz22_m = [zz22_m, nanmean(nanmean(zz1(mids2,mids2)))];
            cc22_m = [cc22_m, nanmean(nanmean(zz2(mids2,mids2)))];

            zz12_m = [zz12_m, nanmean(nanmean(zz1(mids1,mids2)))];
            cc12_m = [cc12_m, nanmean(nanmean(zz2(mids1,mids2)))];
   
        end
            
    end

%% - summary

% - all data points
myz1 = zz1_all;
myz2 = zz2_all;
myz3 = zz3_all;

myz1_r = reshape(myz1, 1,[]);
myz2_r = reshape(myz2, 1,[]);
myz3_r = reshape(myz3, 1,[]);

figure('Position',[100,100,300,300])
subplot(111); hold on
plot(myz1, myz2, '.', 'MarkerSize',3,'color', [.7,.7,.7])

r2s{dsi} = zeros(1,size(myz1,1));
for i = 1:size(myz1,1)
    [r2s{dsi}(i), m] = my_regress(myz1(i,:), myz2(i,:), 'r', [.9,.15],0);
end

[r2, m] = my_regress(myz1_r, myz2_r, 'r', [.9,.95]);

pids = logical(myz3_r>prctile(myz3_r,80));

[r2p, m] = my_regress(myz1_r(pids), myz2_r(pids), 'k', [.9,.9]);

zz1 = [reshape(zz21_all,1,[]), reshape(zz22_all,1,[])];
[r2w, m] = my_regress(myz1_r(pids), myz2_r(pids), [.7,.7,.7], [.9,.8]);

ylim([0.3, 1])
xlim([-.1/4,1.2])

xlabel('|\Delta pupil width|')
ylabel('Repres. sim.')

set(gca, 'LineWidth', 1, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.025,.025])

print([reg '__repDrift_ppl_all_' session_type '.png'], '-dpng', '-r300');

% - average across mice
figure('Position',[100,100,300,300])

subplot(111);
hold on

h1=plot(zz11_m, cc11_m, 'o', 'color', cl11, 'LineWidth',2, 'MarkerSize',7);

h2=plot(zz22_m, cc22_m, 'o', 'color', cl22, 'LineWidth',2, 'MarkerSize',7);

h3=plot(zz12_m, cc12_m, 'o', 'color',cl12, 'LineWidth',2, 'MarkerSize',7);

x = [zz11_m, zz22_m, zz12_m]';
y = [cc11_m, cc22_m, cc12_m]';
yl = 0.9/2;
[r2, m] = my_regress(x', y', 'r', [yl,.9]);

x = [zz11_m, zz22_m]';
y = [cc11_m, cc22_m]';
[r2, m] = my_regress(x', y', [.7,.7,.7], [yl,.85]);


ylim([0.3,1]);

if strcmp(session_type, 'functional_connectivity')
    text(.2,1,['N = ' num2str(cnt)], 'FontSize',17.5)
elseif strcmp(session_type, 'brain_observatory_1.1')
    text(.2,1,['N = ' num2str(cnt)], 'FontSize',17.5)
end

xlabel('Avg. |\Delta pupil width|')
ylabel('Avg. repres. sim.')

set(gca, 'LineWidth', 1, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.025,.025])

print([reg '__repDrift_ppl_avg_' session_type '.png'], '-dpng', '-r300');

end

