
run('../init');

cls = {'b', 'r'};

reg = 'VISp';

r2_all = {};
            
%% -

ccw_all = [];
ccs_all = [];
ccr_all = [];
ppw_all = [];
actm_all = [];
ccu_all = [];
r2_all = {};
m_all = {};
actm_unit_all = {};
spd_mean = {};
for dsi = 1:2
    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        L = 300*3;
        nm = 10*3;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        L = 300;
        nm = 10;
    end

    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type) 
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end

%%
    
    N_rep = 2;
    N_sessions = length(session_ids);
    l = L/nm;
    
    cnt = 0;
    
    r2_all{dsi} = [];
    
    ccw_all{dsi} = [];
    ccs_all{dsi} = [];
    ccr_all{dsi} = [];
    ppw_all{dsi} = [];
    actm_all{dsi} = [];
    ccu_all{dsi} = [];
    r2_all{dsi} = [];
    m_all{dsi} = [];
    actm_unit_all{dsi} = [];
    spd_mean{dsi} = [];
    
    xcol_cnt = 1;
    
    for sessi = 1:N_sessions
        session_id = session_ids{sessi};
       
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        ppw_z = (ppw - nanmean(ppw(:)))/nanstd(ppw(:));
        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
        
        reg_un = unique(unit_regs); 
        if strcmp(reg, 'All')
            unids = 1:size(act,1);
        else
            unids = find(ismember(unit_regs, reg));
        end
        
        if length(unids) > 40 && (size(act,2) == N_rep*nm) && (sum(isnan(ppw(:)))<prod(size(ppw))) ...
                && nanmean(spd(:)) > 0%5
            cnt = cnt+1;
            
            spd_mean{dsi} = [spd_mean{dsi}, nanmean(spd(:))];

            act_r = reshape(act, size(act,1), []);
            act_z = ((act_r' - nanmean(act_r')) ./ nanstd(act_r'))';
            act_z = reshape(act_z, size(act));
            
            z_act = permute(act_z(unids,:,:),[2,3,1]);                
            z_act_r = reshape(z_act, size(z_act,1), []);

            ccw = corr(squeeze(nanmean(act_z(unids,:,:),3))', nanmean(ppw_z,2))';
            ccw_all{dsi} = [ccw_all{dsi}, ccw];
            
            z_act_m = squeeze(nanmean(nanmean(act_z(unids,:,:),1),2));
            
            ccs = corr(squeeze(nanmean(act_z(unids,:,:),2))', z_act_m)';
            ccs_all{dsi} = [ccs_all{dsi}, ccs];
            
            ccr = corr(squeeze(nanmean(act_z(unids,:,:),1))', z_act_m)';
            ccr_all{dsi} = [ccr_all{dsi}, ccr];
             
            ppw_all{dsi} = [ppw_all{dsi}, nanmean(ppw_z,2)'];
            actm_all{dsi} = [actm_all{dsi}, squeeze(nanmean(nanmean(act_z(unids,:,:),2),3))'];
                
            actm_unit_all{dsi}{sessi} = squeeze(nanmean(act_z(unids,:,:),3));
            ppwm_all{dsi}{sessi} = nanmean(ppw_z,2);
            
            % - Stimulus reliability (CC of units' responses across repeats)
            ccus = [];
            for i = 1:length(unids)
                ccu = corr(squeeze(act(unids(i),:,:))');
                ccu(eye(length(ccu))==1)=nan;
                ccus = [ccus, nanmean(ccu(:))]; 
            end
            ccu_all{dsi} = [ccu_all{dsi},ccus];
            
        end
        
    end

end

%% - plotting the figures

fs = 17; 

for ij = 1:2
    
    figure('Position',[200,200,300,300])
    subplot(111); hold on
    
    h = scatterhist(ccu_all{ij},abs(ccw_all{ij}), 'kernel', 'on', 'Color','k', ...
        'Marker','.', 'NBins',[20,20], 'direction', 'out');
    hold on
    [rs1,m1] = my_regress(ccu_all{ij}, abs(ccw_all{ij}), cls{ij}, [.75,1.1], 1);
    xlabel('Stim. reliability')
    ylabel('|Behav. modulation|')
    xlim([0,1])
    ylim([0,1])
    set(gca, 'LineWidth', 1, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.025,.025])
    
    print(['scatter_hist_' num2str(ij) '.png'], '-dpng', '-r300');

end

% - 

bins = 0:.1:1;

figure('Position',[100,100,250,250])
hold on
my_hist(ccu_all{1}, bins, 'b');
my_hist(ccu_all{2}, bins, 'r');

legend('dataset1', 'dataset2');
legend boxoff

xlabel('Stim. reliability')
ylabel('Fraction of units (%)')

set(gca, 'LineWidth', 1, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.025,.025])

print(['CC_data_ccr_dist.png'], '-dpng', '-r300');

bins = -1:.1:1;

figure('Position',[100,100,250,250])
hold on
my_hist(ccw_all{1}, bins, 'b');
my_hist(ccw_all{2}, bins, 'r');

xlabel('Behav. modulation')
ylabel('Fraction of units (%)')

set(gca, 'LineWidth', 1, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.025,.025])

print(['CC_data_ccw_dist.png'], '-dpng', '-r300');
