
run('../init');

cls = {'b', 'r'};

reg = 'all';
    
N_rep = 2;

for dsi = 1:2
    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        L = 300*3;
        nm = 10*3;
        session_id_ex = 778998620;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        L = 300;
        nm = 10;
        session_id_ex = 759883607;
    end

    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type) 
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end

    N_sessions = length(session_ids);
    
    r2s_pc1 = []; r2s_pc2 = []; r2s_pc1_act = [];

    pc1_all = []; pc2_all = [];
    ccr_all = [];
    ppw_r_all = [];
    act_m_all = [];
    ppl_m = []; spd_m = [];
    ppl_v = []; spd_v = [];
    var_exp1 = []; var_exp2 = [];
    for sessi = 1:N_sessions
        session_id = session_ids{sessi};
       
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
        
        reg_un = unique(unit_regs); 
        
        if strcmp(reg, 'all')
            unids = 1:size(act,1);
        else
            unids = find(ismember(unit_regs, reg));
        end 
        
        if length(unids) > 40 && (size(act,2) == N_rep*nm) && (sum(isnan(ppw(:)))<prod(size(ppw)))
            
            my_act = act(unids,:,:);
            
            act_r = reshape(permute(my_act,[1,3,2]), size(my_act,1), []);
            
            act_zr = ((act_r' - nanmean(act_r')) ./ nanstd(act_r'))';
            
            ppw_r = reshape(ppw_z', 1, []);
            spd_r = reshape(spd_z', 1, []);
            
            [COEFF, SCORE, LATENT, TSQUARED, EXPLAINED] = pca(act_r);
                 
            cpc_ppw = corr(COEFF, ppw_r');
            cpc_spd = corr(COEFF, spd_r');
            
            cfr = reshape(COEFF', size(COEFF',1),size(act,3), size(my_act,2));
            
            cfr_cr = [];
            for i = 1:size(cfr,1)
                ccr = corr(squeeze(cfr(i,:,:))');
                ccr(eye(length(ccr))==1)=nan;
                cfr_cr = [cfr_cr, nanmean(ccr(:))]; 
            end
            
            
            cc_spd = corr(act_r', spd_r')';
            cc_ppw = corr(act_r', ppw_r')';
            
            
            ccus = [];
            for i = 1:size(my_act,1)
                ccu = corr(squeeze(act(i,:,:))');
                ccu(eye(length(ccu))==1)=nan;
                ccus = [ccus, nanmean(ccu(:))]; 
            end
            
            
            % --
            
            ppl_m = [ppl_m, [nanmean(ppw_r(1:length(ppw_r)/2)), nanmean(ppw_r(1+length(ppw_r)/2:end))]'];
            spd_m = [spd_m, [nanmean(spd_r(1:length(spd_r)/2)), nanmean(spd_r(1+length(spd_r)/2:end))]'];
            
            ppl_v = [ppl_v, [nanvar(ppw_r(1:length(ppw_r)/2)), nanvar(ppw_r(1+length(ppw_r)/2:end))]'];
            spd_v = [spd_v, [nanvar(spd_r(1:length(spd_r)/2)), nanvar(spd_r(1+length(spd_r)/2:end))]'];
                
            pc1_all = [pc1_all, SCORE(:,1)'/max(SCORE(:,1))];
            pc2_all = [pc2_all, SCORE(:,2)'/max(SCORE(:,2))];
            ccr_all = [ccr_all, ccus];
               
            var_exp1 = [var_exp1, EXPLAINED(1)];
            var_exp2 = [var_exp2, EXPLAINED(2)];
           
            z1 = ccus;
            [r2, m] = my_regress(z1, SCORE(:,1)'/max(SCORE(:,1)), 'r', [1,0.1], 0);
            r2s_pc1 = [r2s_pc1, r2];
            [r2, m] = my_regress(z1, SCORE(:,2)'/max(SCORE(:,2)), 'm', [1,0], 0);
            r2s_pc2 = [r2s_pc2, r2];

        end
    end

    fs = 18;    
    
    x0 = .3;
    dx = .6;
    dy = .175;

    ax1_pos = [x0+.1/2,.725, dx-.1/2,dy];
    ax2_pos = [x0,.4, dx,dy];
    ax3_pos = [x0,.1, dx,dy];
            
    figure('Position',[100,100,250,250])
    hold on
    plot(ccr_all, pc1_all, 'k.', 'MarkerSize',1)
    
    [r2, m] = my_regress(ccr_all, pc1_all, 'k', [.75,1], 1);
    [r2, m] = my_regress(ccr_all, pc2_all, [.7,.7,.7], [.75,0.85], 1);
    
    ylabel('\color{black}{Proj. over} \color{black}{PC1} \color{black}{/} \color{gray}{PC2}')

    xlabel('Stim. reliab.')
    
    yticks([-0.5, 0, 0.5, 1])
    ylim([-0.5,1])
            
    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])

    print(['./all/' session_type '/pc_space_' reg '__11.png'], '-dpng', '-r300');
    
    %%% - 
    
   figure('Position',[100,100,250,250])
    hold on
    
    plot(r2s_pc1, 'k-o', 'MarkerSize',7, 'LineWidth',1)
    plot(r2s_pc2, '-', 'color', [.7,.7,.7], 'MarkerSize',7, 'LineWidth',1)
        
    legend('PC1', 'PC2')
    legend boxoff
    
    ylim([0,1])
    
    ylabel('R^2')
    xlabel('Mouse #')
    
    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
    
    print(['./all/' session_type '/pc_space_' reg '__12.png'], '-dpng', '-r300');
    
    %%% - 
    
    figure('Position',[100,100,250,250])
    
    hold on
    plot(var_exp1, 'k-o', 'MarkerSize',7, 'LineWidth',1)
    plot(var_exp2, '-', 'color', [.7,.7,.7], 'MarkerSize',10, 'LineWidth',1)
    
    legend('PC1', 'PC2', 'Location','best', 'numcolumns',2)
    legend boxoff
    
    ylim([0,100])
    xlim([0, length(var_exp1)+1])
    
    ylabel('% Var. explained')
    xlabel('Mouse #')
    
    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
    
    print(['./all/' session_type '/pc_space_' reg '__13.png'], '-dpng', '-r300');
    
   
end
