
run('../init');

cls = {'b', 'r'};

reg = 'VISp';

N_rep = 2;

for dsi = 1:2
    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        L = 300*3;
        nm = 10*3;
        session_id_ex = 778998620;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        L = 300;
        nm = 10;
        session_id_ex = 759883607;
    end

    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type) 
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end


    for sessi = 1
        session_id = session_id_ex
       
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
        
        reg_un = unique(unit_regs); 
        unids = find(ismember(unit_regs, reg));
                    
        if strcmp(reg, 'all')
        my_act = act(:,:,:);
        else
        my_act = act(unids,:,:);
        end

        act_r = reshape(permute(my_act,[1,3,2]), size(my_act,1), []);
        act_z = (my_act-nanmean(my_act(:))) ./nanstd(my_act(:));
        act_zr = reshape(permute(act_z,[1,3,2]), size(act_z,1), []);
        ppw_r = reshape(ppw', 1, []);
        spd_r = reshape(spd', 1, []);


        z1 = squeeze(nanmean(my_act(:,1:nm,:),3));
        z2 = squeeze(nanmean(my_act(:,1+nm:end,:),3));

        z1m = nanmean(z1,2);
        z2m = nanmean(z2,2);

        z1s = nanstd(z1')';
        z2s = nanstd(z2')';


        bins = -1:.1/2:1;

        fs = 20;

        % - 

        figure('Position',[100,100,550,250])

        sm_bw = 3;

        subplot(1,1,1)
        hold on

        plot(1:nm, nanmean(z1,1), '-o', 'color', [.7,.7,.7],  'LineWidth',2);
        h0=plot(1+nm:2*nm, nanmean(z2,1), '-o', 'color', 'k',  'LineWidth',2);

        ylabel('Avg. V1 act. (1/s)')

        ymx = max([nanmean(z1,1), nanmean(z2,1)]);
        plot([nm,nm], [0, ymx], 'k--', 'LineWidth',2);

        yyaxis right
        hold on

        h1=plot(1:2*nm, nanmean(ppw,2), '-', 'color',[0.5,0.5,0], 'LineWidth',2);
        h2=plot(1:2*nm, nanmean(spd,2), '-', 'color',[0.5,0,0.5], 'LineWidth',2);

        if dsi == 2
        legend([h0, h1,h2], {'Avg. V1 activity', 'Pupil width (cm)', 'Run. speed (cm/s)'}, 'Location','southeast')
        legend boxoff
        end

        xlim([1,2*nm])

        xlabel('Repeat #')
        ylabel('Beh. (run./pupil)')

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.01,.01], 'YColor','k')

        print(['./Examples/' session_type '_' reg '_sampleAct.png'], '-dpng', '-r300');


        % - 
        fs = 17;

        ppw_m = nanmean(ppw,2);
        spd_m = nanmean(spd,2);
        act_m = squeeze(nanmean(my_act,3));
        act_m_all = squeeze(nanmean(act,3));

        figure('Position',[100,100,300,300])

        subplot(111); hold on
        plot(ppw_m(1:nm), nanmean(act_m(:,1:nm),1), 'o', ...
            'MarkerSize',10, 'MarkerEdgeColor',[.7,.7,.7], 'LineWidth',1)
        plot(ppw_m(1+nm:end), nanmean(act_m(:,1+nm:end),1), 'o', ...
            'MarkerSize',10, 'MarkerEdgeColor','k', 'LineWidth',1)

        xlabel('Pupil width (cm)')
        ylabel('Avg. V1 act. (1/s)')

        xlim([10,70])
        ylim([0,15])

        yyaxis right
        plot(ppw_m(1:nm), spd_m(1:nm), 'o', 'MarkerSize',7, 'MarkerEdgeColor',[0.5,0,0.5], 'LineWidth',1)
        plot(ppw_m(1+nm:end), spd_m(1+nm:end), 'o', 'MarkerSize',7, 'MarkerEdgeColor',[0.5,0,0.5], 'LineWidth',1)

        xlabel('Pupil width (cm)')
        ylabel('Run. speed (cm/s)')

        ylim([0,80])

        set(gca, 'LineWidth', 1.5, 'FontSize', 20, 'YColor', [0.5,0,0.5])%, 'TickDir', 'out', 'TickLength',[.01,.01])

        print(['./Examples/' session_type '_' reg '_pplRunAct.png'], '-dpng', '-r300');


        % - cell-wise analysis

        fs = 17;

        figure('Position',[100,100,300,300])
        subplot(111); title('Avg. act. (1/s)', 'FontWeight','normal');
        hold on
        plot(z1m, z2m, 'ko', 'LineWidth',1)
        axis image
        plot([0.1,100], [0.1,100], 'r--', 'LineWidth',2)
        xlabel('1st block')
        ylabel('2nd block')
        xticks([0.1,1,10,100])
        xticklabels([0.1,1,10,100])
        yticks([0.1,1,10,100])
        yticklabels([0.1,1,10,100])
        set(gca, 'XScale', 'log', 'YScale', 'log')
        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])

        print(['./Examples/' session_type '_' reg '_ActAvg_2ndV1st.png'], '-dpng', '-r300');


        %%% -

        fs = 20;

        ccm = corr(act_m, 'rows', 'complete');
        ccm(eye(length(ccm))==1)=nan;

        ccm_all = corr(act_m_all, 'rows', 'complete');
        ccm_all(eye(length(ccm_all))==1)=nan;

        figure('Position',[100,100,300,300])
        subplot(111); hold on
        title('Setpoint sim.', 'FontWeight','normal')
        imagesc(ccm, [0.5,1])
        cb=colorbar('Ticks',[0.5,1]);
        title(cb, 'Corr.');
        axis image
        xlabel('Repeat #')
        ylabel('Repeat #')
        xticks([1,nm,2*nm])
        yticks([1,nm,2*nm])

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])

        print(['./Examples/' session_type '_' reg '_SetSim.png'], '-dpng', '-r300');

        % - 
        ppw_m = nanmean(ppw_z, 2);
        ppw_d = zeros(2*nm,2*nm);
        for i = 1:2*nm
            ppw_d(i,:) = ppw_m(i) - ppw_m;
        end

        fs = 17;

        figure('Position',[100,100,400,250])
        subplot(121); hold on
        title('V1 units', 'FontWeight','normal')
        plot(abs(ppw_d), ccm, 'ko', 'MarkerSize',5)

        my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm,1,[]), 'r', [0.1,0.45], 1, 15);

        xlabel('|\DeltaPupil width|')
        ylabel('Setpoint sim.')

        ylim([0.4,1.1])

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        subplot(122); hold on
        title('All units', 'FontWeight','normal')
        plot(abs(ppw_d), ccm_all, 'ko', 'MarkerSize',5)

        my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm_all,1,[]), 'r', [0.1,0.45], 1, 15);

        xlabel('|\DeltaPupil width|')

        ylim([0.4,1.1])
        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        print(['./Examples/' session_type '_' reg '_SetSim_ppd.png'], '-dpng', '-r300');

        % - stim-dependence of setPoint similarity

        r2_v1 = nan*zeros(1,30);
        r2_all = nan*zeros(1,30);
        for i = 1:30

            ppw_c = ppw_z(:,i);
            ppw_d = zeros(2*nm,2*nm);
            for j = 1:2*nm
                ppw_d(j,:) = ppw_c(j) - ppw_c;
            end

            act_c = squeeze(my_act(:,:,i));
            ccm = corr(act_c, 'rows', 'complete');
            ccm(eye(length(ccm))==1)=nan;

            act_c_all = squeeze(act(:,:,i));
            ccm_all = corr(act_c_all, 'rows', 'complete');
            ccm_all(eye(length(ccm_all))==1)=nan;

            [r2_v1(i), m] = my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm,1,[]), 'r', [0.1,0.45], 0, 15);
            [r2_all(i), m] = my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm_all,1,[]), 'r', [0.1,0.45], 0, 15);
        end

        figure('Position',[100,100,300,300])
        hold on
        plot(r2_v1, '-o', 'LineWidth',1)
        plot(r2_all, '-o', 'LineWidth',1)

        ylim([0,1])

        if dsi == 2
        legend('V1 units', 'All units', 'Location', 'best', 'fontsize',15)
        legend boxoff
        end

        xlabel('Frame #')
        ylabel('R^2')

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        print(['./Examples/' session_type '_' reg '_SetSim_ppd_stimWise.png'], '-dpng', '-r300');

        % - PV mean/std
        [a,b] = sort(z1m);

        fs = 17;

        figure('Position',[100,100,600,300])

        subplot(121); title('1st block', 'FontWeight','normal');
        hold on

        x = 1:length(b);

        h1 = plot(x, z1m(b), '-o','color',[.7,.7,.7], 'LineWidth',1);

        ylabel('Avg. act. (1/s)')
        xlabel('Unit # (sorted)')
        ylim([0,50])

        h2 = plot(x, z1s(b), '-','color','r', 'LineWidth',1);

        lg = legend([h1,h2], {'mean', 'std'}, 'Location', 'best');
        legend boxoff

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        subplot(122); title('2nd block', 'FontWeight','normal');
        hold on

        plot(x, z1m(b), 'color',[.7,.7,.7], 'LineWidth',1);
        h2 = plot(x, z2m(b), '-o','color','k', 'LineWidth',1);

        ylim([0,50])

        plot(x, z2s(b), '-','color','r', 'LineWidth',1);

        xlabel('Unit # (sorted, 1st)')

        set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        print(['./Examples/' session_type '_' reg '_ActAvgVar.png'], '-dpng', '-r300');

    end

end
