
run('../init');
     
cls = {'b', 'r'};

reg = 'all';
    
N_rep = 2;

for dsi = 1:2
    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        L = 300*3;
        nm = 10*3;
        session_id_ex = 778998620;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        L = 300;
        nm = 10;
        session_id_ex = 759883607;
    end
    
    l = L/nm;

    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type) 
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end


    for sessi = 1
        session_id = session_id_ex
       
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        if strcmp(reg, 'all')
            unids = 1:size(act,1);
        else
            unids = find(ismember(unit_regs, reg));
        end 
        
        my_act = act(unids,:,:);
        
        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
            
            act_r = reshape(permute(my_act,[1,3,2]), size(my_act,1), []);
            act_zr = ((act_r' - nanmean(act_r')) ./ nanstd(act_r'))';

            ppw_r = reshape(ppw_z', 1, []);
            spd_r = reshape(spd_z', 1, []);
            
            [COEFF, SCORE, LATENT, TSQUARED, EXPLAINED] = pca(act_r);  
            
            cpc_ppw = corr(COEFF, ppw_r');
            cpc_spd = corr(COEFF, spd_r');
            
            cfr = reshape(COEFF', size(COEFF',1),size(act,3), size(my_act,2));
            
            cfr_cr = [];
            for i = 1:size(cfr,1)
                ccr = corr(squeeze(cfr(i,:,:))');
                ccr(eye(length(ccr))==1)=nan;
                cfr_cr = [cfr_cr, nanmean(ccr(:))]; 
            end
            
            
            cc_spd = corr(act_r', spd_r')';
            cc_ppw = corr(act_r', ppw_r')';
            
            
            ccus = [];
            for i = 1:size(my_act,1)
                ccu = corr(squeeze(act(i,:,:))');
                ccu(eye(length(ccu))==1)=nan;
                ccus = [ccus, nanmean(ccu(:))]; 
            end
            
            fs = 18;
            
            % - 
            act_res = act_r - nanmean(act_r,1);
            
            cc_res_spd = corr(act_res', spd_r'); 
            
            cc_1st_spd = corr(act_r(:,1:length(spd_r)/2)', spd_r(1,1:length(spd_r)/2)');
            cc_2nd_spd = corr(act_r(:,length(spd_r)/2+1:end)', spd_r(1,length(spd_r)/2+1:end)');
            
            [a,b] = sort(cc_2nd_spd);
            
            % - 
            
            pl_3d = 1;
            
            x0 = .2;
            dx = .55;
            dy = .175;
            
            ax1_pos = [x0+.1/2,.7, dx-.1/2,dy];
            ax2_pos = [x0,.35, dx,dy];
            ax3_pos = [x0,.05, dx,dy];
            
                       
            %%% - 
            figure('Position',[100,100,250,250])
            
            hold on
            plot(EXPLAINED, 'k-o', 'LineWidth',2, 'MarkerSize',7)
            xlim([0,10])
            ylabel('% Var Explained')
            xlabel('PC #')
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
            
            print(['./examples/' session_type '/pc_space_' reg '__11.png'], '-dpng', '-r300');
            
            %%% - 
            
            figure('Position',[100,100,300,300])
            hold on; 
            nsh = 1;
            s = 10; 
            c = ppw_r(1:nsh:end); 
            if pl_3d
                scatter3(COEFF(1:nsh:end,1), COEFF(1:nsh:end,2), COEFF(1:nsh:end,3), s, c);
                rotate3d on;
                view(-30,30)
            else
                scatter(COEFF(1:nsh:end,1), COEFF(1:nsh:end,2), s,c);
            end
            
            colormap(flip(hot))
            
            cb = colorbar('Location', 'north'); 
            if ~strcmp(session_type, 'functional_connectivity')
            cb.Label.String = {'pupil (Z)'};
            cb.Label.FontSize=15;
            cb.Label.Position = [-3,1.5,0];
            set(cb,'position',[.35 .8 .4 .05]);
            else
                set(cb,'position',[.5 .8 .35 .05]);
            end
            
            cb.Ticks = [-1,0,1]; 
            cb.TickLength=0.1/2;
            
            xlabel('PC1'); ylabel('PC2'); zlabel('PC3');
            xticks([]); yticks([]); zticks([]);
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
            
            print(['./examples/' session_type '/pc_space_' reg '__12.png'], '-dpng', '-r300');
            
            %%% -             
            figure('Position',[100,100,300,300])
            
            hold on; title('projections', 'FontWeight','normal')
            nsh = 1;
            s = 10; 
            c = (nanmean(act_r,2));
            if pl_3d
                scatter3(SCORE(1:nsh:end,1), SCORE(1:nsh:end,2), SCORE(1:nsh:end,3), s,c);
                rotate3d on;
                view(-30,30)
            else
                scatter(SCORE(1:nsh:end,1), SCORE(1:nsh:end,2), s,c);
            end
            
            colormap(flip(hot))
           
            cb = colorbar; 
            set(cb,'position',[.7 .55 .1/2 .25]);
            cb.Label.String = {'activity (1/s)'};
            if ~strcmp(session_type, 'functional_connectivity')
            cb.Ticks = [0,10,20,30,40]; 
            end
            cb.TickLength=.1/2;
            
            xlabel('PC1'); ylabel('PC2'); zlabel('PC3');
            xticks([]); yticks([]); zticks([]);
            
            view(30,-15);
            
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
            
            print(['./examples/' session_type '/pc_space_' reg '__13.png'], '-dpng', '-r300');
                 
            % - 
            
            ax1_pos = [x0+.1/2,.725, dx-.1/2,dy];
            ax2_pos = [x0,.4, dx,dy];
            ax3_pos = [x0,.1, dx,dy];
                        
            %%% - 
            
            figure('Position',[100,100,250,250])
            
            hold on
            plot(COEFF(:,1), ppw_r, '.', 'MarkerSize',10, 'color', cl_pupil)
            ylabel('ppl')
            plot(COEFF(:,1), spd_r, '.', 'MarkerSize',7, 'color', cl_running)
            
            [r2, m] = my_regress(COEFF(:,1)', ppw_r,cl_pupil, [min(COEFF(:,1))*1.1,1.5], 1);
            [r2, m] = my_regress(COEFF(:,1)', spd_r, cl_running, [min(COEFF(:,1))*1.1,1], 1);
            
            xlabel('PC1')
            ylabel('\color[rgb]{.75 .25 0}{Pupil} \color{black}{/} \color[rgb]{.15 0.15 .15}{Run.} \color{black}{(Z)}')
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
            
            print(['./examples/' session_type '/pc_space_' reg '__21.png'], '-dpng', '-r300');
            
            %%% -  
            figure('Position',[100,100,250,250])
            hold on
            
            plot(ccus, SCORE(:,1)/nanmax(SCORE(:,1)), 'k.')
            
            [r2, m] = my_regress(ccus, SCORE(:,1)'/nanmax(SCORE(:,1)),'k', [0.7,.9], 1);
            [r2, m] = my_regress(ccus, SCORE(:,2)'/nanmax(SCORE(:,2)), [.7,.7,.7], [0.7,.75], 1);
            
            yticks([-0.5, 0, 0.5, 1])
            ylim([-0.5,1])
            
            xlabel('Stim. reliab.')
            ylabel('\color{black}{Proj.} \color{black}{PC1} \color{black}{/} \color{gray}{PC2}')
            
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])
            
            print(['./examples/' session_type '/pc_space_' reg '__22.png'], '-dpng', '-r300');
            
            %%% - 
            figure('Position',[100,100,300,300])
            hold on
            
            plot(nanmean(act_r(:,1:size(act_r,2)/2),2), SCORE(:,1)/nanmax(SCORE(:,1)), 'ko', 'MarkerSize',5)
            
            zm = nanmean(act_r(:,1:size(act_r,2)/2),2);
            if dsi == 1
            [r2, m] = my_regress(zm', SCORE(:,1)'/nanmax(SCORE(:,1)), 'k', [.75*max(zm(:)),0.15], 1);
            [r2, m] = my_regress(zm', SCORE(:,2)'/nanmax(SCORE(:,2)), [.7,.7,.7], [.75*max(zm(:)),0], 1);
            elseif dsi == 2
            [r2, m] = my_regress(zm', SCORE(:,1)'/nanmax(SCORE(:,1)), 'k', [.75*max(zm(:)),-.1], 1);
            [r2, m] = my_regress(zm', SCORE(:,2)'/nanmax(SCORE(:,2)), [.7,.7,.7], [.75*max(zm(:)),-.25], 1);
            end
                   
            ylabel('\color{black}{Proj.} \color{black}{PC1} \color{black}{/} \color{gray}{PC2}')
            
            xlabel('Avg. activity')
            set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.02,.02])

            print(['./examples/' session_type '/pc_space_' reg '__23.png'], '-dpng', '-r300');
            
    end

end

