
run('../init');

cls = {'b', 'r'};

reg = 'VISp';
    
N_rep = 2;

for dsi = 1:2
    
    ccm_tot = [];
    ccm_all_tot = [];
    ppw_d_tot = [];
    act_tot = [];
    ppw_tot = [];
    r2_v1_tot = [];
    r2_all_tot = [];

    if dsi == 1
        session_type = 'functional_connectivity';
        stim_sel = 'natural_movie_one_more_repeats';
        L = 300*3;
        nm = 10*3;
        session_id_ex = 778998620;
        
    elseif dsi == 2
        session_type = 'brain_observatory_1.1';
        stim_sel = 'natural_movie_one';
        L = 300;
        nm = 10;
        session_id_ex = 759883607;
    end

    [NUM,TXT,RAW] = xlsread('session_info.xls');
    session_ids = [];
    j = 0;
    for i = 1:length(NUM)
        if strcmp(TXT(i,4), session_type) 
            j = j+1;
            session_ids{j} = NUM(i,1);
        end
    end
    N_sessions = length(session_ids);

    xcol_cnt = 1;
    
    for sessi = 1:N_sessions
        session_id = session_ids{sessi};
       
        load(['../prep_data_NM1/prep_data_' num2str(session_id) '.mat']);

        ppw_z = (ppw - nanmean(ppw(:)))/nanstd(ppw(:));
        spd_z = (spd - nanmean(spd(:)))/nanstd(spd(:));
        
        reg_un = unique(unit_regs); 
        unids = find(ismember(unit_regs, reg));
                    
        if length(unids) > 40 && (size(act,2) == N_rep*nm) && (sum(isnan(ppw(:)))<prod(size(ppw)))

            if strcmp(reg, 'all')
            my_act = act(:,:,:);
            else
            my_act = act(unids,:,:);
            end
            
            act_r = reshape(permute(my_act,[1,3,2]), size(my_act,1), []);
            act_z = (my_act-nanmean(my_act(:))) ./nanstd(my_act(:));
            act_zr = reshape(permute(act_z,[1,3,2]), size(act_z,1), []);
            ppw_r = reshape(ppw', 1, []);
            spd_r = reshape(spd', 1, []);
            
            
            z1 = squeeze(nanmean(my_act(:,1:nm,:),3));
            z2 = squeeze(nanmean(my_act(:,1+nm:end,:),3));

            z1m = nanmean(z1,2);
            z2m = nanmean(z2,2);

            z1s = nanstd(z1')';
            z2s = nanstd(z2')';
           
            
            bins = -1:.1/2:1;
            
            fs = 17;
       
            % - 
            ppw_m = nanmean(ppw,2);
            spd_m = nanmean(spd,2);
            act_m = squeeze(nanmean(my_act,3));
            act_m_all = squeeze(nanmean(act,3));
            
            act_tot = [act_tot, nanmean(act_m,1)];
            ppw_tot = [ppw_tot, (ppw_m - nanmean(ppw_m))'/nanmean(ppw_m(:))];
            
            ccm = corr(act_m, 'rows', 'complete');
            ccm(eye(length(ccm))==1)=nan;
            
            ccm_m = [nanmean(nanmean(ccm(1:nm,1:nm))), ...
                      nanmean(nanmean(ccm(1+nm:end,1+nm:end))), ...
                      nanmean(nanmean(ccm(1:nm,1+nm:end)))];
            ccm_tot = [ccm_tot, ccm_m];
                        
            ccm_all = corr(act_m_all, 'rows', 'complete');
            ccm_all(eye(length(ccm_all))==1)=nan;
            
            ccm_all_m = [nanmean(nanmean(ccm_all(1:nm,1:nm))), ...
                      nanmean(nanmean(ccm_all(1+nm:end,1+nm:end))), ...
                      nanmean(nanmean(ccm_all(1:nm,1+nm:end)))];
            ccm_all_tot = [ccm_all_tot, ccm_all_m];
            
            
            % - 
            ppw_m = nanmean(ppw_z, 2);
            ppw_d = zeros(2*nm,2*nm);
            for i = 1:2*nm
                ppw_d(i,:) = ppw_m(i) - ppw_m;
            end
            
            ppw_dm = [nanmean(nanmean(ppw_d(1:nm,1:nm))), ...
                      nanmean(nanmean(ppw_d(1+nm:end,1+nm:end))), ...
                      nanmean(nanmean(ppw_d(1:nm,1+nm:end)))];
            ppw_d_tot = [ppw_d_tot, ppw_dm];


            r2_v1 = nan*zeros(1,30);
            r2_all = nan*zeros(1,30);
            for i = 1:30
                
                ppw_c = ppw_z(:,i);
                ppw_d = zeros(2*nm,2*nm);
                for j = 1:2*nm
                    ppw_d(j,:) = ppw_c(j) - ppw_c;
                end
            
                act_c = squeeze(my_act(:,:,i));
                ccm = corr(act_c, 'rows', 'complete');
                ccm(eye(length(ccm))==1)=nan;

                act_c_all = squeeze(act(:,:,i));
                ccm_all = corr(act_c_all, 'rows', 'complete');
                ccm_all(eye(length(ccm_all))==1)=nan;

                [r2_v1(i), m] = my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm,1,[]), 'r', [0.1,0.45], 0, 15);
                [r2_all(i), m] = my_regress(reshape(abs(ppw_d),1,[]), reshape(ccm_all,1,[]), 'r', [0.1,0.45], 0, 15);
            end
            
            r2_v1_tot = [r2_v1_tot; r2_v1];
            r2_all_tot = [r2_all_tot; r2_all];
            
        end
    end

    fs = 17;
           
    figure('Position',[100,100,300,300])
    hold on
    plot(ppw_tot, act_tot, 'k.')
    
    my_regress(ppw_tot, act_tot, 'r', [nanmean(ppw_tot),15], 1, 15);
    
    ylim([0,16])
    
    xlabel('Pupil (norm.)')
    ylabel('Avg. V1 act. (1/s)')
    
    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

        
    print(['./All/' session_type '_' reg '_pplAct_all.png'], '-dpng', '-r300');

                
    figure('Position',[100,100,400,250])
    subplot(121); hold on
    title('V1 units', 'FontWeight','normal')
    plot(abs(ppw_d_tot), ccm_tot, 'ko', 'MarkerSize',7.5)

    my_regress(abs(ppw_d_tot), ccm_tot, 'r', [0.1,0.45], 1, 15);

    xlabel('|\DeltaPupil width|')
    ylabel('Setpoint sim.')

    ylim([0.4,1.1])

    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

    subplot(122); hold on
    title('All units', 'FontWeight','normal')
    plot(abs(ppw_d_tot), ccm_all_tot, 'ko', 'MarkerSize',7.5)

    my_regress(abs(ppw_d_tot), ccm_all_tot, 'r', [0.1,0.45], 1, 15);

    xlabel('|\DeltaPupil width|')

    ylim([0.4,1])
    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

    print(['./All/' session_type '_' reg '_SetSim_ppd_all.png'], '-dpng', '-r300');
    
    % - 
    figure('Position',[100,100,300,300])
    hold on
    plot(nanmean(r2_v1_tot,1), '-o', 'LineWidth',1)
    plot(nanmean(r2_all_tot,1), '-o', 'LineWidth',1)

    ylim([0,1])

    if dsi == 2
    legend('V1 units', 'All units', 'Location', 'best', 'fontsize',15)
    legend boxoff
    end

    xlabel('Frame #')
    ylabel('R^2')

    set(gca, 'LineWidth', 1.5, 'FontSize', fs, 'TickDir', 'out', 'TickLength',[.015,.015])

    print(['./All/' session_type '_' reg '_SetSim_ppd_stimWise.png'], '-dpng', '-r300');
            
end
