function [r2, m] = my_regress(z1, z2, cl, pos, plt, fs)
if nargin<5; plt = 1; end
if nargin<6; fs = 15; end

nnids = logical(~isnan(z1) .* ~isnan(z2));
                    
x = z1(nnids)';
y = z2(nnids)';
X = [ones(length(x),1) x];
B = X\y;
xmn = min(x(:));
xmx = max(x(:));

xx = xmn:(xmx-xmn)/10:xmx;

yCalc1 = B(1) + B(2)*x;
r2 = 1 - sum((y - yCalc1).^2)/sum((y - mean(y)).^2);
m = B(2);

if plt
    plot(xx, B(1) + B(2)*xx, '-', 'color', cl, 'LineWidth',2)

    text(pos(1), pos(2), ['R^2: ' num2str(round(r2,1))], 'FontSize',fs, 'Color',cl);
end

end