clear;
%% loading
cellName = '11162020-004H';
filepath = fullfile('E:\Pigeon\THz Data\THz\data\111620\', [cellName, '.mat']);
rawData = importdata(filepath);

eyFs = 1 / rawData.H.interval;

ey = rawData.H.values;
waveLen = length(ey);

clear rawData

%% config
lpFc = 60; % low pass cut freq.
hpFc = 5;
susWid = [0.02; 0.04] * eyFs; % half-prominence width, 'sus' for preliminary screening
wid    = [0.02; 0.08] * eyFs;
isoTole = 0.04 * eyFs; % max time between pk and va
sacLenTole = 3 * eyFs; % max duration of a saccade
intvS = 1800;

%% detect saccades
lpEy = butter_low_pass(ey, lpFc, eyFs);
hpLpEy = butter_high_pass(lpEy, hpFc, eyFs);
% -CONFIG- about saccade amplitude
susPro =  4.6 * std(hpLpEy); % prominence, 'sus' for preliminary screening
pro    = 1.8 * std(hpLpEy); % prominence
toughPro = 3 * std(hpLpEy);
% find preliminary saccade time range
[susPLoc, susVLoc] = mark_peak(susWid, susPro, hpLpEy);
susPLoc = delete_isolator(susPLoc, susVLoc, isoTole);
susVLoc = delete_isolator(susVLoc, susPLoc, isoTole);
susPvLoc = sort( [susPLoc; susVLoc] );
susDPvLoc = diff(susPvLoc);
% -CONFIG- for preliminary saccade detection
newSacThre = 0.3 * eyFs; 
susPreIntv  = round( 0.04 * eyFs );
susPostIntv = round( 0.08 * eyFs );
sacConfiLen = susPreIntv + susPostIntv + 0.05 * eyFs;
% preliminary saccade time range: (1st mark - preIntv) -> (last mark + postIntv)
susSacStrt = susPvLoc( find( susDPvLoc > newSacThre ) + 1 ) - susPreIntv;
susSacStrt = [susPvLoc(1) - susPreIntv; susSacStrt];
susSacStop = susPvLoc(  susDPvLoc > newSacThre  ) + susPostIntv;
susSacStop = [susSacStop; susPvLoc(end) + susPostIntv];
susSacQty = numel(susSacStrt);
ovlpSusSacNo = [];
sensiTim = 0.2 * eyFs;
for k = 1: susSacQty - 1
    kStop =  susSacStop(k);
    kp1Strt = susSacStrt(k + 1);
    if kStop + sensiTim >= kp1Strt 
        ovlpSusSacNo = [ovlpSusSacNo; k];
    end
end
susSacStop(ovlpSusSacNo) = [];
susSacStrt(ovlpSusSacNo + 1) = [];
susSacQty = numel(susSacStrt);

%% define saccades
pLoc = [];
vLoc = [];
for k = 1: susSacQty
    
    strt = susSacStrt(k);
    stop = susSacStop(k);
    strt = max(strt, 1);
    stop = min(stop, waveLen);
    if stop - strt < sacConfiLen
        tempPro = toughPro;
    else
        tempPro = pro;
    end
    [p, v] = mark_peak( wid, pro, hpLpEy(strt: stop) );
    pLoc = [pLoc; p + strt - 1];
    vLoc = [vLoc; v + strt - 1];
end

% delete isolated markers
pLoc = delete_isolator(pLoc, vLoc, isoTole);
vLoc = delete_isolator(vLoc, pLoc, isoTole);
pvLoc = sort( [pLoc; vLoc] );

dPvLoc = diff(pvLoc);
newSacThre = 0.05 * eyFs; 
preIntv  = round( 0.04 * eyFs );
postIntv = round( 0.04 * eyFs );
sacStrt = pvLoc( find( dPvLoc > newSacThre ) + 1 ) - preIntv;
sacStrt = [pvLoc(1) - preIntv; sacStrt];
sacStop = pvLoc(  dPvLoc > newSacThre ) + postIntv;
sacStop = [sacStop; pvLoc(end) + postIntv];
sacQty = numel(sacStrt);

ovlpSacNo = [];
sensiTim = 0 * eyFs;
for k = 1: sacQty - 1
    kStop =  sacStop(k);
    kp1Strt = sacStrt(k + 1);
    if kStop + sensiTim >= kp1Strt
        ovlpSacNo = [ovlpSacNo; k];
    end
end
sacStop(ovlpSacNo) = [];
sacStrt(ovlpSacNo + 1) = [];
sacQty = numel(sacStrt);

save (['E:\Pigeon\THz Data\THz\sample\sac\',cellName], 'sacStrt','sacStop');
