close("*");
Dialog.create("Process single movie or entire folder");
items = newArray("entire folder             ", "single movie");
Dialog.addRadioButtonGroup(" ", items, 1, 2, "entire folder             ");
Dialog.addNumber("filter small:", 7.5);
Dialog.addNumber("filter large:", 40);
Dialog.show;
if (Dialog.getRadioButton=="entire folder             "){
	dir1 = getDirectory("Choose a Directory ");
	list = getFileList(dir1);
} else {
   path = File.openDialog("Select file");
   dir1="";
   list=newArray(1);
   list[0]=path;
}
tifcount=0; ntif=0;
for (ii=0; ii<list.length; ii++) {
  if (endsWith(list[ii], ".tif")) {
     tifcount++; 	
  }
}
filterS=Dialog.getNumber();
filterL=Dialog.getNumber();
setBatchMode(true);
IJ.deleteRows(0, nResults);
setBatchMode("show");
write("started");
setBatchMode("show");


for (ii=0; ii<list.length; ii++) {
  if (endsWith(list[ii], ".tif")) {
  	write(list[ii]);
  	showProgress(ntif/tifcount);
    ntif++;
    open(dir1 + list[ii]);
	name=getTitle();
	rename("Result of stack.tif");
	run("32-bit");
	getDimensions(width, height, channels, slices, frames);
	
	if (slices<frames) {
		stack_size=frames;
	} else {
			stack_size=slices;
    }
	run("Properties...", "channels=1 slices="+stack_size+" frames=1 unit=pixel pixel_width=1.0000 pixel_height=1.0000 voxel_depth=1.0000");	     
	run("Z Project...", "start=1 stop="+stack_size+" projection=[Average Intensity]");
	imageCalculator("Subtract create 32-bit stack", "Result of stack.tif","AVG_Result of stack.tif");
	selectWindow("AVG_Result of stack.tif");
	close();
	selectWindow("Result of stack.tif");
	close();
	selectWindow("Result of Result of stack.tif");
	rename("Result of stack.tif");
	run("Bandpass Filter...", "filter_large="+filterL+" filter_small="+filterS+" suppress=None tolerance=5 autoscale saturate process");
	rename("bigimage");

	newImage("Stack2", "32-bit black", width, height, 2);

	selectWindow("bigimage");

	for (i = 0; i < stack_size-2; i++) {
		    		selectWindow("bigimage");
					setSlice(i+1);
					run("Copy");
					selectWindow("Stack2");
					setSlice(2);
					run("Paste");
					run("Multiply...", "value=-1.00000000");
					changeValues(-10000,0,0);
					selectWindow("bigimage");
					setSlice(i+2);
					run("Copy");
					selectWindow("Stack2");
					setSlice(1);
					run("Paste");
					run("Multiply...", "value=-1.00000000");
					changeValues(-10000,0,0);

				    selectWindow("Results");
				    setBatchMode("show");
					selectWindow("Stack2");
					setBatchMode("show");
					setSlice(1);
					run("Image Stabilizer", "transformation=Translation maximum_pyramid_levels=1 template_update_coefficient=0.90 maximum_iterations=200 error_tolerance=0.0000001 ");

				}

    selectWindow("bigimage");
	close();

	selectWindow("Stack2");
	run("Close");
	if (dir1==""){
		saveAs("Results", list[0]+"_Results.txt");
	}else{
		saveAs("Results", dir1+name+"_Results.txt");
	}
	IJ.deleteRows(0, nResults);
	call("java.lang.System.gc");
  }
}
write("done");
setBatchMode(false);