#pragma rtGlobals=3		// Use modern global access method and strict wave access.

///////////////////////////////////To analyze EPSCs triggered by of light stimulation of ChR2-expressing IHCs////////////////
////Load the Opto_IV recordings using PatchMasterPowerTools////
////It does one first detection of level using Vavg-(initialThreshold)xSD. Based on that it does a second detection with Vavg-4xSD////
////The input vairable "initialThreshold" can be change accordingly based on the baseline noise of the recording////
////The function creates waves with the info about the amplitude, charge, latency and time to return to baseline of the EPSC for each optoIV////
////It also creates waves containing info about the voltage input (given to the LASER controller unit to control intensity) and stimduration////

function OptoEPSCs(initialThreshold)
	
	variable initialThreshold
	string myStimList=wavelist("*_1_2_Stim_DA",";","")
	wave Intensity_Wave = LightIntensity
	variable q
		
	for (q=0; q<itemsinlist(myStimList); q+=1)
		wave stimwave=$stringfromlist(q, myStimList)
		string expr="Opto_IV_var+_([[:digit:]]+)_([[:digit:]]+)_([[:digit:]]+)_2_Stim_DA"
		string Group, Series, Sweep
		splitstring/E=expr nameofwave(stimwave), Group, Series, Sweep	
		Make /O/N=0/T PulseName
		Make /O/N=0  wavenumber, Amp_EPSC, Q_EPSC, Delay, Voltage, Stimdur, Return2Base
		
		string mylist=wavelist("Opto_IV_var_1_"+Series+"_"+"*_Imon_1",";","")
		string cellname
		string basename
		variable i
		variable AmpEPSC, Qepsc
		variable level, level2, level3
		
		Cellname=getdatafolder(0)
	
		for (i=0; i<itemsinlist(mylist); i+=1)
		
			wave currwave=$stringfromlist(i,mylist)
			basename=removeending(nameofwave(currwave),"_1_Imon_1")
				
			wave stimwave=$basename+"_2_Stim_DA"
			wavestats /Q stimwave
			variable Stim=V_max
			variable startStim=V_maxloc
			FindLevel /Q/R=(startStim) stimWave, 0
			variable stimTime=V_levelX-startStim
			
			Duplicate/O currwave $basename+"_INT"
			wave currout=$basename+"_INT"	
			
			//display currout
			//NewPanel  /NA=1 as "Pause for Cursor"
	//		/K=2 /W=(187,368,437,531)
			//DoWindow/C tmp_PauseforCursor					// Set to an unlikely name
			//AutoPositionWindow/E/M=1/R=$currwave			// Put panel near the graph
			//PauseForUser tmp_PauseforCursor,currout
			WaveStats /Q/R=(0,startStim) currout
			currout -= V_avg
			WaveStats /Q/R=(0,startStim) currout
			level=V_avg-(initialThreshold)*V_sdev
			Duplicate/O currout $basename+"_base"
			FindLevel /Q/EDGE=2 currout, level
			WaveStats /Q/R=(0,V_levelX) currout
			level2=V_avg-4*V_sdev
			FindLevel /Q/EDGE=2 currout, level2
			variable Latency
			if (V_flag==1)
				latency=pnt2x(currout,(numpnts(currout)))
			else
				latency=V_levelX
			endif
			
			level3=V_avg+2*V_sdev	//depends on the trace. 
			FindLevel /Q/EDGE=1/R=(Latency) currout, level3
			variable decay
			if (V_flag==1)
				decay=pnt2x(currout,(numpnts(currout)))
			else
				decay=V_levelX
			endif
			WaveStats /Q/R=(startStim,Latency) currout
			currout -= V_avg
			WaveStats /Q/R=(startStim, decay) currout
			AmpEPSC=V_min*1e12
			Integrate currout
			currout *=-1
			WaveStats /Q/R=(startStim,Latency) currout
			currout -= V_avg
			wavestats /Q/R=(Latency-0.005, decay) currout	
			variable Qmax = V_max
			//print Qmax
			//wavestats /Q/R=(0.02, V_levelX) currout
			variable Qmin = V_min
			//print Qmin
			Qepsc=(Qmax-Qmin)*1e15
		
			insertpoints numpnts(PulseName),1,PulseName, wavenumber, Amp_EPSC, Q_EPSC, Delay, Voltage, Stimdur, Return2Base
			PulseName[numpnts(PulseName)-1]=basename
			wavenumber[numpnts(PulseName)-1]=i
			Amp_EPSC[numpnts(PulseName)-1]=AmpEPSC
			Q_EPSC[numpnts(PulseName)-1]=Qepsc
			Delay[numpnts(PulseName)-1]=(Latency-0.02)*1000
			Return2Base[numpnts(PulseName)-1]=Decay*1000
			Voltage[numpnts(PulseName)-1]=Stim
			Stimdur[numpnts(PulseName)-1]=stimTime*1000
		
		endfor
		
	duplicate/O PulseName $"PulseName_"+Series
	duplicate/O wavenumber $"Wavenumber_"+Series
	duplicate/O Amp_EPSC $"Amp_EPSC_"+Series
	duplicate/O Q_EPSC $"Q_EPSC_"+Series
	duplicate/O Delay $"Delay_"+Series
	duplicate/O Voltage $"Voltage_"+Series
	duplicate/O Stimdur $"Stimdur_"+Series
	duplicate/O Return2base $"Return2Base_"+Series
	
	DoWindow Charge
	if (V_flag==0)
		display/K=1/N=Charge
	endif
	DoWindow Amp
	if (V_flag==0)
		display/K=1/N=Amp
	endif
	DoWindow Late
	if (V_flag==0)
		display/K=1/N=Late
	endif
	
		appendtograph/W=Charge $"Q_EPSC_"+Series vs $"Voltage_"+Series
		string TraceList=TraceNameList("Charge",";",1+4)
		string TraceName=stringfromlist(itemsinlist(TraceList)-1, TraceList)
		ModifyGraph/W=Charge mode($TraceName)=4,marker($Tracename)=19,mrkThick($Tracename)=1;DelayUpdate
		if (Stimdur[0]==5)
			ModifyGraph/W=Charge rgb($Tracename)=(47872,47872,47872)
		elseif (Stimdur[0]==10)
			ModifyGraph/W=Charge rgb($Tracename)=(0,0,0)
		elseif (Stimdur[0]==50)
			ModifyGraph/W=Charge rgb($Tracename)=(30464,30464,30464)
		endif
		
		appendtograph/W=Amp $"Amp_EPSC_"+Series vs $"Voltage_"+Series
		TraceList=TraceNameList("Amp",";",1+4)
		TraceName=stringfromlist(itemsinlist(TraceList)-1, TraceList)
		ModifyGraph/W=Amp mode($TraceName)=4,marker($Tracename)=19,mrkThick($Tracename)=1;DelayUpdate
		if (Stimdur[0]==5)
			ModifyGraph/W=Amp rgb($Tracename)=(47872,47872,47872)
		elseif (Stimdur[0]==10)
			ModifyGraph/W=Amp rgb($Tracename)=(0,0,0)
		elseif (Stimdur[0]==50)
			ModifyGraph/W=Amp rgb($Tracename)=(30464,30464,30464)
		endif
		
		appendtograph/W=Late $"Delay_"+Series vs $"Voltage_"+Series
		TraceList=TraceNameList("Late",";",1+4)
		TraceName=stringfromlist(itemsinlist(TraceList)-1, TraceList)
		ModifyGraph/W=Late mode($TraceName)=4,marker($Tracename)=19,mrkThick($Tracename)=1;DelayUpdate
		if (Stimdur[0]==5)
			ModifyGraph/W=Late rgb($Tracename)=(47872,47872,47872)
		elseif (Stimdur[0]==10)
			ModifyGraph/W=Late rgb($Tracename)=(0,0,0)
		elseif (Stimdur[0]==50)
			ModifyGraph/W=Late rgb($Tracename)=(30464,30464,30464)
		endif
	
	endfor
	killwaves/Z PulseName, wavenumber, Amp_EPSC, Q_EPSC, Delay, Voltage, Stimdur, Return2Base
end	

///