function HPMCreateCOStartChanTime
global guiInfo lib DAQmx_ taskh 

%{
    DAQmxCreateCOPulseChanTime
taskHandle             TaskHandle     The task to which to add the channels that this function creates. 
counter                const char []  The name of the counter to use to create virtual channels. You can specify a list or range of physical channels. 
nameToAssignToChannel  const char []  The name(s) to assign to the created virtual channel(s). If you do not specify a name, NI-DAQmx uses the physical channel name as the virtual channel name. If you specify your own names for nameToAssignToChannel, you must use the names when you refer to these channels in other NI-DAQmx functions.
units                  int32          The units in which to define pulse high and low time. Value  Description DAQmx_Val_Seconds   Seconds 
idleState              int32          The resting state of the output terminal. Value  Description DAQmx_Val_High | DAQmx_Val_Low   Low state. 
initialDelay           float64        The amount of time in seconds to wait before generating the first pulse. 
lowTime                float64        The amount of time the pulse is low, in seconds. 
highTime               float64        The amount of time the pulse is high, in seconds. 


    DAQmxCfgImplicitTiming
taskHandle              TaskHandle      The task used in this function.
sampleMode              int32           DAQmx_Val_FiniteSamps  DAQmx_Val_ContSamps DAQmx_Val_HWTimedSinglePoint
sampsPerChanToAcquire 	uInt64
%}
guiInfo.isTimeHPM=0.472;
[err,b]=calllib(lib,'DAQmxStopTask',taskh.StrobeCounterStart); [err,b]=calllib(lib,'DAQmxClearTask',taskh.StrobeCounterStart);
[err,b,taskh.StrobeCounterStart]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);  

switch guiInfo.isStimMode
  case guiInfo.StimModeStimulate
    guiInfo.initialDelay=1.0; guiInfo.isStartTimeHigh=0.5;
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterStart,'Dev1/ctr1','',DAQmx_.Val_Seconds,DAQmx_.Val_Low,guiInfo.initialDelay,guiInfo.isStimTimeLow,guiInfo.isStartTimeHigh); DAQmxCheckError(lib,err);    
  case guiInfo.StimModeRecovery
    guiInfo.isStartTimeHigh=0.5;
    guiInfo.initialDelay=guiInfo.isDelayHPM+guiInfo.isStimTimeHigh-guiInfo.isTimeHPM;
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterStart,'Dev1/ctr1','',DAQmx_.Val_Seconds,DAQmx_.Val_Low,guiInfo.initialDelay,guiInfo.isStimTimeLow,guiInfo.isStartTimeHigh); DAQmxCheckError(lib,err);
    if guiInfo.isDPZ [err,b]=calllib(lib,'DAQmxCfgDigEdgeStartTrig',taskh.StrobeCounterStart,'/Dev1/PFI12',DAQmx_.Val_Rising); end;
    if guiInfo.isBIN [err,b]=calllib(lib,'DAQmxCfgDigEdgeStartTrig',taskh.StrobeCounterStart,'/Dev1/PFI6',DAQmx_.Val_Rising); end;
    DAQmxCheckError(lib,err);        
end
%disp(['Dev1/ctr1  HPMstart']); disp([guiInfo.initialDelay guiInfo.isStartTimeHigh guiInfo.isStimTimeLow guiInfo.isStimTimeHigh guiInfo.isStimTimeDelay guiInfo.isDelayHPM]);
[err,b]=calllib(lib,'DAQmxCfgImplicitTiming',taskh.StrobeCounterStart,DAQmx_.Val_FiniteSamps,1); DAQmxCheckError(lib,err);
[err,b]=calllib(lib,'DAQmxStartTask',taskh.StrobeCounterStart);
