clc;
clear all;
close all;

path='W:\public\Software\Matlab\ghoch\matlab-files\HPM\OPTICAL\';

nPath=size(path,1);
for j=1:nPath
  ispath=regexprep(path(j,:),' ',''); ispath=(path(j,:)); 
  files=dir(fullfile(ispath,'*.xls')); 
  nFiles=size(files,1);
  for i=1:nFiles
    [pathstr,name,ext,versn]=fileparts(files(i).name); display([ispath name '   ' num2str(i) '/' num2str(nFiles)]);
    fid = fopen([ispath files(i).name]); x(i)=str2num(name);
    for j=1:4 data(i).headerStr(j).s=fgets(fid);  end; 
    data(i).riseTime.s= fscanf(fid, '%s\n %s\n' , 2); data(i).riseTime.val=str2num(fscanf(fid, '%s\n',1)); fscanf(fid, '%s\n',1); rTime(i)=data(i).riseTime.val;
    data(i).ShiftPT.s= fscanf(fid, '%s\n %s\n' , 2); data(i).ShiftPT.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); sPT(i)=data(i).ShiftPT.val;
    data(i).hpDwell.s= fscanf(fid, '%s\n %s\n' , 2); data(i).hpDwell.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); hpDwell(i)=data(i).hpDwell.val;    
    data(i).CoolingRate.s= fscanf(fid, '%s\n %s\n' , 2); data(i).CoolingRate.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); CoolingRate(i)=data(i).CoolingRate.val;    
    for j=1:4 s=fgets(fid); end; 
    j=0;
    while ~feof(fid)
      j=j+1;
      data(i).t(j)=str2num(fscanf(fid, '%s\n',1));t(j,i)=data(i).t(j)/1000;
      data(i).p(j)=str2num(fscanf(fid, '%s\n',1));p(j,i)=data(i).p(j);
      data(i).temp(j)=str2num(fscanf(fid, '%s\n',1));temp(j,i)=data(i).temp(j);
    end  
    fclose(fid);
  end
end
f=figure('NumberTitle','off');plot(x,rTime); title('rise Time'); xlabel('probe'); ylabel('msec');
f=figure('NumberTitle','off');plot(x,sPT); title('Shift p/T'); xlabel('probe'); ylabel('msec');
f=figure('NumberTitle','off');plot(x,hpDwell); title('hp Dwell'); xlabel('probe'); ylabel('msec'); ylim([270 370]);
f=figure('NumberTitle','off');plot(x,CoolingRate); title('Cooling Rate'); xlabel('probe'); ylabel('C/s');  ylim([10000 30000]);
f=figure('NumberTitle','off'); hold on; for j=1:size(p,2) plot(t(:,j),p(:,j),'color',[0.8 0.8 0.8]); end; plot(t(:,j),mean(p,2),'color',[0 0 0]); title('pressure'); xlabel('msec'); ylabel('bar'); xlim([0 20]); hold off; grid on;
f=figure('NumberTitle','off'); hold on; for j=1:size(temp,2) plot(t(:,j),temp(:,j),'color',[0.8 0.8 0.8]); end; plot(t(:,j),mean(temp,2),'color',[0 0 0]); title('temperatur'); xlabel('msec'); ylabel('C'); xlim([0 20]); hold off; grid on;
