%******************************************************************************
%*** NI-DAQmx Attributes ******************************************************
%******************************************************************************
% copyright National Instruments
% adapted for use in matlab, by Jens Roesner, jan/25/2005

%********** Calibration Info Attributes **********
DAQmx_.SelfCal_Supported = hex2dec('1860'); % Indicates whether the device supports self calibration.
DAQmx_.SelfCal_LastTemp = hex2dec('1864'); % Indicates in degrees Celsius the temperature of the device at the time of the last self calibration. Compare this temperature to the current onboard temperature to determine if you should perform another calibration.
DAQmx_.ExtCal_RecommendedInterval = hex2dec('1868'); % Indicates in months the National Instruments recommended interval between each external calibration of the device.
DAQmx_.ExtCal_LastTemp = hex2dec('1867'); % Indicates in degrees Celsius the temperature of the device at the time of the last external calibration. Compare this temperature to the current onboard temperature to determine if you should perform another calibration.
DAQmx_.Cal_UserDefinedInfo = hex2dec('1861'); % Specifies a string that contains arbitrary, user-defined information. This number of characters in this string can be no more than Max Size.
DAQmx_.Cal_UserDefinedInfo_MaxSize = hex2dec('191C'); % Indicates the maximum length in characters of Information.
DAQmx_.Cal_DevTemp = hex2dec('223B'); % Indicates in degrees Celsius the current temperature of the device.

%********** Channel Attributes **********
DAQmx_.ChanType = hex2dec('187F'); % Indicates the type of the virtual channel.
DAQmx_.PhysicalChanName = hex2dec('18F5'); % Indicates the name of the physical channel upon which this virtual channel is based.
DAQmx_.ChanDescr = hex2dec('1926'); % Specifies a user-defined description for the channel.
DAQmx_.AI_Max = hex2dec('17DD'); % Specifies the maximum value you expect to measure. This value is in the units you specify with a units property. When you query this property, it returns the coerced maximum value that the device can measure with the current settings.
DAQmx_.AI_Min = hex2dec('17DE'); % Specifies the minimum value you expect to measure. This value is in the units you specify with a units property.When you query this property, it returns the coerced minimum value that the device can measure with the current settings.
DAQmx_.AI_CustomScaleName = hex2dec('17E0'); % Specifies the name of a custom scale for the channel.
DAQmx_.AI_MeasType = hex2dec('0695'); % Indicates the measurement to take with the analog input channel and in some cases, such as for temperature measurements, the sensor to use.
DAQmx_.AI_Voltage_Units = hex2dec('1094'); % Specifies the units to use to return voltage measurements from the channel.
DAQmx_.AI_Temp_Units = hex2dec('1033'); % Specifies the units to use to return temperature measurements from the channel.
DAQmx_.AI_Thrmcpl_Type = hex2dec('1050'); % Specifies the type of thermocouple connected to the channel. Thermocouple types differ in composition and measurement range.
DAQmx_.AI_Thrmcpl_CJCSrc = hex2dec('1035'); % Indicates the source of cold-junction compensation.
DAQmx_.AI_Thrmcpl_CJCVal = hex2dec('1036'); % Specifies the temperature of the cold junction if CJC Source is DAQmx_.Val_ConstVal. Specify this value in the units of the measurement.
DAQmx_.AI_Thrmcpl_CJCChan = hex2dec('1034'); % Indicates the channel that acquires the temperature of the cold junction if CJC Source is DAQmx_.Val_Chan. If the channel is a temperature channel, NI-DAQmx acquires the temperature in the correct units. Other channel types, such as a resistance channel with a custom sensor, must use a custom scale to scale values to degrees Celsius.
DAQmx_.AI_RTD_Type = hex2dec('1032'); % Specifies the type of RTD connected to the channel.
DAQmx_.AI_RTD_R0 = hex2dec('1030'); % Specifies in ohms the sensor resistance at 0 deg C. The Callendar-Van Dusen equation requires this value. Refer to the sensor documentation to determine this value.
DAQmx_.AI_RTD_A = hex2dec('1010'); % Specifies the 'A' constant of the Callendar-Van Dusen equation. NI-DAQmx requires this value when you use a custom RTD.
DAQmx_.AI_RTD_B = hex2dec('1011'); % Specifies the 'B' constant of the Callendar-Van Dusen equation. NI-DAQmx requires this value when you use a custom RTD.
DAQmx_.AI_RTD_C = hex2dec('1013'); % Specifies the 'C' constant of the Callendar-Van Dusen equation. NI-DAQmx requires this value when you use a custom RTD.
DAQmx_.AI_Thrmstr_A = hex2dec('18C9'); % Specifies the 'A' constant of the Steinhart-Hart thermistor equation.
DAQmx_.AI_Thrmstr_B = hex2dec('18CB'); % Specifies the 'B' constant of the Steinhart-Hart thermistor equation.
DAQmx_.AI_Thrmstr_C = hex2dec('18CA'); % Specifies the 'C' constant of the Steinhart-Hart thermistor equation.
DAQmx_.AI_Thrmstr_R1 = hex2dec('1061'); % Specifies in ohms the value of the reference resistor if you use voltage excitation. NI-DAQmx ignores this value for current excitation.
DAQmx_.AI_ForceReadFromChan = hex2dec('18F8'); % Specifies whether to read from the channel if it is a cold-junction compensation channel. By default, an NI-DAQmx Read function does not return data from cold-junction compensation channels.Setting this property to TRUE forces read operations to return the cold-junction compensation channel data with the other channels in the task.
DAQmx_.AI_Current_Units = hex2dec('0701'); % Specifies the units to use to return current measurements from the channel.
DAQmx_.AI_Strain_Units = hex2dec('0981'); % Specifies the units to use to return strain measurements from the channel.
DAQmx_.AI_StrainGage_GageFactor = hex2dec('0994'); % Specifies the sensitivity of the strain gage.Gage factor relates the change in electrical resistance to the change in strain. Refer to the sensor documentation for this value.
DAQmx_.AI_StrainGage_PoissonRatio = hex2dec('0998'); % Specifies the ratio of lateral strain to axial strain in the material you are measuring.
DAQmx_.AI_StrainGage_Cfg = hex2dec('0982'); % Specifies the bridge configuration of the strain gages.
DAQmx_.AI_Resistance_Units = hex2dec('0955'); % Specifies the units to use to return resistance measurements.
DAQmx_.AI_Freq_Units = hex2dec('0806'); % Specifies the units to use to return frequency measurements from the channel.
DAQmx_.AI_Freq_ThreshVoltage = hex2dec('0815'); % Specifies the voltage level at which to recognize waveform repetitions. You should select a voltage level that occurs only once within the entire period of a waveform. You also can select a voltage that occurs only once while the voltage rises or falls.
DAQmx_.AI_Freq_Hyst = hex2dec('0814'); % Specifies in volts a window below Threshold Level. The input voltage must pass below Threshold Level minus this value before NI-DAQmx recognizes a waveform repetition at Threshold Level. Hysteresis can improve the measurement accuracy when the signal contains noise or jitter.
DAQmx_.AI_LVDT_Units = hex2dec('0910'); % Specifies the units to use to return linear position measurements from the channel.
DAQmx_.AI_LVDT_Sensitivity = hex2dec('0939'); % Specifies the sensitivity of the LVDT. This value is in the units you specify with Sensitivity Units. Refer to the sensor documentation to determine this value.
DAQmx_.AI_LVDT_SensitivityUnits = hex2dec('219A'); % Specifies the units of Sensitivity.
DAQmx_.AI_RVDT_Units = hex2dec('0877'); % Specifies the units to use to return angular position measurements from the channel.
DAQmx_.AI_RVDT_Sensitivity = hex2dec('0903'); % Specifies the sensitivity of the RVDT. This value is in the units you specify with Sensitivity Units. Refer to the sensor documentation to determine this value.
DAQmx_.AI_RVDT_SensitivityUnits = hex2dec('219B'); % Specifies the units of Sensitivity.
DAQmx_.AI_SoundPressure_MaxSoundPressureLvl = hex2dec('223A'); % Specifies the maximum instantaneous sound pressure level you expect to measure. This value is in decibels, referenced to 20 micropascals. NI-DAQmx uses the maximum sound pressure level to calculate values in pascals for Maximum Value and Minimum Value for the channel.
DAQmx_.AI_SoundPressure_Units = hex2dec('1528'); % Specifies the units to use to return sound pressure measurements from the channel.
DAQmx_.AI_Microphone_Sensitivity = hex2dec('1536'); % Specifies the sensitivity of the microphone. This value is in mV/Pa. Refer to the sensor documentation to determine this value.
DAQmx_.AI_Accel_Units = hex2dec('0673'); % Specifies the units to use to return acceleration measurements from the channel.
DAQmx_.AI_Accel_Sensitivity = hex2dec('0692'); % Specifies the sensitivity of the accelerometer. This value is in the units you specify with Sensitivity Units. Refer to the sensor documentation to determine this value.
DAQmx_.AI_Accel_SensitivityUnits = hex2dec('219C'); % Specifies the units of Sensitivity.
DAQmx_.AI_TEDS_Units = hex2dec('21E0'); % Indicates the units defined by TEDS information associated with the channel.
DAQmx_.AI_Coupling = hex2dec('0064'); % Specifies the coupling for the channel.
DAQmx_.AI_Impedance = hex2dec('0062'); % Specifies the input impedance of the channel.
DAQmx_.AI_TermCfg = hex2dec('1097'); % Specifies the terminal configuration for the channel.
DAQmx_.AI_InputSrc = hex2dec('2198'); % Specifies the source of the channel. You can use the signal from the I/O connector or one of several calibration signals. Certain devices have a single calibration signal bus. For these devices, you must specify the same calibration signal for all channels you connect to a calibration signal.
DAQmx_.AI_ResistanceCfg = hex2dec('1881'); % Specifies the resistance configuration for the channel. NI-DAQmx uses this value for any resistance-based measurements, including temperature measurement using a thermistor or RTD.
DAQmx_.AI_LeadWireResistance = hex2dec('17EE'); % Specifies in ohms the resistance of the wires that lead to the sensor.
DAQmx_.AI_Bridge_Cfg = hex2dec('0087'); % Specifies the type of Wheatstone bridge that the sensor is.
DAQmx_.AI_Bridge_NomResistance = hex2dec('17EC'); % Specifies in ohms the resistance across each arm of the bridge in an unloaded position.
DAQmx_.AI_Bridge_InitialVoltage = hex2dec('17ED'); % Specifies in volts the output voltage of the bridge in the unloaded condition. NI-DAQmx subtracts this value from any measurements before applying scaling equations.
DAQmx_.AI_Bridge_ShuntCal_Enable = hex2dec('0094'); % Specifies whether to enable a shunt calibration switch. Use Shunt Cal Select to select the switch(es) to enable.
DAQmx_.AI_Bridge_ShuntCal_Select = hex2dec('21D5'); % Specifies which shunt calibration switch(es) to enable.Use Shunt Cal Enable to enable the switch(es) you specify with this property.
DAQmx_.AI_Bridge_ShuntCal_GainAdjust = hex2dec('193F'); % Specifies the result of a shunt calibration. NI-DAQmx multiplies data read from the channel by the value of this property. This value should be close to 1.0.
DAQmx_.AI_Bridge_Balance_CoarsePot = hex2dec('17F1'); % Specifies by how much to compensate for offset in the signal. This value can be between 0 and 127.
DAQmx_.AI_Bridge_Balance_FinePot = hex2dec('18F4'); % Specifies by how much to compensate for offset in the signal. This value can be between 0 and 4095.
DAQmx_.AI_CurrentShunt_Loc = hex2dec('17F2'); % Specifies the shunt resistor location for current measurements.
DAQmx_.AI_CurrentShunt_Resistance = hex2dec('17F3'); % Specifies in ohms the external shunt resistance for current measurements.
DAQmx_.AI_Excit_Src = hex2dec('17F4'); % Specifies the source of excitation.
DAQmx_.AI_Excit_Val = hex2dec('17F5'); % Specifies the amount of excitation that the sensor requires. If Voltage or Current isDAQmx_.Val_Voltage, this value is in volts. If Voltage or Current isDAQmx_.Val_Current, this value is in amperes.
DAQmx_.AI_Excit_UseForScaling = hex2dec('17FC'); % Specifies if NI-DAQmx divides the measurement by the excitation. You should typically set this property to TRUE for ratiometric transducers. If you set this property to TRUE, set Maximum Value and Minimum Value to reflect the scaling.
DAQmx_.AI_Excit_UseMultiplexed = hex2dec('2180'); % Specifies if the SCXI-1122 multiplexes the excitation to the upper half of the channels as it advances through the scan list.
DAQmx_.AI_Excit_ActualVal = hex2dec('1883'); % Specifies the actual amount of excitation supplied by an internal excitation source.If you read an internal excitation source more precisely with an external device, set this property to the value you read.NI-DAQmx ignores this value for external excitation.
DAQmx_.AI_Excit_DCorAC = hex2dec('17FB'); % Specifies if the excitation supply is DC or AC.
DAQmx_.AI_Excit_VoltageOrCurrent = hex2dec('17F6'); % Specifies if the channel uses current or voltage excitation.
DAQmx_.AI_ACExcit_Freq = hex2dec('0101'); % Specifies the AC excitation frequency in Hertz.
DAQmx_.AI_ACExcit_SyncEnable = hex2dec('0102'); % Specifies whether to synchronize the AC excitation source of the channel to that of another channel. Synchronize the excitation sources of multiple channels to use multichannel sensors. Set this property to FALSE for the master channel and to TRUE for the slave channels.
DAQmx_.AI_ACExcit_WireMode = hex2dec('18CD'); % Specifies the number of leads on the LVDT or RVDT. Some sensors require you to tie leads together to create a four- or five- wire sensor. Refer to the sensor documentation for more information.
DAQmx_.AI_Atten = hex2dec('1801'); % Specifies the amount of attenuation to use.
DAQmx_.AI_Lowpass_Enable = hex2dec('1802'); % Specifies whether to enable the lowpass filter of the channel.
DAQmx_.AI_Lowpass_CutoffFreq = hex2dec('1803'); % Specifies the frequency in Hertz that corresponds to the -3dB cutoff of the filter.
DAQmx_.AI_Lowpass_SwitchCap_ClkSrc = hex2dec('1884'); % Specifies the source of the filter clock. If you need a higher resolution for the filter, you can supply an external clock to increase the resolution. Refer to the SCXI-1141/1142/1143 User Manual for more information.
DAQmx_.AI_Lowpass_SwitchCap_ExtClkFreq = hex2dec('1885'); % Specifies the frequency of the external clock when you set Clock Source to DAQmx_.Val_External.NI-DAQmx uses this frequency to set the pre- and post- filters on the SCXI-1141, SCXI-1142, and SCXI-1143. On those devices, NI-DAQmx determines the filter cutoff by using the equation f/(100*n), where f is the external frequency, and n is the external clock divisor. Refer to the SCXI-1141/1142/1143 User Manual for more...
DAQmx_.AI_Lowpass_SwitchCap_ExtClkDiv = hex2dec('1886'); % Specifies the divisor for the external clock when you set Clock Source to DAQmx_.Val_External. On the SCXI-1141, SCXI-1142, and SCXI-1143, NI-DAQmx determines the filter cutoff by using the equation f/(100*n), where f is the external frequency, and n is the external clock divisor. Refer to the SCXI-1141/1142/1143 User Manual for more information.
DAQmx_.AI_Lowpass_SwitchCap_OutClkDiv = hex2dec('1887'); % Specifies the divisor for the output clock.NI-DAQmx uses the cutoff frequency to determine the output clock frequency. Refer to the SCXI-1141/1142/1143 User Manual for more information.
DAQmx_.AI_ResolutionUnits = hex2dec('1764'); % Indicates the units of Resolution Value.
DAQmx_.AI_Resolution = hex2dec('1765'); % Indicates the resolution of the analog-to-digital converter of the channel. This value is in the units you specify with Resolution Units.
DAQmx_.AI_Dither_Enable = hex2dec('0068'); % Specifies whether to enable dithering.Dithering adds Gaussian noise to the input signal. You can use dithering to achieve higher resolution measurements by over sampling the input signal and averaging the results.
DAQmx_.AI_Rng_High = hex2dec('1815'); % Specifies the upper limit of the input range of the device. This value is in the native units of the device. On E Series devices, for example, the native units is volts.
DAQmx_.AI_Rng_Low = hex2dec('1816'); % Specifies the lower limit of the input range of the device. This value is in the native units of the device. On E Series devices, for example, the native units is volts.
DAQmx_.AI_Gain = hex2dec('1818'); % Specifies a gain factor to apply to the channel.
DAQmx_.AI_SampAndHold_Enable = hex2dec('181A'); % Specifies whether to enable the sample and hold circuitry of the device. When you disable sample and hold circuitry, a small voltage offset might be introduced into the signal.You can eliminate this offset by using Auto Zero Mode to perform an auto zero on the channel.
DAQmx_.AI_AutoZeroMode = hex2dec('1760'); % Specifies when to measure ground. NI-DAQmx subtracts the measured ground voltage from every sample.
DAQmx_.AI_DataXferMech = hex2dec('1821'); % Specifies the data transfer mode for the device.
DAQmx_.AI_DataXferReqCond = hex2dec('188B'); % Specifies under what condition to transfer data from the onboard memory of the device to the buffer.
DAQmx_.AI_MemMapEnable = hex2dec('188C'); % Specifies for NI-DAQmx to map hardware registers to the memory space of the customer process, if possible. Mapping to the memory space of the customer process increases performance. However, memory mapping can adversely affect the operation of the device and possibly result in a system crash if software in the process unintentionally accesses the mapped registers.
DAQmx_.AI_DevScalingCoeff = hex2dec('1930'); % Indicates the coefficients of a polynomial equation that NI-DAQmx uses to scale values from the native format of the device to volts. Each element of the array corresponds to a term of the equation. For example, if index two of the array is 4, the third term of the equation is 4x^2. Scaling coefficients do not account for any custom scales or sensors contained by the channel.
DAQmx_.AI_EnhancedAliasRejectionEnable = hex2dec('2294'); % Specifies whether to enable enhanced alias rejection. By default, enhanced alias rejection is enabled on supported devices. Leave this property set to the default value for most applications.
DAQmx_.AO_Max = hex2dec('1186'); % Specifies the maximum value you expect to generate. The value is in the units you specify with a units property. If you try to write a value larger than the maximum value, NI-DAQmx generates an error. NI-DAQmx might coerce this value to a smaller value if other task settings restrict the device from generating the desired maximum.
DAQmx_.AO_Min = hex2dec('1187'); % Specifies the minimum value you expect to generate. The value is in the units you specify with a units property. If you try to write a value smaller than the minimum value, NI-DAQmx generates an error. NI-DAQmx might coerce this value to a larger value if other task settings restrict the device from generating the desired minimum.
DAQmx_.AO_CustomScaleName = hex2dec('1188'); % Specifies the name of a custom scale for the channel.
DAQmx_.AO_OutputType = hex2dec('1108'); % Indicates whether the channel generates voltage or current.
DAQmx_.AO_Voltage_Units = hex2dec('1184'); % Specifies in what units to generate voltage on the channel. Write data to the channel in the units you select.
DAQmx_.AO_Current_Units = hex2dec('1109'); % Specifies in what units to generate current on the channel. Write data to the channel is in the units you select.
DAQmx_.AO_OutputImpedance = hex2dec('1490'); % Specifies in ohms the impedance of the analog output stage of the device.
DAQmx_.AO_LoadImpedance = hex2dec('0121'); % Specifies in ohms the load impedance connected to the analog output channel.
DAQmx_.AO_IdleOutputBehavior = hex2dec('2240'); % Specifies the state of the channel when no generation is in progress.
DAQmx_.AO_TermCfg = hex2dec('188E'); % Specifies the terminal configuration of the channel.
DAQmx_.AO_ResolutionUnits = hex2dec('182B'); % Specifies the units of Resolution Value.
DAQmx_.AO_Resolution = hex2dec('182C'); % Indicates the resolution of the digital-to-analog converter of the channel. This value is in the units you specify with Resolution Units.
DAQmx_.AO_DAC_Rng_High = hex2dec('182E'); % Specifies the upper limit of the output range of the device. This value is in the native units of the device. On E Series devices, for example, the native units is volts.
DAQmx_.AO_DAC_Rng_Low = hex2dec('182D'); % Specifies the lower limit of the output range of the device. This value is in the native units of the device. On E Series devices, for example, the native units is volts.
DAQmx_.AO_DAC_Ref_ConnToGnd = hex2dec('0130'); % Specifies whether to ground the internal DAC reference. Grounding the internal DAC reference has the effect of grounding all analog output channels and stopping waveform generation across all analog output channels regardless of whether the channels belong to the current task. You can ground the internal DAC reference only when Source is DAQmx_.Val_Internal and Allow Connecting DAC Reference to Ground at Runtime is...
DAQmx_.AO_DAC_Ref_AllowConnToGnd = hex2dec('1830'); % Specifies whether to allow grounding the internal DAC reference at run time. You must set this property to TRUE and set Source to DAQmx_.Val_Internal before you can set Connect DAC Reference to Ground to TRUE.
DAQmx_.AO_DAC_Ref_Src = hex2dec('0132'); % Specifies the source of the DAC reference voltage. The value of this voltage source determines the full-scale value of the DAC.
DAQmx_.AO_DAC_Ref_ExtSrc = hex2dec('2252'); % Specifies the source of the DAC reference voltage if Source is DAQmx_.Val_External.
DAQmx_.AO_DAC_Ref_Val = hex2dec('1832'); % Specifies in volts the value of the DAC reference voltage. This voltage determines the full-scale range of the DAC. Smaller reference voltages result in smaller ranges, but increased resolution.
DAQmx_.AO_DAC_Offset_Src = hex2dec('2253'); % Specifies the source of the DAC offset voltage. The value of this voltage source determines the full-scale value of the DAC.
DAQmx_.AO_DAC_Offset_ExtSrc = hex2dec('2254'); % Specifies the source of the DAC offset voltage if Source is DAQmx_.Val_External.
DAQmx_.AO_DAC_Offset_Val = hex2dec('2255'); % Specifies in volts the value of the DAC offset voltage.
DAQmx_.AO_ReglitchEnable = hex2dec('0133'); % Specifies whether to enable reglitching.The output of a DAC normally glitches whenever the DAC is updated with a new value. The amount of glitching differs from code to code and is generally largest at major code transitions.Reglitching generates uniform glitch energy at each code transition and provides for more uniform glitches.Uniform glitch energy makes it easier to filter out the noise introduced from g...
DAQmx_.AO_Gain = hex2dec('0118'); % Specifies in decibels the gain factor to apply to the channel.
DAQmx_.AO_UseOnlyOnBrdMem = hex2dec('183A'); % Specifies whether to write samples directly to the onboard memory of the device, bypassing the memory buffer. Generally, you cannot update onboard memory after you start the task. Onboard memory includes data FIFOs.
DAQmx_.AO_DataXferMech = hex2dec('0134'); % Specifies the data transfer mode for the device.
DAQmx_.AO_DataXferReqCond = hex2dec('183C'); % Specifies under what condition to transfer data from the buffer to the onboard memory of the device.
DAQmx_.AO_MemMapEnable = hex2dec('188F'); % Specifies if NI-DAQmx maps hardware registers to the memory space of the customer process, if possible. Mapping to the memory space of the customer process increases performance. However, memory mapping can adversely affect the operation of the device and possibly result in a system crash if software in the process unintentionally accesses the mapped registers.
DAQmx_.AO_DevScalingCoeff = hex2dec('1931'); % Indicates the coefficients of a linear equation that NI-DAQmx uses to scale values from a voltage to the native format of the device.Each element of the array corresponds to a term of the equation. For example, if index two of the array is 4, the third term of the equation is 4x^2.Scaling coefficients do not account for any custom scales that may be applied to the channel.
DAQmx_.DI_InvertLines = hex2dec('0793'); % Specifies whether to invert the lines in the channel. If you set this property to TRUE, the lines are at high logic when off and at low logic when on.
DAQmx_.DI_NumLines = hex2dec('2178'); % Indicates the number of digital lines in the channel.
DAQmx_.DI_DigFltr_Enable = hex2dec('21D6'); % Specifies whether to enable the digital filter for the line(s) or port(s). You can enable the filter on a line-by-line basis. You do not have to enable the filter for all lines in a channel.
DAQmx_.DI_DigFltr_MinPulseWidth = hex2dec('21D7'); % Specifies in seconds the minimum pulse width the filter recognizes as a valid high or low state transition.
DAQmx_.DI_Tristate = hex2dec('1890'); % Specifies whether to tristate the lines in the channel. If you set this property to TRUE, NI-DAQmx tristates the lines in the channel. If you set this property to FALSE, NI-DAQmx does not modify the configuration of the lines even if the lines were previously tristated. Set this property to FALSE to read lines in other tasks or to read output-only lines.
DAQmx_.DI_DataXferMech = hex2dec('2263'); % Specifies the data transfer mode for the device.
DAQmx_.DI_DataXferReqCond = hex2dec('2264'); % Specifies under what condition to transfer data from the onboard memory of the device to the buffer.
DAQmx_.DO_InvertLines = hex2dec('1133'); % Specifies whether to invert the lines in the channel. If you set this property to TRUE, the lines are at high logic when off and at low logic when on.
DAQmx_.DO_NumLines = hex2dec('2179'); % Indicates the number of digital lines in the channel.
DAQmx_.DO_Tristate = hex2dec('18F3'); % Specifies whether to stop driving the channel and set it to a Hi-Z state.
DAQmx_.DO_UseOnlyOnBrdMem = hex2dec('2265'); % Specifies whether to write samples directly to the onboard memory of the device, bypassing the memory buffer. Generally, you cannot update onboard memory after you start the task. Onboard memory includes data FIFOs.
DAQmx_.DO_DataXferMech = hex2dec('2266'); % Specifies the data transfer mode for the device.
DAQmx_.DO_DataXferReqCond = hex2dec('2267'); % Specifies under what condition to transfer data from the buffer to the onboard memory of the device.
DAQmx_.CI_Max = hex2dec('189C'); % Specifies the maximum value you expect to measure. This value is in the units you specify with a units property. When you query this property, it returns the coerced maximum value that the hardware can measure with the current settings.
DAQmx_.CI_Min = hex2dec('189D'); % Specifies the minimum value you expect to measure. This value is in the units you specify with a units property. When you query this property, it returns the coerced minimum value that the hardware can measure with the current settings.
DAQmx_.CI_CustomScaleName = hex2dec('189E'); % Specifies the name of a custom scale for the channel.
DAQmx_.CI_MeasType = hex2dec('18A0'); % Indicates the measurement to take with the channel.
DAQmx_.CI_Freq_Units = hex2dec('18A1'); % Specifies the units to use to return frequency measurements.
DAQmx_.CI_Freq_Term = hex2dec('18A2'); % Specifies the input terminal of the signal to measure.
DAQmx_.CI_Freq_StartingEdge = hex2dec('0799'); % Specifies between which edges to measure the frequency of the signal.
DAQmx_.CI_Freq_MeasMeth = hex2dec('0144'); % Specifies the method to use to measure the frequency of the signal.
DAQmx_.CI_Freq_MeasTime = hex2dec('0145'); % Specifies in seconds the length of time to measure the frequency of the signal if Method is DAQmx_.Val_HighFreq2Ctr. Measurement accuracy increases with increased measurement time and with increased signal frequency. If you measure a high-frequency signal for too long, however, the count register could roll over, which results in an incorrect measurement.
DAQmx_.CI_Freq_Div = hex2dec('0147'); % Specifies the value by which to divide the input signal ifMethod is DAQmx_.Val_LargeRng2Ctr. The larger the divisor, the more accurate the measurement. However, too large a value could cause the count register to roll over, which results in an incorrect measurement.
DAQmx_.CI_Freq_DigFltr_Enable = hex2dec('21E7'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_Freq_DigFltr_MinPulseWidth = hex2dec('21E8'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_Freq_DigFltr_TimebaseSrc = hex2dec('21E9'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_Freq_DigFltr_TimebaseRate = hex2dec('21EA'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_Freq_DigSync_Enable = hex2dec('21EB'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_Period_Units = hex2dec('18A3'); % Specifies the unit to use to return period measurements.
DAQmx_.CI_Period_Term = hex2dec('18A4'); % Specifies the input terminal of the signal to measure.
DAQmx_.CI_Period_StartingEdge = hex2dec('0852'); % Specifies between which edges to measure the period of the signal.
DAQmx_.CI_Period_MeasMeth = hex2dec('192C'); % Specifies the method to use to measure the period of the signal.
DAQmx_.CI_Period_MeasTime = hex2dec('192D'); % Specifies in seconds the length of time to measure the period of the signal if Method is DAQmx_.Val_HighFreq2Ctr. Measurement accuracy increases with increased measurement time and with increased signal frequency. If you measure a high-frequency signal for too long, however, the count register could roll over, which results in an incorrect measurement.
DAQmx_.CI_Period_Div = hex2dec('192E'); % Specifies the value by which to divide the input signal if Method is DAQmx_.Val_LargeRng2Ctr. The larger the divisor, the more accurate the measurement. However, too large a value could cause the count register to roll over, which results in an incorrect measurement.
DAQmx_.CI_Period_DigFltr_Enable = hex2dec('21EC'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_Period_DigFltr_MinPulseWidth = hex2dec('21ED'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_Period_DigFltr_TimebaseSrc = hex2dec('21EE'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_Period_DigFltr_TimebaseRate = hex2dec('21EF'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_Period_DigSync_Enable = hex2dec('21F0'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_CountEdges_Term = hex2dec('18C7'); % Specifies the input terminal of the signal to measure.
DAQmx_.CI_CountEdges_Dir = hex2dec('0696'); % Specifies whether to increment or decrement the counter on each edge.
DAQmx_.CI_CountEdges_DirTerm = hex2dec('21E1'); % Specifies the source terminal of the digital signal that controls the count direction if Direction is DAQmx_.Val_ExtControlled.
DAQmx_.CI_CountEdges_CountDir_DigFltr_Enable = hex2dec('21F1'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_CountEdges_CountDir_DigFltr_MinPulseWidth = hex2dec('21F2'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_CountEdges_CountDir_DigFltr_TimebaseSrc = hex2dec('21F3'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_CountEdges_CountDir_DigFltr_TimebaseRate = hex2dec('21F4'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_CountEdges_CountDir_DigSync_Enable = hex2dec('21F5'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_CountEdges_InitialCnt = hex2dec('0698'); % Specifies the starting value from which to count.
DAQmx_.CI_CountEdges_ActiveEdge = hex2dec('0697'); % Specifies on which edges to increment or decrement the counter.
DAQmx_.CI_CountEdges_DigFltr_Enable = hex2dec('21F6'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_CountEdges_DigFltr_MinPulseWidth = hex2dec('21F7'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_CountEdges_DigFltr_TimebaseSrc = hex2dec('21F8'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_CountEdges_DigFltr_TimebaseRate = hex2dec('21F9'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_CountEdges_DigSync_Enable = hex2dec('21FA'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_AngEncoder_Units = hex2dec('18A6'); % Specifies the units to use to return angular position measurements from the channel.
DAQmx_.CI_AngEncoder_PulsesPerRev = hex2dec('0875'); % Specifies the number of pulses the encoder generates per revolution. This value is the number of pulses on either signal A or signal B, not the total number of pulses on both signal A and signal B.
DAQmx_.CI_AngEncoder_InitialAngle = hex2dec('0881'); % Specifies the starting angle of the encoder. This value is in the units you specify with Units.
DAQmx_.CI_LinEncoder_Units = hex2dec('18A9'); % Specifies the units to use to return linear encoder measurements from the channel.
DAQmx_.CI_LinEncoder_DistPerPulse = hex2dec('0911'); % Specifies the distance to measure for each pulse the encoder generates on signal A or signal B. This value is in the units you specify with Units.
DAQmx_.CI_LinEncoder_InitialPos = hex2dec('0915'); % Specifies the position of the encoder when the measurement begins. This value is in the units you specify with Units.
DAQmx_.CI_Encoder_DecodingType = hex2dec('21E6'); % Specifies how to count and interpret the pulses the encoder generates on signal A and signal B. DAQmx_.Val_X1, DAQmx_.Val_X2, and DAQmx_.Val_X4 are valid for quadrature encoders only. DAQmx_.Val_TwoPulseCounting is valid for two-pulse encoders only.
DAQmx_.CI_Encoder_AInputTerm = hex2dec('219D'); % Specifies the terminal to which signal A is connected.
DAQmx_.CI_Encoder_AInput_DigFltr_Enable = hex2dec('21FB'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_Encoder_AInput_DigFltr_MinPulseWidth = hex2dec('21FC'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_Encoder_AInput_DigFltr_TimebaseSrc = hex2dec('21FD'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_Encoder_AInput_DigFltr_TimebaseRate = hex2dec('21FE'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_Encoder_AInput_DigSync_Enable = hex2dec('21FF'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_Encoder_BInputTerm = hex2dec('219E'); % Specifies the terminal to which signal B is connected.
DAQmx_.CI_Encoder_BInput_DigFltr_Enable = hex2dec('2200'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_Encoder_BInput_DigFltr_MinPulseWidth = hex2dec('2201'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_Encoder_BInput_DigFltr_TimebaseSrc = hex2dec('2202'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_Encoder_BInput_DigFltr_TimebaseRate = hex2dec('2203'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_Encoder_BInput_DigSync_Enable = hex2dec('2204'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_Encoder_ZInputTerm = hex2dec('219F'); % Specifies the terminal to which signal Z is connected.
DAQmx_.CI_Encoder_ZInput_DigFltr_Enable = hex2dec('2205'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_Encoder_ZInput_DigFltr_MinPulseWidth = hex2dec('2206'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_Encoder_ZInput_DigFltr_TimebaseSrc = hex2dec('2207'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_Encoder_ZInput_DigFltr_TimebaseRate = hex2dec('2208'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_Encoder_ZInput_DigSync_Enable = hex2dec('2209'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_Encoder_ZIndexEnable = hex2dec('0890'); % Specifies whether to use Z indexing for the channel.
DAQmx_.CI_Encoder_ZIndexVal = hex2dec('0888'); % Specifies the value to which to reset the measurement when signal Z is high and signal A and signal B are at the states you specify with Z Index Phase. Specify this value in the units of the measurement.
DAQmx_.CI_Encoder_ZIndexPhase = hex2dec('0889'); % Specifies the states at which signal A and signal B must be while signal Z is high for NI-DAQmx to reset the measurement. If signal Z is never high while signal A and signal B are high, for example, you must choose a phase other than DAQmx_.Val_AHighBHigh.
DAQmx_.CI_PulseWidth_Units = hex2dec('0823'); % Specifies the units to use to return pulse width measurements.
DAQmx_.CI_PulseWidth_Term = hex2dec('18AA'); % Specifies the input terminal of the signal to measure.
DAQmx_.CI_PulseWidth_StartingEdge = hex2dec('0825'); % Specifies on which edge of the input signal to begin each pulse width measurement.
DAQmx_.CI_PulseWidth_DigFltr_Enable = hex2dec('220A'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_PulseWidth_DigFltr_MinPulseWidth = hex2dec('220B'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_PulseWidth_DigFltr_TimebaseSrc = hex2dec('220C'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_PulseWidth_DigFltr_TimebaseRate = hex2dec('220D'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_PulseWidth_DigSync_Enable = hex2dec('220E'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_TwoEdgeSep_Units = hex2dec('18AC'); % Specifies the units to use to return two-edge separation measurements from the channel.
DAQmx_.CI_TwoEdgeSep_FirstTerm = hex2dec('18AD'); % Specifies the source terminal of the digital signal that starts each measurement.
DAQmx_.CI_TwoEdgeSep_FirstEdge = hex2dec('0833'); % Specifies on which edge of the first signal to start each measurement.
DAQmx_.CI_TwoEdgeSep_First_DigFltr_Enable = hex2dec('220F'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_TwoEdgeSep_First_DigFltr_MinPulseWidth = hex2dec('2210'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_TwoEdgeSep_First_DigFltr_TimebaseSrc = hex2dec('2211'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_TwoEdgeSep_First_DigFltr_TimebaseRate = hex2dec('2212'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_TwoEdgeSep_First_DigSync_Enable = hex2dec('2213'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_TwoEdgeSep_SecondTerm = hex2dec('18AE'); % Specifies the source terminal of the digital signal that stops each measurement.
DAQmx_.CI_TwoEdgeSep_SecondEdge = hex2dec('0834'); % Specifies on which edge of the second signal to stop each measurement.
DAQmx_.CI_TwoEdgeSep_Second_DigFltr_Enable = hex2dec('2214'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_TwoEdgeSep_Second_DigFltr_MinPulseWidth = hex2dec('2215'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_TwoEdgeSep_Second_DigFltr_TimebaseSrc = hex2dec('2216'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_TwoEdgeSep_Second_DigFltr_TimebaseRate = hex2dec('2217'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_TwoEdgeSep_Second_DigSync_Enable = hex2dec('2218'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_SemiPeriod_Units = hex2dec('18AF'); % Specifies the units to use to return semi-period measurements.
DAQmx_.CI_SemiPeriod_Term = hex2dec('18B0'); % Specifies the input terminal of the signal to measure.
DAQmx_.CI_SemiPeriod_DigFltr_Enable = hex2dec('2219'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_SemiPeriod_DigFltr_MinPulseWidth = hex2dec('221A'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_SemiPeriod_DigFltr_TimebaseSrc = hex2dec('221B'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_SemiPeriod_DigFltr_TimebaseRate = hex2dec('221C'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_SemiPeriod_DigSync_Enable = hex2dec('221D'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_CtrTimebaseSrc = hex2dec('0143'); % Specifies the terminal of the timebase to use for the counter.
DAQmx_.CI_CtrTimebaseRate = hex2dec('18B2'); % Specifies in Hertz the frequency of the counter timebase. Specifying the rate of a counter timebase allows you to take measurements in terms of time or frequency rather than in ticks of the timebase. If you use an external timebase and do not specify the rate, you can take measurements only in terms of ticks of the timebase.
DAQmx_.CI_CtrTimebaseActiveEdge = hex2dec('0142'); % Specifies whether a timebase cycle is from rising edge to rising edge or from falling edge to falling edge.
DAQmx_.CI_CtrTimebase_DigFltr_Enable = hex2dec('2271'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CI_CtrTimebase_DigFltr_MinPulseWidth = hex2dec('2272'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CI_CtrTimebase_DigFltr_TimebaseSrc = hex2dec('2273'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CI_CtrTimebase_DigFltr_TimebaseRate = hex2dec('2274'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CI_CtrTimebase_DigSync_Enable = hex2dec('2275'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CI_Count = hex2dec('0148'); % Indicates the current value of the count register.
DAQmx_.CI_OutputState = hex2dec('0149'); % Indicates the current state of the out terminal of the counter.
DAQmx_.CI_TCReached = hex2dec('0150'); % Indicates whether the counter rolled over. When you query this property, NI-DAQmx resets it to FALSE.
DAQmx_.CI_CtrTimebaseMasterTimebaseDiv = hex2dec('18B3'); % Specifies the divisor for an external counter timebase. You can divide the counter timebase in order to measure slower signals without causing the count register to roll over.
DAQmx_.CI_DataXferMech = hex2dec('0200'); % Specifies the data transfer mode for the channel.
DAQmx_.CI_NumPossiblyInvalidSamps = hex2dec('193C'); % Indicates the number of samples that the device might have overwritten before it could transfer them to the buffer.
DAQmx_.CI_DupCountPrevent = hex2dec('21AC'); % Specifies whether to enable duplicate count prevention for the channel.
DAQmx_.CI_Prescaler = hex2dec('2239'); % Specifies the divisor to apply to the signal you connect to the counter source terminal. Scaled data that you read takes this setting into account. You should use a prescaler only when you connect an external signal to the counter source terminal and when that signal has a higher frequency than the fastest onboard timebase.
DAQmx_.CO_OutputType = hex2dec('18B5'); % Indicates how to define pulses generated on the channel.
DAQmx_.CO_Pulse_IdleState = hex2dec('1170'); % Specifies the resting state of the output terminal.
DAQmx_.CO_Pulse_Term = hex2dec('18E1'); % Specifies on which terminal to generate pulses.
DAQmx_.CO_Pulse_Time_Units = hex2dec('18D6'); % Specifies the units in which to define high and low pulse time.
DAQmx_.CO_Pulse_HighTime = hex2dec('18BA'); % Specifies the amount of time that the pulse is at a high voltage. This value is in the units you specify with Units or when you create the channel.
DAQmx_.CO_Pulse_LowTime = hex2dec('18BB'); % Specifies the amount of time that the pulse is at a low voltage. This value is in the units you specify with Units or when you create the channel.
DAQmx_.CO_Pulse_Time_InitialDelay = hex2dec('18BC'); % Specifies in seconds the amount of time to wait before generating the first pulse.
DAQmx_.CO_Pulse_DutyCyc = hex2dec('1176'); % Specifies the duty cycle of the pulses. The duty cycle of a signal is the width of the pulse divided by period. NI-DAQmx uses this ratio and the pulse frequency to determine the width of the pulses and the delay between pulses.
DAQmx_.CO_Pulse_Freq_Units = hex2dec('18D5'); % Specifies the units in which to define pulse frequency.
DAQmx_.CO_Pulse_Freq = hex2dec('1178'); % Specifies the frequency of the pulses to generate. This value is in the units you specify with Units or when you create the channel.
DAQmx_.CO_Pulse_Freq_InitialDelay = hex2dec('0299'); % Specifies in seconds the amount of time to wait before generating the first pulse.
DAQmx_.CO_Pulse_HighTicks = hex2dec('1169'); % Specifies the number of ticks the pulse is high.
DAQmx_.CO_Pulse_LowTicks = hex2dec('1171'); % Specifies the number of ticks the pulse is low.
DAQmx_.CO_Pulse_Ticks_InitialDelay = hex2dec('0298'); % Specifies the number of ticks to wait before generating the first pulse.
DAQmx_.CO_CtrTimebaseSrc = hex2dec('0339'); % Specifies the terminal of the timebase to use for the counter. Typically, NI-DAQmx uses one of the internal counter timebases when generating pulses. Use this property to specify an external timebase and produce custom pulse widths that are not possible using the internal timebases.
DAQmx_.CO_CtrTimebaseRate = hex2dec('18C2'); % Specifies in Hertz the frequency of the counter timebase. Specifying the rate of a counter timebase allows you to define output pulses in seconds rather than in ticks of the timebase. If you use an external timebase and do not specify the rate, you can define output pulses only in ticks of the timebase.
DAQmx_.CO_CtrTimebaseActiveEdge = hex2dec('0341'); % Specifies whether a timebase cycle is from rising edge to rising edge or from falling edge to falling edge.
DAQmx_.CO_CtrTimebase_DigFltr_Enable = hex2dec('2276'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.CO_CtrTimebase_DigFltr_MinPulseWidth = hex2dec('2277'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.CO_CtrTimebase_DigFltr_TimebaseSrc = hex2dec('2278'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.CO_CtrTimebase_DigFltr_TimebaseRate = hex2dec('2279'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.CO_CtrTimebase_DigSync_Enable = hex2dec('227A'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.CO_Count = hex2dec('0293'); % Indicates the current value of the count register.
DAQmx_.CO_OutputState = hex2dec('0294'); % Indicates the current state of the output terminal of the counter.
DAQmx_.CO_AutoIncrCnt = hex2dec('0295'); % Specifies a number of timebase ticks by which to increment each successive pulse.
DAQmx_.CO_CtrTimebaseMasterTimebaseDiv = hex2dec('18C3'); % Specifies the divisor for an external counter timebase. You can divide the counter timebase in order to generate slower signals without causing the count register to roll over.
DAQmx_.CO_PulseDone = hex2dec('190E'); % Indicates if the task completed pulse generation. Use this value for retriggerable pulse generation when you need to determine if the device generated the current pulse. When you query this property, NI-DAQmx resets it to FALSE.
DAQmx_.CO_Prescaler = hex2dec('226D'); % Specifies the divisor to apply to the signal you connect to the counter source terminal. Pulse generations defined by frequency or time take this setting into account, but pulse generations defined by ticks do not. You should use a prescaler only when you connect an external signal to the counter source terminal and when that signal has a higher frequency than the fastest onboard timebase.

%********** Export Signal Attributes **********
DAQmx_.Exported_AIConvClk_OutputTerm = hex2dec('1687'); % Specifies the terminal to which to route the AI Convert Clock.
DAQmx_.Exported_AIConvClk_Pulse_Polarity = hex2dec('1688'); % Indicates the polarity of the exported AI Convert Clock. The polarity is fixed and independent of the active edge of the source of the AI Convert Clock.
DAQmx_.Exported_10MHzRefClk_OutputTerm = hex2dec('226E'); % Specifies the terminal to which to route the 10MHz Clock.
DAQmx_.Exported_20MHzTimebase_OutputTerm = hex2dec('1657'); % Specifies the terminal to which to route the 20MHz Timebase.
DAQmx_.Exported_SampClk_OutputBehavior = hex2dec('186B'); % Specifies whether the exported Sample Clock issues a pulse at the beginning of a sample or changes to a high state for the duration of the sample.
DAQmx_.Exported_SampClk_OutputTerm = hex2dec('1663'); % Specifies the terminal to which to route the Sample Clock.
DAQmx_.Exported_SampClkTimebase_OutputTerm = hex2dec('18F9'); % Specifies the terminal to which to route the Sample Clock Timebase.
DAQmx_.Exported_DividedSampClkTimebase_OutputTerm = hex2dec('21A1'); % Specifies the terminal to which to route the Divided Sample Clock Timebase.
DAQmx_.Exported_AdvTrig_OutputTerm = hex2dec('1645'); % Specifies the terminal to which to route the Advance Trigger.
DAQmx_.Exported_AdvTrig_Pulse_Polarity = hex2dec('1646'); % Indicates the polarity of the exported Advance Trigger.
DAQmx_.Exported_AdvTrig_Pulse_WidthUnits = hex2dec('1647'); % Specifies the units of Width Value.
DAQmx_.Exported_AdvTrig_Pulse_Width = hex2dec('1648'); % Specifies the width of an exported Advance Trigger pulse. Specify this value in the units you specify with Width Units.
DAQmx_.Exported_RefTrig_OutputTerm = hex2dec('0590'); % Specifies the terminal to which to route the Reference Trigger.
DAQmx_.Exported_StartTrig_OutputTerm = hex2dec('0584'); % Specifies the terminal to which to route the Start Trigger.
DAQmx_.Exported_AdvCmpltEvent_OutputTerm = hex2dec('1651'); % Specifies the terminal to which to route the Advance Complete Event.
DAQmx_.Exported_AdvCmpltEvent_Delay = hex2dec('1757'); % Specifies the output signal delay in periods of the sample clock.
DAQmx_.Exported_AdvCmpltEvent_Pulse_Polarity = hex2dec('1652'); % Specifies the polarity of the exported Advance Complete Event.
DAQmx_.Exported_AdvCmpltEvent_Pulse_Width = hex2dec('1654'); % Specifies the width of the exported Advance Complete Event pulse.
DAQmx_.Exported_AIHoldCmpltEvent_OutputTerm = hex2dec('18ED'); % Specifies the terminal to which to route the AI Hold Complete Event.
DAQmx_.Exported_AIHoldCmpltEvent_PulsePolarity = hex2dec('18EE'); % Specifies the polarity of an exported AI Hold Complete Event pulse.
DAQmx_.Exported_ChangeDetectEvent_OutputTerm = hex2dec('2197'); % Specifies the terminal to which to route the Change Detection Event.
DAQmx_.Exported_CtrOutEvent_OutputTerm = hex2dec('1717'); % Specifies the terminal to which to route the Counter Output Event.
DAQmx_.Exported_CtrOutEvent_OutputBehavior = hex2dec('174F'); % Specifies whether the exported Counter Output Event pulses or changes from one state to the other when the counter reaches terminal count.
DAQmx_.Exported_CtrOutEvent_Pulse_Polarity = hex2dec('1718'); % Specifies the polarity of the pulses at the output terminal of the counter when Output Behavior is DAQmx_.Val_Pulse. NI-DAQmx ignores this property if Output Behavior is DAQmx_.Val_Toggle.
DAQmx_.Exported_CtrOutEvent_Toggle_IdleState = hex2dec('186A'); % Specifies the initial state of the output terminal of the counter when Output Behavior is DAQmx_.Val_Toggle. The terminal enters this state when NI-DAQmx commits the task.
DAQmx_.Exported_SyncPulseEvent_OutputTerm = hex2dec('223C'); % Specifies the terminal to which to route the Synchronization Pulse Event.
DAQmx_.Exported_WatchdogExpiredEvent_OutputTerm = hex2dec('21AA'); % Specifies the terminalto which to route the Watchdog Timer Expired Event.

%********** Device Attributes **********
DAQmx_.Dev_ProductType = hex2dec('0631'); % Indicates the product name of the device.
DAQmx_.Dev_SerialNum = hex2dec('0632'); % Indicates the serial number of the device. This value is zero if the device does not have a serial number.

%********** Read Attributes **********
DAQmx_.Read_RelativeTo = hex2dec('190A'); % Specifies the point in the buffer at which to begin a read operation. If you also specify an offset with Offset, the read operation begins at that offset relative to the point you select with this property. The default value is DAQmx_.Val_CurrReadPos unless you configure a Reference Trigger for the task. If you configure a Reference Trigger, the default value is DAQmx_.Val_FirstPretrigSamp.
DAQmx_.Read_Offset = hex2dec('190B'); % Specifies an offset in samples per channel at which to begin a read operation. This offset is relative to the location you specify with RelativeTo.
DAQmx_.Read_ChannelsToRead = hex2dec('1823'); % Specifies a subset of channels in the task from which to read.
DAQmx_.Read_ReadAllAvailSamp = hex2dec('1215'); % Specifies whether subsequent read operations read all samples currently available in the buffer or wait for the buffer to become full before reading. NI-DAQmx uses this setting for finite acquisitions and only when the number of samples to read is -1. For continuous acquisitions when the number of samples to read is -1, a read operation always reads all samples currently available in the buffer.
DAQmx_.Read_AutoStart = hex2dec('1826'); % Specifies if an NI-DAQmx Read function automatically starts the taskif you did not start the task explicitly by using DAQmxStartTask(). The default value is TRUE. Whenan NI-DAQmx Read function starts a finite acquisition task, it also stops the task after reading the last sample.
DAQmx_.Read_OverWrite = hex2dec('1211'); % Specifies whether to overwrite samples in the buffer that you have not yet read.
DAQmx_.Read_CurrReadPos = hex2dec('1221'); % Indicates in samples per channel the current position in the buffer.
DAQmx_.Read_AvailSampPerChan = hex2dec('1223'); % Indicates the number of samples available to read per channel. This value is the same for all channels in the task.
DAQmx_.Read_TotalSampPerChanAcquired = hex2dec('192A'); % Indicates the total number of samples acquired by each channel. NI-DAQmx returns a single value because this value is the same for all channels.
DAQmx_.Read_OverloadedChansExist = hex2dec('2174'); % Indicates if the device detected an overload in any channel in the task. Reading this property clears the overload status for all channels in the task. You must read this property before you read Overloaded Channels. Otherwise, you will receive an error.
DAQmx_.Read_OverloadedChans = hex2dec('2175'); % Indicates the names of any overloaded virtual channels in the task. You must read Overloaded Channels Exist before you read this property. Otherwise, you will receive an error.
DAQmx_.Read_ChangeDetect_HasOverflowed = hex2dec('2194'); % Indicates if samples were missed because change detection events occurred faster than the device could handle them. Some devices detect overflows differently than others.
DAQmx_.Read_RawDataWidth = hex2dec('217A'); % Indicates in bytes the size of a raw sample from the task.
DAQmx_.Read_NumChans = hex2dec('217B'); % Indicates the number of channels that an NI-DAQmx Read function reads from the task. This value is the number of channels in the task or the number of channels you specify with Channels to Read.
DAQmx_.Read_DigitalLines_BytesPerChan = hex2dec('217C'); % Indicates the number of bytes per channel that NI-DAQmx returns in a sample for line-based reads. If a channel has fewer lines than this number, the extra bytes are FALSE.
DAQmx_.ReadWaitMode = hex2dec('2232'); % Specifies how an NI-DAQmx Read function waits for samples to become available.

%********** Switch Channel Attributes **********
DAQmx_.SwitchChan_Usage = hex2dec('18E4'); % Specifies how you can use the channel. Using this property acts as a safety mechanism to prevent you from connecting two source channels, for example.
DAQmx_.SwitchChan_MaxACCarryCurrent = hex2dec('0648'); % Indicates in amperes the maximum AC current that the device can carry.
DAQmx_.SwitchChan_MaxACSwitchCurrent = hex2dec('0646'); % Indicates in amperes the maximum AC current that the device can switch. This current is always against an RMS voltage level.
DAQmx_.SwitchChan_MaxACCarryPwr = hex2dec('0642'); % Indicates in watts the maximum AC power that the device can carry.
DAQmx_.SwitchChan_MaxACSwitchPwr = hex2dec('0644'); % Indicates in watts the maximum AC power that the device can switch.
DAQmx_.SwitchChan_MaxDCCarryCurrent = hex2dec('0647'); % Indicates in amperes the maximum DC current that the device can carry.
DAQmx_.SwitchChan_MaxDCSwitchCurrent = hex2dec('0645'); % Indicates in amperes the maximum DC current that the device can switch. This current is always against a DC voltage level.
DAQmx_.SwitchChan_MaxDCCarryPwr = hex2dec('0643'); % Indicates in watts the maximum DC power that the device can carry.
DAQmx_.SwitchChan_MaxDCSwitchPwr = hex2dec('0649'); % Indicates in watts the maximum DC power that the device can switch.
DAQmx_.SwitchChan_MaxACVoltage = hex2dec('0651'); % Indicates in volts the maximum AC RMS voltage that the device can switch.
DAQmx_.SwitchChan_MaxDCVoltage = hex2dec('0650'); % Indicates in volts the maximum DC voltage that the device can switch.
DAQmx_.SwitchChan_WireMode = hex2dec('18E5'); % Indicates the number of wires that the channel switches.
DAQmx_.SwitchChan_Bandwidth = hex2dec('0640'); % Indicates in Hertz the maximum frequency of a signal that can pass through the switch without significant deterioration.
DAQmx_.SwitchChan_Impedance = hex2dec('0641'); % Indicates in ohms the switch impedance. This value is important in the RF domain and should match the impedance of the sources and loads.

%********** Switch Device Attributes **********
DAQmx_.SwitchDev_SettlingTime = hex2dec('1244'); % Specifies in seconds the amount of time to wait for the switch to settle (or debounce). NI-DAQmx adds this time to the settling time of the motherboard. Modify this property only if the switch does not settle within the settling time of the motherboard. Refer to device documentation for supported settling times.
DAQmx_.SwitchDev_AutoConnAnlgBus = hex2dec('17DA'); % Specifies if NI-DAQmx routes multiplexed channels to the analog bus backplane. Only the SCXI-1127 and SCXI-1128 support this property.
DAQmx_.SwitchDev_Settled = hex2dec('1243'); % Indicates when Settling Time expires.
DAQmx_.SwitchDev_RelayList = hex2dec('17DC'); % Indicates a comma-delimited list of relay names.
DAQmx_.SwitchDev_NumRelays = hex2dec('18E6'); % Indicates the number of relays on the device. This value matches the number of relay names in Relay List.
DAQmx_.SwitchDev_SwitchChanList = hex2dec('18E7'); % Indicates a comma-delimited list of channel names for the current topology of the device.
DAQmx_.SwitchDev_NumSwitchChans = hex2dec('18E8'); % Indicates the number of switch channels for the current topology of the device. This value matches the number of channel names in Switch Channel List.
DAQmx_.SwitchDev_NumRows = hex2dec('18E9'); % Indicates the number of rows on a device in a matrix switch topology. Indicates the number of multiplexed channels on a device in a mux topology.
DAQmx_.SwitchDev_NumColumns = hex2dec('18EA'); % Indicates the number of columns on a device in a matrix switch topology. This value is always 1 if the device is in a mux topology.
DAQmx_.SwitchDev_Topology = hex2dec('193D'); % Indicates the current topology of the device. This value is one of the topology options in DAQmxSwitchSetTopologyAndReset().

%********** Switch Scan Attributes **********
DAQmx_.SwitchScan_BreakMode = hex2dec('1247'); % Specifies the break mode between each entry in a scan list.
DAQmx_.SwitchScan_RepeatMode = hex2dec('1248'); % Specifies if the task advances through the scan list multiple times.
DAQmx_.SwitchScan_WaitingForAdv = hex2dec('17D9'); % Indicates if the switch hardware is waiting for anAdvance Trigger. If the hardware is waiting, it completed the previous entry in the scan list.

%********** Scale Attributes **********
DAQmx_.Scale_Descr = hex2dec('1226'); % Specifies a description for the scale.
DAQmx_.Scale_ScaledUnits = hex2dec('191B'); % Specifies the units to use for scaled values. You can use an arbitrary string.
DAQmx_.Scale_PreScaledUnits = hex2dec('18F7'); % Specifies the units of the values that you want to scale.
DAQmx_.Scale_Type = hex2dec('1929'); % Indicates the method or equation form that the custom scale uses.
DAQmx_.Scale_Lin_Slope = hex2dec('1227'); % Specifies the slope, m, in the equation y = mx+b.
DAQmx_.Scale_Lin_YIntercept = hex2dec('1228'); % Specifies the y-intercept, b, in the equation y = mx+b.
DAQmx_.Scale_Map_ScaledMax = hex2dec('1229'); % Specifies the largest value in the range of scaled values. NI-DAQmx maps this value to Pre-Scaled Maximum Value. Reads clip samples that are larger than this value. Writes generate errors for samples that are larger than this value.
DAQmx_.Scale_Map_PreScaledMax = hex2dec('1231'); % Specifies the largest value in the range of pre-scaled values. NI-DAQmx maps this value to Scaled Maximum Value.
DAQmx_.Scale_Map_ScaledMin = hex2dec('1230'); % Specifies the smallest value in the range of scaled values. NI-DAQmx maps this value to Pre-Scaled Minimum Value. Reads clip samples that are smaller than this value. Writes generate errors for samples that are smaller than this value.
DAQmx_.Scale_Map_PreScaledMin = hex2dec('1232'); % Specifies the smallest value in the range of pre-scaled values. NI-DAQmx maps this value to Scaled Minimum Value.
DAQmx_.Scale_Poly_ForwardCoeff = hex2dec('1234'); % Specifies an array of coefficients for the polynomial that converts pre-scaled values to scaled values. Each element of the array corresponds to a term of the equation. For example, if index three of the array is 9, the fourth term of the equation is 9x^3.
DAQmx_.Scale_Poly_ReverseCoeff = hex2dec('1235'); % Specifies an array of coefficients for the polynomial that converts scaled values to pre-scaled values. Each element of the array corresponds to a term of the equation. For example, if index three of the array is 9, the fourth term of the equation is 9y^3.
DAQmx_.Scale_Table_ScaledVals = hex2dec('1236'); % Specifies an array of scaled values. These values map directly to the values in Pre-Scaled Values.
DAQmx_.Scale_Table_PreScaledVals = hex2dec('1237'); % Specifies an array of pre-scaled values. These values map directly to the values in Scaled Values.

%********** System Attributes **********
DAQmx_.Sys_GlobalChans = hex2dec('1265'); % Indicates an array that contains the names of all global channels saved on the system.
DAQmx_.Sys_Scales = hex2dec('1266'); % Indicates an array that contains the names of all custom scales saved on the system.
DAQmx_.Sys_Tasks = hex2dec('1267'); % Indicates an array that contains the names of all tasks saved on the system.
DAQmx_.Sys_DevNames = hex2dec('193B'); % Indicates an array that contains the names of all devices installed in the system.
DAQmx_.Sys_NIDAQMajorVersion = hex2dec('1272'); % Indicates the major portion of the installed version of NI-DAQ, such as 7 for version 7.0.
DAQmx_.Sys_NIDAQMinorVersion = hex2dec('1923'); % Indicates the minor portion of the installed version of NI-DAQ, such as 0 for version 7.0.

%********** Task Attributes **********
DAQmx_.Task_Name = hex2dec('1276'); % Indicates the name of the task.
DAQmx_.Task_Channels = hex2dec('1273'); % Indicates the names of all virtual channels in the task.
DAQmx_.Task_NumChans = hex2dec('2181'); % Indicates the number of virtual channels in the task.
DAQmx_.Task_Complete = hex2dec('1274'); % Indicates whether the task completed execution.

%********** Timing Attributes **********
DAQmx_.SampQuant_SampMode = hex2dec('1300'); % Specifies if a task acquires or generates a finite number of samples or if it continuously acquires or generates samples.
DAQmx_.SampQuant_SampPerChan = hex2dec('1310'); % Specifies the number of samples to acquire or generate for each channel if Sample Mode is DAQmx_.Val_FiniteSamps. If Sample Mode is DAQmx_.Val_ContSamps, NI-DAQmx uses this value to determine the buffer size.
DAQmx_.SampTimingType = hex2dec('1347'); % Specifies the type of sample timing to use for the task.
DAQmx_.SampClk_Rate = hex2dec('1344'); % Specifies the sampling rate in samples per channel per second. If you use an external source for the Sample Clock, set this input to the maximum expected rate of that clock.
DAQmx_.SampClk_Src = hex2dec('1852'); % Specifies the terminal of the signal to use as the Sample Clock.
DAQmx_.SampClk_ActiveEdge = hex2dec('1301'); % Specifies on which edge of a clock pulse sampling takes place. This property is useful primarily when the signal you use as the Sample Clock is not a periodic clock.
DAQmx_.SampClk_TimebaseDiv = hex2dec('18EB'); % Specifies the number of Sample Clock Timebase pulses needed to produce a single Sample Clock pulse.
DAQmx_.SampClk_Timebase_Rate = hex2dec('1303'); % Specifies the rate of the Sample Clock Timebase. Some applications require that you specify a rate when you use any signal other than the onboard Sample Clock Timebase. NI-DAQmx requires this rate to calculate other timing parameters.
DAQmx_.SampClk_Timebase_Src = hex2dec('1308'); % Specifies the terminal of the signal to use as the Sample Clock Timebase.
DAQmx_.SampClk_Timebase_ActiveEdge = hex2dec('18EC'); % Specifies on which edge to recognize a Sample Clock Timebase pulse. This property is useful primarily when the signal you use as the Sample Clock Timebase is not a periodic clock.
DAQmx_.SampClk_Timebase_MasterTimebaseDiv = hex2dec('1305'); % Specifies the number of pulses of the Master Timebase needed to produce a single pulse of the Sample Clock Timebase.
DAQmx_.SampClk_DigFltr_Enable = hex2dec('221E'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.SampClk_DigFltr_MinPulseWidth = hex2dec('221F'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.SampClk_DigFltr_TimebaseSrc = hex2dec('2220'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.SampClk_DigFltr_TimebaseRate = hex2dec('2221'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.SampClk_DigSync_Enable = hex2dec('2222'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.ChangeDetect_DI_RisingEdgePhysicalChans = hex2dec('2195'); % Specifies the names of the digital lines or ports on which to detect rising edges. The lines or ports must be used by virtual channels in the task. You also can specify a string that contains a list or range of digital lines or ports.
DAQmx_.ChangeDetect_DI_FallingEdgePhysicalChans = hex2dec('2196'); % Specifies the names of the digital lines or ports on which to detect rising edges. The lines or ports must be used by virtual channels in the task. You also can specify a string that contains a list or range of digital lines or ports.
DAQmx_.OnDemand_SimultaneousAOEnable = hex2dec('21A0'); % Specifies whether to update all channels in the task simultaneously, rather than updating channels independently when you write a sample to that channel.
DAQmx_.AIConv_Rate = hex2dec('1848'); % Specifies the rate at which to clock the analog-to-digital converter. This clock is specific to the analog input section of an E Series device.
DAQmx_.AIConv_Src = hex2dec('1502'); % Specifies the terminal of the signal to use as the AI Convert Clock.
DAQmx_.AIConv_ActiveEdge = hex2dec('1853'); % Specifies on which edge of the clock pulse an analog-to-digital conversion takes place.
DAQmx_.AIConv_TimebaseDiv = hex2dec('1335'); % Specifies the number of AI Convert Clock Timebase pulses needed to produce a single AI Convert Clock pulse.
DAQmx_.AIConv_Timebase_Src = hex2dec('1339'); % Specifies the terminalof the signal to use as the AI Convert Clock Timebase.
DAQmx_.MasterTimebase_Rate = hex2dec('1495'); % Specifies the rate of the Master Timebase.
DAQmx_.MasterTimebase_Src = hex2dec('1343'); % Specifies the terminal of the signal to use as the Master Timebase. On an E Series device, you can choose only between the onboard 20MHz Timebase or the RTSI7 terminal.
DAQmx_.RefClk_Rate = hex2dec('1315'); % Specifies the frequency of the Reference Clock.
DAQmx_.RefClk_Src = hex2dec('1316'); % Specifies the terminal of the signal to use as the Reference Clock.
DAQmx_.SyncPulse_Src = hex2dec('223D'); % Specifies the terminal of the signal to use as the synchronization pulse. The synchronization pulse resets the clock dividers and the ADCs/DACs on the device.
DAQmx_.SyncPulse_SyncTime = hex2dec('223E'); % Indicates in seconds the delay required to reset the ADCs/DACs after the device receives the synchronization pulse.
DAQmx_.SyncPulse_MinDelayToStart = hex2dec('223F'); % Specifies in seconds the amount of time that elapses after the master device issues the synchronization pulse before the task starts.
DAQmx_.DelayFromSampClk_DelayUnits = hex2dec('1304'); % Specifies the units of Delay.
DAQmx_.DelayFromSampClk_Delay = hex2dec('1317'); % Specifies the amount of time to wait after receiving a Sample Clock edge before beginning to acquire the sample. This value is in the units you specify with Delay Units.

%********** Trigger Attributes **********
DAQmx_.StartTrig_Type = hex2dec('1393'); % Specifies the type of trigger to use to start a task.
DAQmx_.DigEdge_StartTrig_Src = hex2dec('1407'); % Specifies the name of a terminal where there is a digital signal to use as the source of the Start Trigger.
DAQmx_.DigEdge_StartTrig_Edge = hex2dec('1404'); % Specifies on which edge of a digital pulse to start acquiring or generating samples.
DAQmx_.DigEdge_StartTrig_DigFltr_Enable = hex2dec('2223'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.DigEdge_StartTrig_DigFltr_MinPulseWidth = hex2dec('2224'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.DigEdge_StartTrig_DigFltr_TimebaseSrc = hex2dec('2225'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.DigEdge_StartTrig_DigFltr_TimebaseRate = hex2dec('2226'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.DigEdge_StartTrig_DigSync_Enable = hex2dec('2227'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.AnlgEdge_StartTrig_Src = hex2dec('1398'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the Start Trigger.
DAQmx_.AnlgEdge_StartTrig_Slope = hex2dec('1397'); % Specifies on which slope of the trigger signal to start acquiring or generating samples.
DAQmx_.AnlgEdge_StartTrig_Lvl = hex2dec('1396'); % Specifies at what threshold in the units of the measurement or generation to start acquiring or generating samples. Use Slope to specify on which slope to trigger on this threshold.
DAQmx_.AnlgEdge_StartTrig_Hyst = hex2dec('1395'); % Specifies a hysteresis level in the units of the measurement or generation. If Slope is DAQmx_.Val_RisingSlope, the trigger does not deassert until the source signal passes belowLevel minus the hysteresis. If Slope is DAQmx_.Val_FallingSlope, the trigger does not deassert until the source signal passes above Level plus the hysteresis.
DAQmx_.AnlgEdge_StartTrig_Coupling = hex2dec('2233'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.AnlgWin_StartTrig_Src = hex2dec('1400'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the Start Trigger.
DAQmx_.AnlgWin_StartTrig_When = hex2dec('1401'); % Specifies whether the task starts acquiring or generating samples when the signal enters or leaves the window you specify with Bottom and Top.
DAQmx_.AnlgWin_StartTrig_Top = hex2dec('1403'); % Specifies the upper limit of the window. Specify this value in the units of the measurement or generation.
DAQmx_.AnlgWin_StartTrig_Btm = hex2dec('1402'); % Specifies the lower limit of the window. Specify this value in the units of the measurement or generation.
DAQmx_.AnlgWin_StartTrig_Coupling = hex2dec('2234'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.StartTrig_Delay = hex2dec('1856'); % Specifies an amount of time to wait after the Start Trigger is received before acquiring or generating the first sample. This value is in the units you specify with Delay Units.
DAQmx_.StartTrig_DelayUnits = hex2dec('18C8'); % Specifies the units of Delay.
DAQmx_.StartTrig_Retriggerable = hex2dec('190F'); % Specifies whether to enable retriggerable counter pulse generation. When you set this property to TRUE, the device generates pulses each time it receives a trigger. The device ignores a trigger if it is in the process of generating pulses.
DAQmx_.RefTrig_Type = hex2dec('1419'); % Specifies the type of trigger to use to mark a reference point for the measurement.
DAQmx_.RefTrig_PretrigSamples = hex2dec('1445'); % Specifies the minimum number of pretrigger samples to acquire from each channel before recognizing the reference trigger. Post-trigger samples per channel are equal to Samples Per Channel minus the number of pretrigger samples per channel.
DAQmx_.DigEdge_RefTrig_Src = hex2dec('1434'); % Specifies the name of a terminal where there is a digital signal to use as the source of the Reference Trigger.
DAQmx_.DigEdge_RefTrig_Edge = hex2dec('1430'); % Specifies on what edge of a digital pulse the Reference Trigger occurs.
DAQmx_.AnlgEdge_RefTrig_Src = hex2dec('1424'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the Reference Trigger.
DAQmx_.AnlgEdge_RefTrig_Slope = hex2dec('1423'); % Specifies on which slope of the source signal the Reference Trigger occurs.
DAQmx_.AnlgEdge_RefTrig_Lvl = hex2dec('1422'); % Specifies in the units of the measurement the threshold at which the Reference Trigger occurs.Use Slope to specify on which slope to trigger at this threshold.
DAQmx_.AnlgEdge_RefTrig_Hyst = hex2dec('1421'); % Specifies a hysteresis level in the units of the measurement. If Slope is DAQmx_.Val_RisingSlope, the trigger does not deassert until the source signal passes below Level minus the hysteresis. If Slope is DAQmx_.Val_FallingSlope, the trigger does not deassert until the source signal passes above Level plus the hysteresis.
DAQmx_.AnlgEdge_RefTrig_Coupling = hex2dec('2235'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.AnlgWin_RefTrig_Src = hex2dec('1426'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the Reference Trigger.
DAQmx_.AnlgWin_RefTrig_When = hex2dec('1427'); % Specifies whether the Reference Trigger occurs when the source signal enters the window or when it leaves the window. Use Bottom and Top to specify the window.
DAQmx_.AnlgWin_RefTrig_Top = hex2dec('1429'); % Specifies the upper limit of the window. Specify this value in the units of the measurement.
DAQmx_.AnlgWin_RefTrig_Btm = hex2dec('1428'); % Specifies the lower limit of the window. Specify this value in the units of the measurement.
DAQmx_.AnlgWin_RefTrig_Coupling = hex2dec('1857'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.AdvTrig_Type = hex2dec('1365'); % Specifies the type of trigger to use to advance to the next entry in a scan list.
DAQmx_.DigEdge_AdvTrig_Src = hex2dec('1362'); % Specifies the name of a terminal where there is a digital signal to use as the source of the Advance Trigger.
DAQmx_.DigEdge_AdvTrig_Edge = hex2dec('1360'); % Specifies on which edge of a digital signal to advance to the next entry in a scan list.
DAQmx_.DigEdge_AdvTrig_DigFltr_Enable = hex2dec('2238'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.PauseTrig_Type = hex2dec('1366'); % Specifies the type of trigger to use to pause a task.
DAQmx_.AnlgLvl_PauseTrig_Src = hex2dec('1370'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the trigger.
DAQmx_.AnlgLvl_PauseTrig_When = hex2dec('1371'); % Specifies whether the task pauses above or below the threshold you specify with Level.
DAQmx_.AnlgLvl_PauseTrig_Lvl = hex2dec('1369'); % Specifies the threshold at which to pause the task. Specify this value in the units of the measurement or generation. Use Pause When to specify whether the task pauses above or below this threshold.
DAQmx_.AnlgLvl_PauseTrig_Hyst = hex2dec('1368'); % Specifies a hysteresis level in the units of the measurement or generation. If Pause When is DAQmx_.Val_AboveLvl, the trigger does not deassert until the source signal passes below Level minus the hysteresis. If Pause When is DAQmx_.Val_BelowLvl, the trigger does not deassert until the source signal passes above Level plus the hysteresis.
DAQmx_.AnlgLvl_PauseTrig_Coupling = hex2dec('2236'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.AnlgWin_PauseTrig_Src = hex2dec('1373'); % Specifies the name of a virtual channel or terminal where there is an analog signal to use as the source of the trigger.
DAQmx_.AnlgWin_PauseTrig_When = hex2dec('1374'); % Specifies whether the task pauses while the trigger signal is inside or outside the window you specify with Bottom and Top.
DAQmx_.AnlgWin_PauseTrig_Top = hex2dec('1376'); % Specifies the upper limit of the window. Specify this value in the units of the measurement or generation.
DAQmx_.AnlgWin_PauseTrig_Btm = hex2dec('1375'); % Specifies the lower limit of the window. Specify this value in the units of the measurement or generation.
DAQmx_.AnlgWin_PauseTrig_Coupling = hex2dec('2237'); % Specifies the coupling for the source signal of the trigger if the source is a terminal rather than a virtual channel.
DAQmx_.DigLvl_PauseTrig_Src = hex2dec('1379'); % Specifies the name of a terminal where there is a digital signal to use as the source of the Pause Trigger.
DAQmx_.DigLvl_PauseTrig_When = hex2dec('1380'); % Specifies whether the task pauses while the signal is high or low.
DAQmx_.DigLvl_PauseTrig_DigFltr_Enable = hex2dec('2228'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.DigLvl_PauseTrig_DigFltr_MinPulseWidth = hex2dec('2229'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.DigLvl_PauseTrig_DigFltr_TimebaseSrc = hex2dec('222A'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.DigLvl_PauseTrig_DigFltr_TimebaseRate = hex2dec('222B'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.DigLvl_PauseTrig_DigSync_Enable = hex2dec('222C'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.
DAQmx_.ArmStartTrig_Type = hex2dec('1414'); % Specifies the type of trigger to use to arm the task for a Start Trigger. If you configure an Arm Start Trigger, the task does not respond to a Start Trigger until the device receives the Arm Start Trigger.
DAQmx_.DigEdge_ArmStartTrig_Src = hex2dec('1417'); % Specifies the name of a terminal where there is a digital signal to use as the source of the Arm Start Trigger.
DAQmx_.DigEdge_ArmStartTrig_Edge = hex2dec('1415'); % Specifies on which edge of a digital signal to arm the task for a Start Trigger.
DAQmx_.DigEdge_ArmStartTrig_DigFltr_Enable = hex2dec('222D'); % Specifies whether to apply the pulse width filter to the signal.
DAQmx_.DigEdge_ArmStartTrig_DigFltr_MinPulseWidth = hex2dec('222E'); % Specifies in seconds the minimum pulse width the filter recognizes.
DAQmx_.DigEdge_ArmStartTrig_DigFltr_TimebaseSrc = hex2dec('222F'); % Specifies the input terminal of the signal to use as the timebase of the pulse width filter.
DAQmx_.DigEdge_ArmStartTrig_DigFltr_TimebaseRate = hex2dec('2230'); % Specifies in hertz the rate of the pulse width filter timebase. NI-DAQmx uses this value to compute settings for the filter.
DAQmx_.DigEdge_ArmStartTrig_DigSync_Enable = hex2dec('2231'); % Specifies whether to synchronize recognition of transitions in the signal to the internal timebase of the device.

%********** Watchdog Attributes **********
DAQmx_.Watchdog_Timeout = hex2dec('21A9'); % Specifies in seconds the amount of time until the watchdog timer expires. A value of -1 means the internal timer never expires. Set this input to -1 if you use an Expiration Trigger to expire the watchdog task.
DAQmx_.WatchdogExpirTrig_Type = hex2dec('21A3'); % Specifies the type of trigger to use to expire a watchdog task.
DAQmx_.DigEdge_WatchdogExpirTrig_Src = hex2dec('21A4'); % Specifies the name of a terminal where a digital signal exists to use as the source of the Expiration Trigger.
DAQmx_.DigEdge_WatchdogExpirTrig_Edge = hex2dec('21A5'); % Specifies on which edge of a digital signal to expire the watchdog task.
DAQmx_.Watchdog_DO_ExpirState = hex2dec('21A7'); % Specifies the state to which to set the digital physical channels when the watchdog task expires.You cannot modify the expiration state of dedicated digital input physical channels.
DAQmx_.Watchdog_HasExpired = hex2dec('21A8'); % Indicates if the watchdog timer expired. You can read this property only while the task is running.

%********** Write Attributes **********
DAQmx_.Write_RelativeTo = hex2dec('190C'); % Specifies the point in the buffer at which to write data. If you also specify an offset with Offset, the write operation begins at that offset relative to this point you select with this property.
DAQmx_.Write_Offset = hex2dec('190D'); % Specifies in samples per channel an offset at which a write operation begins. This offset is relative to the location you specify with Relative To.
DAQmx_.Write_RegenMode = hex2dec('1453'); % Specifies whether to allow NI-DAQmx to generate the same data multiple times.
DAQmx_.Write_CurrWritePos = hex2dec('1458'); % Indicates the number of the next sample for the device to generate. This value is identical for all channels in the task.
DAQmx_.Write_SpaceAvail = hex2dec('1460'); % Indicates in samples per channel the amount of available space in the buffer.
DAQmx_.Write_TotalSampPerChanGenerated = hex2dec('192B'); % Indicates the total number of samples generated by each channel in the task. This value is identical for all channels in the task.
DAQmx_.Write_RawDataWidth = hex2dec('217D'); % Indicates in bytes the required size of a raw sample to write to the task.
DAQmx_.Write_NumChans = hex2dec('217E'); % Indicates the number of channels that an NI-DAQmx Write function writes to the task. This value is the number of channels in the task.
DAQmx_.Write_DigitalLines_BytesPerChan = hex2dec('217F'); % Indicates the number of bytes expected per channel in a sample for line-based writes. If a channel has fewer lines than this number, NI-DAQmx ignores the extra bytes.

%********** Physical Channel Attributes **********
DAQmx_.PhysicalChan_TEDS_MfgID = hex2dec('21DA'); % Indicates the manufacturer ID of the sensor.
DAQmx_.PhysicalChan_TEDS_ModelNum = hex2dec('21DB'); % Indicates the model number of the sensor.
DAQmx_.PhysicalChan_TEDS_SerialNum = hex2dec('21DC'); % Indicates the serial number of the sensor.
DAQmx_.PhysicalChan_TEDS_VersionNum = hex2dec('21DD'); % Indicates the version number of the sensor.
DAQmx_.PhysicalChan_TEDS_VersionLetter = hex2dec('21DE'); % Indicates the version letter of the sensor.
DAQmx_.PhysicalChan_TEDS_BitStream = hex2dec('21DF'); % Indicates the TEDS binary bitstream without checksums.
DAQmx_.PhysicalChan_TEDS_TemplateIDs = hex2dec('228F'); % Indicates the IDs of the templates in the bitstream in BitStream.


%******************************************************************************
% *** NI-DAQmx Values **********************************************************
% ******************************************************************************/

%******************************************************/
%***Non-Attribute Function Parameter Values ***/
%******************************************************/

%*** Values for the Mode parameter of DAQmxTaskControl ***  
DAQmx_.Val_Task_Start = 0; % Start
DAQmx_.Val_Task_Stop =1; % Stop
DAQmx_.Val_Task_Verify =2; % Verify
DAQmx_.Val_Task_Commit =3; % Commit
DAQmx_.Val_Task_Reserve = 4; % Reserve
DAQmx_.Val_Task_Unreserve = 5; % Unreserve
DAQmx_.Val_Task_Abort = 6; % Abort

%*** Values for the Action parameter of DAQmxControlWatchdogTask ***
DAQmx_.Val_ResetTimer = 0; % Reset Timer
DAQmx_.Val_ClearExpiration =1; % Clear Expiration

%*** Values for the Line Grouping parameter of DAQmxCreateDIChan and DAQmxCreateDOChan ***
DAQmx_.Val_ChanPerLine =0; % One Channel For Each Line
DAQmx_.Val_ChanForAllLines =1; % One Channel For All Lines

%*** Values for the Fill Mode parameter of DAQmxReadAnalogF64, DAQmxReadBinaryI16, DAQmxReadBinaryU16, DAQmxReadBinaryI32, DAQmxReadBinaryU32,
%DAQmxReadDigitalU8, DAQmxReadDigitalU32, DAQmxReadDigitalLines ***
%*** Values for the Data Layout parameter of DAQmxWriteAnalogF64, DAQmxWriteBinaryI16, DAQmxWriteDigitalU8, DAQmxWriteDigitalU32, DAQmxWriteDigitalLines ***
DAQmx_.Val_GroupByChannel = 0; % Group by Channel
DAQmx_.Val_GroupByScanNumber =1; % Group by Scan Number

%*** Values for the Signal Modifiers parameter of DAQmxConnectTerms ***/
DAQmx_.Val_DoNotInvertPolarity =0; % Do not invert polarity
DAQmx_.Val_InvertPolarity = 1; % Invert polarity

%*** Values for the Action paramter of DAQmxCloseExtCal ***
DAQmx_.Val_Action_Commit =0; % Commit
DAQmx_.Val_Action_Cancel =1; % Cancel

%*** Values for the Trigger ID parameter of DAQmxSendSoftwareTrigger ***
DAQmx_.Val_AdvanceTrigger = 12488; % Advance Trigger

%*** Value set for the ActiveEdge parameter of DAQmxCfgSampClkTiming ***
DAQmx_.Val_Rising = 10280; % Rising
DAQmx_.Val_Falling =10171; % Falling

%*** Value set SwitchPathType ***
%*** Value set for the output Path Status parameter of DAQmxSwitchFindPath ***
DAQmx_.Val_PathStatus_Available = 10431; % Path Available
DAQmx_.Val_PathStatus_AlreadyExists = 10432; % Path Already Exists
DAQmx_.Val_PathStatus_Unsupported = 10433; % Path Unsupported
DAQmx_.Val_PathStatus_ChannelInUse =10434; % Channel In Use
DAQmx_.Val_PathStatus_SourceChannelConflict = 10435; % Channel Source Conflict
DAQmx_.Val_PathStatus_ChannelReservedForRouting = 10436; % Channel Reserved for Routing

%*** Value set for the Units parameter of DAQmxCreateAIThrmcplChan, DAQmxCreateAIRTDChan, DAQmxCreateAIThrmstrChanIex, DAQmxCreateAIThrmstrChanVex and DAQmxCreateAITempBuiltInSensorChan ***
DAQmx_.Val_DegC = 10143; % Deg C
DAQmx_.Val_DegF = 10144; % Deg F
DAQmx_.Val_Kelvins =10325; % Kelvins
DAQmx_.Val_DegR = 10145; % Deg R

%*** Value set for the state parameter of DAQmxSetDigitalPowerUpStates ***
DAQmx_.Val_High = 10192; % High
DAQmx_.Val_Low =10214; % Low
DAQmx_.Val_Tristate = 10310; % Tristate

%*** Value set RelayPos ***
%*** Value set for the state parameter of DAQmxSwitchGetSingleRelayPos and DAQmxSwitchGetMultiRelayPos ***
DAQmx_.Val_Open = 10437; % Open
DAQmx_.Val_Closed = 10438; % Closed

%*** Value for the Terminal Config parameter of DAQmxCreateAIVoltageChan, DAQmxCreateAICurrentChan and DAQmxCreateAIVoltageChanWithExcit ***
DAQmx_.Val_Cfg_Default =-1; % Default

%*** Value for the Timeout parameter of DAQmxWaitUntilTaskDone
DAQmx_.Val_WaitInfinitely = -1.0;

%*** Value for the Number of Samples per Channel parameter of DAQmxReadAnalogF64, DAQmxReadBinaryI16, DAQmxReadBinaryU16,
%DAQmxReadBinaryI32, DAQmxReadBinaryU32, DAQmxReadDigitalU8, DAQmxReadDigitalU32,
%DAQmxReadDigitalLines, DAQmxReadCounterF64, DAQmxReadCounterU32 and DAQmxReadRaw ***
DAQmx_.Val_Auto = -1;

%/******************************************************/
%/*** = Attribute Values = ***/
%/******************************************************/

%*** Values for DAQmx_.AI_ACExcit_WireMode ***
%*** Value set ACExcitWireMode ***
DAQmx_.Val_4Wire =4; % 4-Wire
DAQmx_.Val_5Wire =5; % 5-Wire

%*** Values for DAQmx_.AI_MeasType ***
%*** Value set AIMeasurementType ***
DAQmx_.Val_Voltage =10322; % Voltage
DAQmx_.Val_Current =10134; % Current
DAQmx_.Val_Voltage_CustomWithExcitation = 10323; % More:Voltage:Custom with Excitation
DAQmx_.Val_Freq_Voltage = 10181; % Frequency
DAQmx_.Val_Resistance = 10278; % Resistance
DAQmx_.Val_Temp_TC =10303; % Temperature:Thermocouple
DAQmx_.Val_Temp_Thrmstr = 10302; % Temperature:Thermistor
DAQmx_.Val_Temp_RTD = 10301; % Temperature:RTD
DAQmx_.Val_Temp_BuiltInSensor = 10311; % Temperature:Built-in Sensor
DAQmx_.Val_Strain_Gage =10300; % Strain Gage
DAQmx_.Val_Position_LVDT =10352; % Position:LVDT
DAQmx_.Val_Position_RVDT =10353; % Position:RVDT
DAQmx_.Val_Accelerometer =10356; % Accelerometer
DAQmx_.Val_SoundPressure_Microphone = 10354; % Sound Pressure:Microphone
DAQmx_.Val_TEDS_Sensor =12531; % TEDS Sensor

%*** Values for DAQmx_.AO_IdleOutputBehavior ***
%*** Value set AOIdleOutputBehavior ***
DAQmx_.Val_ZeroVolts =12526; % Zero Volts
DAQmx_.Val_HighImpedance =12527; % High Impedance
DAQmx_.Val_MaintainExistingValue =12528; % Maintain Existing Value

%*** Values for DAQmx_.AO_OutputType ***
%*** Value set AOOutputChannelType ***
DAQmx_.Val_Voltage =10322; % Voltage
DAQmx_.Val_Current =10134; % Current

%*** Values for DAQmx_.AI_Accel_SensitivityUnits ***
%*** Value set AccelSensitivityUnits1 ***
DAQmx_.Val_mVoltsPerG = 12509; % mVolts/g
DAQmx_.Val_VoltsPerG =12510; % Volts/g

%*** Values for DAQmx_.AI_Accel_Units ***
%*** Value set AccelUnits2 ***
DAQmx_.Val_AccelUnit_g =10186; % g
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.SampQuant_SampMode ***
%*** Value set AcquisitionType ***
DAQmx_.Val_FiniteSamps =10178; % Finite Samples
DAQmx_.Val_ContSamps =10123; % Continuous Samples
DAQmx_.Val_HWTimedSinglePoint = 12522; % Hardware Timed Single Point

%*** Values for DAQmx_.AnlgLvl_PauseTrig_When ***
%*** Value set ActiveLevel ***
DAQmx_.Val_AboveLvl = 10093; % Above Level
DAQmx_.Val_BelowLvl = 10107; % Below Level

%*** Values for DAQmx_.AI_RVDT_Units ***
%*** Value set AngleUnits1 ***
DAQmx_.Val_Degrees =10146; % Degrees
DAQmx_.Val_Radians =10273; % Radians
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.CI_AngEncoder_Units ***
%*** Value set AngleUnits2 ***
DAQmx_.Val_Degrees =10146; % Degrees
DAQmx_.Val_Radians =10273; % Radians
DAQmx_.Val_Ticks =10304; % Ticks
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.AI_AutoZeroMode ***
%*** Value set AutoZeroType1 ***
DAQmx_.Val_None = 10230; % None
DAQmx_.Val_Once = 10244; % Once

%*** Values for DAQmx_.SwitchScan_BreakMode ***
%*** Value set BreakMode ***
DAQmx_.Val_NoAction = 10227; % No Action
DAQmx_.Val_BreakBeforeMake =10110; % Break Before Make

%*** Values for DAQmx_.AI_Bridge_Cfg ***
%*** Value set BridgeConfiguration1 ***
DAQmx_.Val_FullBridge = 10182; % Full Bridge
DAQmx_.Val_HalfBridge = 10187; % Half Bridge
DAQmx_.Val_QuarterBridge =10270; % Quarter Bridge
DAQmx_.Val_NoBridge = 10228; % No Bridge

%*** Values for DAQmx_.CI_MeasType ***
%*** Value set CIMeasurementType ***
DAQmx_.Val_CountEdges = 10125; % Count Edges
DAQmx_.Val_Freq = 10179; % Frequency
DAQmx_.Val_Period = 10256; % Period
DAQmx_.Val_PulseWidth = 10359; % Pulse Width
DAQmx_.Val_SemiPeriod = 10289; % Semi Period
DAQmx_.Val_Position_AngEncoder =10360; % Position:Angular Encoder
DAQmx_.Val_Position_LinEncoder =10361; % Position:Linear Encoder
DAQmx_.Val_TwoEdgeSep = 10267; % Two Edge Separation

%*** Values for DAQmx_.AI_Thrmcpl_CJCSrc ***
%*** Value set CJCSource1 ***
DAQmx_.Val_BuiltIn =10200; % Built-In
DAQmx_.Val_ConstVal = 10116; % Constant Value
DAQmx_.Val_Chan = 10113; % Channel

%*** Values for DAQmx_.CO_OutputType ***
%*** Value set COOutputType ***
DAQmx_.Val_Pulse_Time = 10269; % Pulse:Time
DAQmx_.Val_Pulse_Freq = 10119; % Pulse:Frequency
DAQmx_.Val_Pulse_Ticks =10268; % Pulse:Ticks

%*** Values for DAQmx_.ChanType ***
%*** Value set ChannelType ***
DAQmx_.Val_AI = 10100; % Analog Input
DAQmx_.Val_AO = 10102; % Analog Output
DAQmx_.Val_DI = 10151; % Digital Input
DAQmx_.Val_DO = 10153; % Digital Output
DAQmx_.Val_CI = 10131; % Counter Input
DAQmx_.Val_CO = 10132; % Counter Output

%*** Values for DAQmx_.CI_CountEdges_Dir ***
%*** Value set CountDirection1 ***
DAQmx_.Val_CountUp =10128; % Count Up
DAQmx_.Val_CountDown =10124; % Count Down
DAQmx_.Val_ExtControlled =10326; % Externally Controlled

%*** Values for DAQmx_.CI_Freq_MeasMeth ***
%*** Values for DAQmx_.CI_Period_MeasMeth ***
%*** Value set CounterFrequencyMethod ***
DAQmx_.Val_LowFreq1Ctr =10105; % Low Frequency with 1 Counter
DAQmx_.Val_HighFreq2Ctr = 10157; % High Frequency with 2 Counters
DAQmx_.Val_LargeRng2Ctr = 10205; % Large Range with 2 Counters

%*** Values for DAQmx_.AI_Coupling ***
%*** Value set Coupling1 ***
DAQmx_.Val_AC = 10045; % AC
DAQmx_.Val_DC = 10050; % DC
DAQmx_.Val_GND =10066; % GND

%*** Values for DAQmx_.AnlgEdge_StartTrig_Coupling ***
%*** Values for DAQmx_.AnlgWin_StartTrig_Coupling ***
%*** Values for DAQmx_.AnlgEdge_RefTrig_Coupling ***
%*** Values for DAQmx_.AnlgWin_RefTrig_Coupling ***
%*** Values for DAQmx_.AnlgLvl_PauseTrig_Coupling ***
%*** Values for DAQmx_.AnlgWin_PauseTrig_Coupling ***
%*** Value set Coupling2 ***
DAQmx_.Val_AC = 10045; % AC
DAQmx_.Val_DC = 10050; % DC

%*** Values for DAQmx_.AI_CurrentShunt_Loc ***
%*** Value set CurrentShuntResistorLocation1 ***
DAQmx_.Val_Internal = 10200; % Internal
DAQmx_.Val_External = 10167; % External

%*** Values for DAQmx_.AI_Current_Units ***
%*** Values for DAQmx_.AO_Current_Units ***
%*** Value set CurrentUnits1 ***
DAQmx_.Val_Amps = 10342; % Amps
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale
DAQmx_.Val_FromTEDS = 12516; % From TEDS

%*** Value set CurrentUnits2 ***
DAQmx_.Val_Amps = 10342; % Amps
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.AI_DataXferMech ***
%*** Values for DAQmx_.AO_DataXferMech ***
%*** Values for DAQmx_.DI_DataXferMech ***
%*** Values for DAQmx_.DO_DataXferMech ***
%*** Values for DAQmx_.CI_DataXferMech ***
%*** Value set DataTransferMechanism ***
DAQmx_.Val_DMA =10054; % DMA
DAQmx_.Val_Interrupts = 10204; % Interrupts
DAQmx_.Val_ProgrammedIO = 10264; % Programmed I/O

%*** Values for DAQmx_.Watchdog_DO_ExpirState ***
%*** Value set DigitalLineState ***
DAQmx_.Val_High = 10192; % High
DAQmx_.Val_Low =10214; % Low
DAQmx_.Val_Tristate = 10310; % Tristate
DAQmx_.Val_NoChange = 10160; % No Change

%*** Values for DAQmx_.StartTrig_DelayUnits ***
%*** Value set DigitalWidthUnits1 ***
DAQmx_.Val_SampClkPeriods = 10286; % Sample Clock Periods
DAQmx_.Val_Seconds =10364; % Seconds
DAQmx_.Val_Ticks =10304; % Ticks

%*** Values for DAQmx_.DelayFromSampClk_DelayUnits ***
%*** Value set DigitalWidthUnits2 ***
DAQmx_.Val_Seconds =10364; % Seconds
DAQmx_.Val_Ticks =10304; % Ticks

%*** Values for DAQmx_.Exported_AdvTrig_Pulse_WidthUnits ***
%*** Value set DigitalWidthUnits3 ***
DAQmx_.Val_Seconds =10364; % Seconds

%*** Values for DAQmx_.CI_Freq_StartingEdge ***
%*** Values for DAQmx_.CI_Period_StartingEdge ***
%*** Values for DAQmx_.CI_CountEdges_ActiveEdge ***
%*** Values for DAQmx_.CI_PulseWidth_StartingEdge ***
%*** Values for DAQmx_.CI_TwoEdgeSep_FirstEdge ***
%*** Values for DAQmx_.CI_TwoEdgeSep_SecondEdge ***
%*** Values for DAQmx_.CI_CtrTimebaseActiveEdge ***
%*** Values for DAQmx_.CO_CtrTimebaseActiveEdge ***
%*** Values for DAQmx_.SampClk_ActiveEdge ***
%*** Values for DAQmx_.SampClk_Timebase_ActiveEdge ***
%*** Values for DAQmx_.AIConv_ActiveEdge ***
%*** Values for DAQmx_.DigEdge_StartTrig_Edge ***
%*** Values for DAQmx_.DigEdge_RefTrig_Edge ***
%*** Values for DAQmx_.DigEdge_AdvTrig_Edge ***
%*** Values for DAQmx_.DigEdge_ArmStartTrig_Edge ***
%*** Values for DAQmx_.DigEdge_WatchdogExpirTrig_Edge ***
%*** Value set Edge1 ***
DAQmx_.Val_Rising = 10280; % Rising
DAQmx_.Val_Falling =10171; % Falling

%*** Values for DAQmx_.CI_Encoder_DecodingType ***
%*** Value set EncoderType2 ***
DAQmx_.Val_X1 = 10090; % X1
DAQmx_.Val_X2 = 10091; % X2
DAQmx_.Val_X4 = 10092; % X4
DAQmx_.Val_TwoPulseCounting = 10313; % Two Pulse Counting

%*** Values for DAQmx_.CI_Encoder_ZIndexPhase ***
%*** Value set EncoderZIndexPhase1 ***
DAQmx_.Val_AHighBHigh = 10040; % A High B High
DAQmx_.Val_AHighBLow =10041; % A High B Low
DAQmx_.Val_ALowBHigh =10042; % A Low B High
DAQmx_.Val_ALowBLow = 10043; % A Low B Low

%*** Values for DAQmx_.AI_Excit_DCorAC ***
%*** Value set ExcitationDCorAC ***
DAQmx_.Val_DC = 10050; % DC
DAQmx_.Val_AC = 10045; % AC

%*** Values for DAQmx_.AI_Excit_Src ***
%*** Value set ExcitationSource ***
DAQmx_.Val_Internal = 10200; % Internal
DAQmx_.Val_External = 10167; % External
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.AI_Excit_VoltageOrCurrent ***
%*** Value set ExcitationVoltageOrCurrent ***
DAQmx_.Val_Voltage =10322; % Voltage
DAQmx_.Val_Current =10134; % Current

%*** Values for DAQmx_.Exported_CtrOutEvent_OutputBehavior ***
%*** Value set ExportActions2 ***
DAQmx_.Val_Pulse =10265; % Pulse
DAQmx_.Val_Toggle = 10307; % Toggle

%*** Values for DAQmx_.Exported_SampClk_OutputBehavior ***
%*** Value set ExportActions3 ***
DAQmx_.Val_Pulse =10265; % Pulse
DAQmx_.Val_Lvl =10210; % Level

%*** Values for DAQmx_.AI_Freq_Units ***
%*** Value set FrequencyUnits ***
DAQmx_.Val_Hz = 10373; % Hz
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.CO_Pulse_Freq_Units ***
%*** Value set FrequencyUnits2 ***
DAQmx_.Val_Hz = 10373; % Hz

%*** Values for DAQmx_.CI_Freq_Units ***
%*** Value set FrequencyUnits3 ***
DAQmx_.Val_Hz = 10373; % Hz
DAQmx_.Val_Ticks =10304; % Ticks
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale


%*** Values for DAQmx_.AI_DataXferReqCond ***
%*** Values for DAQmx_.DI_DataXferReqCond ***
%*** Value set InputDataTransferCondition ***
DAQmx_.Val_OnBrdMemMoreThanHalfFull = 10237; % On Board Memory More than Half Full
DAQmx_.Val_OnBrdMemNotEmpty = 10241; % On Board Memory Not Empty

%*** Values for DAQmx_.AI_TermCfg ***
%*** Value set InputTermCfg ***
DAQmx_.Val_RSE =10083; % RSE
DAQmx_.Val_NRSE = 10078; % NRSE
DAQmx_.Val_Diff = 10106; % Differential
DAQmx_.Val_PseudoDiff = 12529; % Pseudodifferential

%*** Values for DAQmx_.AI_LVDT_SensitivityUnits ***
%*** Value set LVDTSensitivityUnits1 ***
DAQmx_.Val_mVoltsPerVoltPerMillimeter = 12506; % mVolts/Volt/mMeter
DAQmx_.Val_mVoltsPerVoltPerMilliInch =12505; % mVolts/Volt/0.001 Inch

%*** Values for DAQmx_.AI_LVDT_Units ***
%*** Value set LengthUnits2 ***
DAQmx_.Val_Meters = 10219; % Meters
DAQmx_.Val_Inches = 10379; % Inches
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.CI_LinEncoder_Units ***
%*** Value set LengthUnits3 ***
DAQmx_.Val_Meters = 10219; % Meters
DAQmx_.Val_Inches = 10379; % Inches
DAQmx_.Val_Ticks =10304; % Ticks
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.CI_OutputState ***
%*** Values for DAQmx_.CO_Pulse_IdleState ***
%*** Values for DAQmx_.CO_OutputState ***
%*** Values for DAQmx_.Exported_CtrOutEvent_Toggle_IdleState ***
%*** Values for DAQmx_.DigLvl_PauseTrig_When ***
%*** Value set Level1 ***
DAQmx_.Val_High = 10192; % High
DAQmx_.Val_Low =10214; % Low

%*** Values for DAQmx_.AIConv_Timebase_Src ***
%*** Value set MIOAIConvertTbSrc ***
DAQmx_.Val_SameAsSampTimebase = 10284; % Same as Sample Timebase
DAQmx_.Val_SameAsMasterTimebase = 10282; % Same as Master Timebase
DAQmx_.Val_20MHzTimebase =12537; % 20MHz Timebase

%*** Values for DAQmx_.AO_DataXferReqCond ***
%*** Values for DAQmx_.DO_DataXferReqCond ***
%*** Value set OutputDataTransferCondition ***
DAQmx_.Val_OnBrdMemEmpty =10235; % On Board Memory Empty
DAQmx_.Val_OnBrdMemHalfFullOrLess = 10239; % On Board Memory Half Full or Less
DAQmx_.Val_OnBrdMemNotFull =10242; % On Board Memory Less than Full

%*** Values for DAQmx_.AO_TermCfg ***
%*** Value set OutputTermCfg ***
DAQmx_.Val_RSE =10083; % RSE
DAQmx_.Val_Diff = 10106; % Differential
DAQmx_.Val_PseudoDiff = 12529; % Pseudodifferential

%*** Values for DAQmx_.Read_OverWrite ***
%*** Value set OverwriteMode1 ***
DAQmx_.Val_OverwriteUnreadSamps = 10252; % Overwrite Unread Samples
DAQmx_.Val_DoNotOverwriteUnreadSamps =10159; % Do Not Overwrite Unread Samples

%*** Values for DAQmx_.Exported_AIConvClk_Pulse_Polarity ***
%*** Values for DAQmx_.Exported_AdvTrig_Pulse_Polarity ***
%*** Values for DAQmx_.Exported_AdvCmpltEvent_Pulse_Polarity ***
%*** Values for DAQmx_.Exported_AIHoldCmpltEvent_PulsePolarity ***
%*** Values for DAQmx_.Exported_CtrOutEvent_Pulse_Polarity ***
%*** Value set Polarity2 ***
DAQmx_.Val_ActiveHigh = 10095; % Active High
DAQmx_.Val_ActiveLow =10096; % Active Low


%*** Values for DAQmx_.AI_RTD_Type ***
%*** Value set RTDType1 ***
DAQmx_.Val_Pt3750 = 12481; % Pt3750
DAQmx_.Val_Pt3851 = 10071; % Pt3851
DAQmx_.Val_Pt3911 = 12482; % Pt3911
DAQmx_.Val_Pt3916 = 10069; % Pt3916
DAQmx_.Val_Pt3920 = 10053; % Pt3920
DAQmx_.Val_Pt3928 = 12483; % Pt3928
DAQmx_.Val_Custom = 10137; % Custom

%*** Values for DAQmx_.AI_RVDT_SensitivityUnits ***
%*** Value set RVDTSensitivityUnits1 ***
DAQmx_.Val_mVoltsPerVoltPerDegree = 12507; % mVolts/Volt/Degree
DAQmx_.Val_mVoltsPerVoltPerRadian = 12508; % mVolts/Volt/Radian

%*** Values for DAQmx_.Read_RelativeTo ***
%*** Value set ReadRelativeTo ***
DAQmx_.Val_FirstSample =10424; % First Sample
DAQmx_.Val_CurrReadPos =10425; % Current Read Position
DAQmx_.Val_RefTrig =10426; % Reference Trigger
DAQmx_.Val_FirstPretrigSamp = 10427; % First Pretrigger Sample
DAQmx_.Val_MostRecentSamp = 10428; % Most Recent Sample


%*** Values for DAQmx_.Write_RegenMode ***
%*** Value set RegenerationMode1 ***
DAQmx_.Val_AllowRegen = 10097; % Allow Regeneration
DAQmx_.Val_DoNotAllowRegen =10158; % Do Not Allow Regeneration

%*** Values for DAQmx_.AI_ResistanceCfg ***
%*** Value set ResistanceConfiguration ***
DAQmx_.Val_2Wire =2; % 2-Wire
DAQmx_.Val_3Wire =3; % 3-Wire
DAQmx_.Val_4Wire =4; % 4-Wire

%*** Values for DAQmx_.AI_Resistance_Units ***
%*** Value set ResistanceUnits1 ***
DAQmx_.Val_Ohms = 10384; % Ohms
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale
DAQmx_.Val_FromTEDS = 12516; % From TEDS

%*** Value set ResistanceUnits2 ***
DAQmx_.Val_Ohms = 10384; % Ohms
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.AI_ResolutionUnits ***
%*** Values for DAQmx_.AO_ResolutionUnits ***
%*** Value set ResolutionType1 ***
DAQmx_.Val_Bits = 10109; % Bits

%*** Values for DAQmx_.SampTimingType ***
%*** Value set SampleTimingType ***
DAQmx_.Val_SampClk =10388; % Sample Clock
DAQmx_.Val_Handshake =10389; % Handshake
DAQmx_.Val_Implicit = 10451; % Implicit
DAQmx_.Val_OnDemand = 10390; % On Demand
DAQmx_.Val_ChangeDetection =12504; % Change Detection

%*** Values for DAQmx_.Scale_Type ***
%*** Value set ScaleType ***
DAQmx_.Val_Linear = 10447; % Linear
DAQmx_.Val_MapRanges =10448; % Map Ranges
DAQmx_.Val_Polynomial = 10449; % Polynomial
DAQmx_.Val_Table =10450; % Table

%*** Values for DAQmx_.AI_Bridge_ShuntCal_Select ***
%*** Value set ShuntCalSelect ***
DAQmx_.Val_A =12513; % A
DAQmx_.Val_B =12514; % B
DAQmx_.Val_AandB =12515; % A and B

%*** Value set Signal ***
DAQmx_.Val_AIConvertClock = 12484; % AI Convert Clock
DAQmx_.Val_10MHzRefClock =12536; % 10MHz Reference Clock
DAQmx_.Val_20MHzTimebaseClock = 12486; % 20MHz Timebase Clock
DAQmx_.Val_SampleClock =12487; % Sample Clock
DAQmx_.Val_AdvanceTrigger = 12488; % Advance Trigger
DAQmx_.Val_ReferenceTrigger = 12490; % Reference Trigger
DAQmx_.Val_StartTrigger = 12491; % Start Trigger
DAQmx_.Val_AdvCmpltEvent =12492; % Advance Complete Event
DAQmx_.Val_AIHoldCmpltEvent = 12493; % AI Hold Complete Event
DAQmx_.Val_CounterOutputEvent = 12494; % Counter Output Event
DAQmx_.Val_ChangeDetectionEvent = 12511; % Change Detection Event
DAQmx_.Val_WDTExpiredEvent =12512; % Watchdog Timer Expired Event

%*** Values for DAQmx_.AnlgEdge_StartTrig_Slope ***
%*** Values for DAQmx_.AnlgEdge_RefTrig_Slope ***
%*** Value set Slope1 ***
DAQmx_.Val_RisingSlope =10280; % Rising
DAQmx_.Val_FallingSlope = 10171; % Falling

%*** Values for DAQmx_.AI_SoundPressure_Units ***
%*** Value set SoundPressureUnits1 ***
DAQmx_.Val_Pascals =10081; % Pascals
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.AI_Lowpass_SwitchCap_ClkSrc ***
%*** Values for DAQmx_.AO_DAC_Ref_Src ***
%*** Values for DAQmx_.AO_DAC_Offset_Src ***
%*** Value set SourceSelection ***
DAQmx_.Val_Internal = 10200; % Internal
DAQmx_.Val_External = 10167; % External

%*** Values for DAQmx_.AI_StrainGage_Cfg ***
%*** Value set StrainGageBridgeType1 ***
DAQmx_.Val_FullBridgeI =10183; % Full Bridge I
DAQmx_.Val_FullBridgeII = 10184; % Full Bridge II
DAQmx_.Val_FullBridgeIII =10185; % Full Bridge III
DAQmx_.Val_HalfBridgeI =10188; % Half Bridge I
DAQmx_.Val_HalfBridgeII = 10189; % Half Bridge II
DAQmx_.Val_QuarterBridgeI = 10271; % Quarter Bridge I
DAQmx_.Val_QuarterBridgeII =10272; % Quarter Bridge II

%*** Values for DAQmx_.AI_Strain_Units ***
%*** Value set StrainUnits1 ***
DAQmx_.Val_Strain = 10299; % Strain
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.SwitchScan_RepeatMode ***
%*** Value set SwitchScanRepeatMode ***
DAQmx_.Val_Finite = 10172; % Finite
DAQmx_.Val_Cont = 10117; % Continuous

%*** Values for DAQmx_.SwitchChan_Usage ***
%*** Value set SwitchUsageTypes ***
DAQmx_.Val_Source = 10439; % Source
DAQmx_.Val_Load = 10440; % Load
DAQmx_.Val_ReservedForRouting = 10441; % Reserved for Routing

%*** Value set TEDSUnits ***
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale
DAQmx_.Val_FromTEDS = 12516; % From TEDS

%*** Values for DAQmx_.AI_Temp_Units ***
%*** Value set TemperatureUnits1 ***
DAQmx_.Val_DegC = 10143; % Deg C
DAQmx_.Val_DegF = 10144; % Deg F
DAQmx_.Val_Kelvins =10325; % Kelvins
DAQmx_.Val_DegR = 10145; % Deg R
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.AI_Thrmcpl_Type ***
%*** Value set ThermocoupleType1 ***
DAQmx_.Val_J_Type_TC =10072; % J
DAQmx_.Val_K_Type_TC =10073; % K
DAQmx_.Val_N_Type_TC =10077; % N
DAQmx_.Val_R_Type_TC =10082; % R
DAQmx_.Val_S_Type_TC =10085; % S
DAQmx_.Val_T_Type_TC =10086; % T
DAQmx_.Val_B_Type_TC =10047; % B
DAQmx_.Val_E_Type_TC =10055; % E

%*** Values for DAQmx_.CO_Pulse_Time_Units ***
%*** Value set TimeUnits2 ***
DAQmx_.Val_Seconds =10364; % Seconds

%*** Values for DAQmx_.CI_Period_Units ***
%*** Values for DAQmx_.CI_PulseWidth_Units ***
%*** Values for DAQmx_.CI_TwoEdgeSep_Units ***
%*** Values for DAQmx_.CI_SemiPeriod_Units ***
%*** Value set TimeUnits3 ***
DAQmx_.Val_Seconds =10364; % Seconds
DAQmx_.Val_Ticks =10304; % Ticks
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.RefTrig_Type ***
%*** Value set TriggerType1 ***
DAQmx_.Val_AnlgEdge = 10099; % Analog Edge
DAQmx_.Val_DigEdge =10150; % Digital Edge
DAQmx_.Val_AnlgWin =10103; % Analog Window
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.ArmStartTrig_Type ***
%*** Values for DAQmx_.WatchdogExpirTrig_Type ***
%*** Value set TriggerType4 ***
DAQmx_.Val_DigEdge =10150; % Digital Edge
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.AdvTrig_Type ***
%*** Value set TriggerType5 ***
DAQmx_.Val_DigEdge =10150; % Digital Edge
DAQmx_.Val_Software = 10292; % Software
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.PauseTrig_Type ***
%*** Value set TriggerType6 ***
DAQmx_.Val_AnlgLvl =10101; % Analog Level
DAQmx_.Val_AnlgWin =10103; % Analog Window
DAQmx_.Val_DigLvl = 10152; % Digital Level
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.StartTrig_Type ***
%*** Value set TriggerType8 ***
DAQmx_.Val_AnlgEdge = 10099; % Analog Edge
DAQmx_.Val_DigEdge =10150; % Digital Edge
DAQmx_.Val_AnlgWin =10103; % Analog Window
DAQmx_.Val_None = 10230; % None

%*** Values for DAQmx_.Scale_PreScaledUnits ***
%*** Value set UnitsPreScaled ***
DAQmx_.Val_Volts =10348; % Volts
DAQmx_.Val_Amps = 10342; % Amps
DAQmx_.Val_DegF = 10144; % Deg F
DAQmx_.Val_DegC = 10143; % Deg C
DAQmx_.Val_DegR = 10145; % Deg R
DAQmx_.Val_Kelvins =10325; % Kelvins
DAQmx_.Val_Strain = 10299; % Strain
DAQmx_.Val_Ohms = 10384; % Ohms
DAQmx_.Val_Hz = 10373; % Hz
DAQmx_.Val_Seconds =10364; % Seconds
DAQmx_.Val_Meters = 10219; % Meters
DAQmx_.Val_Inches = 10379; % Inches
DAQmx_.Val_Degrees =10146; % Degrees
DAQmx_.Val_Radians =10273; % Radians
DAQmx_.Val_g =10186; % g
DAQmx_.Val_Pascals =10081; % Pascals
DAQmx_.Val_FromTEDS = 12516; % From TEDS

%*** Values for DAQmx_.AI_Voltage_Units ***
%*** Value set VoltageUnits1 ***
DAQmx_.Val_Volts =10348; % Volts
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale
DAQmx_.Val_FromTEDS = 12516; % From TEDS

%*** Values for DAQmx_.AO_Voltage_Units ***
%*** Value set VoltageUnits2 ***
DAQmx_.Val_Volts =10348; % Volts
DAQmx_.Val_FromCustomScale =10065; % From Custom Scale

%*** Values for DAQmx_.ReadWaitMode ***
%*** Value set WaitMode ***
DAQmx_.Val_WaitForInterrupt = 12523; % Wait For Interrupt
DAQmx_.Val_Poll = 12524; % Poll
DAQmx_.Val_Yield =12525; % Yield

%*** Values for DAQmx_.AnlgWin_StartTrig_When ***
%*** Values for DAQmx_.AnlgWin_RefTrig_When ***
%*** Value set WindowTriggerCondition1 ***
DAQmx_.Val_EnteringWin =10163; % Entering Window
DAQmx_.Val_LeavingWin = 10208; % Leaving Window

%*** Values for DAQmx_.AnlgWin_PauseTrig_When ***
%*** Value set WindowTriggerCondition2 ***
DAQmx_.Val_InsideWin =10199; % Inside Window
DAQmx_.Val_OutsideWin = 10251; % Outside Window

%*** Value set WriteBasicTEDSOptions ***
DAQmx_.Val_WriteToEEPROM =12538; % Write To EEPROM
DAQmx_.Val_WriteToPROM =12539; % Write To PROM Once
DAQmx_.Val_DoNotWrite = 12540; % Do Not Write

%*** Values for DAQmx_.Write_RelativeTo ***
%*** Value set WriteRelativeTo ***
DAQmx_.Val_FirstSample =10424; % First Sample
DAQmx_.Val_CurrWritePos = 10430; % Current Write Position



%/******************************************************************************
% *** NI-DAQmx Error Codes *****************************************************
% ******************************************************************************/

DAQmxSuccess = (0);
