function DAQmxCheckError(lib,err)
% 
% read error code 
%	zero means no error - does nothing
%	nonzero - find out error string and generate error
% 
% inputs:
%	lib = .dll or alias (ex. 'myni')
%	err = DAQmx error
% 
if err ~= 0 
	% find out how long the error string is
	[numerr,b] = calllib(lib,'DAQmxGetErrorString',err,'',0);
	% get error string	
	errstr = char([1:numerr]);	% have to pass dummy string of correct length
	[err,errstr] = calllib(lib,'DAQmxGetErrorString',err,errstr,numerr);
	error(['DAQmx error - ',errstr])
end

