clear all
close all
global guiInfo lib DAQmx_ taskh 

guiInfo.doUSB=0;
guiInfo.isDPZ=1;guiInfo.isBIN=0;
guiInfo.NrSensor=8; 
guiInfo.RS232(1).Com='';
guiInfo.RS232(2).Com='COM1';
guiInfo.RS232(3).Com='COM2';
guiInfo.RS232(4).Com='';
guiInfo.RS232(5).Com='';
guiInfo.NoOfChanRS232=3;
for ii=1:guiInfo.NoOfChanRS232
  guiInfo.RS232(ii).BaudRate=9600;
  guiInfo.RS232(ii).DataBits=8;
  guiInfo.RS232(ii).ByteOrder='littleEndian';
  guiInfo.RS232(ii).Parity='none';
  guiInfo.RS232(ii).StopBits=1;
  guiInfo.RS232(ii).Terminator='CR'; %guiInfo.RS232(1).Terminator='CR/LF';
  guiInfo.RS232(ii).RequestToSend='off';
  guiInfo.RS232(ii).DataTerminalReady='off';
  guiInfo.RS232(ii).InputBufferSize=1024;
  guiInfo.RS232(ii).OutputBufferSize=1012;
  guiInfo.RS232(ii).Timeout=5;
  guiInfo.RS232(ii).isOpen=0;
end  
guiInfo.on=1;guiInfo.off=0;
guiInfo.HPMLogFile='HPMLogFile.log'; if (exist(guiInfo.HPMLogFile,'file')==0) display(['create: ' guiInfo.HPMLogFile]); guiInfo.fidHPMLogFile=fopen(guiInfo.HPMLogFile,'a'); fclose(guiInfo.fidHPMLogFile); end;

guiInfo.SensorFig=figure('Position',[50 530 800 180],'name','HPM GUI sensor','NumberTitle','off');
plotColor=['-m ';'-y ';'-y ';'-b ';'-r ';'-k ';'-c ';'-g ']; hold on; for ii=1:guiInfo.NrSensor guiInfo.uiHPMsensor(ii)=plot(1,1,plotColor(ii,:)); end; guiInfo.h=legend('x','y','z','LaserTest','LightStrobe','HPMstart','AkustSen','Pressure',4); for ii=1:guiInfo.NrSensor set(guiInfo.uiHPMsensor(ii),'XData',[],'YData',[]); end; hold off;
xlabel('time / [s]'); title ('sensor input'); 

guiInfo.ButtonBackgroundColor= [0.831373 0.815686 0.784314];
guiInfo.MainFig=figure('Position',[50 20 800 500],'name','HPM GUI Ver 9.1','NumberTitle','off');
xPosButton=0.02; dx=0.15; yPos=0.85; dy=0.06; yStep=-0.1; infoDY=0.025;
guiInfo.uiIDinfo=uicontrol('Style','Text','Units','normalized','String','ID','Position',[xPosButton yPos-0.07 0.03 0.04],'Callback','HPMCallbackIDNr;');
guiInfo.uiIDVal=uicontrol('Style','edit','Units','normalized','String','','Position',[xPosButton yPos-0.1 dx 0.04]);

guiInfo.LightSource=['  none    '
                     'LED blue  '
                     'LED white ' 
                     '  Laser   '
                     'Power LED '                     
                   ];
guiInfo.LightSourceNone=1;                 
guiInfo.LightSourceLEDblue=2;
guiInfo.LightSourceLEDwhite=3;
guiInfo.LightSourceLaser=4;
guiInfo.LightSourcePowerLED=5;

guiInfo.isLightSource=guiInfo.LightSourceLEDblue;
guiInfo.memberLightSourceRS232=[guiInfo.LightSourceLEDwhite guiInfo.LightSourceLEDblue];

xPos=0.2; xStep=0.15; listY=0.7; listDY=0.2; listDX=0.12; 
guiInfo.uiListLightSource=uicontrol('Style','Listbox','Units','normalized','Position', [xPos listY listDX listDY],'Min',1,'Max',1,'Value',1,'Callback',['HPMCallbackLightSource;']);
guiInfo.listInfo=[]; for ii=1:size(guiInfo.LightSource,1) guiInfo.listInfo{ii}=guiInfo.LightSource(ii,:); end;  set(guiInfo.uiListLightSource,'String',guiInfo.listInfo);
guiInfo.uiLightSourceInfo=uicontrol('Style','Text','Units','normalized','String','lightsource','Position',[xPos 0.92 0.15 infoDY]);

xPos=xPos+xStep;
guiInfo.allIlumLaser=        [ 0 1   5   10 20 30 40 50 80 100]; 
guiInfo.allIlumLaserValDA=   [ 0 0.1 0.5 1  2  3  4  5  8  10]; 

guiInfo.allIlumPowerLED=     [ 0 0.2 1   2 4 6 8 10 16 20]; 
guiInfo.allIlumPowerLEDValDA=[ 0 0.1 0.5 1 2 3 4 5  8  10]; 

guiInfo.allIlumLEDwhite=     [ 0    0.02 0.03 0.1  0.5  0.8  1    2    3    4    5    8    10   20   25   30   35]; 
guiInfo.allIlumLEDwhiteRS232=[ '00';'10';'20';'30';'40';'50';'60';'70';'80';'90';'a0';'b0';'c0';'d0';'e0';'f0';'ff'];

guiInfo.allIlumLEDblue=      [   0   5    10   15   20   25   30   35   40   45   50   55   60   65   70   75   80]; 
guiInfo.allIlumLEDblueRS232= [ '00';'10';'20';'30';'40';'50';'60';'70';'80';'90';'a0';'b0';'c0';'d0';'e0';'f0';'ff'];

guiInfo.uiListBoxIlum=uicontrol('Style','Listbox','Units','normalized','Visible','on','Position', [xPos listY listDX listDY],'Min',1,'Max',1,'Value',1,'Callback',['HPMCallbackIlumIntensity;']);
guiInfo.uiIlumLEDInfo=uicontrol('Style','Text','Units','normalized','String','intensity','Position',[xPos 0.92 0.15 infoDY]);

xPos=xPos+xStep;
guiInfo.allIlumTime=[0.05 0.1 0.2 0.3 0.4 0.5 1 2 3 4 5 6 7 8 9 10 20 30 40 50 100 200 300 400 500 3000];
guiInfo.uiListBoxIlumTime=uicontrol('Style','Listbox','Units','normalized','Visible','on','Position', [xPos listY listDX listDY],'Min',1,'Max',1,'Value',3,'Callback',['HPMCallbackIlumTime;']);
guiInfo.listInfo=[]; for ii=1:size(guiInfo.allIlumTime,2) guiInfo.listInfo{ii}=[num2str(guiInfo.allIlumTime(ii)) '  ms']; end; set(guiInfo.uiListBoxIlumTime,'String',guiInfo.listInfo);
guiInfo.uiIlumTimeInfo=uicontrol('Style','Text','Units','normalized','String','pulstime','Position',[xPos 0.92 0.15 infoDY]);

xPos=xPos+xStep;
guiInfo.allDelayStimulate=['edit'
                           '0   '
                           '100 '
                           '200 '
                           '279 '
                           '300 '
                           '400 '                           
                           '409 '                           
                           '419 '                           
                           '429 '                           
                           '439 '                           
                           '449 '
                           '459 '
                           '469 '];
guiInfo.allDelayRecovery=['edit'
                          '0.1 '
                          '0.5 '
                          '  1 '
                          '  2 '
                          '  4 '
                          '  6 '
                          '  8 '
                          ' 10 '];
guiInfo.uiListBoxDelayHPM=uicontrol('Style','Listbox','Units','normalized','Visible','on','Position', [xPos listY listDX listDY],'Min',1,'Max',1,'Value',1,'Callback',['HPMCallbackDelay;']);
guiInfo.uiDelayHPMInfo=uicontrol('Style','Text','Units','normalized','String','DelayHPM / ms','Position',[xPos 0.92 0.15 infoDY]);
guiInfo.uiDelayHPMval=uicontrol('Style','edit','Units','normalized','String','0.0','Enable','off','Position',[xPos listY-(0.04) 0.08 0.03],'Callback',['HPMCallbackDelay;']);

xPos=xPos+xStep;
guiInfo.StimMode=['stimulate'
                  'recovery ' 
                   ];
guiInfo.StimModeStimulate=1; guiInfo.StimModeRecovery=2; guiInfo.isStimMode=guiInfo.StimModeStimulate;
guiInfo.uiListStimMode=uicontrol('Style','Listbox','Units','normalized','Position', [xPos listY listDX listDY],'Min',1,'Max',1,'Value',1,'Callback',['HPMCallbackStimMode;']);
guiInfo.listInfo=[]; for ii=1:size(guiInfo.StimMode,1) guiInfo.listInfo{ii}=guiInfo.StimMode(ii,:); end;  set(guiInfo.uiListStimMode,'String',guiInfo.StimMode);
guiInfo.uiStimModeInfo=uicontrol('Style','Text','Units','normalized','String','stimMode','Position',[xPos 0.92 0.15 infoDY]);

yPos=0.55;
guiInfo.ListBoxHPMinfo=[]; guiInfo.ListBoxHPMinfoPos=1;
guiInfo.ListBoxHPMinfoTXT=uicontrol('Style','Text','Units','normalized','String',guiInfo.HPMLogFile,'Position',[0.5 yPos+0.07 0.15 infoDY]);

guiInfo.isPause=0;guiInfo.uiHPMpause=uicontrol('Style','pushbutton','String','HPMpause','Units','normalized','Visible','off','Position',[xPosButton yPos dx dy],'Callback','HPMCallbackPause;');yPos=yPos+yStep;
guiInfo.uiHPMstart=uicontrol('Style','pushbutton','String','HPMstart','Units','normalized','Position',[xPosButton yPos dx dy],'Callback','HPMCallbackStart(guiInfo.isLightSource);');yPos=yPos+yStep;
guiInfo.isLaserShutter=0;guiInfo.uiLaserShutter=uicontrol('Style','pushbutton','String','LaserShutter','Units','normalized','Position',[xPosButton  yPos dx dy],'Callback','HPMCallbackLaserShutter;');
guiInfo.uiListBoxHPMinfo=uicontrol('Style','Listbox','Units','normalized','Visible','on','Position', [0.2 yPos 0.78 0.25],'Min',1,'Max',1,'Value',1,'Callback',['']);

dy=0.05; yStep=-0.07; yPos=0.2;
guiInfo.ListBoxRS232info=[]; guiInfo.ListBoxRS232infoPos=1;
guiInfo.uiRS232init=uicontrol('Style','pushbutton','String','RS232 init','Units','normalized','Position',[xPosButton yPos dx dy],'Callback','HPMCallbackOpenRS232(guiInfo.isLightSource);');yPos=yPos+yStep; 
guiInfo.uiRS232set =uicontrol('Style','pushbutton','String','RS232 set ','Units','normalized','Position',[xPosButton yPos dx dy],'Callback','HPMCallbackSetRS232(guiInfo.isLightSource);'); 
guiInfo.uiRS232setVal=uicontrol('Style','edit','Units','normalized','String','','Position',[xPosButton+0.15 yPos dx dy],'Callback','HPMCallbackSetRS232(guiInfo.isLightSource);');
guiInfo.uiListBoxRS232info=uicontrol('Style','Listbox','Units','normalized','Visible','on','Position', [0.35 0.06 0.4 0.2],'Min',1,'Max',1,'Value',1,'Callback',['']);

guiInfo.uiExit=uicontrol('Style','pushbutton','String','Exit','Units','normalized','Position',[0.85 0.02 dx dy],'Callback','HPMCallbackExit;');

NIconstantsNoErrorDAQmx; lib='myni'; if ~libisloaded(lib) [funclist]=LoadLib(lib); end; disp('Matlab: dll loaded'); 
[err]=calllib('myni','DAQmxResetDevice','Dev1'); [err,ver]=calllib(lib,'DAQmxGetSysNIDAQMajorVersion',uint32(1));
guiInfo.timeout=10; guiInfo.name_task='';guiInfo.EmptyTask=[];

%{
        digital output
ElektretMic5Volt     Dev1/port0/line0  out
HPM5Volt             Dev1/port0/line1  out
StrobeCounterLED     Dev1/port1/line6  ctr0  out
StrobeCounterStart   Dev1/port1/line7  ctr1  out
%}
guiInfo.sfrec=10000;
guiInfo.NumSampleLED=10000;

[err,b,taskh.ElektretMic5Volt]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);
[err,b,c,d] = calllib(lib,'DAQmxCreateDOChan',taskh.ElektretMic5Volt,'Dev1/port0/line0','',DAQmx_.Val_ChanPerLine); DAQmxCheckError(lib,err);
[err]=calllib(lib,'DAQmxWriteDigitalLines',taskh.ElektretMic5Volt,1,1,guiInfo.timeout,DAQmx_.Val_GroupByChannel,guiInfo.on,[],[]);

[err,b,taskh.HPM5Volt]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);
[err,b,c,d] = calllib(lib,'DAQmxCreateDOChan',taskh.HPM5Volt,'Dev1/port0/line1','',DAQmx_.Val_ChanPerLine); DAQmxCheckError(lib,err);
[err]=calllib(lib,'DAQmxWriteDigitalLines',taskh.HPM5Volt,1,1,guiInfo.timeout,DAQmx_.Val_GroupByChannel,guiInfo.on,[],[]);

[err,b,taskh.StrobeCounterLight]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);
[err,b,taskh.StrobeCounterStart]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);

% analog output for laser
% guiInfo.sfrec=10000; guiInfo.NumSampleAcq=guiInfo.sfrec; 
guiInfo.numchanAO_0=1; guiInfo.DAVmin=-10; guiInfo.DAVmax=10;
[err,b,taskh.AO_LaserPWR]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask));
[err,b,taskh.AO_PWRLed]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask));
HPMCreateAOVoltageChan;

% analog input for sensor
guiInfo.ADVmin=-10; guiInfo.ADVmax=10;
guiInfo.SensorPort= ['Dev1/ai0'
                     'Dev1/ai1'
                     'Dev1/ai2'
                     'Dev1/ai3'
                     'Dev1/ai4'
                     'Dev1/ai5'
                     'Dev1/ai6'
                     'Dev1/ai7'];

guiInfo.sampreadSensor=1; guiInfo.sampreadSensor_ptr=libpointer('int32Ptr',guiInfo.sampreadSensor);
guiInfo.empty=[]; guiInfo.empty_ptr=libpointer('uint32Ptr',guiInfo.empty);

[err,b,taskh.AI_Sensor]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask));    % Create AD Sensor tasks

HPMCallbackLightSource;
HPMCallbackIlumIntensity;
HPMCallbackIDNr;
HPMCallbackIlumTime;
HPMCallbackDelay;
HPMCallbackStimMode;