function HPMCreateCOPulseChanTime
global guiInfo lib DAQmx_ taskh 

%{
    DAQmxCreateCOPulseChanTime
taskHandle             TaskHandle     The task to which to add the channels that this function creates. 
counter                const char []  The name of the counter to use to create virtual channels. You can specify a list or range of physical channels. 
nameToAssignToChannel  const char []  The name(s) to assign to the created virtual channel(s). If you do not specify a name, NI-DAQmx uses the physical channel name as the virtual channel name. If you specify your own names for nameToAssignToChannel, you must use the names when you refer to these channels in other NI-DAQmx functions.
units                  int32          The units in which to define pulse high and low time. Value  Description DAQmx_Val_Seconds   Seconds 
idleState              int32          The resting state of the output terminal. Value  Description DAQmx_Val_High | DAQmx_Val_Low   Low state. 
initialDelay           float64        The amount of time in seconds to wait before generating the first pulse. 
lowTime                float64        The amount of time the pulse is low, in seconds. 
highTime               float64        The amount of time the pulse is high, in seconds. 


    DAQmxCfgImplicitTiming
taskHandle              TaskHandle      The task used in this function.
sampleMode              int32           DAQmx_Val_FiniteSamps  DAQmx_Val_ContSamps DAQmx_Val_HWTimedSinglePoint
sampsPerChanToAcquire 	uInt64
%}

HPMCallbackDelay;
HPMCallbackIlumTime;
guiInfo.isStimTimeHigh=guiInfo.isStimTime/1000;
guiInfo.isStimTimeLow=0.000001;
guiInfo.isStimTimeDelay=guiInfo.isDelayHPM/1000;
%disp(['Dev1/ctr0  LightPuls']); disp([guiInfo.isStimTimeDelay guiInfo.isStimTimeLow guiInfo.isStimTimeHigh]);

[err,b]=calllib(lib,'DAQmxStopTask',taskh.StrobeCounterLight); [err,b]=calllib(lib,'DAQmxClearTask',taskh.StrobeCounterLight);
[err,b,taskh.StrobeCounterLight]=calllib(lib,'DAQmxCreateTask',guiInfo.name_task,uint32(guiInfo.EmptyTask)); DAQmxCheckError(lib,err);

switch guiInfo.isLightSource
  case  guiInfo.LightSourceNone
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterLight,'Dev1/ctr0','',DAQmx_.Val_Seconds,DAQmx_.Val_Low,guiInfo.isStimTimeDelay,guiInfo.isStimTimeLow,guiInfo.isStimTimeHigh); DAQmxCheckError(lib,err);      
  case  guiInfo.LightSourceLEDblue 
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterLight,'Dev1/ctr0','',DAQmx_.Val_Seconds,DAQmx_.Val_Low,guiInfo.isStimTimeDelay,guiInfo.isStimTimeLow,guiInfo.isStimTimeHigh); DAQmxCheckError(lib,err);      
  case  guiInfo.LightSourceLEDwhite
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterLight,'Dev1/ctr0','',DAQmx_.Val_Seconds,DAQmx_.Val_Low,guiInfo.isStimTimeDelay,guiInfo.isStimTimeLow,guiInfo.isStimTimeHigh); DAQmxCheckError(lib,err);
  case guiInfo.LightSourceLaser
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterLight,'Dev1/ctr0','',DAQmx_.Val_Seconds,DAQmx_.Val_High,guiInfo.isStimTimeDelay,guiInfo.isStimTimeHigh,guiInfo.isStimTimeLow); DAQmxCheckError(lib,err);  
  case guiInfo.LightSourcePowerLED     
    [err,b,c,d]=calllib(lib,'DAQmxCreateCOPulseChanTime',taskh.StrobeCounterLight,'Dev1/ctr0','',DAQmx_.Val_Seconds,DAQmx_.Val_High,guiInfo.isStimTimeDelay,guiInfo.isStimTimeHigh,guiInfo.isStimTimeLow); DAQmxCheckError(lib,err);  
end  
[err,b]=calllib(lib,'DAQmxCfgImplicitTiming',taskh.StrobeCounterLight,DAQmx_.Val_FiniteSamps,1); DAQmxCheckError(lib,err);
switch guiInfo.isStimMode
  case guiInfo.StimModeStimulate
    if guiInfo.isDPZ [err,b]=calllib(lib,'DAQmxCfgDigEdgeStartTrig',taskh.StrobeCounterLight,'/Dev1/PFI13',DAQmx_.Val_Rising); end;
    if guiInfo.isBIN [err,b]=calllib(lib,'DAQmxCfgDigEdgeStartTrig',taskh.StrobeCounterLight,'/Dev1/PFI7',DAQmx_.Val_Rising); end;
    DAQmxCheckError(lib,err);    
  case guiInfo.StimModeRecovery
end
[err,b]=calllib(lib,'DAQmxStartTask',taskh.StrobeCounterLight); DAQmxCheckError(lib,err);
