function loadLeicafiles
global guiInfo

%Leica
if iscell(guiInfo.ui.Leica.File) 
  guiInfo.ui.Leica.NrOfFile=size(guiInfo.ui.Leica.File,2);
else  
  guiInfo.ui.Leica.NrOfFile=size(guiInfo.ui.Leica.File,1);
end  
guiInfo.Leica.Header=[];
guiInfo.Leica.rTime=[];
guiInfo.Leica.sPT=[];
guiInfo.Leica.hpDwell=[];
guiInfo.Leica.CoolingRate=[];
guiInfo.Leica.Time=[];
guiInfo.Leica.P=[];
guiInfo.Leica.Temp=[];
guiInfo.Leica.FileNr=[];

for iFile=1:guiInfo.ui.Leica.NrOfFile
  if iscell(guiInfo.ui.Leica.File)
    fname=cell2mat(guiInfo.ui.Leica.File(:,iFile));
  else
    fname=guiInfo.ui.Leica.File;
  end
  display([num2str(iFile) '  '  num2str(guiInfo.ui.Leica.NrOfFile) '   ' fname]);
  k1=strfind(fname,'\');k2=strfind(fname,'.'); 
  guiInfo.Leica.FileNr(iFile)=str2num(fname(k1(size(k1,2))+1:k2-1));
  fid=fopen(fname);
  for j=1:4 data(iFile).headerStr(j).s=fgets(fid); guiInfo.Leica.Header(iFile).headerStr(j).s=data(iFile).headerStr(j).s; end;
  data(iFile).riseTime.s= fscanf(fid, '%s\n %s\n' , 2); data(iFile).riseTime.val=str2num(fscanf(fid, '%s\n',1)); fscanf(fid, '%s\n',1); guiInfo.Leica.rTime(iFile)=data(iFile).riseTime.val;
  data(iFile).ShiftPT.s= fscanf(fid, '%s\n %s\n' , 2); data(iFile).ShiftPT.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); guiInfo.Leica.sPT(iFile)=data(iFile).ShiftPT.val;
  data(iFile).hpDwell.s= fscanf(fid, '%s\n %s\n' , 2); data(iFile).hpDwell.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); guiInfo.Leica.hpDwell(iFile)=data(iFile).hpDwell.val;    
  data(iFile).CoolingRate.s= fscanf(fid, '%s\n %s\n' , 2); data(iFile).CoolingRate.val=str2num(fscanf(fid, '%s',1));  fscanf(fid, '%s\n',1); guiInfo.Leica.CoolingRate(iFile)=data(iFile).CoolingRate.val;    
  
  for j=1:4 s=fgets(fid); end;
  j=0;
  while ~feof(fid) j=j+1;
    data(iFile).t(j)=str2num(fscanf(fid,'%s\n',1));  
    data(iFile).p(j)=str2num(fscanf(fid,'%s\n',1));  
    data(iFile).temp(j)=str2num(fscanf(fid,'%s\n',1)); 
    guiInfo.Leica.Time(j,iFile)=data(iFile).t(j)/1000;
    guiInfo.Leica.P(j,iFile)=data(iFile).p(j);
    guiInfo.Leica.Temp(j,iFile)=data(iFile).temp(j);
  end;
  fclose(fid);
  if iscell(guiInfo.ui.Leica.File)
    guiInfo.ui.Leica.listInfo{iFile}=[cell2mat(guiInfo.ui.Leica.listInfo(iFile)) '       ' guiInfo.Leica.Header(iFile).headerStr(1).s(19:size(guiInfo.Leica.Header(iFile).headerStr(1).s,2)-1)];    
  else
    guiInfo.ui.Leica.listInfo=[];guiInfo.ui.Leica.listInfo=[guiInfo.ui.Leica.fName '   ' guiInfo.Leica.Header.headerStr(1).s(19:size(guiInfo.Leica.Header.headerStr(1).s,2)-1)];
  end;
end
set(guiInfo.ui.ListBoxLeica,'String',guiInfo.ui.Leica.listInfo); drawnow;