function doHPManalyse
global guiInfo

%LeicaData
guiInfo.ui.fLeica=figure('NumberTitle','off','Name','Leica','Position',[200 200 900 600]);
guiInfo.ui.x1=guiInfo.Leica.FileNr(1)-1;
guiInfo.ui.x2=guiInfo.Leica.FileNr(size(guiInfo.Leica.FileNr,2))+1;
subplot(3,2,1);plot(guiInfo.Leica.FileNr,guiInfo.Leica.rTime,'*'); title({[guiInfo.path '  NrOfFile:' num2str(guiInfo.ui.Leica.NrOfFile)];'rise Time'},'Interpreter','none'); xlabel('probe'); xlim([guiInfo.ui.x1 guiInfo.ui.x2]);ylabel('msec');
subplot(3,2,2);plot(guiInfo.Leica.FileNr,guiInfo.Leica.sPT,'*'); title('Shift p/T'); xlabel('probe'); xlim([guiInfo.ui.x1 guiInfo.ui.x2]); ylabel('msec');
subplot(3,2,3);plot(guiInfo.Leica.FileNr,guiInfo.Leica.hpDwell,'*'); title('hp Dwell'); xlabel('probe'); xlim([guiInfo.ui.x1 guiInfo.ui.x2]); ylabel('msec');
subplot(3,2,4);plot(guiInfo.Leica.FileNr,guiInfo.Leica.CoolingRate,'*'); title('Cooling Rate'); xlabel('probe'); xlim([guiInfo.ui.x1 guiInfo.ui.x2]); ylabel('C/s');
subplot(3,2,5);hold on; for j=1:size(guiInfo.Leica.Temp,2) plot(guiInfo.Leica.Time(:,j),guiInfo.Leica.Temp(:,j),'color',[0.8 0.8 0.8]); end; plot(guiInfo.Leica.Time(:,j),mean(guiInfo.Leica.Temp,2),'color',[0 0 0]); title('temperatur'); xlabel('msec'); ylabel('C'); hold off; grid on;
subplot(3,2,6);hold on; for j=1:size(guiInfo.Leica.P,2) plot(guiInfo.Leica.Time(:,j),guiInfo.Leica.P(:,j),'color',[0.8 0.8 0.8]); end; plot(guiInfo.Leica.Time(:,j),mean(guiInfo.Leica.P,2),'color',[0 0 0]); title('pressure Leica'); xlabel('msec'); ylabel('bar'); hold off; grid on; 

%NIdata
guiInfo.ui.fdata=figure('NumberTitle','off','Name','HPMdata','Units','normal','Position',[0.2 0.2 0.7 0.7],'PaperOrientation','landscape');
guiInfo.CurserPos=4350; guiInfo.TimePos=6600;
guiInfo.ui.xPos=0.96; guiInfo.ui.yPos=0.05; guiInfo.ui.dy=0.03; guiInfo.Pos=[];
subplot('Position',[0.15 0.1 0.6 0.8]); hold on; 
for j=1:guiInfo.ui.NI.NrOfFile
  isColorIntens=1-(j/guiInfo.ui.NI.NrOfFile/2);
  for iPos=1:size(guiInfo.Leica.Time,1) if ((guiInfo.CurserPos/10)+guiInfo.Leica.Time(iPos,1)<=(guiInfo.TimePos/10)) pos=iPos; end; end;  
  guiInfo.p(j).leicaP=plot(guiInfo.Leica.Time(:,j)+(guiInfo.CurserPos/10),(guiInfo.Leica.P(:,j)/20000)+0.35,'Color',[isColorIntens isColorIntens isColorIntens],'LineStyle','-');  % leica pressure
  if pos>0 guiInfo.p(j).leicaPTime=plot(guiInfo.Leica.Time(round(pos),j)+(guiInfo.CurserPos/10),(guiInfo.Leica.P(round(pos),j)/20000)+0.35,'Color',[isColorIntens isColorIntens isColorIntens],'Marker','+','MarkerSize',20); end  ;
  
  guiInfo.p(j).leicaT= plot(guiInfo.Leica.Time(:,j)+(guiInfo.CurserPos/10),(guiInfo.Leica.Temp(:,j)/3000)+0.3,'Color',[isColorIntens 0 isColorIntens],'LineStyle','-');  % leica temperatur
  if pos>0 guiInfo.p(j).leicaTTime= plot(guiInfo.Leica.Time(round(pos),j)+(guiInfo.CurserPos/10),(guiInfo.Leica.Temp(round(pos),j)/3000)+0.3,'Color',[isColorIntens 0 isColorIntens],'Marker','+','MarkerSize',20); end;
  
  guiInfo.p(j).extP_a=-0.41; guiInfo.p(j).extP_b=1.5;
  guiInfo.p(j).extP=plot(guiInfo.NI.time,(guiInfo.NI.AllData(j).data(8,:)+guiInfo.p(j).extP_a)*guiInfo.p(j).extP_b,'Color',[0 isColorIntens 0],'LineStyle','-');   % ext pressure
  guiInfo.p(j).extPCurser=plot(guiInfo.NI.time(guiInfo.CurserPos),(guiInfo.NI.AllData(j).data(8,guiInfo.CurserPos)+guiInfo.p(j).extP_a)*guiInfo.p(j).extP_b,'Color',[0 isColorIntens 0],'Marker','*','MarkerSize',20);   % ext pressure  
  guiInfo.p(j).extPTime=plot(guiInfo.NI.time(guiInfo.TimePos),(guiInfo.NI.AllData(j).data(8,guiInfo.TimePos)+guiInfo.p(j).extP_a)*guiInfo.p(j).extP_b,'Color',[0 isColorIntens 0],'Marker','+','MarkerSize',20);   % ext pressure  

  guiInfo.p(j).acc_a=4; 
  guiInfo.p(j).acc=plot(guiInfo.NI.time,(guiInfo.NI.AllData(j).data(2,:)-mean(guiInfo.NI.AllData(j).data(2,:)))/guiInfo.p(j).acc_a,'Color',[isColorIntens 0 0],'LineStyle','-'); % acc  
  guiInfo.p(j).accCurser=plot(guiInfo.NI.time(guiInfo.CurserPos),(guiInfo.NI.AllData(j).data(2,guiInfo.CurserPos)-mean(guiInfo.NI.AllData(j).data(2,guiInfo.CurserPos)))/guiInfo.p(j).acc_a,'Color',[isColorIntens 0 0],'Marker','*','MarkerSize',20); % acc    
  guiInfo.p(j).accTime=  plot(guiInfo.NI.time(guiInfo.TimePos)  ,(guiInfo.NI.AllData(j).data(2,guiInfo.TimePos)  -mean(guiInfo.NI.AllData(j).data(2,guiInfo.CurserPos)))/guiInfo.p(j).acc_a,'Color',[isColorIntens 0 0],'Marker','+','MarkerSize',20); % acc      
  
  guiInfo.p(j).micc_a=60; guiInfo.p(j).micc_b=-0.15;
  guiInfo.p(j).mic=plot(guiInfo.NI.time,(guiInfo.NI.AllData(j).data(7,:)/guiInfo.p(j).micc_a)+guiInfo.p(j).micc_b,'Color',[0 0 isColorIntens],'LineStyle','-');    % mic
  guiInfo.p(j).micCurser=plot(guiInfo.NI.time(guiInfo.CurserPos),((guiInfo.NI.AllData(j).data(7,guiInfo.CurserPos)/guiInfo.p(j).micc_a)+guiInfo.p(j).micc_b),'Color',[0 0 isColorIntens],'Marker','*','MarkerSize',20);    % mic  
  guiInfo.p(j).micTime=plot(guiInfo.NI.time(guiInfo.TimePos),((guiInfo.NI.AllData(j).data(7,guiInfo.TimePos)/guiInfo.p(j).micc_a)+guiInfo.p(j).micc_b),'Color',[0 0 isColorIntens],'Marker','+','MarkerSize',20);    % mic    
  
  guiInfo.p(j).lightc_a=20; guiInfo.p(j).lightc_b=0.35;
  guiInfo.p(j).light=plot(guiInfo.NI.time,(guiInfo.NI.AllData(j).data(5,:)/guiInfo.p(j).lightc_a)+guiInfo.p(j).lightc_b,'Color',[0 isColorIntens isColorIntens],'LineStyle','-');    % light
  guiInfo.p(j).lightCurser=plot(guiInfo.NI.time(guiInfo.CurserPos),((guiInfo.NI.AllData(j).data(5,guiInfo.CurserPos)/guiInfo.p(j).lightc_a)+guiInfo.p(j).lightc_b),'Color',[0 isColorIntens isColorIntens],'Marker','*','MarkerSize',20);    % light  
  guiInfo.p(j).lightTime=plot(guiInfo.NI.time(guiInfo.TimePos),((guiInfo.NI.AllData(j).data(5,guiInfo.TimePos)/guiInfo.p(j).lightc_a)+guiInfo.p(j).lightc_b),'Color',[0 isColorIntens isColorIntens],'Marker','+','MarkerSize',20);    % light    
 
  guiInfo.Pos(j).Curser=guiInfo.CurserPos/10;
  guiInfo.ui.CheckBox(j)=uicontrol('Style','checkbox','String',num2str(j),'Units','normal',                             'Position',[guiInfo.ui.xPos      0.9-guiInfo.ui.yPos 0.04 0.02],'Value',1,'Callback',['CallbackCheckbox;']);
  guiInfo.ui.CheckboxCurserTimeTxt(j)=uicontrol('Style','Text','String',num2str(guiInfo.Pos(j).Curser),'Units','normal','Position',[guiInfo.ui.xPos-0.04 0.9-guiInfo.ui.yPos 0.04 0.02]);
  guiInfo.ui.CheckboxHPMpresTimeTxt(j)=uicontrol('Style','Text','String','-','Units','normal',                          'Position',[guiInfo.ui.xPos-0.08 0.9-guiInfo.ui.yPos 0.04 0.02]);
  guiInfo.ui.CheckboxHPMtempTimeTxt(j)=uicontrol('Style','Text','String','-','Units','normal',                          'Position',[guiInfo.ui.xPos-0.12 0.9-guiInfo.ui.yPos 0.04 0.02]);
  guiInfo.ui.CheckBoxNIinfo(j)=uicontrol('Style','Text','String',guiInfo.NI.AllData(j).header.IDVal ,'Units','normal',  'Position',[guiInfo.ui.xPos-0.20 0.9-guiInfo.ui.yPos 0.07 0.02]);  
  guiInfo.ui.yPos=guiInfo.ui.yPos+guiInfo.ui.dy; 
end; 
guiInfo.ui.xPos=0.96; guiInfo.ui.yPos=0.03; 
guiInfo.ui.CheckboxCurserInfo=uicontrol ('Style','Text','String','curser','Units','normal','Position',[guiInfo.ui.xPos-0.04 0.9-guiInfo.ui.yPos 0.04 0.02]);
guiInfo.ui.CheckboxHPMpresInfo=uicontrol('Style','Text','String','pres','Units','normal','Position',[guiInfo.ui.xPos-0.08 0.9-guiInfo.ui.yPos 0.04 0.02]);
guiInfo.ui.CheckboxHPMtempInfo=uicontrol('Style','Text','String','temp','Units','normal','Position',[guiInfo.ui.xPos-0.12 0.9-guiInfo.ui.yPos 0.04 0.02]);
guiInfo.ui.CheckBoxNIIDinfo=uicontrol   ('Style','Text','String','ID','Units','normal','Position',[guiInfo.ui.xPos-0.20 0.9-guiInfo.ui.yPos 0.07 0.02]);  

%viewChannel
guiInfo.ui.CheckBoxChannelTxt=['LPres';'LTemp';'acc  ';'EPres';'mic  ';'puls '];
guiInfo.ui.xPos=0.6; guiInfo.ui.yPos=0.95; guiInfo.ui.dx=0.05;
for j=1:6 guiInfo.ui.CheckBoxChannel(j)=uicontrol('Style','checkbox','String',guiInfo.ui.CheckBoxChannelTxt(j,:),'Units','normal','Position', [guiInfo.ui.xPos+(j*guiInfo.ui.dx) guiInfo.ui.yPos  0.05 0.02],'Value',1,'Callback',['CallbackCheckboxChannel;']); end;

guiInfo.ui.xPos=0.85; guiInfo.ui.yPos=0.9; guiInfo.ui.dy=0.05;
guiInfo.ui.HPMallOn=uicontrol('Style','pushbutton','String','AllOn','Units','normal','Position',[guiInfo.ui.xPos guiInfo.ui.yPos 0.04 0.03],'Callback','CallbackAllOn;');
guiInfo.ui.HPMallOff=uicontrol('Style','pushbutton','String','AllOff','Units','normal','Position',[guiInfo.ui.xPos+0.05 guiInfo.ui.yPos 0.05 0.03],'Callback','CallbackAllOff;');

title({[guiInfo.path '  NrOfFile:' num2str(guiInfo.ui.NI.NrOfFile)];'[b=mic r=acc g=extPres c=puls] with NI    [b=Press m=Temp] leica adjusted in time'},'Interpreter','none'); 
xlabel('msec'); ylabel('AU'); xlim([300 900]); grid on; grid minor; hold off; 

%pushbutton
guiInfo.ui.xPos=0.01; guiInfo.ui.yPos=0.02; guiInfo.ui.dy=0.04;
guiInfo.ui.PlotAllNIchan=uicontrol('Style','pushbutton','String','plotNI','Units','normal','Position',[guiInfo.ui.xPos guiInfo.ui.yPos 0.05 0.03],'Callback','doPlotAllNIchannel;');guiInfo.ui.yPos=guiInfo.ui.yPos+guiInfo.ui.dy;
guiInfo.ui.LeicaPrintPDF=uicontrol('Style','pushbutton','String','printPDF','Units','normal','Position',[guiInfo.ui.xPos guiInfo.ui.yPos 0.05 0.03],'Callback','CallbackPrint;');guiInfo.ui.yPos=guiInfo.ui.yPos+guiInfo.ui.dy;
guiInfo.ui.HPMsaveData=uicontrol('Style','pushbutton','String','saveData','Units','normal','Position',[guiInfo.ui.xPos guiInfo.ui.yPos 0.05 0.03],'Callback','CallbackSaveData;');guiInfo.ui.yPos=guiInfo.ui.yPos+guiInfo.ui.dy;
guiInfo.ui.HPMloadData=uicontrol('Style','pushbutton','String','loadData','Units','normal','Position',[guiInfo.ui.xPos guiInfo.ui.yPos 0.05 0.03],'Callback','CallbackLoadData;');guiInfo.ui.yPos=guiInfo.ui.yPos+guiInfo.ui.dy;

%accSelect
guiInfo.ui.xPos=0.07; guiInfo.ui.yPos=0.02; guiInfo.ui.dx=0.05; guiInfo.ui.dy=0.07;
guiInfo.ui.accSelectAll= ['accX';'accY';'accZ'];guiInfo.ui.accSelect=2;
guiInfo.ui.accListBox=uicontrol('Style','Listbox','Units','normal','Position', [guiInfo.ui.xPos guiInfo.ui.yPos guiInfo.ui.dx guiInfo.ui.dy],'Min',1,'Max',1,'Callback',['CallbackAccSelect;']);
guiInfo.ui.listInfo=[]; for ii=1:size(guiInfo.ui.accSelectAll,1) guiInfo.ui.listInfo{ii}=guiInfo.ui.accSelectAll(ii,:); end;  set(guiInfo.ui.accListBox,'String',guiInfo.ui.listInfo,'Value',guiInfo.ui.accSelect);

%curser
guiInfo.ui.xPos=0.05; guiInfo.ui.yPos=0.25; guiInfo.ui.dySlider=0.3;
guiInfo.ui.HPMcurserSlider=uicontrol('Style','slider','Units','normal','Position', [guiInfo.ui.xPos guiInfo.ui.yPos 0.02 guiInfo.ui.dySlider],'Min',3000,'Max',9000,'Value',guiInfo.CurserPos,'Callback',['CallbackHPMcurserSlider;']);
guiInfo.ui.HPMcurserSliderInfo=uicontrol('Style','Text','String','curser','Units','normal','Position',[guiInfo.ui.xPos-0.01 guiInfo.ui.yPos+guiInfo.ui.dySlider 0.04 0.02]);  
guiInfo.ui.HPMcurserP = uicontrol('Style','pushbutton','String','+1' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos+guiInfo.ui.dySlider-0.03 0.03 0.03],'Callback','CallbackHPMcurserP;');
guiInfo.ui.HPMcurserM = uicontrol('Style','pushbutton','String','-1' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos 0.03 0.03],'Callback','CallbackHPMcurserM;');
guiInfo.ui.HPMcurserP02 = uicontrol('Style','pushbutton','String','+0.2' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos+guiInfo.ui.dySlider-0.03-0.03 0.03 0.03],'Callback','CallbackHPMcurserP02;');
guiInfo.ui.HPMcurserM02 = uicontrol('Style','pushbutton','String','-0.2' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos+0.03 0.03 0.03],'Callback','CallbackHPMcurserM02;');


%timeInfo
guiInfo.ui.xPos=0.05; guiInfo.ui.yPos=0.65; guiInfo.ui.dySlider=0.3;
guiInfo.ui.HPMSliderTime=uicontrol('Style','slider','Units','normal','Position', [guiInfo.ui.xPos guiInfo.ui.yPos 0.02 guiInfo.ui.dySlider],'Min',0,'Max',9000,'Value',guiInfo.TimePos,'Callback',['CallbackHPMSliderTime;']);
guiInfo.ui.HPMSliderTimeTxt=uicontrol('Style','Text','String',num2str(guiInfo.TimePos/10,'%.1f'),'Units','normal','Position',[guiInfo.ui.xPos-0.01 guiInfo.ui.yPos+guiInfo.ui.dySlider 0.04 0.02]);  
guiInfo.ui.HPMTimeP = uicontrol('Style','pushbutton','String','+1' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos+guiInfo.ui.dySlider-0.03 0.03 0.03],'Callback','CallbackHPMtimeP;');
guiInfo.ui.HPMTimeM = uicontrol('Style','pushbutton','String','-1' ,'Units','normal','Position',[guiInfo.ui.xPos-0.04 guiInfo.ui.yPos 0.03 0.03],'Callback','CallbackHPMtimeM;');

CallbackLoadData;