function loadNIfiles
global guiInfo

%HPMdata
guiInfo.NI.sfrec=10000;
if iscell(guiInfo.ui.NI.File) 
  guiInfo.ui.NI.NrOfFile=size(guiInfo.ui.NI.File,2);
else  
  guiInfo.ui.NI.NrOfFile=size(guiInfo.ui.NI.File,1);
end

guiInfo.NI.AllData=[];
for iFile=1:guiInfo.ui.NI.NrOfFile
  if iscell(guiInfo.ui.NI.File)
    fname=cell2mat(guiInfo.ui.NI.File(:,iFile));
  else
    fname=guiInfo.ui.NI.File;
  end
  load(fname,'header','data');  display([fname  '   ' header.IDVal]);   
  guiInfo.NI.AllData(iFile).data=data;     
  guiInfo.NI.AllData(iFile).header=header;
  if iscell(guiInfo.ui.NI.File)
    guiInfo.ui.NI.listInfo{iFile}=[cell2mat(guiInfo.ui.NI.listInfo(iFile)) '     '  header.IDVal];
    if strfind(cell2mat(guiInfo.NI.AllData(1).header.legend(8)),'Pressure') 
      guiInfo.ui.NI.doPressure=1; 
    else
      guiInfo.ui.NI.doPressure=0; 
    end;
  else
    guiInfo.ui.NI.listInfo=[guiInfo.ui.NI.fName '   ' header.IDVal];
    if strfind(cell2mat(guiInfo.NI.AllData(1).header.legend(8)),'Pressure') guiInfo.ui.NI.doPressure=1; else guiInfo.ui.NI.doPressure=0; end;    
  end;
  if (guiInfo.ui.NI.doPressure==0)
    guiInfo.NI.AllData(iFile).data(8,:)=0.41;
  end  
end; 
guiInfo.NI.time=1:size(data,2); guiInfo.NI.time=(guiInfo.NI.time/guiInfo.NI.sfrec)*1000;  
set(guiInfo.ui.ListBoxNI,'String',guiInfo.ui.NI.listInfo); drawnow;
clear header; clear data;