%Institute for Auditory Neuroscience, Kai Bodensiek

%This script normalizes an image to the integrated irradiances on
%the imaged object. 


%input parameter

image_name = 'led_blue_80.bmp'; %image of an intensity distribution gray scale)

total_power = 37.3; %integrated power in the above mentioned image area [mW]

pixel_edge_length = 0.0045; %edge length single pixel [mm], (symmetric pixel)

pixel_area = pixel_edge_length ^ 2; %area of single pixel [mm]

background = false; %set true, if the average pixel background value is known

average_background_pixel_value = 7; % [gray value]


%preprocessing

image = imread(image_name); %reading the image 

imagesc(I) % show image

[height, width] = size(image); %get image size

image_array = zeros([height width],'double'); % preallocate 2-D array

[image_array(:,:)] = image; %write the pixel values to image_array


%calculations

sum_gray_values = sum(image_array(:)); %integrate gray values in complete image

if background   
    image_array = image_array - average_background_pixel_value;
end

power_per_gray_value = total_power/sum_gray_values; % calculate power per gray value 

image_array = (image_array.*power_per_gray_value)./pixel_area; % calculate intensitys for every pixel [mW/mm]


%plot results

x_im_size_mm = width*pixel_edge_length; %calculate the image size in mm
y_im_size_mm = height*pixel_edge_length; %"

x_axis_vec_mm = linspace(0, x_im_size_mm, width); %create axis scale vector in mm
y_axis_vec_mm = linspace(0, y_im_size_mm, height); %"

figure(2);

surf(x_axis_vec_mm,y_axis_vec_mm,image_array,'EdgeColor','none') %surface plot with mm scale

axis([0 x_im_size_mm 0 y_im_size_mm]) %set axis limits

pbaspect([(width/height) (width/width) 1.5]) %set aspect ratio

xlabel('[mm]')
ylabel('[mm]')
zlabel('[mW/mm]')

colorbar

%imwrite(image_array,'intensity_profile.tif')
