%README: This is the standalone supplementary code for Grimes, D. R. (2022, March 28). 
%"The Ellipse of Insignificance - a refined fragility index for ascertaining robustness of results in dichotomous outcome trials." 
%Published in eLife 2022, this version retrieved from osf.io/32p8t - subject to change, version 1.00
%contact: davidrobert.grimes@dcu.ie / davidrobert.grimes@tcd.ie / davidrobertgrimes.com 
%Please note: this is a very basic demonstration and is provided as is!!! 

clear
clc
prompt = {'Experimental endpoint positive (a):','Experimental endpoint negative (b):','Control endpoint positive (c):','Control endpoint negative (d):','Desired alpha value'};
dlgtitle = '2x2 Contingency table ';
dims = [1 60];
definput = {'900','100','500','500','0.05'};
answer = inputdlg(prompt,dlgtitle,dims,definput);

clc

a = str2num(answer{1});
b = str2num(answer{2});
c = str2num(answer{3});
d = str2num(answer{4});
alpha = str2num(answer{5});

chival = @(v) chi2cdf(v,1) - (1-alpha);
v = fzero(chival,0);
n = a + b + +c +d; 
clear chival prompt answer definput dims dlgtitle;

%check for significance at input level! 
tstat_test = (n.*((a.*d - b.*c).^2))./((a+b).*(c+d).*(a+c).*(b+d)) - v;
if tstat_test <= 0 
    vtest = 0;
else 
    vtest = 1;
end

clear tstat_test; 

switch vtest
    case 0
        
        f = msgbox("Not significant before recoding!","Error","error");
         clear
               
    otherwise

 %house keeping to make sure biggest pair go first, otherwise you get same answer but awkwardly inverted
 %simple fix is to ensure that a > c, and flip if not. Analysis is the same. 
       
if c >= a

aa = c;
bb = d;
cc = a;
dd = b;
a = aa;
b = bb;
c = cc;
d = dd;

clear aa bb cc dd

end
        
        %ellipse terms
Ae = (c+d).*((c+d).*n + (a+b).*v);
Be = 2*(a+b)*(c+d)*(n-v); 
Ce = (a+b).*((a+b).*n + (c+d).*v);
De = (c+d).*(2.*(b*c-a*d).*n + (a+b).*(b-a + d -c).*v);
Ee = (a+b).*(2.*(b*c-a*d).*n + (c+d).*(a-b + c -d).*v);
Fe = ((b*c-a*d)^2).*n - (a+b)*(a+c)*(b+d)*(c+d)*v; 

%find FECKUP vector points
syms xp yp
eq1=(2*Ae.*xp + Be.*yp +De).*yp - xp.*(Be.*xp + 2*Ce.*yp + Ee);
eq2=Ae*(xp.^2) + Be.*xp.*yp + Ce.*(yp.^2) + De.*xp + Ee.*yp + Fe; 
eqs = [eq1, eq2];
[xp,yp]=vpasolve(eqs,[xp,yp]);
xp = double(xp);
yp = double(yp);
dv = sqrt((xp.^2) + (yp.^2)); 
i = find(dv == min(dv)); 
xp = xp(i);
yp = yp(i); 
FCKP = dv(i);
clear eq1 eq2 eqs dv i 

%find xi point - simple quadratic form
A1 = (c+d).*((c+d).*n + (a+b).*v);
B1 = (c+d).*(2.*(b*c-a*d).*n + (a+b).*(b-a + d -c).*v);
C1 = ((b*c-a*d)^2).*n - (a+b)*(a+c)*(b+d)*(c+d)*v; 
X1 = (-B1 + sqrt(B1.^2 - 4*A1*C1))./(2*A1); 
X2 = (-B1 - sqrt(B1.^2 - 4*A1*C1))./(2*A1);
g = [X1 X2];
xi = min(g); 
clear A1 B1 C1 X1 X2 g

%find yi point - simple quadratic form
A2 = (a+b)*((a+b)*n + (c+d)*v);
B2 = (a+b)*(2*(b*c-a*d)*n + (a-b+c-d)*(c+d)*v);
C2 = ((b*c-a*d)^2).*n - (a+b)*(a+c)*(b+d)*(c+d)*v; 
Y1 = (-B2 + sqrt(B2.^2 - 4*A2*C2))./(2*A2); 
Y2 = (-B2 - sqrt(B2.^2 - 4*A2*C2))./(2*A2);
g2 = [Y1 Y2];
yi = min(g2); 
clear A2 B2 C2 Y1 Y2 g2

%Find all relevant terms

dmin = floor(abs(xp) + abs(yp));
qvec = [(1 - (a+b - abs(xi))./(a+b)) (1 - (c+d - abs(yi))./(c+d)) (1 - (n - abs(dmin))./(n)) ]

        

%Plotting considerations
xv = -1.05*b:0.01:1.05*a;
By = Be.*xv + Ee;
Cy = Ae.*(xv.^2) + De.*xv + Fe; 
el1 = (-By + sqrt(By.^2 - 4.*Ce.*Cy))./(2.*Ce);
el2 = (-By - sqrt(By.^2 - 4.*Ce.*Cy))./(2.*Ce);
vls = find(abs(imag(el1))>0);
el1(vls) = NaN;
vls2 = find(abs(imag(el2))>0);
el2(vls2) = NaN;
clear By Cy vls vls2


subplot(2,1,1)
ap = plot(xv,el1,'r','LineWidth',2);
hold on
bp = plot(xv,el2,'b','LineWidth',2); 

%circles
%origin and xi, yi circles

dc = 0:0.1:360;
xcirc = 0 + cosd(dc);
ycirc = 0 + sind(dc); 
xicirc = xi+ cosd(dc);
yicirc = 0 + sind(dc); 
xi2circ = 0+ cosd(dc);
yi2circ = yi + sind(dc); 
plot(xcirc,ycirc); 
hold on;
plot(xicirc,yicirc);
hold on
plot(xi2circ,yi2circ); 
xl = [0 xp];
yl = [0 yp];
l1 = line(xl,yl,'Color','red','LineStyle','--');
xm1 = [0 xi];
ym1 = [0 0];
l2 = line(xm1,ym1,'Color','green','LineStyle','--');
xm2 = [0 0];
ym2 = [0 yi];
l3 = line(xm2,ym2,'Color','blue','LineStyle','--');
% extract the handles that require legend entries
hleglines = [l1(1) l2(1) l3(1)];
% create the legend
hleg = legend(hleglines,'FECKUP vector','x_{i}','y_{i}');
xlabel('Experimental recoding (x)')
ylabel('Control recoding (y)')
title('Ellipse of insignificance')

subplot(2,1,2)
ap2 = plot(xv,el1,'r','LineWidth',2);
hold on
bp2 = plot(xv,el2,'b','LineWidth',2); 
plot(xcirc,ycirc); 
hold on;
plot(xicirc,yicirc);
hold on
plot(xi2circ,yi2circ); 
xl = [0 xp];
yl = [0 yp];
l1 = line(xl,yl,'Color','red','LineStyle','--');
xm1 = [0 xi];
ym1 = [0 0];
l2 = line(xm1,ym1,'Color','green','LineStyle','--');
xm2 = [0 0];
ym2 = [0 yi];
l3 = line(xm2,ym2,'Color','blue','LineStyle','--');
% extract the handles that require legend entries
hleglines = [l1(1) l2(1) l3(1)];
% create the legend
hleg = legend(hleglines,'FECKUP vector','x_{i}','y_{i}');
xlim([-0.1.*xi 1.1.*xi])
ylim([-0.1.*yi 1.1.*yi])
xlabel('Experimental recoding (x)')
ylabel('Control recoding (y)')
title('Ellipse of insignificance (select region)')


clear ap bp ap2 bp2 xicirc yicirc xl yl ll xm1 ym1 xm2 ym3 l1 l2 l3 hleg ym2 xm3 hleglines dc el1 el2 vtest xcirc xi2circ ycirc yi2circ

%output values
 
 h = msgbox({['FECKUP vector length: ',num2str(round(FCKP,2))]...
             ['dmin length (Integer): ',num2str(round(dmin,2))]...
             ['xi: ',num2str(round(xi,2)) ' patients.']...
             ['yi: ',num2str(round(yi,2)) ' patients.']...
             ['Qe: ',num2str(round(100.*qvec(1),2)) ' %']...
             ['Qc: ',num2str(round(100.*qvec(2),2)) ' %']...
             ['Qa: ',num2str(round(100.*qvec(3),2)) ' %']...
             ['Total patients: ',num2str(n)]},'EOI statistics',"help");



end

%This line solely included to call James Heathers cankerous because he
%probably won't check the code. 