!
!    modified for diff_activity 
!
!---------------------------------------------------------------------------------------------------------------------------------!

 module cpu_mod
 save

 real*8, parameter ::  &
 r_FPT_sq =  0.18447011256002563      , &
 !
 ak_fene =   22.000000000000000      , &
 r_fene_sq =  0.73788045024010251      , &
 eps_fene =  -8.1166849526411280      , &
 !
 eps_vol_rep =   8.0000000000000000      , trunc_volsq = 1.d0, &
 alp_vol_rep =   7.9584888700000000      , &
 fac_vol_rep =   127.33582192000000      , &
 !
 eps_vol_attr =  -8.0000000000000000      , &
 alp_vol_attr =   7.9584888700000000      , &
 fac_vol_attr =  -127.33582192000000      , &
 !
 rad_coro =   0.13958744800000000      , &
 rad_coro_sq =   1.9484655639152706E-002 , &
 akappa =   4.6565791502972385      , &
 akappa_sq =   21.683729382982950      , &
 fac_wall1 =   81.051044782943237      , &
 fac_wall_ene =   11.313708498984761      , &
 xi =  0.54200542005420049      , &
 xi_2 =   1.0840108401084010      , &
 xi_mod =   4.2005420054200493E-002 , &
 trunc_wall = 1.d0, &
 zeta =  0.80723888823457202      , &
 zeta_fac =   2.2550419627158313      , &
 fac_wall2 =   8.4010840108400986E-002 , &
 !
 eps_attr =  -0.0000000000000000      , &
 alp_attr =   100.00000000000000      , &
 fac_attr =   0.0000000000000000      , &
 peak_attr =  0.40621694424851384      , &
 !
 fac_lang1 =  0.24703919655615447      , &
 !
 alambda_rep_attr =   1.0000000000000000E-004 , &
 alambda_attr_neut =   1.6700000000000000E-003 , &
 alambda_neut_rep =   5.0000000000000003E-002 , &
 !
 delt =   1.0000000000000000E-004 , &
 del_t_sqrt =   1.0000000000000000E-002

 real*8, parameter ::  &
 pi =   3.1415926535897931      , &
 pi4 =   12.566370614359172      , &
 pi4by3 =   4.1887902047863905      , &
 fac_lang2 =  0.70290710133865408      , &
 stretch_init =  0.68719974400000006      , &
 r_fene =  0.85899968000000004      , &
 r_mono =  0.21474992000000001     

 integer*4, parameter :: igrid_ene_d = 1!, iRee_grid_d = 1
 real*8, parameter :: Ree_grid_d = 0.2d0 !, grid_modal_d = 0.1d0

 end module cpu_mod

!----------------------------------------------------------------------------------------------------------------------------------

 include 'mkl_vsl.f90'

!----------------------------------------------------------------------------------------------------------------------------------

 program main
 use cpu_mod
 use MKL_VSL_TYPE
 use MKL_VSL

 implicit integer*4(i-o)
 implicit real*8(a-h,p-z) 
 integer*4 :: i_neigh(2)
 integer*4, allocatable, dimension(:,:) :: nbox, near_neigh, iFPT, jFPT, itagFPT, itimeFPT
 integer*4, allocatable, dimension(:) :: itypeAB, ivol_state, ivol_time, nbx_updt_tag, nbx_updt_frm, nbx_updt_to, igenome_sep
 real*8, allocatable, dimension(:) :: x, y, z, rnd_topo, R_coord, det_fx, det_fy, det_fz, x1, y1, z1, eta1, x0_MSD, y0_MSD, z0_MSD,& 
                                      sq_dispA, sq_dispB, velx, vely, velz, Rij_bp_av, Rij_bp, Rij_1D
 real*8, allocatable, dimension(:,:) :: rnd_topo_part, RsqFPT_i(:,:)

 TYPE (VSL_STREAM_STATE) :: stream_G, stream_U
 integer i_brng_G, i_brng_U, i_seed, method_G, method_U, ntot_mono3, nreplica, ndim_rnd_topo

 i_brng_G = VSL_BRNG_MT19937 !NIEDERR!
 i_brng_U = VSL_BRNG_MT19937 !NIEDERR!
 method_G = VSL_RNG_METHOD_GAUSSIAN_ICDF !VSL_RNG_METHOD_GAUSSIAN_BOXMULLER2
 method_U = VSL_RNG_METHOD_UNIFORM_STD
 i_seed = 786

 open(11,file='parameter.inp')
 open(12,file='replica.inp')
 open(13,file='write_freq.inp')
 open(14,file='init_config.inp')
 open(15,file='ABratio.inp')
 open(16,file='pair_corr_grid.inp')
 open(17,file='blk_size.inp')

 open(121,file='ABtype.dat')
 open(122,file='small_delt.dat')
 open(123,file='check_MSD.dat')
 open(124,file='MSD.dat')
 open(125,file='first_passage.dat')
! open(127,file='inter_mono_sep.dat')
 open(128,file='time_series.dat')

 read(11,*) n_chrom, n_mono, r_nucl, ntime, ntime_ther, nshell
 read(12,*) nreplica
 read(13,*) ifreq_eta, ifreq_snap, ifreq_time_ser, ifreq_avg, itime_check, itime_check_grid, ifreq_volstate, ifreq_snap1, istore_i
 read(15,*) ratio_AB
 read(16,*) pair_corr_grid, delr_corr, n_orig
 read(17,*) iblk_size

 close(11); close(12); close(13); close(15); close(16); close(17)

 do ii = 1, (nreplica-1)*547
   xxx = grnd() !call random_number(xxx)
 enddo

 ntot_mono = n_chrom*n_mono
 ntot_mono3 = 3*ntot_mono
 n_mono_A = nint(ratio_AB*n_mono)  ! A = type 0
 n_mono_B = n_mono - n_mono_A      ! B = type 1
 ndim_cell = 1000 !5*float(ntot_mono)/(ixp+ixm)**2     !ntot_mono / 4                                                               !---- Careful to update
 ndim_Rij_1D = ceiling(ntot_mono/2.d0 * (ntot_mono-1))
 ndim_rnd_topo = ndim_Rij_1D !* 10
 ndim_MSD = 9 * (floor(log10(1.0*ntime)) + 1)
 ixp = ceiling(r_nucl) ; ixpp = ixp+1 ; ixpp2 = 2*ixpp ; ixpp2_sq = ixpp2*ixpp2 ; ixpp2_cube = ixpp2_sq*ixpp2

 allocate(x(ntot_mono), y(ntot_mono), z(ntot_mono), itypeAB(ntot_mono), nbox(ixpp2_cube, ndim_cell), near_neigh(ntot_mono,5000),   &
         ivol_state(ndim_Rij_1D), ivol_time(ndim_Rij_1D), rnd_topo(ndim_rnd_topo),                rnd_topo_part(ntot_mono,5000),   &
         R_coord(ntot_mono), det_fx(ntot_mono), det_fy(ntot_mono), det_fz(ntot_mono), x1(ntot_mono), y1(ntot_mono), z1(ntot_mono), &
         eta1(ntot_mono3), nbx_updt_tag(ntot_mono), nbx_updt_frm(ntot_mono), nbx_updt_to(ntot_mono), x0_MSD(ntot_mono),            &
         y0_MSD(ntot_mono), z0_MSD(ntot_mono), sq_dispA(ndim_MSD), sq_dispB(ndim_MSD), igenome_sep(14), iFPT(14,2048),             &
         jFPT(14,2048), itagFPT(14,2048), itimeFPT(14,2048), RsqFPT_i(14,2048), velx(ntot_mono), vely(ntot_mono), velz(ntot_mono)  &
         , Rij_bp_av(ntot_mono), Rij_bp(ntot_mono), Rij_1D(ndim_Rij_1D) &
         )

 i_seed = i_seed + nreplica - 1
 ierr_G = vslnewstream( stream_G, i_brng_G, i_seed )
 ierr_U = vslnewstream( stream_U, i_brng_U, i_seed )

 do ii = 1, ntot_mono
   read(14,*) x(ii), y(ii), z(ii)
 enddo
 close(14)
 call initial_place(n_chrom, n_mono, ntot_mono, r_nucl, x, y, z, nbox, ndim_cell, ixpp2_cube)

 call type_set_rnd_block_copoly(itypeAB,ntot_mono,n_chrom,n_mono,n_mono_A,n_mono_B,ratio_AB,iblk_size)
 do ii = 1, ntot_mono
   write(121,*) ii, itypeAB(ii)
 enddo
 close(121)

 ierr_U = vdrnguniform( method_U, stream_U, ndim_rnd_topo, rnd_topo, 0.d0, 1.d0 )
 nused_unirnd = 0
 !do ii = 1, ndim_rnd_topo
 !  !call random_number(xxx)
 !  rnd_topo(ii) = grnd() !xxx 
 !enddo

 ivol_state = 1 ; ivol_time = 0
 n_small_delt = 0

 icount_MSD = 0      
 sq_dispA = 0.d0   ;   sq_dispB = 0.d0     
 x0_MSD = x ; y0_MSD = y ; z0_MSD = z

 Rij_bp_av = 0.d0
 nset_Rij_bp = 0

 call cpu_time(t1)

 do itime = 1, ntime                                                                                                                ! Start of itime loop

 ene = 0.d0
 Rij_bp = 0.d0

!----------------------------------------------------------------------- start: search_neighbor subroutine in CUDA 
   near_neigh = 0
   !$OMP PARALLEL DEFAULT(SHARED)
   !$OMP DO PRIVATE(ixref,iyref,izref,ix,iy,iz,icellx,icelly,icell,n_part,j_part,delx,dely,delz,r_sq,n_jnk)
   do i_part = 1, ntot_mono
     ixref = ceiling(x(i_part)) + ixpp ; iyref = ceiling(y(i_part)) + ixpp ; izref = ceiling(z(i_part)) + ixpp
     do ix = ixref-1, ixref+1                                                                                  
       icellx = (ix-1)*ixpp2_sq                                                                                
       do iy = iyref-1, iyref+1                                                                                
         icelly = (iy-1)*ixpp2                                                                                 
         do iz = izref-1, izref+1                                                                              
           icell = icellx + icelly + iz                                                                        
           do n_part = 1, nbox(icell,1)                                                                        
             j_part = nbox(icell,n_part+1)                                                                     
             if(j_part /= i_part) then                                                                         
               delx = x(i_part) - x(j_part)                                                                    
               dely = y(i_part) - y(j_part)                                                                    
               delz = z(i_part) - z(j_part)                                                                    
               r_sq = delx*delx + dely*dely + delz*delz                                                        
                                                                                                                
               if(r_sq<trunc_volsq) then                                                                      
!               if(r_sq<peak_attr_sq) then                                                                     ! neighbours within 0.42 separation
                 near_neigh(i_part, 1 ) = near_neigh(i_part, 1 ) + 1                                           ! Total # of neighbours stored in 1st cell
!                 if(j_part> i_part   ) near_neigh(i_part, 2 ) = near_neigh(i_part, 2 ) + 1                    ! # of neighbours generating NEW bonds is stored in 2nd cell
                 if(j_part > i_part+1 ) near_neigh(i_part, 2 ) = near_neigh(i_part, 2 ) + 1                    ! # of non-next-neighbours generating NEW bonds is stored in 2nd cell
                 n_jnk = near_neigh(i_part, 1 ) + 2                                                             
                 near_neigh(i_part, n_jnk) = j_part                                                            
               endif                                                                                           
             endif                                                                                             
           enddo                                                                                               
         enddo                                                                                                 
       enddo                                                                                                   
     enddo                                                                                                     
   enddo                                                                                                       
   !$OMP END DO
   !$OMP END PARALLEL
   ! print*, sum(near_neigh(:,1)), sum(near_neigh(:,2)), sum(near_neigh(:,:))
!----------------------------------------------------------------------- end: search_neighbor subroutine in CUDA 

!----------------------------------------------------------------------- start: cal_required_unirnd & transfer_unirnd subroutines in CUDA 
   nrequired_unirnd = sum(near_neigh(:,2))
   nused_unirnd = nused_unirnd + nrequired_unirnd

   if(nused_unirnd > ndim_rnd_topo) then
     ierr_U = vdrnguniform( method_U, stream_U, ndim_rnd_topo, rnd_topo, 0.d0, 1.d0 )
     nused_unirnd = nrequired_unirnd
     !do ii = 1, ndim_rnd_topo
     !  !call random_number(xxx)
     !  rnd_topo(ii) = grnd() !xxx 
     !enddo
   endif

   !$OMP PARALLEL DEFAULT(SHARED)
   !$OMP DO PRIVATE(iend,istart,ii)
   do i_part = 1, ntot_mono
     iend = nused_unirnd - nrequired_unirnd + sum(near_neigh(1:i_part,2))
     istart = iend - near_neigh(i_part,2) ! + 1 not needed as + ii is in the 2nd next line
     do ii = 1, near_neigh(i_part,2)
       rnd_topo_part(i_part, ii) = rnd_topo(istart + ii)
     enddo
     ! print*, i_part, iend, istart, OMP_GET_THREAD_NUM(), nused_unirnd, nrequired_unirnd
   enddo
   !$OMP END DO
   !$OMP END PARALLEL
!----------------------------------------------------------------------- end: cal_required_unirnd & transfer_unirnd subroutines in CUDA 

   ierr_G = vdrnggaussian( method_G, stream_G, ntot_mono3, eta1, 0.d0, fac_lang2 )

!----------------------------------------------------------------------- start: vol_state_switch subroutine in CUDA 
   ! print*, itime, sum(ivol_time), sum(ivol_state)
   !$OMP PARALLEL DEFAULT(SHARED)
   !$OMP DO PRIVATE(ncount,nn,jj,j_part,ij)
   do i_part = 1, ntot_mono
     if(itypeAB(i_part) < 1) then                                                            ! modified for diff_activity 
       ncount = 0
       nn = near_neigh(i_part, 1 )
       do jj = 1, nn
         j_part = near_neigh(i_part, 2+jj )
!         if(j_part> i_part   ) then
         if(j_part > i_part+1 .and. itypeAB(j_part) < 1) then                                ! Avoiding next-neighbour-on-chain  ! modified for diff_activity 
           ncount = ncount + 1

           ij = (i_part-1)*(ntot_mono-0.5d0*i_part) + j_part - i_part

           ivol_time(ij) = ivol_time(ij) + 1

           if(ivol_state(ij) > 0) then                                                       ! state 1 => repulsive vol excl ;  state 0 => no vol excl;  state -1 => attractive vol excl
             if(rnd_topo_part(i_part,ncount) < 1-exp(-alambda_rep_attr*ivol_time(ij))) then  ! 1 -> -1           loop dynamics
               ivol_state(ij) = -1
               ivol_time(ij) = 0
             endif
           else if(ivol_state(ij) < 0) then
             if(rnd_topo_part(i_part,ncount) < 1-exp(-alambda_attr_neut*ivol_time(ij))) then !      -1 -> 0      loop dynamics
               ivol_state(ij) = 0
               ivol_time(ij) = 0
             endif
           else
             if(rnd_topo_part(i_part,ncount) < 1-exp(-alambda_neut_rep*ivol_time(ij))) then  !            0 -> 1 loop dynamics
               ivol_state(ij) = 1
               ivol_time(ij) = 0
             endif
           endif
         endif
       enddo
     endif
   enddo
   !$OMP END DO
   !$OMP END PARALLEL
!   print*, itime, sum(ivol_time), sum(ivol_state)
!----------------------------------------------------------------------- end: vol_state_switch subroutine in CUDA 

!----------------------------------------------------------------------- start: vol_state_overwrite subroutine in CUDA 

   !$OMP PARALLEL DEFAULT(SHARED)
   !$OMP DO PRIVATE(nn,j_part,ij,jm,ijm,jp,ijp,im,jim,ip,jip)
   do i_part = 1, ntot_mono
     nn = near_neigh(i_part, 1 )
     do jj = 1, nn
       j_part = near_neigh(i_part, 2+jj )
!       if(j_part> i_part   ) then
       if(j_part > i_part+1 ) then                                                           ! Avoiding next-neighbour-on-chain
         ij = (i_part-1)*(ntot_mono-0.5d0*i_part) + j_part - i_part

         if(ivol_state(ij) < 0) then

           jm = j_part - 1                                   ! Since j_part > i_part+1, min(jm) = 2
           if(jm > i_part + 1) then
             ijm = (i_part-1)*(ntot_mono-0.5d0*i_part) + jm - i_part
             if(ivol_state(ijm) == 1) then
               ivol_state(ijm) = 0
               ivol_time(ijm) = 0
             endif
           endif

           if(j_part < ntot_mono) then
             jp = j_part + 1                                 ! already (jp > i_part+2) & max(jp) = N
             ijp = (i_part-1)*(ntot_mono-0.5d0*i_part) + jp - i_part
             if(ivol_state(ijp) == 1) then
               ivol_state(ijp) = 0
               ivol_time(ijp) = 0
             endif
           endif

           if(i_part > 1) then
             im = i_part - 1
             jim = (im-1)*(ntot_mono-0.5d0*im) + j_part - im         ! already (j_part > im+2) & min(im) = 1
             if(ivol_state(jim) == 1) then
               ivol_state(jim) = 0
               ivol_time(jim) = 0
             endif
           endif

           if(i_part < ntot_mono) then
             ip = i_part + 1
             if(j_part > ip+1) then
               jip = (ip-1)*(ntot_mono-0.5d0*ip) + j_part - ip
               if(ivol_state(jip) == 1) then
                 ivol_state(jip) = 0
                 ivol_time(jip) = 0
               endif
             endif
           endif

         endif
       endif
     enddo
   enddo
   !$OMP END DO
   !$OMP END PARALLEL

!----------------------------------------------------------------------- end: vol_state_overwrite subroutine in CUDA 

   itag_wall = 0
   nbx_updt_tag = 0
   ene = 0.d0

!   if(itime/ifreq_avg*ifreq_avg==itime) then
!!----------------------------------------------------------------------- start: LD_full subroutine in CUDA 
!     
!     !$OMP PARALLEL DEFAULT(SHARED)
!     !$OMP DO PRIVATE(fvolx,fvoly,fvolz,j_part,delx,dely,delz,r_sq,ij,ff,ee,rr,ffenex,ffeney,ffenez,i_neigh,r_sep_memb,fmembx)     & 
!     !$OMP& PRIVATE(fmemby,fmembz,force,i_dummy,R1,ix,iy,iz,ix1,iy1,iz1,icell,icell1) REDUCTION(+:ene,Rij_bp)
!     do i_part = 1, ntot_mono                                                                         ! i_part loop start
!
!       fvolx = 0.d0; fvoly = 0.d0; fvolz = 0.d0                                                       !
!       do j_part = 1, ntot_mono                                                                       !---------------  without grid (nbox)
!         if(j_part /= i_part) then                                                                    !
!           delx = x(i_part) - x(j_part)                                                               !
!           dely = y(i_part) - y(j_part)                                                               !
!           delz = z(i_part) - z(j_part)                                                               !
!           r_sq = delx*delx + dely*dely + delz*delz                                                   !
!                                                                                                      !
!           if(r_sq<trunc_volsq) then                                                                  !
!             if(i_part<j_part) then                                                                   !
!               ij = (i_part-1)*(ntot_mono-0.5d0*i_part) + j_part - i_part                             !
!             else                                                                                     !
!               ij = (j_part-1)*(ntot_mono-0.5d0*j_part) + i_part - j_part                             !
!             endif                                                                                    !
!                                                                                                      !
!             if(ivol_state(ij) > 0 ) then                                                             !
!                   ff = force_vol_rep(r_sq)                                                           !
!                   ee = energy_vol_rep(r_sq) * 0.5d0                                                  ! ene_vol is multiplied by 0.5 in the here 
!                                                                                                      !
!                   fvolx = fvolx + delx*ff                                                            !
!                   fvoly = fvoly + dely*ff                                                            !
!                   fvolz = fvolz + delz*ff                                                            ! volume exclusion interaction calculation 
!                   ene = ene + ee                                                                     ! No calculation needed for neutral vol_excl (eps=0)
!             else if(ivol_state(ij) < 0 ) then                                                        !
!                   ff = force_vol_attr(r_sq)                                                          !
!                   ee = energy_vol_attr(r_sq) * 0.5d0                                                 ! ene_vol is multiplied by 0.5 in the here 
!                                                                                                      !
!                   fvolx = fvolx + delx*ff                                                            !
!                   fvoly = fvoly + dely*ff                                                            !
!                   fvolz = fvolz + delz*ff                                                            !
!                   ene = ene + ee                                                                     !
!             endif                                                                                    !
!                                                                                                      !
!             if(itypeAB(i_part)>0 .and. itypeAB(j_part)>0) then                                       !
!               rr = sqrt(r_sq)                                                                        !
!               ff = force_attr(rr)                                                                    !
!               fvolx = fvolx + delx*ff                                                                !
!               fvoly = fvoly + dely*ff                                                                !
!               fvolz = fvolz + delz*ff                                                                !
!                                                                                                      ! B-B attraction (1-1)
!               ee = energy_attr(rr) * 0.5d0                                                           ! 
!               ene = ene + ee                                                                         !
!             endif                                                                                    !
!           endif                                                                                      !
!                                                                                                      !
!           if(j_part>i_part) then                                                                     !
!             Rij_bp(j_part-i_part) = Rij_bp(j_part-i_part) + r_sq                                     !
!            ! ij = (i_part-1)*(ntot_mono-0.5d0*i_part) + j_part - i_part                              !
!            ! Rij_1D(ij) = r_sq  ! since pair_corr not calculated within                              !
!           endif                                                                                      !
!         endif                                                                                        !
!       enddo                                                                                          !
!
!       ffenex = 0.d0; ffeney = 0.d0; ffenez = 0.d0                                                    !
!       i_neigh(1) = i_part - 1                                                                        !
!       i_neigh(2) = i_part + 1                                                                        !
!       if(mod(i_part,ntot_mono)==1) i_neigh(1) = i_part                                               !
!       if(mod(i_part,ntot_mono)==0) i_neigh(2) = i_part                                               !
!       do ii = 1, 2                                                                                   !
!         delx = x(i_part) - x(i_neigh(ii))                                                            ! FENE force for neighbouring monomers
!         dely = y(i_part) - y(i_neigh(ii))                                                            !
!         delz = z(i_part) - z(i_neigh(ii))                                                            !
!                                                                                                      !
!         r_sq = delx*delx + dely*dely + delz*delz                                                     !
!         ff = force_fene(r_sq)                                                                        !
!         ffenex = ffenex + delx*ff                                                                    !
!         ffeney = ffeney + dely*ff                                                                    !
!         ffenez = ffenez + delz*ff                                                                    !
!       enddo                                                                                          !
!                                                                                                      !
!       ee = energy_fene(r_sq)                                                                         !
!       if(mod(i_part,ntot_mono)/=0) ene = ene + ee                                                    !
!
!       R_coord(i_part) = sqrt( x(i_part)*x(i_part) + y(i_part)*y(i_part) + z(i_part)*z(i_part) )      !    
!       r_sep_memb = r_nucl - R_coord(i_part)                                                          !
!       fmembx = 0.d0; fmemby = 0.d0; fmembz = 0.d0; force = 0.d0                                      !
!       if(r_sep_memb<trunc_wall) then                                                                 !
!         ff = - force_wall(r_sep_memb) / R_coord(i_part)                                              !
!         fmembx = ff*x(i_part)                                                                        ! Confinement attribution
!         fmemby = ff*y(i_part)                                                                        !
!         fmembz = ff*z(i_part)                                                                        !
!                                                                                                      !
!         ee = energy_wall(r_sep_memb)                                                                 !
!         ene = ene + ee                                                                               !
!       endif                                                                                          !
!
!       i_dummy = (i_part - 1)*3 + 1                                                                   !
!       det_fx(i_part) = fac_lang1*(fvolx+ffenex+fmembx)                                               !
!       x1(i_part) = x(i_part) + delt*det_fx(i_part) + del_t_sqrt*eta1(i_dummy)                        !
!                                                                                                      !
!       i_dummy = i_dummy + 1                                                                          !
!       det_fy(i_part) = fac_lang1*(fvoly+ffeney+fmemby)                                               !
!       y1(i_part) = y(i_part) + delt*det_fy(i_part) + del_t_sqrt*eta1(i_dummy)                        ! Overdamped Langevin dynamics
!                                                                                                      !
!       i_dummy = i_dummy + 1                                                                          !
!       det_fz(i_part) = fac_lang1*(fvolz+ffenez+fmembz)                                               !
!       z1(i_part) = z(i_part) + delt*det_fz(i_part) + del_t_sqrt*eta1(i_dummy)                        !
!
!       R1 = sqrt( x1(i_part)*x1(i_part) + y1(i_part)*y1(i_part) + z1(i_part)*z1(i_part) )
!       if(R1>=r_nucl) then 
!         !$OMP ATOMIC WRITE
!         itag_wall = 1 !istat = atomicexch(itag_wall, 1)
!       endif
!
!       ix = ceiling(x(i_part)); ix1 = ceiling(x1(i_part))
!       iy = ceiling(y(i_part)); iy1 = ceiling(y1(i_part))
!       iz = ceiling(z(i_part)); iz1 = ceiling(z1(i_part))
!       ix  = ix  + ixpp          ; iy  = iy  + ixpp          ; iz  = iz  + ixpp
!       ix1 = ix1 + ixpp          ; iy1 = iy1 + ixpp          ; iz1 = iz1 + ixpp
!       icell  = (ix -1)*ixpp2_sq + (iy -1)*ixpp2 + iz
!       icell1 = (ix1-1)*ixpp2_sq + (iy1-1)*ixpp2 + iz1
!
!       if(icell/=icell1) then
!         nbx_updt_tag(i_part) = 1; nbx_updt_frm(i_part) = icell; nbx_updt_to(i_part) = icell1
!       endif
!
!     enddo                                                                                            ! i_part loop end       
!    !$OMP END DO
!    !$OMP END PARALLEL
!!----------------------------------------------------------------------- end: LD_full subroutine in CUDA 
!
!     if(itime > ntime_ther) then                       !
!       !$OMP PARALLEL DEFAULT(SHARED)                  !                                                                      
!       !$OMP DO                                        !                                                                      
!         do ii = 1, n_mono-1                           ! For spatial vs genomic sep
!           Rij_bp(ii) = Rij_bp(ii) / (n_mono-ii)       ! Linked with LD_full
!           Rij_bp_av(ii) = Rij_bp_av(ii) + Rij_bp(ii)  ! Not needed within
!         enddo                                         !
!       !$OMP END DO                                    !                                                                      
!       !$OMP END PARALLEL                              !                                                                      
!       nset_Rij_bp = nset_Rij_bp + 1                   !                                                                      
!     endif                                             !
!
!   else                                                                                                                             ! of if(itime/ifreq_avg*ifreq_avg==itime) cond
!
!!----------------------------------------------------------------------- start: LD_nbox subroutine in CUDA 
!     
     !$OMP PARALLEL DEFAULT(SHARED)
     !$OMP DO PRIVATE(fvolx,fvoly,fvolz,j_part,delx,dely,delz,r_sq,ij,ff,ee,rr,ffenex,ffeney,ffenez,i_neigh,r_sep_memb,fmembx)     & 
     !$OMP& PRIVATE(fmemby,fmembz,force,i_dummy,R1,ix,iy,iz,ix1,iy1,iz1,icell,icell1,ixref,iyref,izref,icellx,icelly,n_part)       &
     !$OMP& PRIVATE(R_coord_nbox) REDUCTION(+:ene)
     do i_part = 1, ntot_mono                                                                         ! i_part loop start
       ixref = ceiling(x(i_part)) + ixpp ; iyref = ceiling(y(i_part)) + ixpp ; izref = ceiling(z(i_part)) + ixpp

       fvolx = 0.d0; fvoly = 0.d0; fvolz = 0.d0                                                                  !
       do ix = ixref-1, ixref+1                                                                                  !
         icellx = (ix-1)*ixpp2_sq                                                                                !
         do iy = iyref-1, iyref+1                                                                                !
           icelly = (iy-1)*ixpp2                                                                                 !
           do iz = izref-1, izref+1                                                                              !
             icell = icellx + icelly + iz                                                                        !
             do n_part = 1, nbox(icell,1)                                                                        !
               j_part = nbox(icell,n_part+1)                                                                     !
               if(j_part /= i_part) then                                                                         !
                 delx = x(i_part) - x(j_part)                                                                    !
                 dely = y(i_part) - y(j_part)                                                                    !
                 delz = z(i_part) - z(j_part)                                                                    !
                 r_sq = delx*delx + dely*dely + delz*delz                                                        !
                                                                                                                 ! volume exclusion interaction calculation 
                 if(r_sq<trunc_volsq) then                                                                       !
                   if(i_part<j_part) then                                                                        !
                     ij = (i_part-1)*(ntot_mono-0.5d0*i_part) + j_part - i_part                                  !
                   else                                                                                          !
                     ij = (j_part-1)*(ntot_mono-0.5d0*j_part) + i_part - j_part                                  !
                   endif                                                                                         !
                                                                                                                 !
                   if(ivol_state(ij) > 0 ) then                                                                  !
                         ff = force_vol_rep(r_sq)                                                                !
                         ee = energy_vol_rep(r_sq) * 0.5d0                                                       ! ene_vol is multiplied by 0.5 in the here 
                                                                                                                 !
                         fvolx = fvolx + delx*ff                                                                 !
                         fvoly = fvoly + dely*ff                                                                 ! No calculation needed for neutral vol_excl (eps=0)
                         fvolz = fvolz + delz*ff                                                                 !
                         ene = ene + ee                                                                          !
                   else if(ivol_state(ij) < 0 ) then                                                             !
                         ff = force_vol_attr(r_sq)                                                               !
                         ee = energy_vol_attr(r_sq) * 0.5d0                                                      ! ene_vol is multiplied by 0.5 in the here 
                                                                                                                 !
                         fvolx = fvolx + delx*ff                                                                 !
                         fvoly = fvoly + dely*ff                                                                 !
                         fvolz = fvolz + delz*ff                                                                 !
                         ene = ene + ee                                                                          !
                   endif                                                                                         !
                                                                                                                 !
                   if(itypeAB(i_part)>0 .and. itypeAB(j_part)>0) then                                            !
                     rr = sqrt(r_sq)                                                                             !
                     ff = force_attr(rr)                                                                         !
                     fvolx = fvolx + delx*ff                                                                     !
                     fvoly = fvoly + dely*ff                                                                     !
                     fvolz = fvolz + delz*ff                                                                     !
                                                                                                                 ! B-B attraction (1-1)
                     ee = energy_attr(rr) * 0.5d0                                                                ! 
                     ene = ene + ee                                                                              !
                   endif                                                                                         !
                 endif                                                                                           !
               endif                                                                                             !
             enddo                                                                                               !
           enddo                                                                                                 !
         enddo                                                                                                   !
       enddo                                                                                                     !

       if(i_part==1) then
         delx = x(i_part) - x(ntot_mono)
         dely = y(i_part) - y(ntot_mono)
         delz = z(i_part) - z(ntot_mono)
         Ree = delx*delx + dely*dely + delz*delz
       endif

       ffenex = 0.d0; ffeney = 0.d0; ffenez = 0.d0                                                    !
       i_neigh(1) = i_part - 1                                                                        !
       i_neigh(2) = i_part + 1                                                                        !
       if(mod(i_part,ntot_mono)==1) i_neigh(1) = i_part                                               !
       if(mod(i_part,ntot_mono)==0) i_neigh(2) = i_part                                               !
       do ii = 1, 2                                                                                   !
         delx = x(i_part) - x(i_neigh(ii))                                                            ! FENE force for neighbouring monomers
         dely = y(i_part) - y(i_neigh(ii))                                                            !
         delz = z(i_part) - z(i_neigh(ii))                                                            !
                                                                                                      !
         r_sq = delx*delx + dely*dely + delz*delz                                                     !
         ff = force_fene(r_sq)                                                                        !
         ffenex = ffenex + delx*ff                                                                    !
         ffeney = ffeney + dely*ff                                                                    !
         ffenez = ffenez + delz*ff                                                                    !
       enddo                                                                                          !
                                                                                                      !
       ee = energy_fene(r_sq)                                                                         !
       ene = ene + ee                                                                                 !

       R_coord_nbox = sqrt( x(i_part)*x(i_part) + y(i_part)*y(i_part) + z(i_part)*z(i_part) )         !    
       r_sep_memb = r_nucl - R_coord_nbox                                                             !
       fmembx = 0.d0; fmemby = 0.d0; fmembz = 0.d0; force = 0.d0                                      !
       if(r_sep_memb<trunc_wall) then                                                                 !
         ff = - force_wall(r_sep_memb) / R_coord_nbox                                                 !
         fmembx = ff*x(i_part)                                                                        ! Confinement attribution
         fmemby = ff*y(i_part)                                                                        !
         fmembz = ff*z(i_part)                                                                        !
                                                                                                      !
         ee = energy_wall(r_sep_memb)                                                                 !
         ene = ene + ee                                                                               !
       endif                                                                                          !

       i_dummy = (i_part - 1)*3 + 1                                                                   !
       det_fx(i_part) = fac_lang1*(fvolx+ffenex+fmembx)                                               !
       x1(i_part) = x(i_part) + delt*det_fx(i_part) + del_t_sqrt*eta1(i_dummy)                        !
                                                                                                      !
       i_dummy = i_dummy + 1                                                                          !
       det_fy(i_part) = fac_lang1*(fvoly+ffeney+fmemby)                                               !
       y1(i_part) = y(i_part) + delt*det_fy(i_part) + del_t_sqrt*eta1(i_dummy)                        ! Overdamped Langevin dynamics
                                                                                                      !
       i_dummy = i_dummy + 1                                                                          !
       det_fz(i_part) = fac_lang1*(fvolz+ffenez+fmembz)                                               !
       z1(i_part) = z(i_part) + delt*det_fz(i_part) + del_t_sqrt*eta1(i_dummy)                        !

       R1 = sqrt( x1(i_part)*x1(i_part) + y1(i_part)*y1(i_part) + z1(i_part)*z1(i_part) )
       if(R1>=r_nucl) then 
         !$OMP ATOMIC WRITE
         itag_wall = 1 !istat = atomicexch(itag_wall, 1)
       endif

       ix = ceiling(x(i_part)); ix1 = ceiling(x1(i_part))
       iy = ceiling(y(i_part)); iy1 = ceiling(y1(i_part))
       iz = ceiling(z(i_part)); iz1 = ceiling(z1(i_part))
       ix  = ix  + ixpp          ; iy  = iy  + ixpp          ; iz  = iz  + ixpp
       ix1 = ix1 + ixpp          ; iy1 = iy1 + ixpp          ; iz1 = iz1 + ixpp
       icell  = (ix -1)*ixpp2_sq + (iy -1)*ixpp2 + iz
       icell1 = (ix1-1)*ixpp2_sq + (iy1-1)*ixpp2 + iz1

       if(icell/=icell1) then
         nbx_updt_tag(i_part) = 1; nbx_updt_frm(i_part) = icell; nbx_updt_to(i_part) = icell1
       endif
                                                                                                               
     enddo                                                                                            ! i_part loop end       
     !$OMP END DO
     !$OMP END PARALLEL
!                                                                                                    
!!----------------------------------------------------------------------- end: LD_nbox subroutine in CUDA 
!
!   endif                                                                                                                            ! of if(itime/ifreq_avg*ifreq_avg==itime) cond

!----------------------------------------------------------------------- start: check_FENE subroutine in CUDA 

   !$OMP PARALLEL DEFAULT(SHARED)
   !$OMP DO PRIVATE(delx,dely,delz)
   do i_part = 1, ntot_mono-1                                  
     delx = x1(i_part) - x1(i_part+1)
     dely = y1(i_part) - y1(i_part+1)
     delz = z1(i_part) - z1(i_part+1)
     if(delx*delx + dely*dely + delz*delz > r_fene_sq) then 
       !$OMP ATOMIC WRITE
       itag_wall = 1 !istat = atomicexch(itag_wall, 1)
     endif
   enddo
   !$OMP END DO
   !$OMP END PARALLEL

!----------------------------------------------------------------------- end: check_FENE subroutine in CUDA 

!----------------------------------------------------------------------- start: repeat_LD subroutine in CUDA 

   if(itag_wall==1) then
     nbx_updt_tag = 0
     n_small_delt = n_small_delt + 1

     !$OMP PARALLEL DEFAULT(SHARED)
     !$OMP DO PRIVATE(i_dummy,ix,iy,iz,ix1,iy1,iz1,icell,icell1)
     do i_part = 1, ntot_mono                                                                         
       i_dummy = (i_part - 1)*3 + 1                                                                   !
       x1(i_part) = x(i_part) + delt*0.000001d0*det_fx(i_part) + del_t_sqrt*0.001d0*eta1(i_dummy)     !
                                                                                                      !
       i_dummy = i_dummy + 1                                                                          !
       y1(i_part) = y(i_part) + delt*0.000001d0*det_fy(i_part) + del_t_sqrt*0.001d0*eta1(i_dummy)     ! Overdamped Langevin dynamics
                                                                                                      !
       i_dummy = i_dummy + 1                                                                          !
       z1(i_part) = z(i_part) + delt*0.000001d0*det_fz(i_part) + del_t_sqrt*0.001d0*eta1(i_dummy)     !

       ix = ceiling(x(i_part)); ix1 = ceiling(x1(i_part))
       iy = ceiling(y(i_part)); iy1 = ceiling(y1(i_part))
       iz = ceiling(z(i_part)); iz1 = ceiling(z1(i_part))
       ix  = ix  + ixpp          ; iy  = iy  + ixpp          ; iz  = iz  + ixpp
       ix1 = ix1 + ixpp          ; iy1 = iy1 + ixpp          ; iz1 = iz1 + ixpp
       icell  = (ix -1)*ixpp2_sq + (iy -1)*ixpp2 + iz
       icell1 = (ix1-1)*ixpp2_sq + (iy1-1)*ixpp2 + iz1

       if(icell/=icell1) then
         nbx_updt_tag(i_part) = 1; nbx_updt_frm(i_part) = icell; nbx_updt_to(i_part) = icell1
       endif
     enddo
     !$OMP END DO
     !$OMP END PARALLEL
     write(122,*) itime
   endif

!----------------------------------------------------------------------- end: repeat_LD subroutine in CUDA 

   if(itime < ntime_ther) then                                                                                   ! start: itime < ntime_ther cond

     if(itime>1) then                                                                                        
       itime_sep = itime - 1                                                                                 
       ii = 10**floor(log10(float(itime_sep)))                                                               
       if(mod(itime_sep,ii)==0) then                                                                         
         icount_MSD = icount_MSD + 1                                                                
         !----------------------------------------------------------------------- start: MSD subroutine in CUDA 
         !$OMP PARALLEL DEFAULT(SHARED)
         !$OMP DO PRIVATE(delx,dely,delz,r_sq) REDUCTION(+:sq_dispA,sq_dispB)
         do i_part = 1, ntot_mono-1                                  
           delx = x(i_part) - x0_MSD(i_part)
           dely = y(i_part) - y0_MSD(i_part)
           delz = z(i_part) - z0_MSD(i_part)
           r_sq = delx*delx + dely*dely + delz*delz                              ! Early time MSD
           if(itypeAB(i_part) > 0) then
             sq_dispB(icount_MSD) = sq_dispB(icount_MSD) + r_sq
           else
             sq_dispA(icount_MSD) = sq_dispA(icount_MSD) + r_sq
           endif
         enddo
         !$OMP END DO
         !$OMP END PARALLEL
         !----------------------------------------------------------------------- end: MSD subroutine in CUDA 
       endif                                                                                                 
     endif 

   else if (itime == ntime_ther) then                                                                            ! else if to itime < ntime_ther cond
                                               
     !----------------------------------------------------------------------- start: choosing FPT pairs
     itagFPT = 0
     itimeFPT = 0
     npair_FPT = 14*2048

     ngenome_sep = 0                           
     do ii = 1, 12                             
       ngenome_sep = ngenome_sep + 1           
       igenome_sep(ngenome_sep) = ii * 5       
     enddo                                     
     ngenome_sep = ngenome_sep + 1    ;    igenome_sep(ngenome_sep) = 70                      
     ngenome_sep = ngenome_sep + 1    ;    igenome_sep(ngenome_sep) = 80
                                                                                                             
     do igensep = 1, ngenome_sep                                                                             
       do igenrep = 1, 2048                                                                 
         idum2 = 0                                                           ! for first passage time (FPT)
         do                                                                                                 
           do                                                                                                
             idum1 = 0                                                                                       
             !call random_number(xxx)
             imono = floor((n_mono - igenome_sep(igensep)) * grnd() ) !xxx) 
             if(imono==0) imono = 1                                                                          
             do kk = 1, igenrep-1                                                                            
               if(iFPT(igensep,kk) == imono) idum1 = 1                                                       
             enddo                                                                                           
             if(idum1==0) exit                                                                               
           enddo                                                                                             
           jmono = imono + igenome_sep(igensep)                                                              
           delx = x(imono) - x(jmono) ; dely = y(imono) - y(jmono) ; delz = z(imono) - z(jmono)              
           rr = sqrt(delx*delx + dely*dely + delz*delz)                                                      
           if(rr > 2*r_mono ) then                                                                             
             iFPT(igensep,igenrep) = imono                                                                   
             jFPT(igensep,igenrep) = jmono                                                                   
             RsqFPT_i(igensep,igenrep) = rr*rr                                                               
             idum2 = 1                                                                                       
           endif                                                                                             
           if(idum2==1) exit                                                                                 
         enddo                                                                                               
       enddo                                                                                                 
     enddo                                                                                                   
     !----------------------------------------------------------------------- end: choosing FPT pairs

     !----------------------------------------------------------------------- start: printing early time MSD
     do ii = 1, icount_MSD                                                                            
       if(ii/9*9 /=ii ) then                                                                               
         jj = 10**(ii/9) * mod(ii,9)                                                                        
       else                                                                                                
         jj = 10**(ii/9 - 1) * 9                                                                           
       endif                                                                                               
       write(123,173) jj, sq_dispA(ii)/n_mono_A, sq_dispB(ii)/n_mono_B        ! printing early time MSD                               
     enddo                                                                                                 
     close(123)                                                                                          
     !----------------------------------------------------------------------- end: printing early time MSD

     sq_dispA = 0.d0   ;   sq_dispB = 0.d0     
     icount_MSD = 0 ; x0_MSD = x ; y0_MSD = y ; z0_MSD = z                   ! intialization for steady-state MSD

   else                                                                                                          ! else to itime <= ntime_ther cond 

     itime_sep = itime - ntime_ther
     ii = 10**floor(log10(float(itime_sep)))
     if(mod(itime_sep,ii)==0) then
       icount_MSD = icount_MSD + 1
       !----------------------------------------------------------------------- start: MSD subroutine in CUDA 
       !$OMP PARALLEL DEFAULT(SHARED)
       !$OMP DO PRIVATE(delx,dely,delz,r_sq) REDUCTION(+:sq_dispA,sq_dispB)
       do i_part = 1, ntot_mono-1
         delx = x(i_part) - x0_MSD(i_part)
         dely = y(i_part) - y0_MSD(i_part)
         delz = z(i_part) - z0_MSD(i_part)
         r_sq = delx*delx + dely*dely + delz*delz                              ! Steady-state MSD
         if(itypeAB(i_part) > 0) then
           sq_dispB(icount_MSD) = sq_dispB(icount_MSD) + r_sq
         else
           sq_dispA(icount_MSD) = sq_dispA(icount_MSD) + r_sq
         endif
       enddo
       !$OMP END DO
       !$OMP END PARALLEL
       !----------------------------------------------------------------------- end: MSD subroutine in CUDA 
     endif

     !----------------------------------------------------------------------- start: cal_FPT subroutine in CUDA 
     !$OMP PARALLEL DEFAULT(SHARED)
     !$OMP DO PRIVATE(igensep,igenrep,imono,jmono,delx,dely,delz) 
     do ii = 1, npair_FPT 
       if(ii/2048*2048 == ii) then 
         igensep = ii / 2048
         igenrep = 2048
       else
         igensep = ceiling(float(ii) / 2048)          
         igenrep = mod(ii,2048)
       endif
       imono = iFPT(igensep,igenrep)
       jmono = jFPT(igensep,igenrep)
       if(itagFPT(igensep,igenrep) < 1) then
         itimeFPT(igensep,igenrep) = itimeFPT(igensep,igenrep) + 1

         delx = x(imono) - x(jmono)
         dely = y(imono) - y(jmono)
         delz = z(imono) - z(jmono)
         if(delx*delx + dely*dely + delz*delz < r_FPT_sq) then
           itagFPT(igensep,igenrep) = 1
         endif
       endif
     enddo
     !$OMP END DO
     !$OMP END PARALLEL
     !----------------------------------------------------------------------- end: cal_FPT subroutine in CUDA 

   endif                                                                                                         ! end of itime <= ntime_ther cond 

   if(itime/ifreq_snap*ifreq_snap == itime) then                                                                           !
     !----------------------------------------------------------------------- start: velocity subroutine in CUDA           !
     !$OMP PARALLEL DEFAULT(SHARED)                                                                                        !
     !$OMP DO                                                                                                              !
     do ii = 1, ntot_mono                                                                                                  !
       velx(ii) = x1(ii) - x(ii)                                                                                           !
       vely(ii) = y1(ii) - y(ii)                                                                                           !
       velz(ii) = z1(ii) - z(ii)                                                                                           !
     enddo                                                                                                                 !
     !$OMP END DO                                                                                                          !
     !$OMP END PARALLEL                                                                                                    !
     !----------------------------------------------------------------------- end: velocity subroutine in CUDA             !
                                                                                                                           !
     do ii = 1, ntot_mono                                                                                                  !
       write(1000000000+itime,172) x(ii), y(ii), z(ii), det_fx(ii), det_fy(ii), det_fz(ii), velx(ii), vely(ii), velz(ii)   !       Snapshots
     enddo                                                                                                                 !
     close(1000000000+itime)                                                                                               !
                                                                                                                           !
     if(itime/ifreq_volstate*ifreq_volstate == itime) then                                                                 !
       do ii = 1, ndim_Rij_1D                                                                                              !
         if(ivol_state(ii) < 1) write(2000000000+itime,174) ii, ivol_state(ii), ivol_time(ii)                              ! 
       enddo                                                                                                               !
       close(2000000000+itime)                                                                                             !
     endif                                                                                                                 !
   else if(itime>istore_i .and. itime/ifreq_snap1*ifreq_snap1==itime) then                                                 !
     do ii = 1, ntot_mono                                                                                                  !
       write(1000000000+itime,172) x(ii), y(ii), z(ii)                                                                     !
     enddo                                                                                                                 !
     close(1000000000+itime)                                                                                               !
   endif                                                                                                                   !

   if(itime/ifreq_time_ser*ifreq_time_ser == itime) then
     write(128,173) itime, ene, Ree
   endif

   do ii = 1, ntot_mono                                                                                                    !
     if(nbx_updt_tag(ii)>0) then                                                                                           !
       n_old = nbox(nbx_updt_frm(ii),1) + 1                                                                                !
       nbox(nbx_updt_frm(ii), 1) = nbox(nbx_updt_frm(ii), 1) - 1                                                           !
       nbox(nbx_updt_to(ii) , 1) = nbox(nbx_updt_to(ii) , 1) + 1                                                           !
       nbox(nbx_updt_to(ii) , nbox(nbx_updt_to(ii),1)+1) = ii                                                              !
                                                                                                                           !
       i_spy = 0                                                                                                           ! nbox update
       do jj = 2, n_old                                                                                                    !
         if(i_spy == 1) nbox(nbx_updt_frm(ii), jj-1) = nbox(nbx_updt_frm(ii), jj)                                          !
         if(nbox(nbx_updt_frm(ii), jj) == ii) then                                                                         !
           i_spy = 1                                                                                                       !
         endif                                                                                                             !
       enddo                                                                                                               !
       nbox(nbx_updt_frm(ii), n_old) = 0                                                                                   !
     endif                                                                                                                 !
   enddo                                                                                                                   !
   x = x1 ; y = y1 ; z = z1

 enddo                                                                                                                              ! End of itime loop

 ierr_G = vsldeletestream( stream_G )
 ierr_U = vsldeletestream( stream_U )

 do ii = 1, icount_MSD
   if(ii/9*9 /=ii ) then
     jj = 10**(ii/9) * mod(ii,9)
   else
     jj = 10**(ii/9 - 1) * 9
   endif
   write(124,173) jj, sq_dispA(ii)/n_mono_A, sq_dispB(ii)/n_mono_B
 enddo
 close(124)

 do igensep = 1, ngenome_sep
   do igenrep = 1, 2048
     write(125,176) iFPT(igensep,igenrep), jFPT(igensep,igenrep), itimeFPT(igensep,igenrep), &
                  sqrt(RsqFPT_i(igensep,igenrep))
   enddo
   write(125,176)
 enddo
 close(125)

! Rij_bp_av = Rij_bp_av / nset_Rij_bp
! do ii = 1, n_mono-1
!   write(127,173) ii, Rij_bp_av(ii)
! enddo

call cpu_time(t2)
print*, t2-t1

  171 format(' ',3G25.17,I10)
  172 format(' ',10G25.17)
  173 format(' ',I10,6G25.17)
  174 format(' ',4I10)
  175 format(' ',2G25.17,I10)
  176 format(' ',3I10,2G25.17)

 
 end program main

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function force_vol_rep(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 force_vol_rep = fac_vol_rep*exp(-alp_vol_rep*r_sq)

 end function force_vol_rep

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function energy_vol_rep(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 energy_vol_rep = eps_vol_rep*exp(-alp_vol_rep*r_sq)

 end function energy_vol_rep

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function force_vol_attr(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 force_vol_attr = fac_vol_attr*exp(-alp_vol_attr*r_sq)  !- ak_fene_vol / (1 - r_sq/r_fene_sq_vol) !

 end function force_vol_attr

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function energy_vol_attr(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 energy_vol_attr = eps_vol_attr*exp(-alp_vol_attr*r_sq)   !eps_fene_vol * log(1 - r_sq/r_fene_sq_vol) !

 end function energy_vol_attr

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function force_attr(r)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 r_comp = peak_attr - r
 force_attr = fac_attr * exp(-alp_attr*r_comp*r_comp) * (1 + alp_attr*r*r_comp)

 end function force_attr

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function energy_attr(r)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 r_comp = peak_attr - r
 energy_attr = eps_attr*r*r*exp(-alp_attr*r_comp*r_comp)

 end function energy_attr

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function force_fene(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 force_fene = - ak_fene / (1 - r_sq/r_fene_sq)

 end function force_fene

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function energy_fene(r_sq)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 energy_fene = eps_fene * log(1 - r_sq/r_fene_sq)

 end function energy_fene

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function force_wall(r_sep_memb)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 if(r_sep_memb > rad_coro) then
   force_wall = fac_wall1 * xi_2 * exp(akappa_sq*(rad_coro_sq-r_sep_memb*r_sep_memb)) ! -ve is absorbed within substraction
 else
   force_wall = fac_wall1 * (rad_coro/r_sep_memb + fac_wall2 * r_sep_memb/rad_coro)
 endif

 end function force_wall

!----------------------------------------------------------------------------------------------------------------------------------

 real*8 function energy_wall(r_sep_memb)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)

 if(r_sep_memb > rad_coro) then
   energy_wall = fac_wall_ene*zeta_fac*erfc(akappa*r_sep_memb)
 else
   a = r_sep_memb/rad_coro
   a_sq = a*a
   energy_wall = fac_wall_ene*(-log(a)-(a_sq-1)*xi_mod+zeta)
 endif

 end function energy_wall

!----------------------------------------------------------------------------------------------------------------------------------

 subroutine initial_place(n_chrom, n_mono, ntot_mono, r_nucl, x, y, z, nbox, ndim_cell, ixpp2_cube)
 use cpu_mod

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)
 dimension x(ntot_mono), y(ntot_mono), z(ntot_mono), nbox(ixpp2_cube, ndim_cell)

 ixp = ceiling(r_nucl) ; ixpp = ixp+1 ; ixpp2 = 2*ixpp ; ixpp2_sq = ixpp2*ixpp2 ; ! ixpp2_cube = ixpp2_sq*ixpp2

 nbox = 0
 do i_chrom = 1, n_chrom
   i_part = (i_chrom-1)*n_mono + 1

   !r_confine = r_nucl-r_mono                        !
   !!call random_number(xxx)                          !
   !r = r_confine*grnd() !xxx                                !
   !!call random_number(xxx)                          !
   !theta = pi*grnd() !xxx                                   !
   !!call random_number(xxx)                          !
   !phi = pi*(2*grnd()-1) !(2*xxx-1)                               ! comment out for crumpled case
   !                                                 !
   !x(i_part) = r*sin(theta)*cos(phi)                !
   !y(i_part) = r*sin(theta)*sin(phi)                !
   !z(i_part) = r*cos(theta)                         !

   R_coord = sqrt( x(i_part)*x(i_part) + y(i_part)*y(i_part) + z(i_part)*z(i_part) )

   ix = ceiling(x(i_part)) ; iy = ceiling(y(i_part)) ; iz = ceiling(z(i_part))
   ix = ix + ixpp          ; iy = iy + ixpp          ; iz = iz + ixpp
   icell = (ix-1)*ixpp2_sq + (iy-1)*ixpp2 + iz
   nbox(icell,1) = nbox(icell,1) + 1
   nbox(icell, nbox(icell,1)+1) = i_part

   write(1000000000,172) x(i_part), y(i_part), z(i_part) , R_coord

   do i_mono = 2, n_mono
     j_part = (i_chrom-1)*n_mono + i_mono
     !do                                                         !
     !  !call random_number(xxx)                                  !
     !  r_stretch = stretch_init*grnd() !xxx                             !
     !  !call random_number(xxx)                                  !
     !  theta = pi*grnd() !xxx                                           !
     !  !call random_number(xxx)                                  !
     !  phi = pi*(2*grnd()-1) !(2*xxx-1)                                       ! comment out for crumpled case
     !  x(j_part) = x(j_part-1) + r_stretch*sin(theta)*cos(phi)  ! comment out for crumpled case
     !  y(j_part) = y(j_part-1) + r_stretch*sin(theta)*sin(phi)  !
     !  z(j_part) = z(j_part-1) + r_stretch*cos(theta)           !
        R_coord = sqrt( x(j_part)*x(j_part) + y(j_part)*y(j_part) + z(j_part)*z(j_part) )
     !  if(R_coord<r_confine) exit                               !
     !enddo                                                      !

     ix = ceiling(x(j_part)) ; iy = ceiling(y(j_part)) ; iz = ceiling(z(j_part))
     ix = ix + ixpp          ; iy = iy + ixpp          ; iz = iz + ixpp
     icell = (ix-1)*ixpp2_sq + (iy-1)*ixpp2 + iz
     nbox(icell,1) = nbox(icell,1) + 1
     nbox(icell, nbox(icell,1)+1) = j_part

     write(1000000000,172) x(j_part), y(j_part), z(j_part) , R_coord !, r_stretch
   enddo
 enddo
 close(1000000000)

  172 format(' ',6G25.17)
  174 format(' ',6I10)

 return
 end subroutine initial_place

!----------------------------------------------------------------------------------------------------------------------------------

 subroutine type_set_rnd_block_copoly(itypeAB,ntot_mono,n_chrom,n_mono,n_mono_A,n_mono_B,ratio_AB,iblk_size)

 implicit real*8(a-h,p-z)
 implicit integer*4(i-o)
 dimension itypeAB(ntot_mono)

 itypeAB = 0
 do ichrom = 1, n_chrom
   nn = 0
   do
     xx = grnd() !call random_number(xx)
     imono = ceiling(n_mono/iblk_size * xx)
     if(imono==0) imono = 1
     imono = imono*iblk_size - (iblk_size-1)
     ipart = (ichrom-1)*n_mono + imono
     if(itypeAB(ipart)==0) then
       xx = grnd() !call random_number(xx)
       if(xx<ratio_AB) then                                  
         do ii = 0, iblk_size-1
           itypeAB(ipart+ii) = 1
           nn = nn + 1
         enddo
       endif
     endif
     if(nn==n_mono_B) exit
   enddo
   print*, 'ichrom, nn, n_mono_B', ichrom, n_mono_A, n_mono_B
 enddo

 end subroutine type_set_rnd_block_copoly

!---------------------------------------------------------------------------------------------------------------------------------!

      subroutine sgrnd(seed)
      implicit integer(a-z)
      parameter(N     =  624)
      dimension mt(0:N-1)
      common /block/mti,mt
      save   /block/
      mt(0)= iand(seed,-1)
      do 1000 mti=1,N-1
        mt(mti) = iand(69069 * mt(mti-1),-1)
 1000 continue
      return
      end

!---------------------------------------------------------------------------------------------------------------------------------!

      double precision function grnd()
      implicit integer(a-z)
      real*8 tiny
      parameter (tiny=4.450147717014403D-308)
      parameter(N     =  624)
      parameter(N1    =  N+1)
      parameter(M     =  397)
      parameter(MATA  = -1727483681)
      parameter(UMASK = -2117483648)
      parameter(LMASK =  2147483647)
      parameter(TMASKB= -1658038656)
      parameter(TMASKC= -272236544)
      dimension mt(0:N-1)
      common /block/mti,mt
      save   /block/
      data   mti/N1/
      dimension mag01(0:1)
      data mag01/0, MATA/
      save mag01
      TSHFTU(y)=ishft(y,-11)
      TSHFTS(y)=ishft(y,7)
      TSHFTT(y)=ishft(y,15)
      TSHFTL(y)=ishft(y,-18)
      if(mti.ge.N) then
       if(mti.eq.N+1) then
         call sgrnd(4357)
       endif
        do 1000 kk=0,N-M-1
            y=ior(iand(mt(kk),UMASK),iand(mt(kk+1),LMASK))
            mt(kk)=ieor(ieor(mt(kk+M),ishft(y,-1)),mag01(iand(y,1)))
 1000   continue
        do 1100 kk=N-M,N-2
            y=ior(iand(mt(kk),UMASK),iand(mt(kk+1),LMASK))
            mt(kk)=ieor(ieor(mt(kk+(M-N)),ishft(y,-1)),mag01(iand(y,1)))
 1100   continue
        y=ior(iand(mt(N-1),UMASK),iand(mt(0),LMASK))
        mt(N-1)=ieor(ieor(mt(M-1),ishft(y,-1)),mag01(iand(y,1)))
        mti = 0
      endif
      y=mt(mti)
      mti=mti+1
      y=ieor(y,TSHFTU(y))
      y=ieor(y,iand(TSHFTS(y),TMASKB))
      y=ieor(y,iand(TSHFTT(y),TMASKC))
      y=ieor(y,TSHFTL(y))
      if(y.lt.0) then
        grnd=(dble(y)+2.0d0**32)/2.0d0**32+tiny
      else
        grnd=dble(y)/2.0d0**32+tiny
      endif
      return
      end

!---------------------------------------------------------------------------------------------------------------------------------!

