/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.io.BaseEncoding;
import io.minio.errors.InvalidArgumentException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public abstract class ServerSideEncryption
implements Destroyable {
    protected boolean destroyed = false;

    public abstract Type getType();

    public abstract void marshal(Map<String, String> var1);

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private static boolean isCustomerKeyValid(SecretKey key) {
        if (key == null) {
            return false;
        }
        return !key.isDestroyed() && key.getAlgorithm().equals("AES") && key.getEncoded().length == 32;
    }

    public static ServerSideEncryption withCustomerKey(SecretKey key) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!ServerSideEncryption.isCustomerKeyValid(key)) {
            throw new InvalidKeyException("The secret key is not a 256 bit AES key");
        }
        return new ServerSideEncryptionWithCustomerKey(key, MessageDigest.getInstance("MD5"));
    }

    public static ServerSideEncryption copyWithCustomerKey(SecretKey key) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!ServerSideEncryption.isCustomerKeyValid(key)) {
            throw new InvalidKeyException("The secret key is not a 256 bit AES key");
        }
        return new ServerSideEncryptionCopyWithCustomerKey(key, MessageDigest.getInstance("MD5"));
    }

    public static ServerSideEncryption atRest() {
        return new ServerSideEncryptionS3();
    }

    public static ServerSideEncryption withManagedKeys(String keyId, Map<String, String> context) throws InvalidArgumentException, UnsupportedEncodingException {
        if (keyId == null) {
            throw new InvalidArgumentException("The key-ID cannot be null");
        }
        if (context == null) {
            return new ServerSideEncryptionKms(keyId, Optional.empty());
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        builder.append('{');
        for (Map.Entry<String, String> entry : context.entrySet()) {
            builder.append('\"');
            builder.append(entry.getKey());
            builder.append('\"');
            builder.append(':');
            builder.append('\"');
            builder.append(entry.getValue());
            builder.append('\"');
            if (i >= context.entrySet().size() - 1) continue;
            builder.append(',');
        }
        builder.append('}');
        String contextString = BaseEncoding.base64().encode(builder.toString().getBytes("UTF-8"));
        return new ServerSideEncryptionKms(keyId, Optional.of(contextString));
    }

    static final class ServerSideEncryptionKms
    extends ServerSideEncryption {
        final String keyId;
        final Optional<String> context;

        public ServerSideEncryptionKms(String keyId, Optional<String> context) {
            this.keyId = keyId;
            this.context = context;
        }

        @Override
        public final Type getType() {
            return Type.SSE_KMS;
        }

        @Override
        public final void marshal(Map<String, String> headers) {
            if (this.isDestroyed()) {
                throw new IllegalStateException("object is already destroyed");
            }
            headers.put("X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id", this.keyId);
            headers.put("X-Amz-Server-Side-Encryption", "aws:kms");
            if (this.context.isPresent()) {
                headers.put("X-Amz-Server-Side-Encryption-Context", this.context.get());
            }
        }

        @Override
        public final void destroy() throws DestroyFailedException {
            this.destroyed = true;
        }
    }

    static final class ServerSideEncryptionS3
    extends ServerSideEncryption {
        ServerSideEncryptionS3() {
        }

        @Override
        public final Type getType() {
            return Type.SSE_S3;
        }

        @Override
        public final void marshal(Map<String, String> headers) {
            headers.put("X-Amz-Server-Side-Encryption", "AES256");
        }

        @Override
        public final void destroy() throws DestroyFailedException {
            this.destroyed = true;
        }
    }

    static final class ServerSideEncryptionCopyWithCustomerKey
    extends ServerSideEncryptionWithCustomerKey {
        public ServerSideEncryptionCopyWithCustomerKey(SecretKey key, MessageDigest md5) {
            super(key, md5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void marshal(Map<String, String> headers) {
            if (this.isDestroyed()) {
                throw new IllegalStateException("object is already destroyed");
            }
            try {
                byte[] key = this.secretKey.getEncoded();
                this.md5.update(key);
                String md5Sum = BaseEncoding.base64().encode(this.md5.digest());
                headers.put("X-Amz-Copy-Source-Server-Side-Encryption-Customer-Algorithm", "AES256");
                headers.put("X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key", BaseEncoding.base64().encode(key));
                headers.put("X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key-Md5", md5Sum);
            }
            finally {
                this.md5.reset();
            }
        }
    }

    static class ServerSideEncryptionWithCustomerKey
    extends ServerSideEncryption {
        protected final SecretKey secretKey;
        protected final MessageDigest md5;

        public ServerSideEncryptionWithCustomerKey(SecretKey key, MessageDigest md5) {
            this.secretKey = key;
            this.md5 = md5;
        }

        @Override
        public final Type getType() {
            return Type.SSE_C;
        }

        @Override
        public void marshal(Map<String, String> headers) {
            if (this.isDestroyed()) {
                throw new IllegalStateException("object is already destroyed");
            }
            try {
                byte[] key = this.secretKey.getEncoded();
                this.md5.update(key);
                headers.put("X-Amz-Server-Side-Encryption-Customer-Algorithm", "AES256");
                headers.put("X-Amz-Server-Side-Encryption-Customer-Key", BaseEncoding.base64().encode(key));
                headers.put("X-Amz-Server-Side-Encryption-Customer-Key-Md5", BaseEncoding.base64().encode(this.md5.digest()));
            }
            finally {
                this.md5.reset();
            }
        }

        @Override
        public final void destroy() throws DestroyFailedException {
            this.secretKey.destroy();
            this.destroyed = true;
        }
    }

    public static enum Type {
        SSE_C,
        SSE_S3,
        SSE_KMS;


        public boolean requiresTls() {
            return this.equals((Object)SSE_C);
        }

        public boolean requiresV4() {
            return this.equals((Object)SSE_KMS);
        }
    }
}

