/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.AccessBuilder;

public class DatasetBuilder {
    protected DatasetBuilder parent;
    protected String name;
    protected Map<String, Object> flds = new HashMap<String, Object>(10);
    protected List<AccessBuilder> accessBuilders;
    protected List<DatasetBuilder> datasetBuilders;

    public static void addToList(Map<String, Object> flds, String fldName, Object fldValue) {
        ArrayList<Object> prevList;
        if (fldValue == null) {
            return;
        }
        Object prevVal = flds.get(fldName);
        if (prevVal == null) {
            flds.put(fldName, fldValue);
            return;
        }
        if (prevVal instanceof List) {
            prevList = (ArrayList<Object>)prevVal;
        } else {
            prevList = new ArrayList<Object>(5);
            prevList.add(prevVal);
            flds.put(fldName, prevList);
        }
        if (fldValue instanceof List) {
            prevList.addAll((List)fldValue);
        } else {
            prevList.add(fldValue);
        }
    }

    public DatasetBuilder(DatasetBuilder parent) {
        this.parent = parent;
    }

    public Object get(String fldName) {
        return this.flds.get(fldName);
    }

    public void put(String fldName, Object fldValue) {
        if (fldValue != null) {
            this.flds.put(fldName, fldValue);
        }
    }

    public void putInheritedField(String fldName, Object fldValue) {
        if (fldValue == null) {
            return;
        }
        ThreddsMetadata tmi = (ThreddsMetadata)this.get("ThreddsMetadataInheritable");
        if (tmi == null) {
            tmi = new ThreddsMetadata();
            this.put("ThreddsMetadataInheritable", tmi);
        }
        tmi.getFlds().put(fldName, fldValue);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addDataset(DatasetBuilder d) {
        if (d == null) {
            return;
        }
        if (this.datasetBuilders == null) {
            this.datasetBuilders = new ArrayList<DatasetBuilder>();
        }
        this.datasetBuilders.add(d);
    }

    public void addAccess(AccessBuilder d) {
        if (this.accessBuilders == null) {
            this.accessBuilders = new ArrayList<AccessBuilder>();
        }
        this.accessBuilders.add(d);
    }

    public Dataset makeDataset(DatasetNode parent) {
        return new Dataset(parent, this.name, this.flds, this.accessBuilders, this.datasetBuilders);
    }

    public void transferMetadata(Dataset from, boolean inherit) {
        if (inherit) {
            this.inheritMetadata(this.flds, from);
        }
        Map<String, Object> fromFlds = from.getFlds();
        for (Map.Entry<String, Object> entry : fromFlds.entrySet()) {
            this.flds.put(entry.getKey(), entry.getValue());
        }
    }

    private void inheritMetadata(Map<String, Object> flds, Dataset from) {
        Dataset fromParent = from.getParentDataset();
        if (fromParent == null) {
            return;
        }
        this.inheritMetadata(flds, fromParent);
        Map<String, Object> fromFlds = fromParent.getFlds();
        for (Map.Entry<String, Object> entry : fromFlds.entrySet()) {
            flds.put(entry.getKey(), entry.getValue());
        }
    }
}

