%calculate R2eff from intensities, plot CPMG profiles
%modified from script from Paul Sapienza
clear
%read in intensity table from NMRViewJ RateAnalysis
m = tdfread('Apo_25mMPO4_MQ_CPMG_850_ints');
%ncyc from vclist
counter = [80 2 70 4 64 6 60 8 54 10 50 12 44 14 40 16 34 18 30 20 28 22 26 24 4 44]; 
%duration of relaxation period (40 ms) included here
tcpmg = 40e-3./(counter(1:length(counter)));
vcpmg = tcpmg.^(-1);
taucpmg = tcpmg./2;
m.T1 = abs(m.T1);%0
m.T2 = abs(m.T2);
m.T3 = abs(m.T3);
m.T4 = abs(m.T4);
m.T5 = abs(m.T5);
m.T6 = abs(m.T6);
m.T7 = abs(m.T7);
m.T8 = abs(m.T8);
m.T9 = abs(m.T9);
m.T10 = abs(m.T10);
m.T11 = abs(m.T11);
m.T12 = abs(m.T12);
m.T13 = abs(m.T13);
m.T14 = abs(m.T14);
m.T15 = abs(m.T15);
m.T16 = abs(m.T16);
m.T17 = abs(m.T17);
m.T18 = abs(m.T18);
m.T19 = abs(m.T19);
m.T20 = abs(m.T20);
m.T21 = abs(m.T21);
m.T22 = abs(m.T22);
m.T23 = abs(m.T23);
m.T24 = abs(m.T24);
m.T25 = abs(m.T25);
m.T26 = abs(m.T26);
m.T27 = abs(m.T27);
Ints = [m.T1 m.T2 m.T3 m.T4 m.T5 m.T6 m.T7 m.T8 m.T9 m.T10 m.T11 m.T12 m.T13 m.T14 m.T15 m.T16 m.T17 m.T18 m.T19 m.T20 m.T21 m.T22 m.T23 m.T24 m.T25 m.T26 m.T27];
%Duration of relaxation period
TimeT2=0.04;
R2eff=zeros(size(Ints,1),size(Ints,2)-1);
for i=2:size(Ints,2)
    %if i == 11 || i == 13 || i == 15
    %    R2eff(:,i-1) = (-1/0.045).*log(Ints(:,i)./m2.T1); 
    %else
        R2eff(:,i-1) = (-1/TimeT2).*log(Ints(:,i)./Ints(:,1)); 
    %end
end
rms=0.145; %base plane noise
rmsd_dup = sqrt(mean([(Ints(:,5)-Ints(:,26)).^(2);(Ints(:,14)-Ints(:,27)).^(2)]));
eR2eff = zeros(size(R2eff,1),size(R2eff,2));
%duplicate point RMSD used to calculate error
for i = 1:size(R2eff,2)
    %if i == 11 || i == 13 || i == 15
    %    eR2eff(:,i)=((1./(0.045.*Ints(:,i+1))).^2*rms^2 + (1./(0.045.*m2.T1)).^2*rms^2).^0.5;
    %else
        eR2eff(:,i)=((1./(TimeT2.*Ints(:,i+1))).^2*rmsd_dup^2 + (1./(TimeT2.*Ints(:,1))).^2*rmsd_dup^2).^0.5;
    %end
end

%remove extra point (for duplicates), use average of the two points
R2eff(:,4) = (R2eff(:,4)+R2eff(:,25))./2;
R2eff(:,13) = (R2eff(:,13)+R2eff(:,26))./2;
R2eff(:,25:26) = [];

eR2eff(:,4) = sqrt((((1/2)^(2))*(eR2eff(:,4).^(2)))+(((1/2)^(2))*(eR2eff(:,25).^(2))));
eR2eff(:,13) = sqrt((((1/2)^(2))*(eR2eff(:,13).^(2)))+(((1/2)^(2))*(eR2eff(:,26).^(2))));
eR2eff(:,25:26) = [];

taucpmg(25:26) = [];
vcpmg(25:26) = [];

%plot profiles
for i = 75:85
    if ~ismember(m.Peak(i),[12 72 19 23 32 33 86 87 35 58 34 82 83 84 40 42 45]) %&& ~isnan(m.Residue(i))
        figure
        errorbar(vcpmg, R2eff(i,:), eR2eff(i,:), '.k','MarkerSize',25)
        title(strcat(num2str(m.Residue(i)),'...',num2str(m.Peak(i))))
        if m.Residue(i) ~= 285
            ylim([min(R2eff(i,:))-2 min(R2eff(i,:))+5])
        end
    end
end
