%plot CEST profiles
clear
%read in intensity table from NMRViewJ RateAnalysis
m = tdfread('hTS_apo_13C_CHD2_CEST_25_ints');
Ints = [m.T1 m.T2 m.T3 m.T4 m.T5 m.T6 m.T7 m.T8 m.T9 m.T10 m.T11 m.T12 m.T13 m.T14 m.T15 m.T16 m.T17 m.T18 m.T19 m.T20 m.T21 m.T22 m.T23 m.T24 m.T25 m.T26 m.T27 m.T28 m.T29 m.T30 m.T31 m.T32 m.T33 m.T34 m.T35 m.T36 m.T37 m.T38 m.T39 m.T40 m.T41 m.T42 m.T43 m.T44 m.T45 m.T46 m.T47 m.T48 m.T49 m.T50 m.T51 m.T52 m.T53 m.T54 m.T55 m.T56 m.T57 m.T58 m.T59 m.T60 m.T61 m.T62 m.T63 m.T64 m.T65 m.T66 m.T67 m.T68 m.T69 m.T70 m.T71 m.T72 m.T73 m.T74 m.T75 m.T76 m.T77 m.T78 m.T79 m.T80 m.T81 m.T82 m.T83 m.T84 m.T85 m.T86 m.T87 m.T88 m.T89 m.T90 m.T91 m.T92 m.T93 m.T94 m.T95 m.T96 m.T97 m.T98 m.T99 m.T100 m.T101 m.T102 m.T103 m.T104 m.T105 m.T106 m.T107 m.T108 m.T109 m.T110 m.T111 m.T112 m.T113 m.T114];
%Ints = abs(Ints);

relInts = Ints;
rms = 0.115;
Err = rms*ones(size(Ints,1),size(Ints,2));
relErr = Err;

for i = 1:size(Ints,1)
    relInts(i,:) = relInts(i,:)./Ints(i,1);
    relErr(i,:) = relErr(i,:)./Ints(i,1);
end

%read in spin lock frequency list (saved along with raw data from topspin)
f = tdfread('fq1list25');
freqs = f.freq;

%get chemical shifts from peaklist
xpk = importdata('hTS_apo_CHD2_CEST_finalassign.xpk', ' ', 6);
cppm=str2double(xpk.textdata(7:end,10));
hppm=str2double(xpk.textdata(7:end,3));

carrier = 19.565;
peak_offset = (cppm - carrier)*150.902; %Hz
SL_peak_offset = zeros(size(relInts,1),size(relInts,2));

%calculate freq difference between spin lock and signal
for i = 1:size(relInts,1)
   SL_peak_offset(i,:) = freqs'-peak_offset(i); 
end

%define peaks which are overlapped and should not be analyzed
overlappeak = [7 8 90 31 74 73 37 41 50 51 102 104 53 76 98 52 54 99 100 60 58 63 107];

%plot the profiles
for i = 1:20
    if ~ismember(m.Peak(i),overlappeak)
        figure
        errorbar(SL_peak_offset(i,2:length(freqs)),relInts(i,2:size(relInts,2)),relErr(i,2:size(relErr,2)),'.k','MarkerSize',22)
        xlabel('Offset (Hz)')
        ylabel('rel. Int.')
        title(strcat(num2str(m.Residue(i)),{' '},num2str(m.Peak(i))))
    end
end