%%% With adjustment for first small injection
%%% For use with itc_general_global_func
%%% Global [cell] correction factor
%%% With Monte Carlo Simulations
%%% Synthetic data set noise based on fit residuals

clear
clearvars -global
options = optimset('lsqnonlin');
%options = optimset(options,'Algorithm','trust-region-reflective');
options = optimset(options,'Algorithm','levenberg-marquardt');
options = optimset(options,'TolFun',1E-11); %1E-11
options = optimset(options,'TolX',1E-11);
%options = optimset(options,'Display','iter');
options = optimset(options,'MaxFunEvals', 2000);
options = optimset(options,'PlotFcns', @optimplotresnorm);

%data collected on 9-10-18
global expts Mt Lt V v q omit1 M0 k Q L0
L0=[1870e-6 5470e-6 8020e-6 400e-6];
%L0=[1870e-6 5470e-6 8020e-6];
L0 = L0*0.9545; %correction to extinction coeff from PULCON
%L0=[1180e-6];
M0=[77e-6 217e-6 312e-6 299e-6];
%M0=[77e-6 217e-6 312e-6];
%M0 = M0*0.787;
%M0=[56e-6];
V=205.2e-6;
expts = input ('How many experiments to globally fit? : \n');
k = [39 39 39 6];
%k = [39 39 39];
omit1 = input ('Would you like to omit first injection? : \n', 's');
MC = input('Would you like to run Monte Carlo Sims? : \n', 's');
tit = 'hTS TMP 20mM NaCl ITC 25^{o}C';
v = ones(k(1),4);
%v = ones(k(1),3);
v(:,1:3)=1e-6.*v(:,1:3);
v(:,4)=2e-6.*v(:,4);
% Size of small injection
v(1,1:4)=2e-7;
%v(1,1:3)=2e-7;

%%% Input data
q1=[-2.66372974679;
-14.0378735489;
-15.8991497461;
-15.8736193962;
-15.4453566369;
-14.7475482624;
-13.787449436;
-13.0384195527;
-12.2795840321;
-11.2740085201;
-10.1993834334;
-9.09041391954;
-7.82103434529;
-6.79230262251;
-5.85614089989;
-5.07481670223;
-4.44040342693;
-3.75416957748;
-3.28624017899;
-2.77722370139;
-2.4095851962;
-2.21007567354;
-1.94248879496;
-1.72724298302;
-1.58039580231;
-1.43954535621;
-1.25571390928;
-1.13903498112;
-1.00099293983;
-0.94524143578;
-0.890633571305;
-0.82518552685;
-0.750717026385;
-0.667910044818;
-0.619382303481;
-0.660414810313;
-0.616454870651;
-0.594703918372;
-0.437193682312;
    ];
%q1 = q1 + 0.59; %avg last 5
q1 = q1 + 0.5;
q2=[-8.5401239276;
-50.1701284218;
-50.7953823378;
-50.9332824311;
-49.1573840504;
-48.605707225;
-46.1222667698;
-43.4566241294;
-40.3031772534;
-35.833621777;
-30.6371549205;
-25.0797340695;
-19.5831233768;
-15.3532578012;
-11.8530432583;
-9.30940392179;
-7.48238624922;
-6.11832020519;
-5.01910654468;
-4.1383608856;
-3.42527853786;
-2.98773121291;
-2.44910510582;
-2.39533108697;
-2.04585188724;
-1.79974806381;
-1.44930177262;
-1.43537531988;
-1.2690442172;
-1.31218081746;
-1.23205357453;
-1.12204641265;
-1.00663069143;
-0.895649784588;
-0.831515688881;
-0.75830001075;
-0.743507160833;
-0.737175729185;
-0.712038035344;
    ];
%q2 = q2 + 0.74; %avg last 4
q2 = q2 + 0.7;
q3=[-13.2037478859;
-73.3930508051;
-74.1060689833;
-74.380983119;
-73.8800991921;
-72.1759788377;
-69.9923142189;
-66.9291169449;
-63.9442357125;
-58.1741005654;
-50.3764209375;
-41.3414695618;
-31.7166654501;
-24.0332412587;
-17.9621209697;
-13.4973637478;
-10.4502677324;
-8.1466162826;
-6.50277273028;
-5.24162292113;
-4.40746464783;
-3.52349649375;
-3.19089346284;
-2.68921159524;
-2.40161923362;
-2.18658396047;
-1.9392170762;
-0.765940597134;
-1.50152430983;
-1.38109874859;
-1.17256898561;
-1.06772420042;
-1.10739962812;
-0.936895144618;
-0.935351629782;
-0.862139935842;
-0.784700681345;
-0.80294096117;
-0.741996186834;
    ];
%q3 = q3 + 0.78; %avg last 3
q3 = q3 + 0.7;
q4=[-1.89183730991;
-7.05470545403;
-6.94330978145;
-7.2659657973;
-6.81147911367;
-6.79671905848;
    ];
q4 = q4 + 0.2; 
q4 = [q4;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0];
q=[q1 q2 q3 q4];
%q=[q1 q2 q3];
%q=q2;
q=q.*10^-6;
%q=q-Hdil;
%%% Duplicate so MC simulations always based on original data.
Q=q;

%%% Based on ITC manual
for i=1:expts;
    for j=1:k(i)
        %Mt(j,i)=M0(i)*((1-sum(v(1:j)/(2*V)))/(1+sum(v(1:j)/(2*V))));
        Lt(j,i)=((sum(v(1:j,i)*L0(i)))/V)*(1-(sum(v(1:j,i)/(2*V))));
    end    
end

%%% Starting guesses and fitting
%x0=[2.2267e5 8.6661e9 -9991.3 -9934.7 0.6910];
x0=[2e5 9e9 -10000 -10000 0.7];
lb=[1e4 1e6 -20000 -20000 0.1];
ub=[1e8 5e12 0 0 1];

ms = MultiStart;
problem = createOptimProblem('lsqnonlin','objective',@itc_general_global_func_multiv_TMP91018,...
'x0',x0,'lb',lb,'ub',ub);
[xmin,fmin,flag,outpt,allmins] = run(ms,problem,100);

x0=xmin

[x, resnorm, residual, exitflag, output, lambda, jacobian] =...
    lsqnonlin(@itc_general_global_func_multiv_TMP91018, x0, [], [], options);
%redchisq=resnorm/(sum(k(1:4))-length(x)-length(k(1:4))-2);
redchisq=resnorm/(sum(k(1:3))-length(x)-length(k(1:3))-2);
xbest=x;

%x=x0;
for i=1:expts;
    for j=1:k(i)
            Mt(j,i)=x(5)*M0(i)*((1-sum(v(1:j,i)/(2*V)))/(1+sum(v(1:j,i)/(2*V)))); 
    end   
end

%%% Generate fit data for residual calc
for i=1:expts;
    for j=1:k(i)
        p=[x(2) (2*Mt(j,i)*x(2)+x(1)-Lt(j,i)*x(2)) (1+Mt(j,i)*x(1)-Lt(j,i)*x(1)) -Lt(j,i)];
        r=roots(p);
        r=r(r>0);
        if length(r) > 1;
            r=r(imag(r)==0);
        end
        if length(r) > 1;
            r=r(r < 0.001);
        end
        Lf(j,i)=r;
        ML0(j,i)=1/(1+x(1)*Lf(j,i)+x(2)*Lf(j,i)^2);
        cML0(j,i)=ML0(j,i)*Mt(j,i);
        ML1(j,i)=(x(1)*Lf(j,i))/(1+x(1)*Lf(j,i)+x(2)*Lf(j,i)^2);
        cML1(j,i)=ML1(j,i)*Mt(j,i);
        ML2(j,i)=(x(2)*Lf(j,i)^2)/(1+x(1)*Lf(j,i)+x(2)*Lf(j,i)^2);
        cML2(j,i)=ML2(j,i)*Mt(j,i);
    end
end

temp=zeros(1,expts);
cML1=vertcat(temp, cML1);
cML2=vertcat(temp, cML2);

for i=1:expts
    j=1;
    for h = 2:k(i)+1
        qfit(j,i)=V*(x(3)*(cML1(h,i)-(cML1(j,i)*(1-(v(j,i)/V))))+((x(3)+x(4))*(cML2(h,i)-(cML2(j,i)*(1-(v(j,i)/V))))));
        %%% Residual
        delta(j,i)=abs(qfit(j,i)-q(j,i));
        j=j+1;
    end
end
        
%%% Monte Carlo Simulations
for i=1:expts
    if i == 1
        a = delta(:,i);
        a(2:3) = [];
        delta(:,i)=mean(a(2:length(a)))*(ones(1,length(delta)));
    else
        delta(:,i)=mean(delta(2:k(i),i))*(ones(1,length(delta)));
    end
end

if MC=='y'
    mcnum=150;
    mc=1:mcnum;
    for m=mc
        for i=1:expts
            q(:,i)=normrnd(Q(:,i),delta(:,i));
        end
        [x, resnorm, residual, exitflag, output, lambda, jacobian] =...
     lsqnonlin(@itc_general_global_func_multiv_TMP91018, x0, [], [], options);
        monte.B1(m)=x(1);
        monte.B2(m)=x(2);
        monte.DH1(m)=x(3);
        monte.DH2(m)=x(4);
        monte.rho(m)=(4*x(2))/x(1)^2;
        monte.scale1(m)=x(5);
        %monte.scale2(m)=x(6);
    end
    %x(1)=mean(monte.B1);
    %x(2)=mean(monte.B2);
    %x(3)=mean(monte.DH1);
    %x(4)=mean(monte.DH2);
    %x(5)=mean(monte.scale1);
    %x(6)=mean(monte.scale2);
end

C=['k', 'b', 'r', 'g'];
for i=1:expts;
    ratio(:,i)=(Lt(:,i)./Mt(:,i));
end

figure;
for i=1:expts
    if omit1=='y'
        if i == 1
            a = ratio(2:k(i),i);
            a(1:2) = [];
            b = Q(2:k(i),i)/(L0(i)*v(2,i));
            b(1:2) = [];
            scatter(a, b, C(i), 'o')
            hold on
            box on
            h(i)=plot(ratio(2:k(i),i), qfit(2:k(i),i)/(L0(i)*v(2,i)), C(i));
            plot(ratio(2:k(i),i), qfit(2:k(i),i)/(L0(i)*v(2,i)), C(i))
        else
            scatter(ratio(2:k(i),i), Q(2:k(i),i)/(L0(i)*v(2,i)), C(i), 'o')
            hold on
            box on
            h(i)=plot(ratio(2:k(i),i), qfit(2:k(i),i)/(L0(i)*v(2,i)), C(i));
            plot(ratio(2:k(i),i), qfit(2:k(i),i)/(L0(i)*v(2,i)), C(i))
        end
    else
        scatter(ratio(:,i), Q(:,i), C(i), 'o')
        hold on
        plot(ratio(:,i), qfit(:,i), C(i))
    xlabel('ratio')
    ylabel('q (microcal)')
    end
end
xlabel('mole ratio')
ylabel('cal/mol ligand')
title(tit);
xlim([0 5.1])
ylim([-10000 1000])
%%% Mean and SD from MC sims

%str=['K_{1} = ', num2str(x(1))];
str=['K_{1} = ', num2str(round(mean(monte.B1),-2)), ' +/- ', num2str(round(std(monte.B1),-3)),' M^{-1}'];
%str2=['K_{2} = ', num2str(x(2)/x(1))];
str2=['K_{2} = ', num2str(round(mean(monte.B2)/mean(monte.B1),-2)), ' +/- ',...
    num2str(round((mean(monte.B2)/mean(monte.B1))*((std(monte.B1)/mean(monte.B1))^2+(std(monte.B2)/mean(monte.B2))^2)^0.5,-3)),' M^{-1}'];
%str3=['\DeltaH1 = ', num2str(x(3))];
str3=['\DeltaH_{1} = ', num2str(round(mean(monte.DH1),-2)), ' +/- ', num2str(round(std(monte.DH1),-1)),' cal/mol'];
%str4=['\DeltaH2 = ', num2str(x(4))];
str4=['\DeltaH_{2} = ', num2str(round(mean(monte.DH2),-2)), ' +/- ', num2str(round(std(monte.DH2),-1)),' cal/mol'];
%str5=['\rho = ', num2str((4*x(2))/(x(1)^(2)))];
str5=['\rho = ', num2str(round((4*mean(monte.B2))/(mean(monte.B1)^(2)),2)), '+/-', num2str(round(std(monte.rho),2))];
%str6=['Cell scaling 1 = ', num2str(x(5))];
%str8=['Cell scaling 2 = ', num2str(x(6))];
str6=['Cell scaling = ', num2str(round(mean(monte.scale1),3)), ' +/- ', num2str(round(std(monte.scale1),3))];
%str8=['Lig scaling = ', num2str(round(mean(monte.scale2),3)), ' +/- ', num2str(round(std(monte.scale2),3))];
str7=['Reduced \chi^{2} = ', num2str(round(redchisq,1))];

annotation('textbox', [0.55,0.45,0.1,0.1],...
           'String', {str;str2;str3;str4;str5;str6;str7})
%M0scale = [round(M0(1)*10^(6)*mean(monte.scale1),0) round(M0(2:3)*10^(6)*mean(monte.scale2),0)];
M0scale = round(M0*10^(6)*mean(monte.scale1),0);
um = ' \muM';
legend([h(1) h(2) h(3)],{strcat(num2str(M0scale(1)),um),strcat(num2str(M0scale(2)),um),strcat(num2str(M0scale(3)),um)})