function F = fitfunction_3stateSQMQ_linear2_CEST_kfit_Ile(x)

global field
global protonfield
global taucp
global data
global delta
global n180array
global ptsmax
global kab
global dwab
global kba
global isMQ
global numres
global freq
global sllist
global sllist_allres
global datainput
global numpts
global chemshift
global fityn
global dataout
global SLdura
global chemcenter
global relErr
global idxlist
global is2state

flds = length(field);
for i =1:flds
    tpts(i) = length(taucp{i});
end

%set params
kac = x(1);
kca = x(2);
kexac = kac+kca;
%calc pops from rates
if is2state == 0
    kexab = kab+kba;
    z = (kba/kexab)/(1-(kba/kexab));
    y = (kca/kexac)/(1-(kca/kexac));
    pb = 1/(1+z+(z/y));
    pa = z*pb;
    pc = (z/y)*pb;
else
    kexab = 0;
    pa = kca/kexac;
    pc = kac/kexac;
    pb = 0;
end
M0 = [pa pb pc]';


for i = 1:flds
    r2eff{i} = data{1,i}(:,1);
    err{i} = data{1,i}(:,2);
    
    % CPMG calculation
    if isMQ(i) == 0 %SQ
        A(i).flds = ...
            [(-1*x(5+i)-kab-kac) kba kca; ...
            kab (-1*x(5+i)-kba+1i*(dwab*field(i)*2*pi)) 0; ...
            kac 0 (-1*x(5+i)-kca+1i*(x(3)*field(i)*2*pi))];
        A(i).conj = conj(A(i).flds);

        for u = 1:tpts(i)
            B(u).me = expm(delta{i}(u)*A(i).flds);
            B(u).cme = expm(delta{i}(u)*A(i).conj);
            B(u).M4nd = real(((B(u).me*B(u).cme*B(u).cme*B(u).me)^(n180array{i}(u)))*M0);
            ratio(u) = (B(u).M4nd(1))/M0(1);
            r2calc{i}(u) = log(ratio(u))*((-1)/(4*n180array{i}(u)*delta{i}(u)));
        end
    elseif isMQ(i) == 1
           m1 = ...
               [(-1*x(5+i)-kab-kac) kba kca; ...
                kab (-1*x(5+i)-kba-1i*((x(4)*protonfield(i)+dwab*field(i))*2*pi)) 0; ...
                kac 0 (-1*x(5+i)-kca-1i*((x(5)*protonfield(i)+x(3)*field(i))*2*pi))];
           m2 = ...
               [(-1*x(5+i)-kab-kac) kba kca; ...
                kab (-1*x(5+i)-kba-1i*((x(4)*protonfield(i)-dwab*field(i))*2*pi)) 0; ...
                kac 0 (-1*x(5+i)-kca-1i*((x(5)*protonfield(i)-x(3)*field(i))*2*pi))];
           m1conj = conj(m1);
           m2conj = conj(m2);
           
           for u = 1:tpts(i)
              M1 = expm(delta{i}(u)*m1);
              M2 = expm(delta{i}(u)*m2);
              M1conj = expm(delta{i}(u)*m1conj);
              M2conj = expm(delta{i}(u)*m2conj);
              W=(M1*M2*M2*M1)^(n180array{i}(u)/2);
              S=(M2conj*M1conj*M1conj*M2conj)^(n180array{i}(u)/2);
              Y=(M2*M1*M1*M2)^(n180array{i}(u)/2);
              Z=(M1conj*M2conj*M2conj*M1conj)^(n180array{i}(u)/2);
              r2calc{i}(u) = ((-1)/(4*n180array{i}(u)*delta{i}(u)))*log(real((0.5/(M0(1)))*[1 0 0]*(W*S+Y*Z)*M0));
           end
    end
    %CPMG resids
    resid_col{i} = real((r2calc{i}(:)-r2eff{i}(:)))./err{i};%./err(:,i));
end

%CEST calculation
    w1 = sllist_allres{1}*2*pi; %spin lock pow
    dataout{1} = zeros(numpts(1), 1);
    for icount = 1:numpts(1)
        %set param
        specfrq = 150.902406439; %600 MHz
        R1 = x(7);
        R2a = x(8);
        R2b = R2a;
        R2c = R2a;

        dwac = x(3);
        kac = x(1);
        kca = x(2);
        kexac = kac+kca;
        if is2state == 0
            kexab = kab+kba;
            z = (kba/kexab)/(1-(kba/kexab));
            y = (kca/kexac)/(1-(kca/kexac));
            pb = 1/(1+z+(z/y));
            pa = z*pb;
            pc = (z/y)*pb;
        else
            kexab = 0;
            pa = kca/kexac;
            pc = kac/kexac;
            pb = 0;
        end

        out = 0;

        wrf = freq{1}(icount);
        %set chem shifts of all states
        %observed resonance set to be pop weighted avg of shift of A and C
        %(states connected by faster process)
        %da = ((chemcenter - chemshift(1))*specfrq+wrf)*2*pi;
        da = ((chemshift(1)*(pa+pc))-(pc*dwac))/(pa+pc);
        da = ((chemcenter - da)*specfrq+wrf)*2*pi;
        db = da-dwab*specfrq*2*pi;
        dc = da-dwac*specfrq*2*pi;

        %init density matrix
        Ao1  = [0.5 0 0 pa 0 0 pb 0 0 pc]'; %E/2 IxA IyA IzA IxB IyB IzB IxC IyC IzC
        Ao2  = [0.5 0 0 -pa 0 0 -pb 0 0 -pc]'; %E/2 IxA IyA IzA IxB IyB IzB IxC IyC IzC
        %evolution matrix
        P =[0         0            0            0            0            0            0 0 0 0       ; ...
            0         R2a+kab+kac  da          -w1(icount)          -kba          0            0 -kca 0 0          ; ...
            0        -da           R2a+kab+kac  0            0           -kba          0 0 -kca 0            ; ...
            -2*R1*pa  w1(icount)           0            R1+kab+kac  0            0           -kba 0 0 -kca      ; ...
            0        -kab          0            0            R2b+kba  db          -w1(icount) 0 0 0          ; ...
            0         0           -kab          0           -db           R2b+kba  0 0 0 0         ; ...
            -2*R1*pb  0            0           -kab         w1(icount)           0            R1+kba 0 0 0 ; ...
            0 -kac 0 0 0 0 0 R2c+kca dc -w1(icount) ; ...
            0 0 -kac 0 0 0 0 -dc R2c+kca 0 ; ...
            -2*R1*pc 0 0 -kac 0 0 0 w1(icount) 0 R1+kca] ;

        eP=expm(-P*SLdura); %SLdura relaxation time
        A1=eP*Ao1;
        Mza1=A1(4); %mag at end (+z)
        A2=eP*Ao2;
        Mza2=A2(4); %mag at end (-z)
        DMz=(Mza1-Mza2)/(2*pa); %normalized int (avg +z,-z)
        out = DMz + out;

        dataout{1}(icount, 1) = out;
    end

    dataout_col = [];
    datainput_col = [];
    %class(datainput)
    
    %CEST data relative to error
    for i = 1:numres
       dataout_col = [dataout_col;dataout{i}./(1.5*relErr(idxlist(i),1))]; %scale up base plane noise
       datainput_col = [datainput_col;datainput{i}./(1.5*relErr(idxlist(i),1))];
    end
    
    %CEST resids
    if fityn == 1
        CESTresid = (dataout_col - datainput_col);
    end

    %CPMG & CEST resids
    if fityn == 1
        if flds == 1
            F = [resid_col{1}; CESTresid];
        elseif flds == 2
            F = [resid_col{1}; resid_col{2}];
        elseif flds == 3
            F = [resid_col{1}; resid_col{2}; resid_col{3}; CESTresid];
        %elseif flds == 4
        %    F = [f(:,1); f(:,2); f(:,3); f(:,4)];
        %else
        %    F = [f(:,1); f(:,2); f(:,3); f(:,4); f(:,5)];
        end
    else
        F = r2calc; %return calc CPMG data
    end
end