function F = fitfunction_cpmgCEST_3stateSQMQ_full_linear_global(x)

global field
global protonfield
global taucp
global data
global delta
global n180array
global ptsmax
global isMQ
global numres
global freq
global sllist
global sllist_allres
global datainput
global numpts
global chemshift
global fityn
global dataout
global SLdura
global chemcenter
global relErr
global idxlist

flds = length(field);
for i =1:flds
    tpts(i) = length(taucp{i});
end

%set param
pa = x(1);
pb = x(2)-x(1);
pc = 1-(pa+pb);
M0 = [pa pb pc]';

for j = 1:numres
    %CPMG calculation (3-state, BAC)
    for i = 1:flds
        r2eff{j,i} = data{j,i}(:,1);
        err{j,i} = data{j,i}(:,2);

        kab = pb*x(3)/(pa+pb);
        kba = pa*x(3)/(pa+pb);
        kac = pc*x(4)/(pa+pc);
        kca = pa*x(4)/(pa+pc);

        if isMQ(i) == 0 %SQ
            A(i).flds = ...
                [(-1*x(9*(j-1)+8+i)-kab-kac) kba kca; ...
                kab (-1*x(9*(j-1)+8+i)-kba+1i*(x(9*(j-1)+5)*field(i)*2*pi)) 0; ...
                kac 0 (-1*x(9*(j-1)+8+i)-kca+1i*(x(9*(j-1)+6)*field(i)*2*pi))];
            A(i).conj = conj(A(i).flds);

            for u = 1:tpts(i)
                B(u).me = expm(delta{i}(u)*A(i).flds);
                B(u).cme = expm(delta{i}(u)*A(i).conj);
                B(u).M4nd = real(((B(u).me*B(u).cme*B(u).cme*B(u).me)^(n180array{i}(u)))*M0);
                ratio(u) = (B(u).M4nd(1))/M0(1);
                r2calc{j,i}(u) = log(ratio(u))*((-1)/(4*n180array{i}(u)*delta{i}(u)));
            end
        elseif isMQ(i) == 1
               m1 = ...
                   [(-1*x(9*(j-1)+8+i)-kab-kac) kba kca; ...
                    kab (-1*x(9*(j-1)+8+i)-kba-1i*((x(9*(j-1)+7)*protonfield(i)+x(9*(j-1)+5)*field(i))*2*pi)) 0; ...
                    kac 0 (-1*x(9*(j-1)+8+i)-kca-1i*((x(9*(j-1)+8)*protonfield(i)+x(9*(j-1)+6)*field(i))*2*pi))];
               m2 = ...
                   [(-1*x(9*(j-1)+8+i)-kab-kac) kba kca; ...
                    kab (-1*x(9*(j-1)+8+i)-kba-1i*((x(9*(j-1)+7)*protonfield(i)-x(9*(j-1)+5)*field(i))*2*pi)) 0; ...
                    kac 0 (-1*x(9*(j-1)+8+i)-kca-1i*((x(9*(j-1)+8)*protonfield(i)-x(9*(j-1)+6)*field(i))*2*pi))];
               m1conj = conj(m1);
               m2conj = conj(m2);

               for u = 1:tpts(i)
                  M1 = expm(delta{i}(u)*m1);
                  M2 = expm(delta{i}(u)*m2);
                  M1conj = expm(delta{i}(u)*m1conj);
                  M2conj = expm(delta{i}(u)*m2conj);
                  W=(M1*M2*M2*M1)^(n180array{i}(u)/2);
                  S=(M2conj*M1conj*M1conj*M2conj)^(n180array{i}(u)/2);
                  Y=(M2*M1*M1*M2)^(n180array{i}(u)/2);
                  Z=(M1conj*M2conj*M2conj*M1conj)^(n180array{i}(u)/2);
                  r2calc{j,i}(u) = ((-1)/(4*n180array{i}(u)*delta{i}(u)))*log(real((0.5/(M0(1)))*[1 0 0]*(W*S+Y*Z)*M0));
               end
        end
        %CPMG resid
        resid{j,i} = real((r2calc{j,i}(:)-r2eff{j,i}(:)))./err{j,i};
        resid_col{i} = [];
    end
    %CEST calculation
    w1 = sllist_allres{j}*2*pi; %spin lock pow
    dataout{j} = zeros(numpts(j), 1);
    for icount = 1:numpts(j)
        %set params
        specfrq = 150.902406439; %600 MHz
        R1 = x((9*(j-1))+12);
        R2a = x((9*(j-1))+13);
        R2b = R2a;
        R2c = R2a;

        dwab = x(9*(j-1)+5);
        dwac = x(9*(j-1)+6);
        kab = pb*x(3)/(pa+pb);
        kba = pa*x(3)/(pa+pb);
        kac = pc*x(4)/(pa+pc);
        kca = pa*x(4)/(pa+pc);

        out = 0;

        wrf = freq{j}(icount);
        %set chem shifts of all states
        %observed resonance set to be pop weighted avg of states A & C
        %(connected by faster process)
        %da = ((chemcenter - chemshift(j))*specfrq+wrf)*2*pi;
        da = ((chemshift(j)*(pa+pc))-(pc*dwac))/(pa+pc);
        da = ((chemcenter - da)*specfrq+wrf)*2*pi;
        db = da-dwab*specfrq*2*pi;
        dc = da-dwac*specfrq*2*pi;

        %init density matrix
        Ao1  = [0.5 0 0 pa 0 0 pb 0 0 pc]'; %E/2 IxA IyA IzA IxB IyB IzB IxC IyC IzC
        Ao2  = [0.5 0 0 -pa 0 0 -pb 0 0 -pc]'; %E/2 IxA IyA IzA IxB IyB IzB IxC IyC IzC
        %evolution matrix
        P =[0         0            0            0            0            0            0 0 0 0       ; ...
            0         R2a+kab+kac  da          -w1(icount)          -kba          0            0 -kca 0 0          ; ...
            0        -da           R2a+kab+kac  0            0           -kba          0 0 -kca 0            ; ...
            -2*R1*pa  w1(icount)           0            R1+kab+kac  0            0           -kba 0 0 -kca      ; ...
            0        -kab          0            0            R2b+kba  db          -w1(icount) 0 0 0          ; ...
            0         0           -kab          0           -db           R2b+kba  0 0 0 0         ; ...
            -2*R1*pb  0            0           -kab         w1(icount)           0            R1+kba 0 0 0 ; ...
            0 -kac 0 0 0 0 0 R2c+kca dc -w1(icount) ; ...
            0 0 -kac 0 0 0 0 -dc R2c+kca 0 ; ...
            -2*R1*pc 0 0 -kac 0 0 0 w1(icount) 0 R1+kca] ;

        eP=expm(-P*SLdura); %SLdura relaxation time
        A1=eP*Ao1;
        Mza1=A1(4); %mag at end (+z)
        A2=eP*Ao2;
        Mza2=A2(4); %mag at end (-z)
        DMz=(Mza1-Mza2)/(2*pa); %normalized int (avg +z,-z)
        out = DMz + out;

        %calc CEST data
        dataout{j}(icount, 1) = out;
    end
end

    dataout_col = [];
    datainput_col = [];
    
    %CEST data relative to error
    for i = 1:numres
       dataout_col = [dataout_col;dataout{i}./(1.5*relErr(idxlist(i),1))];
       datainput_col = [datainput_col;datainput{i}./(1.5*relErr(idxlist(i),1))];
    end
    
    %CEST resids
    if fityn == 1
        CESTresid = (dataout_col - datainput_col);
    end

    %CPMG resids
    for i=1:flds
        for j=1:numres
            resid_col{i} = [resid_col{i};resid{j,i}];
        end
    end
    
    %CPMG & CEST resids
    if fityn == 1
        if flds == 1
            F = [resid_col{1}; CESTresid];
        elseif flds == 2
            F = [resid_col{1}; resid_col{2}];
        elseif flds == 3
            F = [resid_col{1}; resid_col{2}; resid_col{3}; CESTresid];
        %elseif flds == 4
        %    F = [f(:,1); f(:,2); f(:,3); f(:,4)];
        %else
        %    F = [f(:,1); f(:,2); f(:,3); f(:,4); f(:,5)];
        end
    else
        F = r2calc; %return calc CPMG data
    end
end