
*Cardiovascular disease and subsequent risk of psychiatric disorders: a nationwide sibling-controlled study
*1987-2016
*STATA 17.0


*install -xsvmat- package
*ssc install xsvmat


cd /nfs/home/qinshe/CoMorMent/MD_CVD/STATA
set more off




***************Figure time-varying hazard ratio*********************
*sibling cohort
use aim2_cohort_sibling3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365


*1) <1 year of follow up
gen entry2=max(index_date,entry)
gen exit2=min(exit, md_date,fptime1) 
gen fail=1 if exit2==md_date 
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(30) id(setno)

stpm2 _cc KON birthyear edu_c icm_c civ cci_c,df(5) tvc(_cc) dftvc(3) scale(hazard) eform 
predict hr, hrnum(_cc 1) hrdenom(_cc 0) timevar(_t) ci

twoway (rarea hr_lci hr_uci _t, sort fcolor(eltblue) lcolor(ltbluishgray))  (line hr _t, sort lcolor(black)), graphregion(color(white)) legend(r(1) lab(1 "95% confidence interval") lab(2 "time-varying hazard ratio") size(small)) ytitle(Hazard ratio) ylabel(1(1)10) xtitle(Month since diagnosis (<1 year)) xlabel(0(1)12) saving(aim2_pic_sib1, replace)

  


*2) >=1 year of follow up
use aim2_cohort_sibling3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365)  id(setno)

stpm2 _cc KON birthyear edu_c icm_c civ cci_c,df(5) tvc(_cc) dftvc(5) scale(hazard) eform 
predict hr, hrnum(_cc 1) hrdenom(_cc 0) timevar(_t) ci


twoway (rarea hr_lci hr_uci _t, sort fcolor(eltblue) lcolor(ltbluishgray))  (line hr _t, sort lcolor(black)), graphregion(color(white)) legend(r(1) lab(1 "95% confidence interval") lab(2 "time-varying hazard ratio") size(small)) ytitle(Hazard ratio) ylabel(1(0.5)3) xsize(11) xtitle(Year since diagnosis (>=1 year)) xlabel(1(3)28) saving(aim2_pic_sib2, replace)


grc1leg aim2_pic_sib1.gph aim2_pic_sib2.gph, legendfrom(aim2_pic_sib1.gph) span cols(2) graphregion(color(white)) saving(aim2_fig_sib_all,replace)



graph use aim2_pic_sib1.gph
graph export aim2_pic_sib1.tif
  
graph use aim2_pic_sib2.gph
graph export aim2_pic_sib2.tif





*population cohort
use aim2_cohort_pop3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

  
*1) <1 year of follow up
gen entry2=max(index_date,entry)
gen exit2=min(exit, md_date,fptime1) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(30) id(setno)

stpm2 _cc KON birthyear edu_c icm_c civ cci_c fam_md,df(5) tvc(_cc) dftvc(3) scale(hazard) eform 
predict hr, hrnum(_cc 1) hrdenom(_cc 0) timevar(_t) ci

twoway (rarea hr_lci hr_uci _t, sort fcolor(eltblue) lcolor(ltbluishgray))  (line hr _t, sort lcolor(black)), graphregion(color(white)) legend(r(1) lab(1 "95% confidence interval") lab(2 "time-varying hazard ratio") size(small)) ytitle(Hazard ratio) ylabel(1(1)10) xtitle(Month since diagnosis (<1 year)) xlabel(0(1)12) saving(aim2_pic_pop1, replace)

  

*2) >=1 year of follow up
use aim2_cohort_pop3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

*drop entry2 exit2 fail hr hr_lci hr_uci
gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365)  id(setno)

stpm2 _cc KON birthyear edu_c icm_c civ cci_c fam_md,df(5) tvc(_cc) dftvc(3) scale(hazard) eform 
predict hr, hrnum(_cc 1) hrdenom(_cc 0) timevar(_t) ci

twoway (rarea hr_lci hr_uci _t, sort fcolor(eltblue) lcolor(ltbluishgray))  (line hr _t, sort lcolor(black)), graphregion(color(white)) legend(r(1) lab(1 "95% confidence interval") lab(2 "time-varying hazard ratio") size(small)) ytitle(Hazard ratio) ylabel(1(0.5)3) xsize(11) xtitle(Year since diagnosis (>=1 year)) xlabel(1(3)28) saving(aim2_pic_pop2, replace)


graph use aim2_pic_pop1.gph
graph export aim2_pic_pop1.tif
  
graph use aim2_pic_pop2.gph
graph export aim2_pic_pop2.tif











/*Figure - by psychiatric subtype */
*SIBLING COHORT
use aim2_cohort_sibling3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

  matrix A = J(7,14,.)
  matrix list A
  
*1) <1 year of follow up
*md_subtype
gen entry2=max(index_date,entry)
gen exit2=min(exit, md_date,fptime1) 
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

foreach f of num 1/7 { 
gen fail=1 if exit2==md_date & md_type==`f'
stset exit2, failure(fail==1) enter(entry2) exit(time .) origin(index_date) scale(365) id(setno)

*IR
stptime if _cc==0, per(1000)
  matrix A[`f',1] = r(failures) 
  matrix A[`f',2] = r(rate)
stptime if _cc==1, per(1000)
  matrix A[`f',3] = r(failures) 
  matrix A[`f',4] = r(rate)

stcox i._cc KON birthyear edu_c icm_c civ cci_c, strata(_setno)

*extract HR
foreach j of num 1/1{ 
  matrix A[`j'+`f'-1,5] = exp(_b[`j'._cc])
  matrix A[`j'+`f'-1,6] = exp(_b[`j'._cc] - 1.96 * _se[`j'._cc])
  matrix A[`j'+`f'-1,7] = exp(_b[`j'._cc] + 1.96 * _se[`j'._cc])
}  
drop fail
}




*2) >=1 year of follow up
drop entry2 exit2 
gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

foreach f of num 1/7 { 
gen fail=1 if exit2==md_date & md_type==`f'

stset exit2, failure(fail==1) enter(entry2) exit(time .) origin(index_date) scale(365)  id(setno)

stcox i._cc KON birthyear edu_c icm_c civ cci_c, strata(_setno)

*IR
stptime if _cc==0, per(1000)
  matrix A[`f',8] = r(failures) 
  matrix A[`f',9] = r(rate)
stptime if _cc==1, per(1000)
  matrix A[`f',10] = r(failures) 
  matrix A[`f',11] = r(rate)


*extract HR
foreach j of num 1/1{ 
  matrix A[`j'+`f'-1,12] = exp(_b[`j'._cc])
  matrix A[`j'+`f'-1,13] = exp(_b[`j'._cc] - 1.96 * _se[`j'._cc])
  matrix A[`j'+`f'-1,14] = exp(_b[`j'._cc] + 1.96 * _se[`j'._cc])
}  
drop fail
}  



*generate table for table
matrix list A
matrix rownames A =  Type1 Type2 Type3 Type4 Type5 Type6 Type7 
matrix colnames A = event_ref1 rate_ref1 event1 rate1 rr1 lm1 hm1 event_ref2 rate_ref2 event2 rate2 rr2 lm2 hm2
xsvmat A, rownames(vars) names(col) saving(Aim2_sibling_subtype, replace)


***************************************************
*****TABLE generate table ********
use Aim2_sibling_subtype,clear
gen HR1     = string(rr1,"%9.2f") + " (" + string(lm1,"%9.2f") + "-" + string(hm1,"%9.2f") + ")" if rr1!=.
gen HR2     = string(rr2,"%9.2f") + " (" + string(lm2,"%9.2f") + "-" + string(hm2,"%9.2f") + ")" if rr2!=.

drop rr* lm* hm*
export excel Aim2_sibling_subtype.xlsx, firstrow(var) replace




*POPULATION MATCHED COHORT
use aim2_cohort_pop3,replace
destring KON, replace

gen fptime1=_rstime+364
gen fptime2=_rstime+365

  matrix A = J(7,14,.)
  matrix list A
  
*1) <1 year of follow up
*md_subtype
gen entry2=max(_rstime,entry)
gen exit2=min(exit, md_date,fptime1) 
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

foreach f of num 1/7 { 
gen fail=1 if exit2==md_date & md_type==`f'
stset exit2, failure(fail==1) enter(entry2) exit(time .) origin(_rstime) scale(365) id(setno)

*IR
stptime if _cc==0, per(1000)
  matrix A[`f',1] = r(failures) 
  matrix A[`f',2] = r(rate)
stptime if _cc==1, per(1000)
  matrix A[`f',3] = r(failures) 
  matrix A[`f',4] = r(rate)

stcox i._cc edu_c icm_c civ cci_c Fam_md, strata(_setno)

*extract HR
foreach j of num 1/1{ 
  matrix A[`j'+`f'-1,5] = exp(_b[`j'._cc])
  matrix A[`j'+`f'-1,6] = exp(_b[`j'._cc] - 1.96 * _se[`j'._cc])
  matrix A[`j'+`f'-1,7] = exp(_b[`j'._cc] + 1.96 * _se[`j'._cc])
}  
drop fail
}



*2) >=1 year of follow up
drop entry2 exit2 
gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

foreach f of num 1/7 { 
gen fail=1 if exit2==md_date & md_type==`f'

stset exit2, failure(fail==1) enter(entry2) exit(time .) origin(_rstime) scale(365)  id(setno)

stcox i._cc edu_c icm_c civ cci_c Fam_md, strata(_setno)

*IR
stptime if _cc==0, per(1000)
  matrix A[`f',8] = r(failures) 
  matrix A[`f',9] = r(rate)
stptime if _cc==1, per(1000)
  matrix A[`f',10] = r(failures) 
  matrix A[`f',11] = r(rate)


*extract HR
foreach j of num 1/1{ 
  matrix A[`j'+`f'-1,12] = exp(_b[`j'._cc])
  matrix A[`j'+`f'-1,13] = exp(_b[`j'._cc] - 1.96 * _se[`j'._cc])
  matrix A[`j'+`f'-1,14] = exp(_b[`j'._cc] + 1.96 * _se[`j'._cc])
}  
drop fail
}  


*generate table for table
matrix list A
matrix rownames A =  Type1 Type2 Type3 Type4 Type5 Type6 Type7
matrix colnames A = event_ref1 rate_ref1 event1 rate1 rr1 lm1 hm1 event_ref2 rate_ref2 event2 rate2 rr2 lm2 hm2
xsvmat A, rownames(vars) names(col) saving(Aim2_pop_subtype, replace)


***************************************************
*****TABLE generate table ********
use Aim2_pop_subtype,clear
gen HR1     = string(rr1,"%9.2f") + " (" + string(lm1,"%9.2f") + "-" + string(hm1,"%9.2f") + ")" if rr1!=.
gen HR2     = string(rr2,"%9.2f") + " (" + string(lm2,"%9.2f") + "-" + string(hm2,"%9.2f") + ")" if rr2!=.

drop rr* lm* hm*
export excel Aim2_pop_subtype.xlsx, firstrow(var) replace








********************************************************
****Figure - by cvd type****
********************************************************

*SIBLING COHORT
use aim2_cohort_sibling3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

  matrix A = J(18,12,.)
  matrix list A

gen expose=0
 foreach e of num 1/7 { 
replace expose=`e' if _cc==1 & (cvd_type1==`e' | comob_type2==`e')
}


*1) <1 year of follow up
gen entry2=max(index_date,entry) 
gen exit2=min(exit, md_date,fptime1) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365) id(setno)

*IR
 foreach t of num 0/7 { 
stptime if expose==`t', per(1000)
  matrix A[`t'+1,1] = r(ptime) 
  matrix A[`t'+1,2] = r(failures)
  matrix A[`t'+1,3] = r(rate)
}

stcox i.expose KON birthyear edu_c icm_c civ cci_c, strata(_setno)

*extract HR
foreach j of num 1/7{ 
  matrix A[`j'+1,4] = exp(_b[`j'.expose])
  matrix A[`j'+1,5] = exp(_b[`j'.expose] - 1.96 * _se[`j'.expose])
  matrix A[`j'+1,6] = exp(_b[`j'.expose] + 1.96 * _se[`j'.expose])
}  



*2) >=1 year of follow up
use aim2_cohort_sibling3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

gen expose=0
 foreach e of num 1/7 { 
replace expose=`e' if _cc==1 & (cvd_type1==`e' | comob_type2==`e')
}

*drop entry2 exit2 fail

gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365)  id(setno)

stcox i.expose KON birthyear edu_c icm_c civ cci_c, strata(_setno)

*IR
 foreach t of num 0/7 { 
stptime if expose==`t',per(1000)
  matrix A[`t'+10,1] = r(ptime) 
  matrix A[`t'+10,2] = r(failures)
  matrix A[`t'+10,3] = r(rate)
}

*extract HR
foreach j of num 1/7{ 
  matrix A[`j'+10,4] = exp(_b[`j'.expose])
  matrix A[`j'+10,5] = exp(_b[`j'.expose] - 1.96 * _se[`j'.expose])
  matrix A[`j'+10,6] = exp(_b[`j'.expose] + 1.96 * _se[`j'.expose])
}  







*Population COHORT
use aim2_cohort_pop3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

gen expose=0
 foreach e of num 1/7 { 
replace expose=`e' if _cc==1 & (cvd_type1==`e' | comob_type2==`e')
}

*1) <1 year of follow up
gen entry2=max(index_date,entry) 
gen exit2=min(exit, md_date,fptime1) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365) id(setno)

*IR
 foreach t of num 0/7 { 
stptime if expose==`t', per(1000)
  matrix A[`t'+1,7] = r(ptime) 
  matrix A[`t'+1,8] = r(failures)
  matrix A[`t'+1,9] = r(rate)
}

stcox i.expose edu_c icm_c civ cci_c fam_md, strata(_setno)

*extract HR
foreach j of num 1/7{ 
  matrix A[`j'+1,10] = exp(_b[`j'.expose])
  matrix A[`j'+1,11] = exp(_b[`j'.expose] - 1.96 * _se[`j'.expose])
  matrix A[`j'+1,12] = exp(_b[`j'.expose] + 1.96 * _se[`j'.expose])
}  



*2) >=1 year of follow up
use aim2_cohort_pop3,replace
destring KON, replace

gen fptime1=index_date+364
gen fptime2=index_date+365

gen expose=0
 foreach e of num 1/7 { 
replace expose=`e' if _cc==1 & (cvd_type1==`e' | comob_type2==`e')
}

*drop entry2 exit2 fail
gen entry2=max(fptime2,entry)
gen exit2=min(exit, md_date) 
gen fail=1 if exit2==md_date
replace exit2=exit2+1 if entry2==exit2

format entry2 exit2 %td
drop if entry2>exit2

stset exit2, failure(fail==1) enter(entry2) exit(exit2) origin(index_date) scale(365)  id(setno)

stcox i.expose edu_c icm_c civ cci_c fam_md, strata(_setno)

*IR
 foreach t of num 0/7 { 
stptime if expose==`t',per(1000)
  matrix A[`t'+10,7] = r(ptime) 
  matrix A[`t'+10,8] = r(failures)
  matrix A[`t'+10,9] = r(rate)
}

*extract HR
foreach j of num 1/7{ 
  matrix A[`j'+10,10] = exp(_b[`j'.expose])
  matrix A[`j'+10,11] = exp(_b[`j'.expose] - 1.96 * _se[`j'.expose])
  matrix A[`j'+10,12] = exp(_b[`j'.expose] + 1.96 * _se[`j'.expose])
}  


*generate table  
matrix list A
matrix rownames A = FP1_ref FP1_type1 FP1_type2 FP1_type3 FP1_type4 FP1_type5 FP1_type6  FP1_type7 FP1_type8 FP2_ref FP2_type1 FP2_type2 FP2_type3 FP2_type4 FP2_type5 FP2_type6  FP2_type7 FP2_type8 
matrix colnames A = ptime1 event1 rate1 rr1 lm1 hm1 ptime2 event2 rate2 rr2 lm2 hm2
xsvmat A, rownames(vars) names(col) saving(Aim2_tab_cvd1, replace)


***************************************************
*****TABLE generate table ********
use Aim2_tab_cvd1,clear
gen No1		 = event1
gen ir1      = rate1
gen HR1     = string(rr1,"%9.2f") + " (" + string(lm1,"%9.2f") + "-" + string(hm1,"%9.2f") + ")" if rr1!=.
gen No2		 = event2
gen ir2      = rate2
gen HR2     = string(rr2,"%9.2f") + " (" + string(lm2,"%9.2f") + "-" + string(hm2,"%9.2f") + ")" if rr2!=.


drop event* rate* rr* lm* hm*
export excel Aim2_tab_cvd1.xlsx, firstrow(var) replace








***************Figure - Kaplan Meier curve*********************
*only CVD patients
*follow up from 1 year after CVD diagnosis, depending on whether having psychiatric diagnosis during the first year
use aim2_cvd_death,replace
destring KON, replace

gen fail=1 if exit==deathdate & death_cvd==1
replace exit=exit+1 if entry==exit

gen entry2=entry+365

stset exit, failure(fail==1) enter(entry) exit(exit) origin(entry2) scale(365) id(LOPNR)

stptime , by(md) per(1000)
sts graph, by(md) ylabel(0.50(0.10)1.0) graphregion(color(white)) ci xlabel(0 "1" 4 "5" 8 "9" 12 "13" 16 "17" 20 "21" 24 "25" 28 "29") xtitle("Years since diagnosis of cardiovascular disease") 



