#' hclust_fun
#'
#' This function is a wrapper for a few lines that implement a clustering
#' analysis. Given an input dataframe and number of clusters, this will conduct
#' hierarchical cluster using choices that mimic those in Winters et al and
#' others. Clustering is performed on all variables in the input dataframe;
#' often specific variables are chosen at the outset (e.g. x and y).
#'
#' @param df dataframe to cluster; should contain only variables that are used
#' in the clustering process
#' @param k number of clusters to identify
#'
#' @return vector of cluster assignments
#' @export
#'
#' @examples
hclust_fun = function(df, k) {

  dist_mat = ecodist::distance(df, method = "mahalanobis")
  cluster_fit = hclust(dist_mat, method = "ward.D2")
  list(cluster = cutree(cluster_fit, k = k))

}


#' gap_proc
#'
#' The clustering analyses make extensive use of the gap statistic, which is
#' implemented using cluster::clusGap(). The output of that function is
#' "untidy", and the purpose of this function is to clean output for subsequent
#' analysis and comparison.
#'
#' @param gap an object produced by cluster::clusGap()
#'
#' @return a tidied dataframe containing the same results as the input object.
#' @export
#'
#' @examples
gap_proc = function(gap) {

  as_tibble(gap$Tab) %>%
    mutate(k = row_number()) %>%
    select(k, everything())

}
